/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.image;

import android.media.ExifInterface;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import io.flutter.Log;
import io.flutter.embedding.engine.image.Metadata;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

@RequiresApi(value=28)
class ExifMetadataReader {
    private static final String TAG = "ExifMetadataReader";

    ExifMetadataReader() {
    }

    static void read(byte[] bytes, @NonNull Metadata metadata) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            ExifInterface exifInterface = new ExifInterface((InputStream)inputStream);
            metadata.orientation = exifInterface.getAttributeInt("Orientation", 1);
        }
        catch (IOException e) {
            Log.e(TAG, "Failed to read EXIF metadata", e);
        }
    }
}

