/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.common;

import androidx.annotation.Nullable;
import io.flutter.plugin.common.JSONUtil;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugin.common.StringCodec;
import java.nio.ByteBuffer;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public final class JSONMessageCodec
implements MessageCodec<Object> {
    public static final JSONMessageCodec INSTANCE = new JSONMessageCodec();

    private JSONMessageCodec() {
    }

    @Override
    @Nullable
    public ByteBuffer encodeMessage(@Nullable Object message) {
        if (message == null) {
            return null;
        }
        Object wrapped = JSONUtil.wrap(message);
        if (wrapped instanceof String) {
            return StringCodec.INSTANCE.encodeMessage(JSONObject.quote((String)((String)wrapped)));
        }
        return StringCodec.INSTANCE.encodeMessage(wrapped.toString());
    }

    @Override
    @Nullable
    public Object decodeMessage(@Nullable ByteBuffer message) {
        if (message == null) {
            return null;
        }
        try {
            String json = StringCodec.INSTANCE.decodeMessage(message);
            JSONTokener tokener = new JSONTokener(json);
            Object value = tokener.nextValue();
            if (tokener.more()) {
                throw new IllegalArgumentException("Invalid JSON");
            }
            return value;
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Invalid JSON", e);
        }
    }
}

