/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import android.content.pm.PackageManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.StandardMethodCodec;
import java.util.ArrayList;
import java.util.Map;

public class ProcessTextChannel {
    private static final String TAG = "ProcessTextChannel";
    private static final String CHANNEL_NAME = "flutter/processtext";
    private static final String METHOD_QUERY_TEXT_ACTIONS = "ProcessText.queryTextActions";
    private static final String METHOD_PROCESS_TEXT_ACTION = "ProcessText.processTextAction";
    public final MethodChannel channel;
    public final PackageManager packageManager;
    private ProcessTextMethodHandler processTextMethodHandler;
    @NonNull
    public final MethodChannel.MethodCallHandler parsingMethodHandler = new MethodChannel.MethodCallHandler(){

        @Override
        public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            if (ProcessTextChannel.this.processTextMethodHandler == null) {
                return;
            }
            String method = call.method;
            Object args = call.arguments;
            switch (method) {
                case "ProcessText.queryTextActions": {
                    try {
                        Map<String, String> actions = ProcessTextChannel.this.processTextMethodHandler.queryTextActions();
                        result.success(actions);
                    }
                    catch (IllegalStateException exception) {
                        result.error("error", exception.getMessage(), null);
                    }
                    break;
                }
                case "ProcessText.processTextAction": {
                    try {
                        ArrayList argumentList = (ArrayList)args;
                        String id2 = (String)argumentList.get(0);
                        String text = (String)argumentList.get(1);
                        boolean readOnly = (Boolean)argumentList.get(2);
                        ProcessTextChannel.this.processTextMethodHandler.processTextAction(id2, text, readOnly, result);
                    }
                    catch (IllegalStateException exception) {
                        result.error("error", exception.getMessage(), null);
                    }
                    break;
                }
                default: {
                    result.notImplemented();
                }
            }
        }
    };

    public ProcessTextChannel(@NonNull DartExecutor dartExecutor, @NonNull PackageManager packageManager) {
        this.packageManager = packageManager;
        this.channel = new MethodChannel(dartExecutor, CHANNEL_NAME, StandardMethodCodec.INSTANCE);
        this.channel.setMethodCallHandler(this.parsingMethodHandler);
    }

    public void setMethodHandler(@Nullable ProcessTextMethodHandler processTextMethodHandler) {
        this.processTextMethodHandler = processTextMethodHandler;
    }

    public static interface ProcessTextMethodHandler {
        public Map<String, String> queryTextActions();

        public void processTextAction(@NonNull String var1, @NonNull String var2, @NonNull boolean var3, @NonNull MethodChannel.Result var4);
    }
}

