/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.graphics.Matrix;
import android.os.Build;
import android.view.InputDevice;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import io.flutter.embedding.android.MotionEventTracker;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;

public class AndroidTouchProcessor {
    private static final int POINTER_DATA_FIELD_COUNT = 36;
    @VisibleForTesting
    static final int BYTES_PER_FIELD = 8;
    private static final int POINTER_DATA_FLAG_BATCHED = 1;
    @NonNull
    private final FlutterRenderer renderer;
    @NonNull
    private final MotionEventTracker motionEventTracker;
    private static final Matrix IDENTITY_TRANSFORM = new Matrix();
    private final boolean trackMotionEvents;
    private final Map<Integer, float[]> ongoingPans = new HashMap<Integer, float[]>();

    public AndroidTouchProcessor(@NonNull FlutterRenderer renderer, boolean trackMotionEvents) {
        this.renderer = renderer;
        this.motionEventTracker = MotionEventTracker.getInstance();
        this.trackMotionEvents = trackMotionEvents;
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        return this.onTouchEvent(event, IDENTITY_TRANSFORM);
    }

    public boolean onTouchEvent(@NonNull MotionEvent event, @NonNull Matrix transformMatrix) {
        boolean updateForMultiplePointers;
        int pointerCount = event.getPointerCount();
        ByteBuffer packet = ByteBuffer.allocateDirect(pointerCount * 36 * 8);
        packet.order(ByteOrder.LITTLE_ENDIAN);
        int maskedAction = event.getActionMasked();
        int pointerChange = this.getPointerChangeForAction(event.getActionMasked());
        boolean updateForSinglePointer = maskedAction == 0 || maskedAction == 5;
        boolean bl = updateForMultiplePointers = !updateForSinglePointer && (maskedAction == 1 || maskedAction == 6);
        if (updateForSinglePointer) {
            this.addPointerForIndex(event, event.getActionIndex(), pointerChange, 0, transformMatrix, packet);
        } else if (updateForMultiplePointers) {
            for (int p = 0; p < pointerCount; ++p) {
                if (p == event.getActionIndex() || event.getToolType(p) != 1) continue;
                this.addPointerForIndex(event, p, 5, 1, transformMatrix, packet);
            }
            this.addPointerForIndex(event, event.getActionIndex(), pointerChange, 0, transformMatrix, packet);
        } else {
            for (int p = 0; p < pointerCount; ++p) {
                this.addPointerForIndex(event, p, pointerChange, 0, transformMatrix, packet);
            }
        }
        if (packet.position() % 288 != 0) {
            throw new AssertionError((Object)"Packet position is not on field boundary");
        }
        this.renderer.dispatchPointerDataPacket(packet, packet.position());
        return true;
    }

    public boolean onGenericMotionEvent(@NonNull MotionEvent event) {
        boolean isMovementEvent;
        boolean isPointerEvent = Build.VERSION.SDK_INT >= 18 && event.isFromSource(2);
        boolean bl = isMovementEvent = event.getActionMasked() == 7 || event.getActionMasked() == 8;
        if (!isPointerEvent || !isMovementEvent) {
            return false;
        }
        int pointerChange = this.getPointerChangeForAction(event.getActionMasked());
        ByteBuffer packet = ByteBuffer.allocateDirect(event.getPointerCount() * 36 * 8);
        packet.order(ByteOrder.LITTLE_ENDIAN);
        this.addPointerForIndex(event, event.getActionIndex(), pointerChange, 0, IDENTITY_TRANSFORM, packet);
        if (packet.position() % 288 != 0) {
            throw new AssertionError((Object)"Packet position is not on field boundary.");
        }
        this.renderer.dispatchPointerDataPacket(packet, packet.position());
        return true;
    }

    private void addPointerForIndex(MotionEvent event, int pointerIndex, int pointerChange, int pointerData, Matrix transformMatrix, ByteBuffer packet) {
        InputDevice.MotionRange pressureRange;
        long buttons;
        if (pointerChange == -1) {
            return;
        }
        long motionEventId = 0L;
        if (this.trackMotionEvents) {
            MotionEventTracker.MotionEventId trackedEvent = this.motionEventTracker.track(event);
            motionEventId = trackedEvent.getId();
        }
        int pointerKind = this.getPointerDeviceTypeForToolType(event.getToolType(pointerIndex));
        float[] viewToScreenCoords = new float[]{event.getX(pointerIndex), event.getY(pointerIndex)};
        transformMatrix.mapPoints(viewToScreenCoords);
        if (pointerKind == 1) {
            buttons = event.getButtonState() & 0x1F;
            if (buttons == 0L && event.getSource() == 8194 && pointerChange == 4) {
                this.ongoingPans.put(event.getPointerId(pointerIndex), viewToScreenCoords);
            }
        } else {
            buttons = pointerKind == 2 ? (long)(event.getButtonState() >> 4 & 0xF) : 0L;
        }
        boolean isTrackpadPan = this.ongoingPans.containsKey(event.getPointerId(pointerIndex));
        int signalKind = event.getActionMasked() == 8 ? 1 : 0;
        long timeStamp = event.getEventTime() * 1000L;
        packet.putLong(motionEventId);
        packet.putLong(timeStamp);
        if (isTrackpadPan) {
            packet.putLong(this.getPointerChangeForPanZoom(pointerChange));
            packet.putLong(4L);
        } else {
            packet.putLong(pointerChange);
            packet.putLong(pointerKind);
        }
        packet.putLong(signalKind);
        packet.putLong(event.getPointerId(pointerIndex));
        packet.putLong(0L);
        if (isTrackpadPan) {
            float[] panStart = this.ongoingPans.get(event.getPointerId(pointerIndex));
            packet.putDouble(panStart[0]);
            packet.putDouble(panStart[1]);
        } else {
            packet.putDouble(viewToScreenCoords[0]);
            packet.putDouble(viewToScreenCoords[1]);
        }
        packet.putDouble(0.0);
        packet.putDouble(0.0);
        packet.putLong(buttons);
        packet.putLong(0L);
        packet.putLong(0L);
        packet.putDouble(event.getPressure(pointerIndex));
        double pressureMin = 0.0;
        double pressureMax = 1.0;
        if (event.getDevice() != null && (pressureRange = event.getDevice().getMotionRange(2)) != null) {
            pressureMin = pressureRange.getMin();
            pressureMax = pressureRange.getMax();
        }
        packet.putDouble(pressureMin);
        packet.putDouble(pressureMax);
        if (pointerKind == 2) {
            packet.putDouble(event.getAxisValue(24, pointerIndex));
            packet.putDouble(0.0);
        } else {
            packet.putDouble(0.0);
            packet.putDouble(0.0);
        }
        packet.putDouble(event.getSize(pointerIndex));
        packet.putDouble(event.getToolMajor(pointerIndex));
        packet.putDouble(event.getToolMinor(pointerIndex));
        packet.putDouble(0.0);
        packet.putDouble(0.0);
        packet.putDouble(event.getAxisValue(8, pointerIndex));
        if (pointerKind == 2) {
            packet.putDouble(event.getAxisValue(25, pointerIndex));
        } else {
            packet.putDouble(0.0);
        }
        packet.putLong(pointerData);
        if (signalKind == 1) {
            packet.putDouble(-event.getAxisValue(10));
            packet.putDouble(-event.getAxisValue(9));
        } else {
            packet.putDouble(0.0);
            packet.putDouble(0.0);
        }
        if (isTrackpadPan) {
            float[] panStart = this.ongoingPans.get(event.getPointerId(pointerIndex));
            packet.putDouble(viewToScreenCoords[0] - panStart[0]);
            packet.putDouble(viewToScreenCoords[1] - panStart[1]);
        } else {
            packet.putDouble(0.0);
            packet.putDouble(0.0);
        }
        packet.putDouble(0.0);
        packet.putDouble(0.0);
        packet.putDouble(1.0);
        packet.putDouble(0.0);
        packet.putLong(0L);
        if (isTrackpadPan && this.getPointerChangeForPanZoom(pointerChange) == 9) {
            this.ongoingPans.remove(event.getPointerId(pointerIndex));
        }
    }

    @PointerChange
    private int getPointerChangeForAction(int maskedAction) {
        if (maskedAction == 0) {
            return 4;
        }
        if (maskedAction == 1) {
            return 6;
        }
        if (maskedAction == 5) {
            return 4;
        }
        if (maskedAction == 6) {
            return 6;
        }
        if (maskedAction == 2) {
            return 5;
        }
        if (maskedAction == 7) {
            return 3;
        }
        if (maskedAction == 3) {
            return 0;
        }
        if (maskedAction == 8) {
            return 3;
        }
        return -1;
    }

    @PointerChange
    private int getPointerChangeForPanZoom(int pointerChange) {
        if (pointerChange == 4) {
            return 7;
        }
        if (pointerChange == 5) {
            return 8;
        }
        if (pointerChange == 6 || pointerChange == 0) {
            return 9;
        }
        throw new AssertionError((Object)"Unexpected pointer change");
    }

    @PointerDeviceKind
    private int getPointerDeviceTypeForToolType(int toolType) {
        switch (toolType) {
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 3;
            }
        }
        return 5;
    }

    public static @interface PointerPreferredStylusAuxiliaryAction {
        public static final int IGNORE = 0;
        public static final int SHOW_COLOR_PALETTE = 1;
        public static final int SWITCH_ERASER = 2;
        public static final int SWITCH_PREVIOUS = 3;
        public static final int UNKNOWN = 4;
    }

    public static @interface PointerSignalKind {
        public static final int NONE = 0;
        public static final int SCROLL = 1;
        public static final int SCROLL_INERTIA_CANCEL = 2;
        public static final int SCALE = 3;
        public static final int STYLUS_AUXILIARY_ACTION = 4;
        public static final int UNKNOWN = 5;
    }

    public static @interface PointerDeviceKind {
        public static final int TOUCH = 0;
        public static final int MOUSE = 1;
        public static final int STYLUS = 2;
        public static final int INVERTED_STYLUS = 3;
        public static final int TRACKPAD = 4;
        public static final int UNKNOWN = 5;
    }

    public static @interface PointerChange {
        public static final int CANCEL = 0;
        public static final int ADD = 1;
        public static final int REMOVE = 2;
        public static final int HOVER = 3;
        public static final int DOWN = 4;
        public static final int MOVE = 5;
        public static final int UP = 6;
        public static final int PAN_ZOOM_START = 7;
        public static final int PAN_ZOOM_UPDATE = 8;
        public static final int PAN_ZOOM_END = 9;
    }
}

