/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.renderer;

import android.graphics.SurfaceTexture;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;

@Keep
public class SurfaceTextureWrapper {
    private SurfaceTexture surfaceTexture;
    private boolean released;

    public SurfaceTextureWrapper(@NonNull SurfaceTexture surfaceTexture) {
        this.surfaceTexture = surfaceTexture;
        this.released = false;
    }

    @NonNull
    public SurfaceTexture surfaceTexture() {
        return this.surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTexImage() {
        SurfaceTextureWrapper surfaceTextureWrapper = this;
        synchronized (surfaceTextureWrapper) {
            if (!this.released) {
                this.surfaceTexture.updateTexImage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        SurfaceTextureWrapper surfaceTextureWrapper = this;
        synchronized (surfaceTextureWrapper) {
            if (!this.released) {
                this.surfaceTexture.release();
                this.released = true;
            }
        }
    }

    public void attachToGLContext(int texName) {
        this.surfaceTexture.attachToGLContext(texName);
    }

    public void detachFromGLContext() {
        this.surfaceTexture.detachFromGLContext();
    }

    public void getTransformMatrix(float[] mtx) {
        this.surfaceTexture.getTransformMatrix(mtx);
    }
}

