/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.localization;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.LocaleList;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.embedding.engine.systemchannels.LocalizationChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class LocalizationPlugin {
    @NonNull
    private final LocalizationChannel localizationChannel;
    @NonNull
    private final Context context;
    @VisibleForTesting
    final LocalizationChannel.LocalizationMessageHandler localizationMessageHandler = new LocalizationChannel.LocalizationMessageHandler(){

        @Override
        public String getStringResource(@NonNull String key, @Nullable String localeString) {
            Context localContext = LocalizationPlugin.this.context;
            String stringToReturn = null;
            Locale savedLocale = null;
            if (localeString != null) {
                Locale locale = LocalizationPlugin.localeFromString(localeString);
                if (Build.VERSION.SDK_INT >= 17) {
                    Configuration config = new Configuration(LocalizationPlugin.this.context.getResources().getConfiguration());
                    config.setLocale(locale);
                    localContext = LocalizationPlugin.this.context.createConfigurationContext(config);
                } else {
                    Resources resources = LocalizationPlugin.this.context.getResources();
                    Configuration config = resources.getConfiguration();
                    savedLocale = config.locale;
                    config.locale = locale;
                    resources.updateConfiguration(config, null);
                }
            }
            String packageName = LocalizationPlugin.this.context.getPackageName();
            int resId = localContext.getResources().getIdentifier(key, "string", packageName);
            if (resId != 0) {
                stringToReturn = localContext.getResources().getString(resId);
            }
            if (localeString != null && Build.VERSION.SDK_INT < 17) {
                Resources resources = LocalizationPlugin.this.context.getResources();
                Configuration config = resources.getConfiguration();
                config.locale = savedLocale;
                resources.updateConfiguration(config, null);
            }
            return stringToReturn;
        }
    };

    public LocalizationPlugin(@NonNull Context context, @NonNull LocalizationChannel localizationChannel) {
        this.context = context;
        this.localizationChannel = localizationChannel;
        this.localizationChannel.setLocalizationMessageHandler(this.localizationMessageHandler);
    }

    public Locale resolveNativeLocale(List<Locale> supportedLocales) {
        if (supportedLocales == null || supportedLocales.isEmpty()) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            ArrayList<Locale.LanguageRange> languageRanges = new ArrayList<Locale.LanguageRange>();
            LocaleList localeList = this.context.getResources().getConfiguration().getLocales();
            int localeCount = localeList.size();
            for (int index = 0; index < localeCount; ++index) {
                Locale locale = localeList.get(index);
                String fullRange = locale.getLanguage();
                if (!locale.getScript().isEmpty()) {
                    fullRange = fullRange + "-" + locale.getScript();
                }
                if (!locale.getCountry().isEmpty()) {
                    fullRange = fullRange + "-" + locale.getCountry();
                }
                languageRanges.add(new Locale.LanguageRange(fullRange));
                languageRanges.add(new Locale.LanguageRange(locale.getLanguage()));
                languageRanges.add(new Locale.LanguageRange(locale.getLanguage() + "-*"));
            }
            Locale platformResolvedLocale = Locale.lookup(languageRanges, supportedLocales);
            if (platformResolvedLocale != null) {
                return platformResolvedLocale;
            }
            return supportedLocales.get(0);
        }
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleList localeList = this.context.getResources().getConfiguration().getLocales();
            for (int index = 0; index < localeList.size(); ++index) {
                Locale preferredLocale = localeList.get(index);
                for (Locale locale : supportedLocales) {
                    if (!preferredLocale.equals(locale)) continue;
                    return locale;
                }
                for (Locale locale : supportedLocales) {
                    if (!preferredLocale.getLanguage().equals(locale.toLanguageTag())) continue;
                    return locale;
                }
                for (Locale locale : supportedLocales) {
                    if (!preferredLocale.getLanguage().equals(locale.getLanguage())) continue;
                    return locale;
                }
            }
            return supportedLocales.get(0);
        }
        Locale preferredLocale = this.context.getResources().getConfiguration().locale;
        if (preferredLocale != null) {
            for (Locale locale : supportedLocales) {
                if (!preferredLocale.equals(locale)) continue;
                return locale;
            }
            for (Locale locale : supportedLocales) {
                if (!preferredLocale.getLanguage().equals(locale.toString())) continue;
                return locale;
            }
        }
        return supportedLocales.get(0);
    }

    public void sendLocalesToFlutter(@NonNull Configuration config) {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleList localeList = config.getLocales();
            int localeCount = localeList.size();
            for (int index = 0; index < localeCount; ++index) {
                Locale locale = localeList.get(index);
                locales.add(locale);
            }
        } else {
            locales.add(config.locale);
        }
        this.localizationChannel.sendLocales(locales);
    }

    @VisibleForTesting
    public static Locale localeFromString(String localeString) {
        localeString = localeString.replace('_', '-');
        String[] parts = localeString.split("-", -1);
        String languageCode = parts[0];
        String scriptCode = "";
        String countryCode = "";
        int index = 1;
        if (parts.length > index && parts[index].length() == 4) {
            scriptCode = parts[index];
            ++index;
        }
        if (parts.length > index && parts[index].length() >= 2 && parts[index].length() <= 3) {
            countryCode = parts[index];
            ++index;
        }
        return new Locale(languageCode, countryCode, scriptCode);
    }
}

