import 'package:flutter/material.dart';

/// Flutter code sample for [LinearProgressIndicator].

void main() => runApp(const ProgressIndicatorExampleApp());

class ProgressIndicatorExampleApp extends StatelessWidget {
  const ProgressIndicatorExampleApp({super.key});

  @override
  Widget build(BuildContext context) {
    return const MaterialApp(home: ProgressIndicatorExample());
  }
}

class ProgressIndicatorExample extends StatefulWidget {
  const ProgressIndicatorExample({super.key});

  @override
  State<ProgressIndicatorExample> createState() =>
      _ProgressIndicatorExampleState();
}

class _ProgressIndicatorExampleState extends State<ProgressIndicatorExample>
    with TickerProviderStateMixin {
  late AnimationController controller;
  bool year2023 = true;

  @override
  void initState() {
    super.initState();
    controller =
        AnimationController(
            /// [AnimationController]s can be created with `vsync: this` because of
            /// [TickerProviderStateMixin].
            vsync: this,
            duration: const Duration(seconds: 5),
          )
          ..addListener(() {
            setState(() {});
          })
          ..repeat(reverse: true);
  }

  @override
  void dispose() {
    controller.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: Column(
        spacing: 16.0,
        mainAxisAlignment: MainAxisAlignment.center,
        children: <Widget>[
          const Text('Determinate LinearProgressIndicator'),
          Padding(
            padding: const EdgeInsets.symmetric(horizontal: 16),
            child: LinearProgressIndicator(
              // ignore: deprecated_member_use
              year2023: year2023,
              value: controller.value,
            ),
          ),
          const Text('Indeterminate LinearProgressIndicator'),
          Padding(
            padding: const EdgeInsets.symmetric(horizontal: 16),
            // ignore: deprecated_member_use
            child: LinearProgressIndicator(year2023: year2023),
          ),
          SwitchListTile(
            value: year2023,
            title: year2023
                ? const Text('Switch to latest M3 style')
                : const Text('Switch to year2023 M3 style'),
            onChanged: (bool value) {
              setState(() {
                year2023 = !year2023;
              });
            },
          ),
        ],
      ),
    );
  }
}