import 'package:flutter/material.dart';

/// Flutter code sample for [InputDecoration].

void main() => runApp(const MaterialStateExampleApp());

class MaterialStateExampleApp extends StatelessWidget {
  const MaterialStateExampleApp({super.key});

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      home: Scaffold(
        appBar: AppBar(title: const Text('InputDecoration Sample')),
        body: const MaterialStateExample(),
      ),
    );
  }
}

class MaterialStateExample extends StatelessWidget {
  const MaterialStateExample({super.key});

  @override
  Widget build(BuildContext context) {
    return TextFormField(
      initialValue: 'abc',
      decoration: const InputDecoration(
        prefixIcon: Icon(Icons.person),
        prefixIconColor: WidgetStateColor.fromMap(
          <WidgetStatesConstraint, Color>{
            WidgetState.focused: Colors.green,
            WidgetState.any: Colors.grey,
          },
        ),
      ),
    );
  }
}