import 'package:flutter/cupertino.dart';

/// Flutter code sample for [CupertinoRadio].

void main() => runApp(const CupertinoRadioApp());

class CupertinoRadioApp extends StatelessWidget {
  const CupertinoRadioApp({super.key});

  @override
  Widget build(BuildContext context) {
    return const CupertinoApp(
      theme: CupertinoThemeData(brightness: Brightness.light),
      home: CupertinoPageScaffold(
        navigationBar: CupertinoNavigationBar(
          middle: Text('CupertinoRadio Example'),
        ),
        child: SafeArea(child: CupertinoRadioExample()),
      ),
    );
  }
}

enum SingingCharacter { lafayette, jefferson }

class CupertinoRadioExample extends StatefulWidget {
  const CupertinoRadioExample({super.key});

  @override
  State<CupertinoRadioExample> createState() => _CupertinoRadioExampleState();
}

class _CupertinoRadioExampleState extends State<CupertinoRadioExample> {
  SingingCharacter? _character = SingingCharacter.lafayette;

  @override
  Widget build(BuildContext context) {
    return RadioGroup<SingingCharacter>(
      groupValue: _character,
      onChanged: (SingingCharacter? value) {
        setState(() {
          _character = value;
        });
      },
      child: CupertinoListSection(
        children: const <Widget>[
          CupertinoListTile(
            title: Text('Lafayette'),
            leading: CupertinoRadio<SingingCharacter>(
              value: SingingCharacter.lafayette,
            ),
          ),
          CupertinoListTile(
            title: Text('Thomas Jefferson'),
            leading: CupertinoRadio<SingingCharacter>(
              value: SingingCharacter.jefferson,
            ),
          ),
        ],
      ),
    );
  }
}