/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import androidx.annotation.NonNull;
import io.flutter.Log;
import io.flutter.embedding.android.KeyChannelResponder;
import io.flutter.embedding.android.KeyEmbedderResponder;
import io.flutter.embedding.engine.systemchannels.KeyEventChannel;
import io.flutter.embedding.engine.systemchannels.KeyboardChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.editing.InputConnectionAdaptor;
import java.util.HashSet;
import java.util.Map;

public class KeyboardManager
implements InputConnectionAdaptor.KeyboardDelegate,
KeyboardChannel.KeyboardMethodHandler {
    private static final String TAG = "KeyboardManager";
    protected final Responder[] responders;
    private final HashSet<KeyEvent> redispatchedEvents = new HashSet();
    private final ViewDelegate viewDelegate;

    public KeyboardManager(@NonNull ViewDelegate viewDelegate) {
        this.viewDelegate = viewDelegate;
        this.responders = new Responder[]{new KeyEmbedderResponder(viewDelegate.getBinaryMessenger()), new KeyChannelResponder(new KeyEventChannel(viewDelegate.getBinaryMessenger()))};
        KeyboardChannel keyboardChannel = new KeyboardChannel(viewDelegate.getBinaryMessenger());
        keyboardChannel.setKeyboardMethodHandler(this);
    }

    @Override
    public boolean handleEvent(@NonNull KeyEvent keyEvent) {
        boolean isRedispatchedEvent = this.redispatchedEvents.remove(keyEvent);
        if (isRedispatchedEvent) {
            return false;
        }
        if (this.responders.length > 0) {
            PerEventCallbackBuilder callbackBuilder = new PerEventCallbackBuilder(keyEvent);
            for (Responder primaryResponder : this.responders) {
                primaryResponder.handleEvent(keyEvent, callbackBuilder.buildCallback());
            }
        } else {
            this.onUnhandled(keyEvent);
        }
        return true;
    }

    public void destroy() {
        int remainingRedispatchCount = this.redispatchedEvents.size();
        if (remainingRedispatchCount > 0) {
            Log.w(TAG, "A KeyboardManager was destroyed with " + String.valueOf(remainingRedispatchCount) + " unhandled redispatch event(s).");
        }
    }

    private void onUnhandled(@NonNull KeyEvent keyEvent) {
        if (this.viewDelegate == null || this.viewDelegate.onTextInputKeyEvent(keyEvent)) {
            return;
        }
        this.redispatchedEvents.add(keyEvent);
        this.viewDelegate.redispatch(keyEvent);
        if (this.redispatchedEvents.remove(keyEvent)) {
            Log.w(TAG, "A redispatched key event was consumed before reaching KeyboardManager");
        }
    }

    @Override
    public Map<Long, Long> getKeyboardState() {
        KeyEmbedderResponder embedderResponder = (KeyEmbedderResponder)this.responders[0];
        return embedderResponder.getPressedState();
    }

    private class PerEventCallbackBuilder {
        final KeyEvent keyEvent;
        int unrepliedCount;
        boolean isEventHandled;

        PerEventCallbackBuilder(KeyEvent keyEvent) {
            this.unrepliedCount = KeyboardManager.this.responders.length;
            this.isEventHandled = false;
            this.keyEvent = keyEvent;
        }

        public Responder.OnKeyEventHandledCallback buildCallback() {
            return new Callback();
        }

        private class Callback
        implements Responder.OnKeyEventHandledCallback {
            boolean isCalled = false;

            private Callback() {
            }

            @Override
            public void onKeyEventHandled(boolean canHandleEvent) {
                if (this.isCalled) {
                    throw new IllegalStateException("The onKeyEventHandledCallback should be called exactly once.");
                }
                this.isCalled = true;
                --PerEventCallbackBuilder.this.unrepliedCount;
                PerEventCallbackBuilder.this.isEventHandled |= canHandleEvent;
                if (PerEventCallbackBuilder.this.unrepliedCount == 0 && !PerEventCallbackBuilder.this.isEventHandled) {
                    KeyboardManager.this.onUnhandled(PerEventCallbackBuilder.this.keyEvent);
                }
            }
        }
    }

    public static interface ViewDelegate {
        public BinaryMessenger getBinaryMessenger();

        public boolean onTextInputKeyEvent(@NonNull KeyEvent var1);

        public void redispatch(@NonNull KeyEvent var1);
    }

    public static interface Responder {
        public void handleEvent(@NonNull KeyEvent var1, @NonNull OnKeyEventHandledCallback var2);

        public static interface OnKeyEventHandledCallback {
            public void onKeyEventHandled(boolean var1);
        }
    }

    public static class CharacterCombiner {
        private int combiningCharacter = 0;

        Character applyCombiningCharacterToBaseCharacter(int newCharacterCodePoint) {
            boolean isNewCodePointACombiningCharacter;
            char complexCharacter = (char)newCharacterCodePoint;
            boolean bl = isNewCodePointACombiningCharacter = (newCharacterCodePoint & Integer.MIN_VALUE) != 0;
            if (isNewCodePointACombiningCharacter) {
                int plainCodePoint = newCharacterCodePoint & Integer.MAX_VALUE;
                this.combiningCharacter = this.combiningCharacter != 0 ? KeyCharacterMap.getDeadChar((int)this.combiningCharacter, (int)plainCodePoint) : plainCodePoint;
            } else if (this.combiningCharacter != 0) {
                int combinedChar = KeyCharacterMap.getDeadChar((int)this.combiningCharacter, (int)newCharacterCodePoint);
                if (combinedChar > 0) {
                    complexCharacter = (char)combinedChar;
                }
                this.combiningCharacter = 0;
            }
            return Character.valueOf(complexCharacter);
        }
    }
}

