/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.Log;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.StandardMethodCodec;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class PlatformViewsChannel {
    private static final String TAG = "PlatformViewsChannel";
    private final MethodChannel channel;
    private PlatformViewsHandler handler;
    private final MethodChannel.MethodCallHandler parsingHandler = new MethodChannel.MethodCallHandler(){

        @Override
        public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            if (PlatformViewsChannel.this.handler == null) {
                return;
            }
            Log.v(PlatformViewsChannel.TAG, "Received '" + call.method + "' message.");
            switch (call.method) {
                case "create": {
                    this.create(call, result);
                    break;
                }
                case "dispose": {
                    this.dispose(call, result);
                    break;
                }
                case "resize": {
                    this.resize(call, result);
                    break;
                }
                case "touch": {
                    this.touch(call, result);
                    break;
                }
                case "setDirection": {
                    this.setDirection(call, result);
                    break;
                }
                case "clearFocus": {
                    this.clearFocus(call, result);
                    break;
                }
                case "synchronizeToNativeViewHierarchy": {
                    this.synchronizeToNativeViewHierarchy(call, result);
                    break;
                }
                default: {
                    result.notImplemented();
                }
            }
        }

        private void create(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            Map createArgs = (Map)call.arguments();
            boolean usesHybridComposition = createArgs.containsKey("hybrid") && (Boolean)createArgs.get("hybrid") != false;
            double width = usesHybridComposition ? 0.0 : (Double)createArgs.get("width");
            double height = usesHybridComposition ? 0.0 : (Double)createArgs.get("height");
            PlatformViewCreationRequest request = new PlatformViewCreationRequest((Integer)createArgs.get("id"), (String)createArgs.get("viewType"), width, height, (Integer)createArgs.get("direction"), createArgs.containsKey("params") ? ByteBuffer.wrap((byte[])createArgs.get("params")) : null);
            try {
                if (usesHybridComposition) {
                    PlatformViewsChannel.this.handler.createAndroidViewForPlatformView(request);
                    result.success(null);
                } else {
                    long textureId = PlatformViewsChannel.this.handler.createVirtualDisplayForPlatformView(request);
                    result.success(textureId);
                }
            }
            catch (IllegalStateException exception) {
                result.error("error", PlatformViewsChannel.detailedExceptionString(exception), null);
            }
        }

        private void dispose(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            Map disposeArgs = (Map)call.arguments();
            int viewId = (Integer)disposeArgs.get("id");
            boolean usesHybridComposition = disposeArgs.containsKey("hybrid") && (Boolean)disposeArgs.get("hybrid") != false;
            try {
                if (usesHybridComposition) {
                    PlatformViewsChannel.this.handler.disposeAndroidViewForPlatformView(viewId);
                } else {
                    PlatformViewsChannel.this.handler.disposeVirtualDisplayForPlatformView(viewId);
                }
                result.success(null);
            }
            catch (IllegalStateException exception) {
                result.error("error", PlatformViewsChannel.detailedExceptionString(exception), null);
            }
        }

        private void resize(@NonNull MethodCall call, final @NonNull MethodChannel.Result result) {
            Map resizeArgs = (Map)call.arguments();
            PlatformViewResizeRequest resizeRequest = new PlatformViewResizeRequest((Integer)resizeArgs.get("id"), (Double)resizeArgs.get("width"), (Double)resizeArgs.get("height"));
            try {
                PlatformViewsChannel.this.handler.resizePlatformView(resizeRequest, new Runnable(){

                    @Override
                    public void run() {
                        result.success(null);
                    }
                });
            }
            catch (IllegalStateException exception) {
                result.error("error", PlatformViewsChannel.detailedExceptionString(exception), null);
            }
        }

        private void touch(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            List args = (List)call.arguments();
            PlatformViewTouch touch = new PlatformViewTouch((Integer)args.get(0), (Number)args.get(1), (Number)args.get(2), (Integer)args.get(3), (Integer)args.get(4), args.get(5), args.get(6), (Integer)args.get(7), (Integer)args.get(8), (float)((Double)args.get(9)).doubleValue(), (float)((Double)args.get(10)).doubleValue(), (Integer)args.get(11), (Integer)args.get(12), (Integer)args.get(13), (Integer)args.get(14), ((Number)args.get(15)).longValue());
            try {
                PlatformViewsChannel.this.handler.onTouch(touch);
                result.success(null);
            }
            catch (IllegalStateException exception) {
                result.error("error", PlatformViewsChannel.detailedExceptionString(exception), null);
            }
        }

        private void setDirection(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            Map setDirectionArgs = (Map)call.arguments();
            int newDirectionViewId = (Integer)setDirectionArgs.get("id");
            int direction = (Integer)setDirectionArgs.get("direction");
            try {
                PlatformViewsChannel.this.handler.setDirection(newDirectionViewId, direction);
                result.success(null);
            }
            catch (IllegalStateException exception) {
                result.error("error", PlatformViewsChannel.detailedExceptionString(exception), null);
            }
        }

        private void clearFocus(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            int viewId = (Integer)call.arguments();
            try {
                PlatformViewsChannel.this.handler.clearFocus(viewId);
                result.success(null);
            }
            catch (IllegalStateException exception) {
                result.error("error", PlatformViewsChannel.detailedExceptionString(exception), null);
            }
        }

        private void synchronizeToNativeViewHierarchy(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            boolean yes = (Boolean)call.arguments();
            try {
                PlatformViewsChannel.this.handler.synchronizeToNativeViewHierarchy(yes);
                result.success(null);
            }
            catch (IllegalStateException exception) {
                result.error("error", PlatformViewsChannel.detailedExceptionString(exception), null);
            }
        }
    };

    public void invokeViewFocused(int viewId) {
        if (this.channel == null) {
            return;
        }
        this.channel.invokeMethod("viewFocused", viewId);
    }

    private static String detailedExceptionString(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public PlatformViewsChannel(@NonNull DartExecutor dartExecutor) {
        this.channel = new MethodChannel(dartExecutor, "flutter/platform_views", StandardMethodCodec.INSTANCE);
        this.channel.setMethodCallHandler(this.parsingHandler);
    }

    public void setPlatformViewsHandler(@Nullable PlatformViewsHandler handler) {
        this.handler = handler;
    }

    public static class PlatformViewTouch {
        public final int viewId;
        @NonNull
        public final Number downTime;
        @NonNull
        public final Number eventTime;
        public final int action;
        public final int pointerCount;
        @NonNull
        public final Object rawPointerPropertiesList;
        @NonNull
        public final Object rawPointerCoords;
        public final int metaState;
        public final int buttonState;
        public final float xPrecision;
        public final float yPrecision;
        public final int deviceId;
        public final int edgeFlags;
        public final int source;
        public final int flags;
        public final long motionEventId;

        public PlatformViewTouch(int viewId, @NonNull Number downTime, @NonNull Number eventTime, int action, int pointerCount, @NonNull Object rawPointerPropertiesList, @NonNull Object rawPointerCoords, int metaState, int buttonState, float xPrecision, float yPrecision, int deviceId, int edgeFlags, int source, int flags, long motionEventId) {
            this.viewId = viewId;
            this.downTime = downTime;
            this.eventTime = eventTime;
            this.action = action;
            this.pointerCount = pointerCount;
            this.rawPointerPropertiesList = rawPointerPropertiesList;
            this.rawPointerCoords = rawPointerCoords;
            this.metaState = metaState;
            this.buttonState = buttonState;
            this.xPrecision = xPrecision;
            this.yPrecision = yPrecision;
            this.deviceId = deviceId;
            this.edgeFlags = edgeFlags;
            this.source = source;
            this.flags = flags;
            this.motionEventId = motionEventId;
        }
    }

    public static class PlatformViewResizeRequest {
        public final int viewId;
        public final double newLogicalWidth;
        public final double newLogicalHeight;

        public PlatformViewResizeRequest(int viewId, double newLogicalWidth, double newLogicalHeight) {
            this.viewId = viewId;
            this.newLogicalWidth = newLogicalWidth;
            this.newLogicalHeight = newLogicalHeight;
        }
    }

    public static class PlatformViewCreationRequest {
        public final int viewId;
        @NonNull
        public final String viewType;
        public final double logicalWidth;
        public final double logicalHeight;
        public final int direction;
        @Nullable
        public final ByteBuffer params;

        public PlatformViewCreationRequest(int viewId, @NonNull String viewType, double logicalWidth, double logicalHeight, int direction, @Nullable ByteBuffer params) {
            this.viewId = viewId;
            this.viewType = viewType;
            this.logicalWidth = logicalWidth;
            this.logicalHeight = logicalHeight;
            this.direction = direction;
            this.params = params;
        }
    }

    public static interface PlatformViewsHandler {
        public void createAndroidViewForPlatformView(@NonNull PlatformViewCreationRequest var1);

        public void disposeAndroidViewForPlatformView(int var1);

        public long createVirtualDisplayForPlatformView(@NonNull PlatformViewCreationRequest var1);

        public void disposeVirtualDisplayForPlatformView(int var1);

        public void resizePlatformView(@NonNull PlatformViewResizeRequest var1, @NonNull Runnable var2);

        public void onTouch(@NonNull PlatformViewTouch var1);

        public void setDirection(int var1, int var2);

        public void clearFocus(int var1);

        public void synchronizeToNativeViewHierarchy(boolean var1);
    }
}

