/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.renderer;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.os.Handler;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.Log;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.renderer.FlutterUiDisplayListener;
import io.flutter.embedding.engine.renderer.SurfaceTextureWrapper;
import io.flutter.view.TextureRegistry;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

@TargetApi(value=16)
public class FlutterRenderer
implements TextureRegistry {
    private static final String TAG = "FlutterRenderer";
    @NonNull
    private final FlutterJNI flutterJNI;
    @NonNull
    private final AtomicLong nextTextureId = new AtomicLong(0L);
    @Nullable
    private Surface surface;
    private boolean isDisplayingFlutterUi = false;
    private Handler handler = new Handler();
    @NonNull
    private final FlutterUiDisplayListener flutterUiDisplayListener = new FlutterUiDisplayListener(){

        @Override
        public void onFlutterUiDisplayed() {
            FlutterRenderer.this.isDisplayingFlutterUi = true;
        }

        @Override
        public void onFlutterUiNoLongerDisplayed() {
            FlutterRenderer.this.isDisplayingFlutterUi = false;
        }
    };

    public FlutterRenderer(@NonNull FlutterJNI flutterJNI) {
        this.flutterJNI = flutterJNI;
        this.flutterJNI.addIsDisplayingFlutterUiListener(this.flutterUiDisplayListener);
    }

    public boolean isDisplayingFlutterUi() {
        return this.isDisplayingFlutterUi;
    }

    public void addIsDisplayingFlutterUiListener(@NonNull FlutterUiDisplayListener listener) {
        this.flutterJNI.addIsDisplayingFlutterUiListener(listener);
        if (this.isDisplayingFlutterUi) {
            listener.onFlutterUiDisplayed();
        }
    }

    public void removeIsDisplayingFlutterUiListener(@NonNull FlutterUiDisplayListener listener) {
        this.flutterJNI.removeIsDisplayingFlutterUiListener(listener);
    }

    @Override
    public TextureRegistry.SurfaceTextureEntry createSurfaceTexture() {
        Log.v(TAG, "Creating a SurfaceTexture.");
        SurfaceTexture surfaceTexture = new SurfaceTexture(0);
        return this.registerSurfaceTexture(surfaceTexture);
    }

    @Override
    public TextureRegistry.SurfaceTextureEntry registerSurfaceTexture(@NonNull SurfaceTexture surfaceTexture) {
        surfaceTexture.detachFromGLContext();
        SurfaceTextureRegistryEntry entry = new SurfaceTextureRegistryEntry(this.nextTextureId.getAndIncrement(), surfaceTexture);
        Log.v(TAG, "New SurfaceTexture ID: " + entry.id());
        this.registerTexture(entry.id(), entry.textureWrapper());
        return entry;
    }

    public void startRenderingToSurface(@NonNull Surface surface, boolean keepCurrentSurface) {
        if (this.surface != null && !keepCurrentSurface) {
            this.stopRenderingToSurface();
        }
        this.surface = surface;
        this.flutterJNI.onSurfaceCreated(surface);
    }

    public void swapSurface(@NonNull Surface surface) {
        this.surface = surface;
        this.flutterJNI.onSurfaceWindowChanged(surface);
    }

    public void surfaceChanged(int width, int height) {
        this.flutterJNI.onSurfaceChanged(width, height);
    }

    public void stopRenderingToSurface() {
        this.flutterJNI.onSurfaceDestroyed();
        this.surface = null;
        if (this.isDisplayingFlutterUi) {
            this.flutterUiDisplayListener.onFlutterUiNoLongerDisplayed();
        }
        this.isDisplayingFlutterUi = false;
    }

    public void setViewportMetrics(@NonNull ViewportMetrics viewportMetrics) {
        if (!viewportMetrics.validate()) {
            return;
        }
        Log.v(TAG, "Setting viewport metrics\nSize: " + viewportMetrics.width + " x " + viewportMetrics.height + "\nPadding - L: " + viewportMetrics.viewPaddingLeft + ", T: " + viewportMetrics.viewPaddingTop + ", R: " + viewportMetrics.viewPaddingRight + ", B: " + viewportMetrics.viewPaddingBottom + "\nInsets - L: " + viewportMetrics.viewInsetLeft + ", T: " + viewportMetrics.viewInsetTop + ", R: " + viewportMetrics.viewInsetRight + ", B: " + viewportMetrics.viewInsetBottom + "\nSystem Gesture Insets - L: " + viewportMetrics.systemGestureInsetLeft + ", T: " + viewportMetrics.systemGestureInsetTop + ", R: " + viewportMetrics.systemGestureInsetRight + ", B: " + viewportMetrics.systemGestureInsetRight + "\nDisplay Features: " + viewportMetrics.displayFeatures.size());
        int[] displayFeaturesBounds = new int[viewportMetrics.displayFeatures.size() * 4];
        int[] displayFeaturesType = new int[viewportMetrics.displayFeatures.size()];
        int[] displayFeaturesState = new int[viewportMetrics.displayFeatures.size()];
        for (int i = 0; i < viewportMetrics.displayFeatures.size(); ++i) {
            DisplayFeature displayFeature = viewportMetrics.displayFeatures.get(i);
            displayFeaturesBounds[4 * i] = displayFeature.bounds.left;
            displayFeaturesBounds[4 * i + 1] = displayFeature.bounds.top;
            displayFeaturesBounds[4 * i + 2] = displayFeature.bounds.right;
            displayFeaturesBounds[4 * i + 3] = displayFeature.bounds.bottom;
            displayFeaturesType[i] = displayFeature.type.encodedValue;
            displayFeaturesState[i] = displayFeature.state.encodedValue;
        }
        this.flutterJNI.setViewportMetrics(viewportMetrics.devicePixelRatio, viewportMetrics.width, viewportMetrics.height, viewportMetrics.viewPaddingTop, viewportMetrics.viewPaddingRight, viewportMetrics.viewPaddingBottom, viewportMetrics.viewPaddingLeft, viewportMetrics.viewInsetTop, viewportMetrics.viewInsetRight, viewportMetrics.viewInsetBottom, viewportMetrics.viewInsetLeft, viewportMetrics.systemGestureInsetTop, viewportMetrics.systemGestureInsetRight, viewportMetrics.systemGestureInsetBottom, viewportMetrics.systemGestureInsetLeft, viewportMetrics.physicalTouchSlop, displayFeaturesBounds, displayFeaturesType, displayFeaturesState);
    }

    public Bitmap getBitmap() {
        return this.flutterJNI.getBitmap();
    }

    public void dispatchPointerDataPacket(@NonNull ByteBuffer buffer, int position) {
        this.flutterJNI.dispatchPointerDataPacket(buffer, position);
    }

    private void registerTexture(long textureId, @NonNull SurfaceTextureWrapper textureWrapper) {
        this.flutterJNI.registerTexture(textureId, textureWrapper);
    }

    private void markTextureFrameAvailable(long textureId) {
        this.flutterJNI.markTextureFrameAvailable(textureId);
    }

    private void unregisterTexture(long textureId) {
        this.flutterJNI.unregisterTexture(textureId);
    }

    public boolean isSoftwareRenderingEnabled() {
        return this.flutterJNI.getIsSoftwareRenderingEnabled();
    }

    public void setAccessibilityFeatures(int flags) {
        this.flutterJNI.setAccessibilityFeatures(flags);
    }

    public void setSemanticsEnabled(boolean enabled) {
        this.flutterJNI.setSemanticsEnabled(enabled);
    }

    public void dispatchSemanticsAction(int id, int action, @Nullable ByteBuffer args, int argsPosition) {
        this.flutterJNI.dispatchSemanticsAction(id, action, args, argsPosition);
    }

    public static enum DisplayFeatureState {
        UNKNOWN(0),
        POSTURE_FLAT(1),
        POSTURE_HALF_OPENED(2);

        public final int encodedValue;

        private DisplayFeatureState(int encodedValue) {
            this.encodedValue = encodedValue;
        }
    }

    public static enum DisplayFeatureType {
        UNKNOWN(0),
        FOLD(1),
        HINGE(2),
        CUTOUT(3);

        public final int encodedValue;

        private DisplayFeatureType(int encodedValue) {
            this.encodedValue = encodedValue;
        }
    }

    public static final class DisplayFeature {
        public final Rect bounds;
        public final DisplayFeatureType type;
        public final DisplayFeatureState state;

        public DisplayFeature(Rect bounds, DisplayFeatureType type, DisplayFeatureState state) {
            this.bounds = bounds;
            this.type = type;
            this.state = state;
        }

        public DisplayFeature(Rect bounds, DisplayFeatureType type) {
            this.bounds = bounds;
            this.type = type;
            this.state = DisplayFeatureState.UNKNOWN;
        }
    }

    public static final class ViewportMetrics {
        public static final int unsetValue = -1;
        public float devicePixelRatio = 1.0f;
        public int width = 0;
        public int height = 0;
        public int viewPaddingTop = 0;
        public int viewPaddingRight = 0;
        public int viewPaddingBottom = 0;
        public int viewPaddingLeft = 0;
        public int viewInsetTop = 0;
        public int viewInsetRight = 0;
        public int viewInsetBottom = 0;
        public int viewInsetLeft = 0;
        public int systemGestureInsetTop = 0;
        public int systemGestureInsetRight = 0;
        public int systemGestureInsetBottom = 0;
        public int systemGestureInsetLeft = 0;
        public int physicalTouchSlop = -1;
        public List<DisplayFeature> displayFeatures = new ArrayList<DisplayFeature>();

        boolean validate() {
            return this.width > 0 && this.height > 0 && this.devicePixelRatio > 0.0f;
        }
    }

    static final class SurfaceTextureFinalizerRunnable
    implements Runnable {
        private final long id;
        private final FlutterJNI flutterJNI;

        SurfaceTextureFinalizerRunnable(long id, @NonNull FlutterJNI flutterJNI) {
            this.id = id;
            this.flutterJNI = flutterJNI;
        }

        @Override
        public void run() {
            if (!this.flutterJNI.isAttached()) {
                return;
            }
            Log.v(FlutterRenderer.TAG, "Releasing a SurfaceTexture (" + this.id + ").");
            this.flutterJNI.unregisterTexture(this.id);
        }
    }

    final class SurfaceTextureRegistryEntry
    implements TextureRegistry.SurfaceTextureEntry {
        private final long id;
        @NonNull
        private final SurfaceTextureWrapper textureWrapper;
        private boolean released;
        private SurfaceTexture.OnFrameAvailableListener onFrameListener = new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(@NonNull SurfaceTexture texture) {
                if (SurfaceTextureRegistryEntry.this.released || !FlutterRenderer.this.flutterJNI.isAttached()) {
                    return;
                }
                FlutterRenderer.this.markTextureFrameAvailable(SurfaceTextureRegistryEntry.this.id);
            }
        };

        SurfaceTextureRegistryEntry(@NonNull long id, SurfaceTexture surfaceTexture) {
            this.id = id;
            this.textureWrapper = new SurfaceTextureWrapper(surfaceTexture);
            if (Build.VERSION.SDK_INT >= 21) {
                this.surfaceTexture().setOnFrameAvailableListener(this.onFrameListener, new Handler());
            } else {
                this.surfaceTexture().setOnFrameAvailableListener(this.onFrameListener);
            }
        }

        @NonNull
        public SurfaceTextureWrapper textureWrapper() {
            return this.textureWrapper;
        }

        @Override
        @NonNull
        public SurfaceTexture surfaceTexture() {
            return this.textureWrapper.surfaceTexture();
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public void release() {
            if (this.released) {
                return;
            }
            Log.v(FlutterRenderer.TAG, "Releasing a SurfaceTexture (" + this.id + ").");
            this.textureWrapper.release();
            FlutterRenderer.this.unregisterTexture(this.id);
            this.released = true;
        }

        protected void finalize() throws Throwable {
            try {
                if (this.released) {
                    return;
                }
                FlutterRenderer.this.handler.post((Runnable)new SurfaceTextureFinalizerRunnable(this.id, FlutterRenderer.this.flutterJNI));
            }
            finally {
                super.finalize();
            }
        }
    }
}

