/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.util;

import android.content.Context;
import android.os.Build;
import java.io.File;

public final class PathUtils {
    public static String getFilesDir(Context applicationContext) {
        File filesDir = applicationContext.getFilesDir();
        if (filesDir == null) {
            filesDir = new File(PathUtils.getDataDirPath(applicationContext), "files");
        }
        return filesDir.getPath();
    }

    public static String getDataDirectory(Context applicationContext) {
        String name = "flutter";
        File flutterDir = applicationContext.getDir("flutter", 0);
        if (flutterDir == null) {
            flutterDir = new File(PathUtils.getDataDirPath(applicationContext), "app_flutter");
        }
        return flutterDir.getPath();
    }

    public static String getCacheDirectory(Context applicationContext) {
        File cacheDir;
        if (Build.VERSION.SDK_INT >= 21) {
            cacheDir = applicationContext.getCodeCacheDir();
            if (cacheDir == null) {
                cacheDir = applicationContext.getCacheDir();
            }
        } else {
            cacheDir = applicationContext.getCacheDir();
        }
        if (cacheDir == null) {
            cacheDir = new File(PathUtils.getDataDirPath(applicationContext), "cache");
        }
        return cacheDir.getPath();
    }

    private static String getDataDirPath(Context applicationContext) {
        if (Build.VERSION.SDK_INT >= 24) {
            return applicationContext.getDataDir().getPath();
        }
        return applicationContext.getApplicationInfo().dataDir;
    }
}

