/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.mutatorsstack;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Path;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.embedding.android.AndroidTouchProcessor;
import io.flutter.embedding.engine.mutatorsstack.FlutterMutatorsStack;

public class FlutterMutatorView
extends FrameLayout {
    private FlutterMutatorsStack mutatorsStack;
    private float screenDensity;
    private int left;
    private int top;
    private int prevLeft;
    private int prevTop;
    private final AndroidTouchProcessor androidTouchProcessor;
    @Nullable
    @VisibleForTesting
    ViewTreeObserver.OnGlobalFocusChangeListener activeFocusListener;

    public FlutterMutatorView(@NonNull Context context, float screenDensity, @Nullable AndroidTouchProcessor androidTouchProcessor) {
        super(context, null);
        this.screenDensity = screenDensity;
        this.androidTouchProcessor = androidTouchProcessor;
    }

    public FlutterMutatorView(@NonNull Context context) {
        this(context, 1.0f, null);
    }

    @VisibleForTesting
    public static boolean childHasFocus(@Nullable View root) {
        if (root == null) {
            return false;
        }
        if (root.hasFocus()) {
            return true;
        }
        if (root instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)root;
            for (int idx = 0; idx < viewGroup.getChildCount(); ++idx) {
                if (!FlutterMutatorView.childHasFocus(viewGroup.getChildAt(idx))) continue;
                return true;
            }
        }
        return false;
    }

    public void setOnDescendantFocusChangeListener(final @NonNull View.OnFocusChangeListener userFocusListener) {
        this.unsetOnDescendantFocusChangeListener();
        FlutterMutatorView mutatorView = this;
        ViewTreeObserver observer = this.getViewTreeObserver();
        if (observer.isAlive() && this.activeFocusListener == null) {
            this.activeFocusListener = new ViewTreeObserver.OnGlobalFocusChangeListener((View)mutatorView){
                final /* synthetic */ View val$mutatorView;
                {
                    this.val$mutatorView = view;
                }

                public void onGlobalFocusChanged(View oldFocus, View newFocus) {
                    userFocusListener.onFocusChange(this.val$mutatorView, FlutterMutatorView.childHasFocus(this.val$mutatorView));
                }
            };
            observer.addOnGlobalFocusChangeListener(this.activeFocusListener);
        }
    }

    public void unsetOnDescendantFocusChangeListener() {
        ViewTreeObserver observer = this.getViewTreeObserver();
        if (observer.isAlive() && this.activeFocusListener != null) {
            ViewTreeObserver.OnGlobalFocusChangeListener currFocusListener = this.activeFocusListener;
            this.activeFocusListener = null;
            observer.removeOnGlobalFocusChangeListener(currFocusListener);
        }
    }

    public void readyToDisplay(@NonNull FlutterMutatorsStack mutatorsStack, int left, int top, int width, int height) {
        this.mutatorsStack = mutatorsStack;
        this.left = left;
        this.top = top;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(width, height);
        layoutParams.leftMargin = left;
        layoutParams.topMargin = top;
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.setWillNotDraw(false);
    }

    public void draw(Canvas canvas) {
        canvas.save();
        for (Path path : this.mutatorsStack.getFinalClippingPaths()) {
            Path pathCopy = new Path(path);
            pathCopy.offset((float)(-this.left), (float)(-this.top));
            canvas.clipPath(pathCopy);
        }
        super.draw(canvas);
        canvas.restore();
    }

    public void dispatchDraw(Canvas canvas) {
        canvas.save();
        canvas.concat(this.getPlatformViewMatrix());
        super.dispatchDraw(canvas);
        canvas.restore();
    }

    private Matrix getPlatformViewMatrix() {
        Matrix finalMatrix = new Matrix(this.mutatorsStack.getFinalMatrix());
        finalMatrix.preScale(1.0f / this.screenDensity, 1.0f / this.screenDensity);
        finalMatrix.postTranslate((float)(-this.left), (float)(-this.top));
        return finalMatrix;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        return true;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (this.androidTouchProcessor == null) {
            return super.onTouchEvent(event);
        }
        Matrix screenMatrix = new Matrix();
        switch (event.getAction()) {
            case 0: {
                this.prevLeft = this.left;
                this.prevTop = this.top;
                screenMatrix.postTranslate((float)this.left, (float)this.top);
                break;
            }
            case 2: {
                screenMatrix.postTranslate((float)this.prevLeft, (float)this.prevTop);
                this.prevLeft = this.left;
                this.prevTop = this.top;
                break;
            }
            default: {
                screenMatrix.postTranslate((float)this.left, (float)this.top);
            }
        }
        return this.androidTouchProcessor.onTouchEvent(event, screenMatrix);
    }
}

