/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.util.LongSparseArray;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicLong;

public final class MotionEventTracker {
    private final LongSparseArray<MotionEvent> eventById = new LongSparseArray();
    private final PriorityQueue<Long> unusedEvents = new PriorityQueue();
    private static MotionEventTracker INSTANCE;

    @NonNull
    public static MotionEventTracker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MotionEventTracker();
        }
        return INSTANCE;
    }

    private MotionEventTracker() {
    }

    @NonNull
    public MotionEventId track(@NonNull MotionEvent event) {
        MotionEventId eventId = MotionEventId.createUnique();
        this.eventById.put(eventId.id, (Object)MotionEvent.obtain((MotionEvent)event));
        this.unusedEvents.add(eventId.id);
        return eventId;
    }

    @Nullable
    public MotionEvent pop(@NonNull MotionEventId eventId) {
        while (!this.unusedEvents.isEmpty() && this.unusedEvents.peek() < eventId.id) {
            this.eventById.remove(this.unusedEvents.poll().longValue());
        }
        if (!this.unusedEvents.isEmpty() && this.unusedEvents.peek() == eventId.id) {
            this.unusedEvents.poll();
        }
        MotionEvent event = (MotionEvent)this.eventById.get(eventId.id);
        this.eventById.remove(eventId.id);
        return event;
    }

    public static class MotionEventId {
        private static final AtomicLong ID_COUNTER = new AtomicLong(0L);
        private final long id;

        private MotionEventId(long id) {
            this.id = id;
        }

        @NonNull
        public static MotionEventId from(long id) {
            return new MotionEventId(id);
        }

        @NonNull
        public static MotionEventId createUnique() {
            return MotionEventId.from(ID_COUNTER.incrementAndGet());
        }

        public long getId() {
            return this.id;
        }
    }
}

