/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.image;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import io.flutter.embedding.engine.image.BitmapMetadataReader;
import io.flutter.embedding.engine.image.ExifMetadataReader;
import io.flutter.embedding.engine.image.FlutterImageDecoder;
import io.flutter.embedding.engine.image.ImageUtils;
import io.flutter.embedding.engine.image.MediaMetadataReader;
import java.nio.ByteBuffer;

@RequiresApi(value=28)
class Metadata {
    int width;
    int height;
    int rotation;
    @Nullable
    String mimeType;
    int orientation;
    int originalHeight;
    int originalWidth;

    @VisibleForTesting
    Metadata() {
    }

    static Metadata create(@NonNull ByteBuffer buffer, @NonNull FlutterImageDecoder.HeaderListener headerListener) {
        Metadata metadata = new Metadata();
        byte[] bytes = ImageUtils.getBytes(buffer);
        BitmapMetadataReader.read(bytes, metadata);
        if (metadata.isHeif()) {
            MediaMetadataReader.read(bytes, metadata);
            headerListener.onImageHeader(metadata.width, metadata.height);
            ExifMetadataReader.read(bytes, metadata);
        }
        return metadata;
    }

    boolean isHeif() {
        return "image/heif".equals(this.mimeType);
    }
}

