/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.editing;

import android.annotation.SuppressLint;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ContentResolver;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.text.DynamicLayout;
import android.text.Editable;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextPaint;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodSubtype;
import io.flutter.Log;
import io.flutter.embedding.android.AndroidKeyProcessor;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.systemchannels.TextInputChannel;
import io.flutter.plugin.editing.FlutterTextUtils;
import io.flutter.plugin.editing.ListenableEditingState;

class InputConnectionAdaptor
extends BaseInputConnection
implements ListenableEditingState.EditingStateWatcher {
    private static final String TAG = "InputConnectionAdaptor";
    private final View mFlutterView;
    private final int mClient;
    private final TextInputChannel textInputChannel;
    private final AndroidKeyProcessor keyProcessor;
    private final ListenableEditingState mEditable;
    private final EditorInfo mEditorInfo;
    private ExtractedTextRequest mExtractRequest;
    private boolean mMonitorCursorUpdate = false;
    private CursorAnchorInfo.Builder mCursorAnchorInfoBuilder;
    private ExtractedText mExtractedText = new ExtractedText();
    private InputMethodManager mImm;
    private final Layout mLayout;
    private FlutterTextUtils flutterTextUtils;

    public InputConnectionAdaptor(View view, int client, TextInputChannel textInputChannel, AndroidKeyProcessor keyProcessor, ListenableEditingState editable, EditorInfo editorInfo, FlutterJNI flutterJNI) {
        super(view, true);
        this.mFlutterView = view;
        this.mClient = client;
        this.textInputChannel = textInputChannel;
        this.mEditable = editable;
        this.mEditable.addEditingStateListener(this);
        this.mEditorInfo = editorInfo;
        this.keyProcessor = keyProcessor;
        this.flutterTextUtils = new FlutterTextUtils(flutterJNI);
        this.mLayout = new DynamicLayout((CharSequence)((Object)this.mEditable), new TextPaint(), Integer.MAX_VALUE, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        this.mImm = (InputMethodManager)view.getContext().getSystemService("input_method");
    }

    public InputConnectionAdaptor(View view, int client, TextInputChannel textInputChannel, AndroidKeyProcessor keyProcessor, ListenableEditingState editable, EditorInfo editorInfo) {
        this(view, client, textInputChannel, keyProcessor, editable, editorInfo, new FlutterJNI());
    }

    private ExtractedText getExtractedText(ExtractedTextRequest request) {
        this.mExtractedText.startOffset = 0;
        this.mExtractedText.partialStartOffset = -1;
        this.mExtractedText.partialEndOffset = -1;
        this.mExtractedText.selectionStart = this.mEditable.getSelectionStart();
        this.mExtractedText.selectionEnd = this.mEditable.getSelectionEnd();
        this.mExtractedText.text = request == null || (request.flags & 1) == 0 ? this.mEditable.toString() : this.mEditable;
        return this.mExtractedText;
    }

    private CursorAnchorInfo getCursorAnchorInfo() {
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        if (this.mCursorAnchorInfoBuilder == null) {
            this.mCursorAnchorInfoBuilder = new CursorAnchorInfo.Builder();
        } else {
            this.mCursorAnchorInfoBuilder.reset();
        }
        this.mCursorAnchorInfoBuilder.setSelectionRange(this.mEditable.getSelectionStart(), this.mEditable.getSelectionEnd());
        int composingStart = this.mEditable.getComposingStart();
        int composingEnd = this.mEditable.getComposingEnd();
        if (composingStart >= 0 && composingEnd > composingStart) {
            this.mCursorAnchorInfoBuilder.setComposingText(composingStart, this.mEditable.toString().subSequence(composingStart, composingEnd));
        } else {
            this.mCursorAnchorInfoBuilder.setComposingText(-1, (CharSequence)"");
        }
        return this.mCursorAnchorInfoBuilder.build();
    }

    public Editable getEditable() {
        return this.mEditable;
    }

    public boolean beginBatchEdit() {
        this.mEditable.beginBatchEdit();
        return super.beginBatchEdit();
    }

    public boolean endBatchEdit() {
        boolean result = super.endBatchEdit();
        this.mEditable.endBatchEdit();
        return result;
    }

    public boolean commitText(CharSequence text, int newCursorPosition) {
        boolean result = super.commitText(text, newCursorPosition);
        return result;
    }

    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        if (this.mEditable.getSelectionStart() == -1) {
            return true;
        }
        boolean result = super.deleteSurroundingText(beforeLength, afterLength);
        return result;
    }

    public boolean deleteSurroundingTextInCodePoints(int beforeLength, int afterLength) {
        boolean result = super.deleteSurroundingTextInCodePoints(beforeLength, afterLength);
        return result;
    }

    public boolean setComposingRegion(int start, int end) {
        boolean result = super.setComposingRegion(start, end);
        return result;
    }

    public boolean setComposingText(CharSequence text, int newCursorPosition) {
        this.beginBatchEdit();
        boolean result = text.length() == 0 ? super.commitText(text, newCursorPosition) : super.setComposingText(text, newCursorPosition);
        this.endBatchEdit();
        return result;
    }

    public boolean finishComposingText() {
        boolean result = super.finishComposingText();
        return result;
    }

    public ExtractedText getExtractedText(ExtractedTextRequest request, int flags) {
        boolean textMonitor = (flags & 1) != 0;
        if (textMonitor == (this.mExtractRequest == null)) {
            Log.d(TAG, "The input method toggled text monitoring " + (textMonitor ? "on" : "off"));
        }
        this.mExtractRequest = textMonitor ? request : null;
        return this.getExtractedText(request);
    }

    public boolean requestCursorUpdates(int cursorUpdateMode) {
        boolean updated;
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        if ((cursorUpdateMode & 1) != 0) {
            this.mImm.updateCursorAnchorInfo(this.mFlutterView, this.getCursorAnchorInfo());
        }
        boolean bl = updated = (cursorUpdateMode & 2) != 0;
        if (updated != this.mMonitorCursorUpdate) {
            Log.d(TAG, "The input method toggled cursor monitoring " + (updated ? "on" : "off"));
        }
        this.mMonitorCursorUpdate = updated;
        return true;
    }

    public boolean clearMetaKeyStates(int states) {
        boolean result = super.clearMetaKeyStates(states);
        return result;
    }

    public void closeConnection() {
        super.closeConnection();
        this.mEditable.removeEditingStateListener(this);
    }

    @SuppressLint(value={"NewApi"})
    private boolean isSamsung() {
        InputMethodSubtype subtype = this.mImm.getCurrentInputMethodSubtype();
        if (subtype == null || Build.VERSION.SDK_INT < 21 || !Build.MANUFACTURER.equals("samsung")) {
            return false;
        }
        String keyboardName = Settings.Secure.getString((ContentResolver)this.mFlutterView.getContext().getContentResolver(), (String)"default_input_method");
        return keyboardName.contains("Samsung");
    }

    public boolean setSelection(int start, int end) {
        this.beginBatchEdit();
        boolean result = super.setSelection(start, end);
        this.endBatchEdit();
        return result;
    }

    private static int clampIndexToEditable(int index, Editable editable) {
        int clamped = Math.max(0, Math.min(editable.length(), index));
        if (clamped != index) {
            Log.d("flutter", "Text selection index was clamped (" + index + "->" + clamped + ") to remain in bounds. This may not be your fault, as some keyboards may select outside of bounds.");
        }
        return clamped;
    }

    public boolean sendKeyEvent(KeyEvent event) {
        if (this.keyProcessor != null && !this.keyProcessor.isPendingEvent(event) && this.keyProcessor.onKeyEvent(event)) {
            return true;
        }
        if (event.getAction() == 0) {
            if (event.getKeyCode() == 21) {
                return this.handleHorizontalMovement(true, event.isShiftPressed());
            }
            if (event.getKeyCode() == 22) {
                return this.handleHorizontalMovement(false, event.isShiftPressed());
            }
            if (event.getKeyCode() == 19) {
                return this.handleVerticalMovement(true, event.isShiftPressed());
            }
            if (event.getKeyCode() == 20) {
                return this.handleVerticalMovement(false, event.isShiftPressed());
            }
            if ((event.getKeyCode() == 66 || event.getKeyCode() == 160) && (0x20000 & this.mEditorInfo.inputType) == 0) {
                this.performEditorAction(this.mEditorInfo.imeOptions & 0xFF);
                return true;
            }
            int selStart = Selection.getSelectionStart((CharSequence)((Object)this.mEditable));
            int selEnd = Selection.getSelectionEnd((CharSequence)((Object)this.mEditable));
            int character = event.getUnicodeChar();
            if (selStart < 0 || selEnd < 0 || character == 0) {
                return false;
            }
            int selMin = Math.min(selStart, selEnd);
            int selMax = Math.max(selStart, selEnd);
            this.beginBatchEdit();
            if (selMin != selMax) {
                this.mEditable.delete(selMin, selMax);
            }
            this.mEditable.insert(selMin, String.valueOf((char)character));
            this.setSelection(selMin + 1, selMin + 1);
            this.endBatchEdit();
            return true;
        }
        if (event.getAction() == 1 && (event.getKeyCode() == 59 || event.getKeyCode() == 60)) {
            int selEnd = Selection.getSelectionEnd((CharSequence)((Object)this.mEditable));
            this.setSelection(selEnd, selEnd);
            return true;
        }
        return false;
    }

    private boolean handleHorizontalMovement(boolean isLeft, boolean isShiftPressed) {
        boolean shouldCollapse;
        int selStart = Selection.getSelectionStart((CharSequence)((Object)this.mEditable));
        int selEnd = Selection.getSelectionEnd((CharSequence)((Object)this.mEditable));
        if (selStart < 0 || selEnd < 0) {
            return false;
        }
        int newSelectionEnd = isLeft ? Math.max(this.flutterTextUtils.getOffsetBefore((CharSequence)((Object)this.mEditable), selEnd), 0) : Math.min(this.flutterTextUtils.getOffsetAfter((CharSequence)((Object)this.mEditable), selEnd), this.mEditable.length());
        boolean bl = shouldCollapse = selStart == selEnd && !isShiftPressed;
        if (shouldCollapse) {
            this.setSelection(newSelectionEnd, newSelectionEnd);
        } else {
            this.setSelection(selStart, newSelectionEnd);
        }
        return true;
    }

    private boolean handleVerticalMovement(boolean isUp, boolean isShiftPressed) {
        int selStart = Selection.getSelectionStart((CharSequence)((Object)this.mEditable));
        int selEnd = Selection.getSelectionEnd((CharSequence)((Object)this.mEditable));
        if (selStart < 0 || selEnd < 0) {
            return false;
        }
        boolean shouldCollapse = selStart == selEnd && !isShiftPressed;
        this.beginBatchEdit();
        if (shouldCollapse) {
            if (isUp) {
                Selection.moveUp((Spannable)this.mEditable, (Layout)this.mLayout);
            } else {
                Selection.moveDown((Spannable)this.mEditable, (Layout)this.mLayout);
            }
            int newSelection = Selection.getSelectionStart((CharSequence)((Object)this.mEditable));
            this.setSelection(newSelection, newSelection);
        } else {
            if (isUp) {
                Selection.extendUp((Spannable)this.mEditable, (Layout)this.mLayout);
            } else {
                Selection.extendDown((Spannable)this.mEditable, (Layout)this.mLayout);
            }
            this.setSelection(Selection.getSelectionStart((CharSequence)((Object)this.mEditable)), Selection.getSelectionEnd((CharSequence)((Object)this.mEditable)));
        }
        this.endBatchEdit();
        return true;
    }

    public boolean performContextMenuAction(int id2) {
        this.beginBatchEdit();
        boolean result = this.doPerformContextMenuAction(id2);
        this.endBatchEdit();
        return result;
    }

    private boolean doPerformContextMenuAction(int id2) {
        if (id2 == 16908319) {
            this.setSelection(0, this.mEditable.length());
            return true;
        }
        if (id2 == 0x1020020) {
            int selEnd;
            int selStart = Selection.getSelectionStart((CharSequence)((Object)this.mEditable));
            if (selStart != (selEnd = Selection.getSelectionEnd((CharSequence)((Object)this.mEditable)))) {
                int selMin = Math.min(selStart, selEnd);
                int selMax = Math.max(selStart, selEnd);
                CharSequence textToCut = this.mEditable.subSequence(selMin, selMax);
                ClipboardManager clipboard = (ClipboardManager)this.mFlutterView.getContext().getSystemService("clipboard");
                ClipData clip = ClipData.newPlainText((CharSequence)"text label?", (CharSequence)textToCut);
                clipboard.setPrimaryClip(clip);
                this.mEditable.delete(selMin, selMax);
                this.setSelection(selMin, selMin);
            }
            return true;
        }
        if (id2 == 0x1020021) {
            int selEnd;
            int selStart = Selection.getSelectionStart((CharSequence)((Object)this.mEditable));
            if (selStart != (selEnd = Selection.getSelectionEnd((CharSequence)((Object)this.mEditable)))) {
                CharSequence textToCopy = this.mEditable.subSequence(Math.min(selStart, selEnd), Math.max(selStart, selEnd));
                ClipboardManager clipboard = (ClipboardManager)this.mFlutterView.getContext().getSystemService("clipboard");
                clipboard.setPrimaryClip(ClipData.newPlainText((CharSequence)"text label?", (CharSequence)textToCopy));
            }
            return true;
        }
        if (id2 == 0x1020022) {
            ClipboardManager clipboard = (ClipboardManager)this.mFlutterView.getContext().getSystemService("clipboard");
            ClipData clip = clipboard.getPrimaryClip();
            if (clip != null) {
                int selMax;
                int selEnd;
                CharSequence textToPaste = clip.getItemAt(0).coerceToText(this.mFlutterView.getContext());
                int selStart = Math.max(0, Selection.getSelectionStart((CharSequence)((Object)this.mEditable)));
                int selMin = Math.min(selStart, selEnd = Math.max(0, Selection.getSelectionEnd((CharSequence)((Object)this.mEditable))));
                if (selMin != (selMax = Math.max(selStart, selEnd))) {
                    this.mEditable.delete(selMin, selMax);
                }
                this.mEditable.insert(selMin, textToPaste);
                int newSelStart = selMin + textToPaste.length();
                this.setSelection(newSelStart, newSelStart);
            }
            return true;
        }
        return false;
    }

    public boolean performPrivateCommand(String action, Bundle data) {
        this.textInputChannel.performPrivateCommand(this.mClient, action, data);
        return true;
    }

    public boolean performEditorAction(int actionCode) {
        switch (actionCode) {
            case 1: {
                this.textInputChannel.newline(this.mClient);
                break;
            }
            case 0: {
                this.textInputChannel.unspecifiedAction(this.mClient);
                break;
            }
            case 2: {
                this.textInputChannel.go(this.mClient);
                break;
            }
            case 3: {
                this.textInputChannel.search(this.mClient);
                break;
            }
            case 4: {
                this.textInputChannel.send(this.mClient);
                break;
            }
            case 5: {
                this.textInputChannel.next(this.mClient);
                break;
            }
            case 7: {
                this.textInputChannel.previous(this.mClient);
                break;
            }
            default: {
                this.textInputChannel.done(this.mClient);
            }
        }
        return true;
    }

    @Override
    public void didChangeEditingState(boolean textChanged, boolean selectionChanged, boolean composingRegionChanged) {
        this.mImm.updateSelection(this.mFlutterView, this.mEditable.getSelectionStart(), this.mEditable.getSelectionEnd(), this.mEditable.getComposingStart(), this.mEditable.getComposingEnd());
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if (this.mExtractRequest != null) {
            this.mImm.updateExtractedText(this.mFlutterView, this.mExtractRequest.token, this.getExtractedText(this.mExtractRequest));
        }
        if (this.mMonitorCursorUpdate) {
            CursorAnchorInfo info = this.getCursorAnchorInfo();
            this.mImm.updateCursorAnchorInfo(this.mFlutterView, info);
        }
    }
}

