/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.dart;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import io.flutter.Log;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.dart.PlatformMessageHandler;
import io.flutter.plugin.common.BinaryMessenger;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

class DartMessenger
implements BinaryMessenger,
PlatformMessageHandler {
    private static final String TAG = "DartMessenger";
    @NonNull
    private final FlutterJNI flutterJNI;
    @NonNull
    private final Map<String, BinaryMessenger.BinaryMessageHandler> messageHandlers;
    @NonNull
    private final Map<Integer, BinaryMessenger.BinaryReply> pendingReplies;
    private int nextReplyId = 1;

    DartMessenger(@NonNull FlutterJNI flutterJNI) {
        this.flutterJNI = flutterJNI;
        this.messageHandlers = new HashMap<String, BinaryMessenger.BinaryMessageHandler>();
        this.pendingReplies = new HashMap<Integer, BinaryMessenger.BinaryReply>();
    }

    @Override
    public void setMessageHandler(@NonNull String channel, @Nullable BinaryMessenger.BinaryMessageHandler handler) {
        if (handler == null) {
            Log.v(TAG, "Removing handler for channel '" + channel + "'");
            this.messageHandlers.remove(channel);
        } else {
            Log.v(TAG, "Setting handler for channel '" + channel + "'");
            this.messageHandlers.put(channel, handler);
        }
    }

    @Override
    @UiThread
    public void send(@NonNull String channel, @NonNull ByteBuffer message) {
        Log.v(TAG, "Sending message over channel '" + channel + "'");
        this.send(channel, message, null);
    }

    @Override
    public void send(@NonNull String channel, @Nullable ByteBuffer message, @Nullable BinaryMessenger.BinaryReply callback) {
        Log.v(TAG, "Sending message with callback over channel '" + channel + "'");
        int replyId = 0;
        if (callback != null) {
            replyId = this.nextReplyId++;
            this.pendingReplies.put(replyId, callback);
        }
        if (message == null) {
            this.flutterJNI.dispatchEmptyPlatformMessage(channel, replyId);
        } else {
            this.flutterJNI.dispatchPlatformMessage(channel, message, message.position(), replyId);
        }
    }

    @Override
    public void handleMessageFromDart(@NonNull String channel, @Nullable byte[] message, int replyId) {
        Log.v(TAG, "Received message from Dart over channel '" + channel + "'");
        BinaryMessenger.BinaryMessageHandler handler = this.messageHandlers.get(channel);
        if (handler != null) {
            try {
                Log.v(TAG, "Deferring to registered handler to process message.");
                ByteBuffer buffer = message == null ? null : ByteBuffer.wrap(message);
                handler.onMessage(buffer, new Reply(this.flutterJNI, replyId));
            }
            catch (Exception ex) {
                Log.e(TAG, "Uncaught exception in binary message listener", ex);
                this.flutterJNI.invokePlatformMessageEmptyResponseCallback(replyId);
            }
            catch (Error err) {
                DartMessenger.handleError(err);
            }
        } else {
            Log.v(TAG, "No registered handler for message. Responding to Dart with empty reply message.");
            this.flutterJNI.invokePlatformMessageEmptyResponseCallback(replyId);
        }
    }

    @Override
    public void handlePlatformMessageResponse(int replyId, @Nullable byte[] reply) {
        Log.v(TAG, "Received message reply from Dart.");
        BinaryMessenger.BinaryReply callback = this.pendingReplies.remove(replyId);
        if (callback != null) {
            try {
                Log.v(TAG, "Invoking registered callback for reply from Dart.");
                callback.reply(reply == null ? null : ByteBuffer.wrap(reply));
            }
            catch (Exception ex) {
                Log.e(TAG, "Uncaught exception in binary message reply handler", ex);
            }
            catch (Error err) {
                DartMessenger.handleError(err);
            }
        }
    }

    @UiThread
    public int getPendingChannelResponseCount() {
        return this.pendingReplies.size();
    }

    private static void handleError(Error err) {
        Thread currentThread = Thread.currentThread();
        if (currentThread.getUncaughtExceptionHandler() == null) {
            throw err;
        }
        currentThread.getUncaughtExceptionHandler().uncaughtException(currentThread, err);
    }

    static class Reply
    implements BinaryMessenger.BinaryReply {
        @NonNull
        private final FlutterJNI flutterJNI;
        private final int replyId;
        private final AtomicBoolean done = new AtomicBoolean(false);

        Reply(@NonNull FlutterJNI flutterJNI, int replyId) {
            this.flutterJNI = flutterJNI;
            this.replyId = replyId;
        }

        @Override
        public void reply(@Nullable ByteBuffer reply) {
            if (this.done.getAndSet(true)) {
                throw new IllegalStateException("Reply already submitted");
            }
            if (reply == null) {
                this.flutterJNI.invokePlatformMessageEmptyResponseCallback(this.replyId);
            } else {
                this.flutterJNI.invokePlatformMessageResponseCallback(this.replyId, reply, reply.position());
            }
        }
    }
}

