/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import android.os.Build;
import android.view.InputDevice;
import android.view.KeyEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.Log;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.JSONMessageCodec;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class KeyEventChannel {
    private static final String TAG = "KeyEventChannel";
    private EventResponseHandler eventResponseHandler;
    @NonNull
    public final BasicMessageChannel<Object> channel;

    public void setEventResponseHandler(EventResponseHandler handler) {
        this.eventResponseHandler = handler;
    }

    public KeyEventChannel(@NonNull BinaryMessenger binaryMessenger) {
        this.channel = new BasicMessageChannel<Object>(binaryMessenger, "flutter/keyevent", JSONMessageCodec.INSTANCE);
    }

    BasicMessageChannel.Reply<Object> createReplyHandler(KeyEvent event) {
        return message -> {
            if (this.eventResponseHandler == null) {
                return;
            }
            try {
                if (message == null) {
                    this.eventResponseHandler.onKeyEventNotHandled(event);
                    return;
                }
                JSONObject annotatedEvent = (JSONObject)message;
                boolean handled = annotatedEvent.getBoolean("handled");
                if (handled) {
                    this.eventResponseHandler.onKeyEventHandled(event);
                } else {
                    this.eventResponseHandler.onKeyEventNotHandled(event);
                }
            }
            catch (JSONException e) {
                Log.e(TAG, "Unable to unpack JSON message: " + (Object)((Object)e));
                this.eventResponseHandler.onKeyEventNotHandled(event);
            }
        };
    }

    public void keyUp(@NonNull FlutterKeyEvent keyEvent) {
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("type", "keyup");
        message.put("keymap", "android");
        this.encodeKeyEvent(keyEvent, message);
        this.channel.send(message, this.createReplyHandler(keyEvent.event));
    }

    public void keyDown(@NonNull FlutterKeyEvent keyEvent) {
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("type", "keydown");
        message.put("keymap", "android");
        this.encodeKeyEvent(keyEvent, message);
        this.channel.send(message, this.createReplyHandler(keyEvent.event));
    }

    private void encodeKeyEvent(@NonNull FlutterKeyEvent keyEvent, @NonNull Map<String, Object> message) {
        message.put("flags", keyEvent.event.getFlags());
        message.put("plainCodePoint", keyEvent.event.getUnicodeChar(0));
        message.put("codePoint", keyEvent.event.getUnicodeChar());
        message.put("keyCode", keyEvent.event.getKeyCode());
        message.put("scanCode", keyEvent.event.getScanCode());
        message.put("metaState", keyEvent.event.getMetaState());
        if (keyEvent.complexCharacter != null) {
            message.put("character", keyEvent.complexCharacter.toString());
        }
        message.put("source", keyEvent.event.getSource());
        InputDevice device = InputDevice.getDevice((int)keyEvent.event.getDeviceId());
        int vendorId = 0;
        int productId = 0;
        if (device != null && Build.VERSION.SDK_INT >= 19) {
            vendorId = device.getVendorId();
            productId = device.getProductId();
        }
        message.put("vendorId", vendorId);
        message.put("productId", productId);
        message.put("deviceId", keyEvent.event.getDeviceId());
        message.put("repeatCount", keyEvent.event.getRepeatCount());
    }

    public static class FlutterKeyEvent {
        public final KeyEvent event;
        @Nullable
        public final Character complexCharacter;

        public FlutterKeyEvent(@NonNull KeyEvent androidKeyEvent) {
            this(androidKeyEvent, null);
        }

        public FlutterKeyEvent(@NonNull KeyEvent androidKeyEvent, @Nullable Character complexCharacter) {
            this.event = androidKeyEvent;
            this.complexCharacter = complexCharacter;
        }
    }

    public static interface EventResponseHandler {
        public void onKeyEventHandled(KeyEvent var1);

        public void onKeyEventNotHandled(KeyEvent var1);
    }
}

