/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.util;

import androidx.annotation.NonNull;
import androidx.tracing.Trace;

public final class TraceSection {
    private static String cropSectionName(@NonNull String sectionName) {
        return sectionName.length() < 124 ? sectionName : sectionName.substring(0, 124) + "...";
    }

    public static void begin(@NonNull String sectionName) {
        Trace.beginSection((String)TraceSection.cropSectionName(sectionName));
    }

    public static void end() throws RuntimeException {
        Trace.endSection();
    }

    public static void beginAsyncSection(String sectionName, int cookie) {
        Trace.beginAsyncSection((String)TraceSection.cropSectionName(sectionName), (int)cookie);
    }

    public static void endAsyncSection(String sectionName, int cookie) {
        Trace.endAsyncSection((String)TraceSection.cropSectionName(sectionName), (int)cookie);
    }
}

