/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.view.KeyEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.embedding.android.KeyData;
import io.flutter.embedding.android.KeyboardManager;
import io.flutter.embedding.android.KeyboardMap;
import io.flutter.plugin.common.BinaryMessenger;
import java.util.ArrayList;
import java.util.HashMap;

public class KeyEmbedderResponder
implements KeyboardManager.Responder {
    private static final String TAG = "KeyEmbedderResponder";
    @NonNull
    private final BinaryMessenger messenger;
    @NonNull
    private final HashMap<Long, Long> pressingRecords = new HashMap();
    @NonNull
    private final HashMap<Long, KeyboardMap.TogglingGoal> togglingGoals = new HashMap();
    @NonNull
    private final KeyboardManager.CharacterCombiner characterCombiner = new KeyboardManager.CharacterCombiner();

    private static KeyData.Type getEventType(KeyEvent event) {
        boolean isRepeatEvent = event.getRepeatCount() > 0;
        switch (event.getAction()) {
            case 0: {
                return isRepeatEvent ? KeyData.Type.kRepeat : KeyData.Type.kDown;
            }
            case 1: {
                return KeyData.Type.kUp;
            }
        }
        throw new AssertionError((Object)"Unexpected event type");
    }

    public KeyEmbedderResponder(BinaryMessenger messenger) {
        this.messenger = messenger;
        for (KeyboardMap.TogglingGoal goal : KeyboardMap.getTogglingGoals()) {
            this.togglingGoals.put(goal.logicalKey, goal);
        }
    }

    private static long keyOfPlane(long key, long plane) {
        return plane | key & 0xFFFFFFFFL;
    }

    private Long getPhysicalKey(@NonNull KeyEvent event) {
        long scancode = event.getScanCode();
        if (scancode == 0L) {
            return KeyEmbedderResponder.keyOfPlane(event.getKeyCode(), 0x1100000000L);
        }
        Long byMapping = KeyboardMap.scanCodeToPhysical.get(scancode);
        if (byMapping != null) {
            return byMapping;
        }
        return KeyEmbedderResponder.keyOfPlane(event.getScanCode(), 0x1100000000L);
    }

    private Long getLogicalKey(@NonNull KeyEvent event) {
        Long byMapping = KeyboardMap.keyCodeToLogical.get(event.getKeyCode());
        if (byMapping != null) {
            return byMapping;
        }
        return KeyEmbedderResponder.keyOfPlane(event.getKeyCode(), 0x1100000000L);
    }

    void updatePressingState(@NonNull Long physicalKey, @Nullable Long logicalKey) {
        if (logicalKey != null) {
            Long previousValue = this.pressingRecords.put(physicalKey, logicalKey);
            if (previousValue != null) {
                throw new AssertionError((Object)"The key was not empty");
            }
        } else {
            Long previousValue = this.pressingRecords.remove(physicalKey);
            if (previousValue == null) {
                throw new AssertionError((Object)"The key was empty");
            }
        }
    }

    void synchronizePressingKey(KeyboardMap.PressingGoal goal, boolean truePressed, long eventLogicalKey, long eventPhysicalKey, KeyEvent event, ArrayList<Runnable> postSynchronize) {
        KeyboardMap.KeyPair key;
        int keyIdx;
        boolean[] nowStates = new boolean[goal.keys.length];
        Boolean[] preEventStates = new Boolean[goal.keys.length];
        boolean postEventAnyPressed = false;
        for (keyIdx = 0; keyIdx < goal.keys.length; ++keyIdx) {
            key = goal.keys[keyIdx];
            nowStates[keyIdx] = this.pressingRecords.containsKey(key.physicalKey);
            if (key.logicalKey == eventLogicalKey) {
                switch (KeyEmbedderResponder.getEventType(event)) {
                    case kDown: {
                        preEventStates[keyIdx] = false;
                        postEventAnyPressed = true;
                        if (truePressed) break;
                        postSynchronize.add(() -> this.synthesizeEvent(false, key.logicalKey, eventPhysicalKey, event.getEventTime()));
                        break;
                    }
                    case kUp: {
                        preEventStates[keyIdx] = nowStates[keyIdx];
                        break;
                    }
                    case kRepeat: {
                        if (!truePressed) {
                            postSynchronize.add(() -> this.synthesizeEvent(false, key.logicalKey, key.physicalKey, event.getEventTime()));
                        }
                        preEventStates[keyIdx] = nowStates[keyIdx];
                        postEventAnyPressed = true;
                    }
                }
                continue;
            }
            postEventAnyPressed = postEventAnyPressed || nowStates[keyIdx];
        }
        if (truePressed) {
            for (keyIdx = 0; keyIdx < goal.keys.length; ++keyIdx) {
                if (preEventStates[keyIdx] != null) continue;
                if (postEventAnyPressed) {
                    preEventStates[keyIdx] = nowStates[keyIdx];
                    continue;
                }
                preEventStates[keyIdx] = true;
                postEventAnyPressed = true;
            }
            if (!postEventAnyPressed) {
                preEventStates[0] = true;
            }
        } else {
            for (keyIdx = 0; keyIdx < goal.keys.length; ++keyIdx) {
                if (preEventStates[keyIdx] != null) continue;
                preEventStates[keyIdx] = false;
            }
        }
        for (keyIdx = 0; keyIdx < goal.keys.length; ++keyIdx) {
            if (nowStates[keyIdx] == preEventStates[keyIdx]) continue;
            key = goal.keys[keyIdx];
            this.synthesizeEvent(preEventStates[keyIdx], key.logicalKey, key.physicalKey, event.getEventTime());
        }
    }

    void synchronizeTogglingKey(KeyboardMap.TogglingGoal goal, boolean trueEnabled, long eventLogicalKey, KeyEvent event) {
        if (goal.logicalKey == eventLogicalKey) {
            return;
        }
        if (goal.enabled != trueEnabled) {
            boolean firstIsDown;
            boolean bl = firstIsDown = !this.pressingRecords.containsKey(goal.physicalKey);
            if (firstIsDown) {
                goal.enabled = !goal.enabled;
            }
            this.synthesizeEvent(firstIsDown, goal.logicalKey, goal.physicalKey, event.getEventTime());
            if (!firstIsDown) {
                goal.enabled = !goal.enabled;
            }
            this.synthesizeEvent(!firstIsDown, goal.logicalKey, goal.physicalKey, event.getEventTime());
        }
    }

    private boolean handleEventImpl(@NonNull KeyEvent event, @NonNull KeyboardManager.Responder.OnKeyEventHandledCallback onKeyEventHandledCallback) {
        KeyboardMap.TogglingGoal maybeTogglingGoal;
        KeyData.Type type;
        boolean isDownEvent;
        if (event.getScanCode() == 0 && event.getKeyCode() == 0) {
            return false;
        }
        Long physicalKey = this.getPhysicalKey(event);
        Long logicalKey = this.getLogicalKey(event);
        ArrayList<Runnable> postSynchronizeEvents = new ArrayList<Runnable>();
        for (KeyboardMap.PressingGoal goal : KeyboardMap.pressingGoals) {
            this.synchronizePressingKey(goal, (event.getMetaState() & goal.mask) != 0, logicalKey, physicalKey, event, postSynchronizeEvents);
        }
        for (KeyboardMap.TogglingGoal goal : this.togglingGoals.values()) {
            this.synchronizeTogglingKey(goal, (event.getMetaState() & goal.mask) != 0, logicalKey, event);
        }
        switch (event.getAction()) {
            case 0: {
                isDownEvent = true;
                break;
            }
            case 1: {
                isDownEvent = false;
                break;
            }
            default: {
                return false;
            }
        }
        String character = null;
        Long lastLogicalRecord = this.pressingRecords.get(physicalKey);
        if (isDownEvent) {
            if (lastLogicalRecord == null) {
                type = KeyData.Type.kDown;
            } else if (event.getRepeatCount() > 0) {
                type = KeyData.Type.kRepeat;
            } else {
                this.synthesizeEvent(false, lastLogicalRecord, physicalKey, event.getEventTime());
                type = KeyData.Type.kDown;
            }
            char complexChar = this.characterCombiner.applyCombiningCharacterToBaseCharacter(event.getUnicodeChar()).charValue();
            if (complexChar != '\u0000') {
                character = "" + complexChar;
            }
        } else {
            if (lastLogicalRecord == null) {
                return false;
            }
            type = KeyData.Type.kUp;
        }
        if (type != KeyData.Type.kRepeat) {
            this.updatePressingState(physicalKey, isDownEvent ? logicalKey : null);
        }
        if (type == KeyData.Type.kDown && (maybeTogglingGoal = this.togglingGoals.get(logicalKey)) != null) {
            maybeTogglingGoal.enabled = !maybeTogglingGoal.enabled;
        }
        KeyData output = new KeyData();
        output.timestamp = event.getEventTime();
        output.type = type;
        output.logicalKey = logicalKey;
        output.physicalKey = physicalKey;
        output.character = character;
        output.synthesized = false;
        this.sendKeyEvent(output, onKeyEventHandledCallback);
        for (Runnable postSyncEvent : postSynchronizeEvents) {
            postSyncEvent.run();
        }
        return true;
    }

    private void synthesizeEvent(boolean isDown, Long logicalKey, Long physicalKey, long timestamp) {
        KeyData output = new KeyData();
        output.timestamp = timestamp;
        output.type = isDown ? KeyData.Type.kDown : KeyData.Type.kUp;
        output.logicalKey = logicalKey;
        output.physicalKey = physicalKey;
        output.character = null;
        output.synthesized = true;
        if (physicalKey != 0L && logicalKey != 0L) {
            this.updatePressingState(physicalKey, isDown ? logicalKey : null);
        }
        this.sendKeyEvent(output, null);
    }

    private void sendKeyEvent(KeyData data, KeyboardManager.Responder.OnKeyEventHandledCallback onKeyEventHandledCallback) {
        BinaryMessenger.BinaryReply handleMessageReply = onKeyEventHandledCallback == null ? null : message -> {
            Boolean handled = false;
            message.rewind();
            if (message.capacity() != 0) {
                handled = message.get() != 0;
            }
            onKeyEventHandledCallback.onKeyEventHandled(handled);
        };
        this.messenger.send("flutter/keydata", data.toBytes(), handleMessageReply);
    }

    @Override
    public void handleEvent(@NonNull KeyEvent event, @NonNull KeyboardManager.Responder.OnKeyEventHandledCallback onKeyEventHandledCallback) {
        boolean sentAny = this.handleEventImpl(event, onKeyEventHandledCallback);
        if (!sentAny) {
            this.synthesizeEvent(true, 0L, 0L, 0L);
            onKeyEventHandledCallback.onKeyEventHandled(true);
        }
    }
}

