/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.ClipData;
import android.content.ClipDescription;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.Window;
import androidx.activity.OnBackPressedDispatcherOwner;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.view.WindowInsetsControllerCompat;
import io.flutter.Log;
import io.flutter.embedding.engine.systemchannels.PlatformChannel;
import java.io.FileNotFoundException;
import java.util.List;

public class PlatformPlugin {
    public static final int DEFAULT_SYSTEM_UI = 1280;
    private final Activity activity;
    private final PlatformChannel platformChannel;
    private final PlatformPluginDelegate platformPluginDelegate;
    private PlatformChannel.SystemChromeStyle currentTheme;
    private int mEnabledOverlays;
    private static final String TAG = "PlatformPlugin";
    @VisibleForTesting
    final PlatformChannel.PlatformMessageHandler mPlatformMessageHandler = new PlatformChannel.PlatformMessageHandler(){

        @Override
        public void playSystemSound(@NonNull PlatformChannel.SoundType soundType) {
            PlatformPlugin.this.playSystemSound(soundType);
        }

        @Override
        public void vibrateHapticFeedback(@NonNull PlatformChannel.HapticFeedbackType feedbackType) {
            PlatformPlugin.this.vibrateHapticFeedback(feedbackType);
        }

        @Override
        public void setPreferredOrientations(int androidOrientation) {
            PlatformPlugin.this.setSystemChromePreferredOrientations(androidOrientation);
        }

        @Override
        public void setApplicationSwitcherDescription(@NonNull PlatformChannel.AppSwitcherDescription description) {
            PlatformPlugin.this.setSystemChromeApplicationSwitcherDescription(description);
        }

        @Override
        public void showSystemOverlays(@NonNull List<PlatformChannel.SystemUiOverlay> overlays) {
            PlatformPlugin.this.setSystemChromeEnabledSystemUIOverlays(overlays);
        }

        @Override
        public void showSystemUiMode(@NonNull PlatformChannel.SystemUiMode mode) {
            PlatformPlugin.this.setSystemChromeEnabledSystemUIMode(mode);
        }

        @Override
        public void setSystemUiChangeListener() {
            PlatformPlugin.this.setSystemChromeChangeListener();
        }

        @Override
        public void restoreSystemUiOverlays() {
            PlatformPlugin.this.restoreSystemChromeSystemUIOverlays();
        }

        @Override
        public void setSystemUiOverlayStyle(@NonNull PlatformChannel.SystemChromeStyle systemUiOverlayStyle) {
            PlatformPlugin.this.setSystemChromeSystemUIOverlayStyle(systemUiOverlayStyle);
        }

        @Override
        public void popSystemNavigator() {
            PlatformPlugin.this.popSystemNavigator();
        }

        @Override
        public CharSequence getClipboardData(@Nullable PlatformChannel.ClipboardContentFormat format) {
            return PlatformPlugin.this.getClipboardData(format);
        }

        @Override
        public void setClipboardData(@NonNull String text) {
            PlatformPlugin.this.setClipboardData(text);
        }

        @Override
        public boolean clipboardHasStrings() {
            return PlatformPlugin.this.clipboardHasStrings();
        }
    };

    public PlatformPlugin(Activity activity, PlatformChannel platformChannel) {
        this(activity, platformChannel, null);
    }

    public PlatformPlugin(Activity activity, PlatformChannel platformChannel, PlatformPluginDelegate delegate) {
        this.activity = activity;
        this.platformChannel = platformChannel;
        this.platformChannel.setPlatformMessageHandler(this.mPlatformMessageHandler);
        this.platformPluginDelegate = delegate;
        this.mEnabledOverlays = 1280;
    }

    public void destroy() {
        this.platformChannel.setPlatformMessageHandler(null);
    }

    private void playSystemSound(PlatformChannel.SoundType soundType) {
        if (soundType == PlatformChannel.SoundType.CLICK) {
            View view = this.activity.getWindow().getDecorView();
            view.playSoundEffect(0);
        }
    }

    @VisibleForTesting
    void vibrateHapticFeedback(PlatformChannel.HapticFeedbackType feedbackType) {
        View view = this.activity.getWindow().getDecorView();
        switch (feedbackType) {
            case STANDARD: {
                view.performHapticFeedback(0);
                break;
            }
            case LIGHT_IMPACT: {
                view.performHapticFeedback(1);
                break;
            }
            case MEDIUM_IMPACT: {
                view.performHapticFeedback(3);
                break;
            }
            case HEAVY_IMPACT: {
                if (Build.VERSION.SDK_INT < 23) break;
                view.performHapticFeedback(6);
                break;
            }
            case SELECTION_CLICK: {
                if (Build.VERSION.SDK_INT < 21) break;
                view.performHapticFeedback(4);
            }
        }
    }

    private void setSystemChromePreferredOrientations(int androidOrientation) {
        this.activity.setRequestedOrientation(androidOrientation);
    }

    private void setSystemChromeApplicationSwitcherDescription(PlatformChannel.AppSwitcherDescription description) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if (Build.VERSION.SDK_INT < 28 && Build.VERSION.SDK_INT > 21) {
            this.activity.setTaskDescription(new ActivityManager.TaskDescription(description.label, null, description.color));
        }
        if (Build.VERSION.SDK_INT >= 28) {
            ActivityManager.TaskDescription taskDescription = new ActivityManager.TaskDescription(description.label, 0, description.color);
            this.activity.setTaskDescription(taskDescription);
        }
    }

    private void setSystemChromeChangeListener() {
        View decorView = this.activity.getWindow().getDecorView();
        decorView.setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener(){

            public void onSystemUiVisibilityChange(int visibility) {
                if ((visibility & 4) == 0) {
                    PlatformPlugin.this.platformChannel.systemChromeChanged(false);
                } else {
                    PlatformPlugin.this.platformChannel.systemChromeChanged(true);
                }
            }
        });
    }

    private void setSystemChromeEnabledSystemUIMode(PlatformChannel.SystemUiMode systemUiMode) {
        int enabledOverlays;
        if (systemUiMode == PlatformChannel.SystemUiMode.LEAN_BACK && Build.VERSION.SDK_INT >= 16) {
            enabledOverlays = 1798;
        } else if (systemUiMode == PlatformChannel.SystemUiMode.IMMERSIVE && Build.VERSION.SDK_INT >= 19) {
            enabledOverlays = 3846;
        } else if (systemUiMode == PlatformChannel.SystemUiMode.IMMERSIVE_STICKY && Build.VERSION.SDK_INT >= 19) {
            enabledOverlays = 5894;
        } else if (systemUiMode == PlatformChannel.SystemUiMode.EDGE_TO_EDGE && Build.VERSION.SDK_INT >= 29) {
            enabledOverlays = 1792;
        } else {
            return;
        }
        this.mEnabledOverlays = enabledOverlays;
        this.updateSystemUiOverlays();
    }

    private void setSystemChromeEnabledSystemUIOverlays(List<PlatformChannel.SystemUiOverlay> overlaysToShow) {
        int enabledOverlays = 1798;
        if (overlaysToShow.size() == 0 && Build.VERSION.SDK_INT >= 19) {
            enabledOverlays |= 0x1000;
        }
        block4: for (int i = 0; i < overlaysToShow.size(); ++i) {
            PlatformChannel.SystemUiOverlay overlayToShow = overlaysToShow.get(i);
            switch (overlayToShow) {
                case TOP_OVERLAYS: {
                    enabledOverlays &= 0xFFFFFFFB;
                    continue block4;
                }
                case BOTTOM_OVERLAYS: {
                    enabledOverlays &= 0xFFFFFDFF;
                    enabledOverlays &= 0xFFFFFFFD;
                }
            }
        }
        this.mEnabledOverlays = enabledOverlays;
        this.updateSystemUiOverlays();
    }

    public void updateSystemUiOverlays() {
        this.activity.getWindow().getDecorView().setSystemUiVisibility(this.mEnabledOverlays);
        if (this.currentTheme != null) {
            this.setSystemChromeSystemUIOverlayStyle(this.currentTheme);
        }
    }

    private void restoreSystemChromeSystemUIOverlays() {
        this.updateSystemUiOverlays();
    }

    private void setSystemChromeSystemUIOverlayStyle(PlatformChannel.SystemChromeStyle systemChromeStyle) {
        Window window = this.activity.getWindow();
        View view = window.getDecorView();
        WindowInsetsControllerCompat windowInsetsControllerCompat = new WindowInsetsControllerCompat(window, view);
        if (Build.VERSION.SDK_INT >= 23) {
            if (systemChromeStyle.statusBarIconBrightness != null) {
                switch (systemChromeStyle.statusBarIconBrightness) {
                    case DARK: {
                        windowInsetsControllerCompat.setAppearanceLightStatusBars(true);
                        break;
                    }
                    case LIGHT: {
                        windowInsetsControllerCompat.setAppearanceLightStatusBars(false);
                    }
                }
            }
            if (systemChromeStyle.statusBarColor != null) {
                window.setStatusBarColor(systemChromeStyle.statusBarColor.intValue());
            }
        }
        if (systemChromeStyle.systemStatusBarContrastEnforced != null && Build.VERSION.SDK_INT >= 29) {
            window.setStatusBarContrastEnforced(systemChromeStyle.systemStatusBarContrastEnforced.booleanValue());
        }
        if (Build.VERSION.SDK_INT >= 26) {
            if (systemChromeStyle.systemNavigationBarIconBrightness != null) {
                switch (systemChromeStyle.systemNavigationBarIconBrightness) {
                    case DARK: {
                        windowInsetsControllerCompat.setAppearanceLightNavigationBars(true);
                        break;
                    }
                    case LIGHT: {
                        windowInsetsControllerCompat.setAppearanceLightNavigationBars(false);
                    }
                }
            }
            if (systemChromeStyle.systemNavigationBarColor != null) {
                window.setNavigationBarColor(systemChromeStyle.systemNavigationBarColor.intValue());
            }
        }
        if (systemChromeStyle.systemNavigationBarDividerColor != null && Build.VERSION.SDK_INT >= 28) {
            window.addFlags(Integer.MIN_VALUE);
            window.clearFlags(0x8000000);
            window.setNavigationBarDividerColor(systemChromeStyle.systemNavigationBarDividerColor.intValue());
        }
        if (systemChromeStyle.systemNavigationBarContrastEnforced != null && Build.VERSION.SDK_INT >= 29) {
            window.setNavigationBarContrastEnforced(systemChromeStyle.systemNavigationBarContrastEnforced.booleanValue());
        }
        this.currentTheme = systemChromeStyle;
    }

    private void popSystemNavigator() {
        if (this.platformPluginDelegate != null && this.platformPluginDelegate.popSystemNavigator()) {
            return;
        }
        if (this.activity instanceof OnBackPressedDispatcherOwner) {
            ((OnBackPressedDispatcherOwner)this.activity).getOnBackPressedDispatcher().onBackPressed();
        } else {
            this.activity.finish();
        }
    }

    private CharSequence getClipboardData(PlatformChannel.ClipboardContentFormat format) {
        ClipboardManager clipboard = (ClipboardManager)this.activity.getSystemService("clipboard");
        if (!clipboard.hasPrimaryClip()) {
            return null;
        }
        try {
            ClipData clip = clipboard.getPrimaryClip();
            if (clip == null) {
                return null;
            }
            if (format == null || format == PlatformChannel.ClipboardContentFormat.PLAIN_TEXT) {
                ClipData.Item item = clip.getItemAt(0);
                if (item.getUri() != null) {
                    this.activity.getContentResolver().openTypedAssetFileDescriptor(item.getUri(), "text/*", null);
                }
                return item.coerceToText((Context)this.activity);
            }
        }
        catch (SecurityException e) {
            Log.w(TAG, "Attempted to get clipboard data that requires additional permission(s).\nSee the exception details for which permission(s) are required, and consider adding them to your Android Manifest as described in:\nhttps://developer.android.com/guide/topics/permissions/overview", e);
            return null;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return null;
    }

    private void setClipboardData(String text) {
        ClipboardManager clipboard = (ClipboardManager)this.activity.getSystemService("clipboard");
        ClipData clip = ClipData.newPlainText((CharSequence)"text label?", (CharSequence)text);
        clipboard.setPrimaryClip(clip);
    }

    private boolean clipboardHasStrings() {
        ClipboardManager clipboard = (ClipboardManager)this.activity.getSystemService("clipboard");
        if (!clipboard.hasPrimaryClip()) {
            return false;
        }
        ClipDescription description = clipboard.getPrimaryClipDescription();
        if (description == null) {
            return false;
        }
        return description.hasMimeType("text/*");
    }

    public static interface PlatformPluginDelegate {
        public boolean popSystemNavigator();
    }
}

