/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Configuration;
import android.database.ContentObserver;
import android.graphics.Insets;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.DisplayCutout;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewStructure;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.autofill.AutofillValue;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.textservice.TextServicesManager;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import androidx.core.util.Consumer;
import androidx.window.java.layout.WindowInfoTrackerCallbackAdapter;
import androidx.window.layout.DisplayFeature;
import androidx.window.layout.FoldingFeature;
import androidx.window.layout.WindowInfoTracker;
import androidx.window.layout.WindowLayoutInfo;
import io.flutter.Log;
import io.flutter.embedding.android.AndroidTouchProcessor;
import io.flutter.embedding.android.FlutterImageView;
import io.flutter.embedding.android.FlutterSurfaceView;
import io.flutter.embedding.android.FlutterTextureView;
import io.flutter.embedding.android.KeyboardManager;
import io.flutter.embedding.android.RenderMode;
import io.flutter.embedding.android.TransparencyMode;
import io.flutter.embedding.android.WindowInfoRepositoryCallbackAdapterWrapper;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.embedding.engine.renderer.FlutterUiDisplayListener;
import io.flutter.embedding.engine.renderer.RenderSurface;
import io.flutter.embedding.engine.systemchannels.SettingsChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.editing.SpellCheckPlugin;
import io.flutter.plugin.editing.TextInputPlugin;
import io.flutter.plugin.localization.LocalizationPlugin;
import io.flutter.plugin.mouse.MouseCursorPlugin;
import io.flutter.util.ViewUtils;
import io.flutter.view.AccessibilityBridge;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FlutterView
extends FrameLayout
implements MouseCursorPlugin.MouseCursorViewDelegate,
KeyboardManager.ViewDelegate {
    private static final String TAG = "FlutterView";
    @Nullable
    private FlutterSurfaceView flutterSurfaceView;
    @Nullable
    private FlutterTextureView flutterTextureView;
    @Nullable
    private FlutterImageView flutterImageView;
    @Nullable
    @VisibleForTesting
    RenderSurface renderSurface;
    @Nullable
    private RenderSurface previousRenderSurface;
    private final Set<FlutterUiDisplayListener> flutterUiDisplayListeners = new HashSet<FlutterUiDisplayListener>();
    private boolean isFlutterUiDisplayed;
    @Nullable
    private FlutterEngine flutterEngine;
    @NonNull
    private final Set<FlutterEngineAttachmentListener> flutterEngineAttachmentListeners = new HashSet<FlutterEngineAttachmentListener>();
    @Nullable
    private MouseCursorPlugin mouseCursorPlugin;
    @Nullable
    private TextInputPlugin textInputPlugin;
    @Nullable
    private SpellCheckPlugin spellCheckPlugin;
    @Nullable
    private LocalizationPlugin localizationPlugin;
    @Nullable
    private KeyboardManager keyboardManager;
    @Nullable
    private AndroidTouchProcessor androidTouchProcessor;
    @Nullable
    private AccessibilityBridge accessibilityBridge;
    @Nullable
    private TextServicesManager textServicesManager;
    @Nullable
    private WindowInfoRepositoryCallbackAdapterWrapper windowInfoRepo;
    private final FlutterRenderer.ViewportMetrics viewportMetrics = new FlutterRenderer.ViewportMetrics();
    private final AccessibilityBridge.OnAccessibilityChangeListener onAccessibilityChangeListener = new AccessibilityBridge.OnAccessibilityChangeListener(){

        @Override
        public void onAccessibilityChanged(boolean isAccessibilityEnabled, boolean isTouchExplorationEnabled) {
            FlutterView.this.resetWillNotDraw(isAccessibilityEnabled, isTouchExplorationEnabled);
        }
    };
    private final ContentObserver systemSettingsObserver = new ContentObserver(new Handler(Looper.getMainLooper())){

        public void onChange(boolean selfChange) {
            super.onChange(selfChange);
            if (FlutterView.this.flutterEngine == null) {
                return;
            }
            Log.v(FlutterView.TAG, "System settings changed. Sending user settings to Flutter.");
            FlutterView.this.sendUserSettingsToFlutter();
        }

        public boolean deliverSelfNotifications() {
            return true;
        }
    };
    private final FlutterUiDisplayListener flutterUiDisplayListener = new FlutterUiDisplayListener(){

        @Override
        public void onFlutterUiDisplayed() {
            FlutterView.this.isFlutterUiDisplayed = true;
            for (FlutterUiDisplayListener listener : FlutterView.this.flutterUiDisplayListeners) {
                listener.onFlutterUiDisplayed();
            }
        }

        @Override
        public void onFlutterUiNoLongerDisplayed() {
            FlutterView.this.isFlutterUiDisplayed = false;
            for (FlutterUiDisplayListener listener : FlutterView.this.flutterUiDisplayListeners) {
                listener.onFlutterUiNoLongerDisplayed();
            }
        }
    };
    private final Consumer<WindowLayoutInfo> windowInfoListener = new Consumer<WindowLayoutInfo>(){

        public void accept(WindowLayoutInfo layoutInfo) {
            FlutterView.this.setWindowInfoListenerDisplayFeatures(layoutInfo);
        }
    };

    public FlutterView(@NonNull Context context) {
        this(context, null, new FlutterSurfaceView(context));
    }

    @Deprecated
    public FlutterView(@NonNull Context context, @NonNull RenderMode renderMode) {
        super(context, null);
        if (renderMode == RenderMode.surface) {
            this.flutterSurfaceView = new FlutterSurfaceView(context);
            this.renderSurface = this.flutterSurfaceView;
        } else if (renderMode == RenderMode.texture) {
            this.flutterTextureView = new FlutterTextureView(context);
            this.renderSurface = this.flutterTextureView;
        } else {
            throw new IllegalArgumentException(String.format("RenderMode not supported with this constructor: %s", new Object[]{renderMode}));
        }
        this.init();
    }

    @Deprecated
    public FlutterView(@NonNull Context context, @NonNull TransparencyMode transparencyMode) {
        this(context, null, new FlutterSurfaceView(context, transparencyMode == TransparencyMode.transparent));
    }

    public FlutterView(@NonNull Context context, @NonNull FlutterSurfaceView flutterSurfaceView) {
        this(context, null, flutterSurfaceView);
    }

    public FlutterView(@NonNull Context context, @NonNull FlutterTextureView flutterTextureView) {
        this(context, null, flutterTextureView);
    }

    @TargetApi(value=19)
    public FlutterView(@NonNull Context context, @NonNull FlutterImageView flutterImageView) {
        this(context, null, flutterImageView);
    }

    public FlutterView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, new FlutterSurfaceView(context));
    }

    @Deprecated
    public FlutterView(@NonNull Context context, @NonNull RenderMode renderMode, @NonNull TransparencyMode transparencyMode) {
        super(context, null);
        if (renderMode == RenderMode.surface) {
            this.flutterSurfaceView = new FlutterSurfaceView(context, transparencyMode == TransparencyMode.transparent);
            this.renderSurface = this.flutterSurfaceView;
        } else if (renderMode == RenderMode.texture) {
            this.flutterTextureView = new FlutterTextureView(context);
            this.renderSurface = this.flutterTextureView;
        } else {
            throw new IllegalArgumentException(String.format("RenderMode not supported with this constructor: %s", new Object[]{renderMode}));
        }
        this.init();
    }

    private FlutterView(@NonNull Context context, @Nullable AttributeSet attrs, @NonNull FlutterSurfaceView flutterSurfaceView) {
        super(context, attrs);
        this.flutterSurfaceView = flutterSurfaceView;
        this.renderSurface = flutterSurfaceView;
        this.init();
    }

    private FlutterView(@NonNull Context context, @Nullable AttributeSet attrs, @NonNull FlutterTextureView flutterTextureView) {
        super(context, attrs);
        this.flutterTextureView = flutterTextureView;
        this.renderSurface = flutterTextureView;
        this.init();
    }

    @TargetApi(value=19)
    private FlutterView(@NonNull Context context, @Nullable AttributeSet attrs, @NonNull FlutterImageView flutterImageView) {
        super(context, attrs);
        this.flutterImageView = flutterImageView;
        this.renderSurface = flutterImageView;
        this.init();
    }

    private void init() {
        Log.v(TAG, "Initializing FlutterView");
        if (this.flutterSurfaceView != null) {
            Log.v(TAG, "Internally using a FlutterSurfaceView.");
            this.addView((View)this.flutterSurfaceView);
        } else if (this.flutterTextureView != null) {
            Log.v(TAG, "Internally using a FlutterTextureView.");
            this.addView((View)this.flutterTextureView);
        } else {
            Log.v(TAG, "Internally using a FlutterImageView.");
            this.addView(this.flutterImageView);
        }
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        if (Build.VERSION.SDK_INT >= 26) {
            this.setImportantForAutofill(1);
        }
    }

    public boolean hasRenderedFirstFrame() {
        return this.isFlutterUiDisplayed;
    }

    public void addOnFirstFrameRenderedListener(@NonNull FlutterUiDisplayListener listener) {
        this.flutterUiDisplayListeners.add(listener);
    }

    public void removeOnFirstFrameRenderedListener(@NonNull FlutterUiDisplayListener listener) {
        this.flutterUiDisplayListeners.remove(listener);
    }

    protected void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.flutterEngine != null) {
            Log.v(TAG, "Configuration changed. Sending locales and user settings to Flutter.");
            this.localizationPlugin.sendLocalesToFlutter(newConfig);
            this.sendUserSettingsToFlutter();
            ViewUtils.calculateMaximumDisplayMetrics(this.getContext(), this.flutterEngine);
        }
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        Log.v(TAG, "Size changed. Sending Flutter new viewport metrics. FlutterView was " + oldWidth + " x " + oldHeight + ", it is now " + width + " x " + height);
        this.viewportMetrics.width = width;
        this.viewportMetrics.height = height;
        this.sendViewportMetricsToFlutter();
    }

    @VisibleForTesting
    protected WindowInfoRepositoryCallbackAdapterWrapper createWindowInfoRepo() {
        try {
            return new WindowInfoRepositoryCallbackAdapterWrapper(new WindowInfoTrackerCallbackAdapter(WindowInfoTracker.Companion.getOrCreate(this.getContext())));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.windowInfoRepo = this.createWindowInfoRepo();
        Activity activity = ViewUtils.getActivity(this.getContext());
        if (this.windowInfoRepo != null && activity != null) {
            this.windowInfoRepo.addWindowLayoutInfoListener(activity, ContextCompat.getMainExecutor((Context)this.getContext()), this.windowInfoListener);
        }
    }

    protected void onDetachedFromWindow() {
        if (this.windowInfoRepo != null) {
            this.windowInfoRepo.removeWindowLayoutInfoListener(this.windowInfoListener);
        }
        this.windowInfoRepo = null;
        super.onDetachedFromWindow();
    }

    @TargetApi(value=28)
    protected void setWindowInfoListenerDisplayFeatures(WindowLayoutInfo layoutInfo) {
        DisplayCutout cutout;
        WindowInsets insets;
        List displayFeatures = layoutInfo.getDisplayFeatures();
        ArrayList<FlutterRenderer.DisplayFeature> result = new ArrayList<FlutterRenderer.DisplayFeature>();
        for (DisplayFeature displayFeature : displayFeatures) {
            Log.v(TAG, "WindowInfoTracker Display Feature reported with bounds = " + displayFeature.getBounds().toString() + " and type = " + displayFeature.getClass().getSimpleName());
            if (displayFeature instanceof FoldingFeature) {
                FoldingFeature feature = (FoldingFeature)displayFeature;
                FlutterRenderer.DisplayFeatureType type = feature.getOcclusionType() == FoldingFeature.OcclusionType.FULL ? FlutterRenderer.DisplayFeatureType.HINGE : FlutterRenderer.DisplayFeatureType.FOLD;
                FlutterRenderer.DisplayFeatureState state = feature.getState() == FoldingFeature.State.FLAT ? FlutterRenderer.DisplayFeatureState.POSTURE_FLAT : (feature.getState() == FoldingFeature.State.HALF_OPENED ? FlutterRenderer.DisplayFeatureState.POSTURE_HALF_OPENED : FlutterRenderer.DisplayFeatureState.UNKNOWN);
                result.add(new FlutterRenderer.DisplayFeature(displayFeature.getBounds(), type, state));
                continue;
            }
            result.add(new FlutterRenderer.DisplayFeature(displayFeature.getBounds(), FlutterRenderer.DisplayFeatureType.UNKNOWN, FlutterRenderer.DisplayFeatureState.UNKNOWN));
        }
        if (Build.VERSION.SDK_INT >= 28 && (insets = this.getRootWindowInsets()) != null && (cutout = insets.getDisplayCutout()) != null) {
            for (Rect bounds : cutout.getBoundingRects()) {
                Log.v(TAG, "DisplayCutout area reported with bounds = " + bounds.toString());
                result.add(new FlutterRenderer.DisplayFeature(bounds, FlutterRenderer.DisplayFeatureType.CUTOUT));
            }
        }
        this.viewportMetrics.displayFeatures = result;
        this.sendViewportMetricsToFlutter();
    }

    private ZeroSides calculateShouldZeroSides() {
        Context context = this.getContext();
        int orientation = context.getResources().getConfiguration().orientation;
        int rotation = ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getRotation();
        if (orientation == 2) {
            if (rotation == 1) {
                return ZeroSides.RIGHT;
            }
            if (rotation == 3) {
                return Build.VERSION.SDK_INT >= 23 ? ZeroSides.LEFT : ZeroSides.RIGHT;
            }
            if (rotation == 0 || rotation == 2) {
                return ZeroSides.BOTH;
            }
        }
        return ZeroSides.NONE;
    }

    @TargetApi(value=20)
    @RequiresApi(value=20)
    private int guessBottomKeyboardInset(WindowInsets insets) {
        int screenHeight = this.getRootView().getHeight();
        double keyboardHeightRatioHeuristic = 0.18;
        if ((double)insets.getSystemWindowInsetBottom() < (double)screenHeight * 0.18) {
            return 0;
        }
        return insets.getSystemWindowInsetBottom();
    }

    @TargetApi(value=20)
    @RequiresApi(value=20)
    @SuppressLint(value={"InlinedApi", "NewApi"})
    @NonNull
    public final WindowInsets onApplyWindowInsets(@NonNull WindowInsets insets) {
        boolean navigationBarVisible;
        WindowInsets newInsets = super.onApplyWindowInsets(insets);
        if (Build.VERSION.SDK_INT == 29) {
            Insets systemGestureInsets = insets.getSystemGestureInsets();
            this.viewportMetrics.systemGestureInsetTop = systemGestureInsets.top;
            this.viewportMetrics.systemGestureInsetRight = systemGestureInsets.right;
            this.viewportMetrics.systemGestureInsetBottom = systemGestureInsets.bottom;
            this.viewportMetrics.systemGestureInsetLeft = systemGestureInsets.left;
        }
        boolean statusBarVisible = (4 & this.getWindowSystemUiVisibility()) == 0;
        boolean bl = navigationBarVisible = (2 & this.getWindowSystemUiVisibility()) == 0;
        if (Build.VERSION.SDK_INT >= 30) {
            int mask = 0;
            if (navigationBarVisible) {
                mask |= WindowInsets.Type.navigationBars();
            }
            if (statusBarVisible) {
                mask |= WindowInsets.Type.statusBars();
            }
            Insets uiInsets = insets.getInsets(mask);
            this.viewportMetrics.viewPaddingTop = uiInsets.top;
            this.viewportMetrics.viewPaddingRight = uiInsets.right;
            this.viewportMetrics.viewPaddingBottom = uiInsets.bottom;
            this.viewportMetrics.viewPaddingLeft = uiInsets.left;
            Insets imeInsets = insets.getInsets(WindowInsets.Type.ime());
            this.viewportMetrics.viewInsetTop = imeInsets.top;
            this.viewportMetrics.viewInsetRight = imeInsets.right;
            this.viewportMetrics.viewInsetBottom = imeInsets.bottom;
            this.viewportMetrics.viewInsetLeft = imeInsets.left;
            Insets systemGestureInsets = insets.getInsets(WindowInsets.Type.systemGestures());
            this.viewportMetrics.systemGestureInsetTop = systemGestureInsets.top;
            this.viewportMetrics.systemGestureInsetRight = systemGestureInsets.right;
            this.viewportMetrics.systemGestureInsetBottom = systemGestureInsets.bottom;
            this.viewportMetrics.systemGestureInsetLeft = systemGestureInsets.left;
            DisplayCutout cutout = insets.getDisplayCutout();
            if (cutout != null) {
                Insets waterfallInsets = cutout.getWaterfallInsets();
                this.viewportMetrics.viewPaddingTop = Math.max(Math.max(this.viewportMetrics.viewPaddingTop, waterfallInsets.top), cutout.getSafeInsetTop());
                this.viewportMetrics.viewPaddingRight = Math.max(Math.max(this.viewportMetrics.viewPaddingRight, waterfallInsets.right), cutout.getSafeInsetRight());
                this.viewportMetrics.viewPaddingBottom = Math.max(Math.max(this.viewportMetrics.viewPaddingBottom, waterfallInsets.bottom), cutout.getSafeInsetBottom());
                this.viewportMetrics.viewPaddingLeft = Math.max(Math.max(this.viewportMetrics.viewPaddingLeft, waterfallInsets.left), cutout.getSafeInsetLeft());
            }
        } else {
            ZeroSides zeroSides = ZeroSides.NONE;
            if (!navigationBarVisible) {
                zeroSides = this.calculateShouldZeroSides();
            }
            this.viewportMetrics.viewPaddingTop = statusBarVisible ? insets.getSystemWindowInsetTop() : 0;
            this.viewportMetrics.viewPaddingRight = zeroSides == ZeroSides.RIGHT || zeroSides == ZeroSides.BOTH ? 0 : insets.getSystemWindowInsetRight();
            this.viewportMetrics.viewPaddingBottom = navigationBarVisible && this.guessBottomKeyboardInset(insets) == 0 ? insets.getSystemWindowInsetBottom() : 0;
            this.viewportMetrics.viewPaddingLeft = zeroSides == ZeroSides.LEFT || zeroSides == ZeroSides.BOTH ? 0 : insets.getSystemWindowInsetLeft();
            this.viewportMetrics.viewInsetTop = 0;
            this.viewportMetrics.viewInsetRight = 0;
            this.viewportMetrics.viewInsetBottom = this.guessBottomKeyboardInset(insets);
            this.viewportMetrics.viewInsetLeft = 0;
        }
        Log.v(TAG, "Updating window insets (onApplyWindowInsets()):\nStatus bar insets: Top: " + this.viewportMetrics.viewPaddingTop + ", Left: " + this.viewportMetrics.viewPaddingLeft + ", Right: " + this.viewportMetrics.viewPaddingRight + "\nKeyboard insets: Bottom: " + this.viewportMetrics.viewInsetBottom + ", Left: " + this.viewportMetrics.viewInsetLeft + ", Right: " + this.viewportMetrics.viewInsetRight + "System Gesture Insets - Left: " + this.viewportMetrics.systemGestureInsetLeft + ", Top: " + this.viewportMetrics.systemGestureInsetTop + ", Right: " + this.viewportMetrics.systemGestureInsetRight + ", Bottom: " + this.viewportMetrics.viewInsetBottom);
        this.sendViewportMetricsToFlutter();
        return newInsets;
    }

    protected boolean fitSystemWindows(@NonNull Rect insets) {
        if (Build.VERSION.SDK_INT <= 19) {
            this.viewportMetrics.viewPaddingTop = insets.top;
            this.viewportMetrics.viewPaddingRight = insets.right;
            this.viewportMetrics.viewPaddingBottom = 0;
            this.viewportMetrics.viewPaddingLeft = insets.left;
            this.viewportMetrics.viewInsetTop = 0;
            this.viewportMetrics.viewInsetRight = 0;
            this.viewportMetrics.viewInsetBottom = insets.bottom;
            this.viewportMetrics.viewInsetLeft = 0;
            Log.v(TAG, "Updating window insets (fitSystemWindows()):\nStatus bar insets: Top: " + this.viewportMetrics.viewPaddingTop + ", Left: " + this.viewportMetrics.viewPaddingLeft + ", Right: " + this.viewportMetrics.viewPaddingRight + "\nKeyboard insets: Bottom: " + this.viewportMetrics.viewInsetBottom + ", Left: " + this.viewportMetrics.viewInsetLeft + ", Right: " + this.viewportMetrics.viewInsetRight);
            this.sendViewportMetricsToFlutter();
            return true;
        }
        return super.fitSystemWindows(insets);
    }

    @Nullable
    public InputConnection onCreateInputConnection(@NonNull EditorInfo outAttrs) {
        if (!this.isAttachedToFlutterEngine()) {
            return super.onCreateInputConnection(outAttrs);
        }
        return this.textInputPlugin.createInputConnection((View)this, this.keyboardManager, outAttrs);
    }

    public boolean checkInputConnectionProxy(View view) {
        return this.flutterEngine != null ? this.flutterEngine.getPlatformViewsController().checkInputConnectionProxy(view) : super.checkInputConnectionProxy(view);
    }

    public boolean dispatchKeyEvent(@NonNull KeyEvent event) {
        if (event.getAction() == 0 && event.getRepeatCount() == 0) {
            this.getKeyDispatcherState().startTracking(event, (Object)this);
        } else if (event.getAction() == 1) {
            this.getKeyDispatcherState().handleUpEvent(event);
        }
        return this.isAttachedToFlutterEngine() && this.keyboardManager.handleEvent(event) || super.dispatchKeyEvent(event);
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (!this.isAttachedToFlutterEngine()) {
            return super.onTouchEvent(event);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.requestUnbufferedDispatch(event);
        }
        return this.androidTouchProcessor.onTouchEvent(event);
    }

    public boolean onGenericMotionEvent(@NonNull MotionEvent event) {
        boolean handled = this.isAttachedToFlutterEngine() && this.androidTouchProcessor.onGenericMotionEvent(event, this.getContext());
        return handled ? true : super.onGenericMotionEvent(event);
    }

    public boolean onHoverEvent(@NonNull MotionEvent event) {
        if (!this.isAttachedToFlutterEngine()) {
            return super.onHoverEvent(event);
        }
        boolean handled = this.accessibilityBridge.onAccessibilityHoverEvent(event);
        if (!handled) {
            // empty if block
        }
        return handled;
    }

    @Nullable
    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        if (this.accessibilityBridge != null && this.accessibilityBridge.isAccessibilityEnabled()) {
            return this.accessibilityBridge;
        }
        return null;
    }

    @SuppressLint(value={"SoonBlockedPrivateApi"})
    @Nullable
    public View findViewByAccessibilityIdTraversal(int accessibilityId) {
        Method findViewByAccessibilityIdTraversalMethod;
        if (Build.VERSION.SDK_INT < 29) {
            return this.findViewByAccessibilityIdRootedAtCurrentView(accessibilityId, (View)this);
        }
        try {
            findViewByAccessibilityIdTraversalMethod = View.class.getDeclaredMethod("findViewByAccessibilityIdTraversal", Integer.TYPE);
        }
        catch (NoSuchMethodException exception) {
            return null;
        }
        findViewByAccessibilityIdTraversalMethod.setAccessible(true);
        try {
            return (View)findViewByAccessibilityIdTraversalMethod.invoke((Object)this, accessibilityId);
        }
        catch (IllegalAccessException exception) {
            return null;
        }
        catch (InvocationTargetException exception) {
            return null;
        }
    }

    @SuppressLint(value={"DiscouragedPrivateApi"})
    private View findViewByAccessibilityIdRootedAtCurrentView(int accessibilityId, View currentView) {
        Method getAccessibilityViewIdMethod;
        try {
            getAccessibilityViewIdMethod = View.class.getDeclaredMethod("getAccessibilityViewId", new Class[0]);
        }
        catch (NoSuchMethodException exception) {
            return null;
        }
        getAccessibilityViewIdMethod.setAccessible(true);
        try {
            if (getAccessibilityViewIdMethod.invoke((Object)currentView, new Object[0]).equals(accessibilityId)) {
                return currentView;
            }
        }
        catch (IllegalAccessException exception) {
            return null;
        }
        catch (InvocationTargetException exception) {
            return null;
        }
        if (currentView instanceof ViewGroup) {
            for (int i = 0; i < ((ViewGroup)currentView).getChildCount(); ++i) {
                View view = this.findViewByAccessibilityIdRootedAtCurrentView(accessibilityId, ((ViewGroup)currentView).getChildAt(i));
                if (view == null) continue;
                return view;
            }
        }
        return null;
    }

    private void resetWillNotDraw(boolean isAccessibilityEnabled, boolean isTouchExplorationEnabled) {
        if (!this.flutterEngine.getRenderer().isSoftwareRenderingEnabled()) {
            this.setWillNotDraw(!isAccessibilityEnabled && !isTouchExplorationEnabled);
        } else {
            this.setWillNotDraw(false);
        }
    }

    @Override
    @TargetApi(value=24)
    @RequiresApi(value=24)
    @NonNull
    public PointerIcon getSystemPointerIcon(int type) {
        return PointerIcon.getSystemIcon((Context)this.getContext(), (int)type);
    }

    @Override
    public BinaryMessenger getBinaryMessenger() {
        return this.flutterEngine.getDartExecutor();
    }

    @Override
    public boolean onTextInputKeyEvent(@NonNull KeyEvent keyEvent) {
        return this.textInputPlugin.handleKeyEvent(keyEvent);
    }

    @Override
    public void redispatch(@NonNull KeyEvent keyEvent) {
        this.getRootView().dispatchKeyEvent(keyEvent);
    }

    public void attachToFlutterEngine(@NonNull FlutterEngine flutterEngine) {
        Log.v(TAG, "Attaching to a FlutterEngine: " + flutterEngine);
        if (this.isAttachedToFlutterEngine()) {
            if (flutterEngine == this.flutterEngine) {
                Log.v(TAG, "Already attached to this engine. Doing nothing.");
                return;
            }
            Log.v(TAG, "Currently attached to a different engine. Detaching and then attaching to new engine.");
            this.detachFromFlutterEngine();
        }
        this.flutterEngine = flutterEngine;
        FlutterRenderer flutterRenderer = this.flutterEngine.getRenderer();
        this.isFlutterUiDisplayed = flutterRenderer.isDisplayingFlutterUi();
        this.renderSurface.attachToRenderer(flutterRenderer);
        flutterRenderer.addIsDisplayingFlutterUiListener(this.flutterUiDisplayListener);
        if (Build.VERSION.SDK_INT >= 24) {
            this.mouseCursorPlugin = new MouseCursorPlugin(this, this.flutterEngine.getMouseCursorChannel());
        }
        this.textInputPlugin = new TextInputPlugin((View)this, this.flutterEngine.getTextInputChannel(), this.flutterEngine.getPlatformViewsController());
        try {
            this.textServicesManager = (TextServicesManager)this.getContext().getSystemService("textservices");
            this.spellCheckPlugin = new SpellCheckPlugin(this.textServicesManager, this.flutterEngine.getSpellCheckChannel());
        }
        catch (Exception e) {
            Log.e(TAG, "TextServicesManager not supported by device, spell check disabled.");
        }
        this.localizationPlugin = this.flutterEngine.getLocalizationPlugin();
        this.keyboardManager = new KeyboardManager(this);
        this.androidTouchProcessor = new AndroidTouchProcessor(this.flutterEngine.getRenderer(), false);
        this.accessibilityBridge = new AccessibilityBridge((View)this, flutterEngine.getAccessibilityChannel(), (AccessibilityManager)this.getContext().getSystemService("accessibility"), this.getContext().getContentResolver(), this.flutterEngine.getPlatformViewsController());
        this.accessibilityBridge.setOnAccessibilityChangeListener(this.onAccessibilityChangeListener);
        this.resetWillNotDraw(this.accessibilityBridge.isAccessibilityEnabled(), this.accessibilityBridge.isTouchExplorationEnabled());
        this.flutterEngine.getPlatformViewsController().attachAccessibilityBridge(this.accessibilityBridge);
        this.flutterEngine.getPlatformViewsController().attachToFlutterRenderer(this.flutterEngine.getRenderer());
        this.textInputPlugin.getInputMethodManager().restartInput((View)this);
        this.sendUserSettingsToFlutter();
        this.getContext().getContentResolver().registerContentObserver(Settings.System.getUriFor((String)"show_password"), false, this.systemSettingsObserver);
        this.sendViewportMetricsToFlutter();
        flutterEngine.getPlatformViewsController().attachToView(this);
        for (FlutterEngineAttachmentListener listener : this.flutterEngineAttachmentListeners) {
            listener.onFlutterEngineAttachedToFlutterView(flutterEngine);
        }
        if (this.isFlutterUiDisplayed) {
            this.flutterUiDisplayListener.onFlutterUiDisplayed();
        }
    }

    public void detachFromFlutterEngine() {
        Log.v(TAG, "Detaching from a FlutterEngine: " + this.flutterEngine);
        if (!this.isAttachedToFlutterEngine()) {
            Log.v(TAG, "FlutterView not attached to an engine. Not detaching.");
            return;
        }
        for (FlutterEngineAttachmentListener listener : this.flutterEngineAttachmentListeners) {
            listener.onFlutterEngineDetachedFromFlutterView();
        }
        this.getContext().getContentResolver().unregisterContentObserver(this.systemSettingsObserver);
        this.flutterEngine.getPlatformViewsController().detachFromView();
        this.flutterEngine.getPlatformViewsController().detachAccessibilityBridge();
        this.accessibilityBridge.release();
        this.accessibilityBridge = null;
        this.textInputPlugin.getInputMethodManager().restartInput((View)this);
        this.textInputPlugin.destroy();
        this.keyboardManager.destroy();
        if (this.spellCheckPlugin != null) {
            this.spellCheckPlugin.destroy();
        }
        if (this.mouseCursorPlugin != null) {
            this.mouseCursorPlugin.destroy();
        }
        FlutterRenderer flutterRenderer = this.flutterEngine.getRenderer();
        this.isFlutterUiDisplayed = false;
        flutterRenderer.removeIsDisplayingFlutterUiListener(this.flutterUiDisplayListener);
        flutterRenderer.stopRenderingToSurface();
        flutterRenderer.setSemanticsEnabled(false);
        if (this.previousRenderSurface != null && this.renderSurface == this.flutterImageView) {
            this.renderSurface = this.previousRenderSurface;
        }
        this.renderSurface.detachFromRenderer();
        this.releaseImageView();
        this.previousRenderSurface = null;
        this.flutterEngine = null;
    }

    private void releaseImageView() {
        if (this.flutterImageView != null) {
            this.flutterImageView.closeImageReader();
            this.removeView(this.flutterImageView);
            this.flutterImageView = null;
        }
    }

    @VisibleForTesting
    @NonNull
    public FlutterImageView createImageView() {
        return new FlutterImageView(this.getContext(), this.getWidth(), this.getHeight(), FlutterImageView.SurfaceKind.background);
    }

    @VisibleForTesting
    public FlutterImageView getCurrentImageSurface() {
        return this.flutterImageView;
    }

    public void convertToImageView() {
        this.renderSurface.pause();
        if (this.flutterImageView == null) {
            this.flutterImageView = this.createImageView();
            this.addView(this.flutterImageView);
        } else {
            this.flutterImageView.resizeIfNeeded(this.getWidth(), this.getHeight());
        }
        this.previousRenderSurface = this.renderSurface;
        this.renderSurface = this.flutterImageView;
        if (this.flutterEngine != null) {
            this.renderSurface.attachToRenderer(this.flutterEngine.getRenderer());
        }
    }

    public void revertImageView(final @NonNull Runnable onDone) {
        if (this.flutterImageView == null) {
            Log.v(TAG, "Tried to revert the image view, but no image view is used.");
            return;
        }
        if (this.previousRenderSurface == null) {
            Log.v(TAG, "Tried to revert the image view, but no previous surface was used.");
            return;
        }
        this.renderSurface = this.previousRenderSurface;
        this.previousRenderSurface = null;
        final FlutterRenderer renderer = this.flutterEngine.getRenderer();
        if (this.flutterEngine == null || renderer == null) {
            this.flutterImageView.detachFromRenderer();
            this.releaseImageView();
            onDone.run();
            return;
        }
        this.renderSurface.attachToRenderer(renderer);
        renderer.addIsDisplayingFlutterUiListener(new FlutterUiDisplayListener(){

            @Override
            public void onFlutterUiDisplayed() {
                renderer.removeIsDisplayingFlutterUiListener(this);
                onDone.run();
                if (!(FlutterView.this.renderSurface instanceof FlutterImageView) && FlutterView.this.flutterImageView != null) {
                    FlutterView.this.flutterImageView.detachFromRenderer();
                    FlutterView.this.releaseImageView();
                }
            }

            @Override
            public void onFlutterUiNoLongerDisplayed() {
            }
        });
    }

    public void attachOverlaySurfaceToRender(@NonNull FlutterImageView view) {
        if (this.flutterEngine != null) {
            view.attachToRenderer(this.flutterEngine.getRenderer());
        }
    }

    public boolean acquireLatestImageViewFrame() {
        if (this.flutterImageView != null) {
            return this.flutterImageView.acquireLatestImage();
        }
        return false;
    }

    @VisibleForTesting
    public boolean isAttachedToFlutterEngine() {
        return this.flutterEngine != null && this.flutterEngine.getRenderer() == this.renderSurface.getAttachedRenderer();
    }

    @VisibleForTesting
    @Nullable
    public FlutterEngine getAttachedFlutterEngine() {
        return this.flutterEngine;
    }

    @VisibleForTesting
    public void addFlutterEngineAttachmentListener(@NonNull FlutterEngineAttachmentListener listener) {
        this.flutterEngineAttachmentListeners.add(listener);
    }

    @VisibleForTesting
    public void removeFlutterEngineAttachmentListener(@NonNull FlutterEngineAttachmentListener listener) {
        this.flutterEngineAttachmentListeners.remove(listener);
    }

    @VisibleForTesting
    void sendUserSettingsToFlutter() {
        boolean isNightModeOn = (this.getResources().getConfiguration().uiMode & 0x30) == 32;
        SettingsChannel.PlatformBrightness brightness = isNightModeOn ? SettingsChannel.PlatformBrightness.dark : SettingsChannel.PlatformBrightness.light;
        boolean isNativeSpellCheckServiceDefined = false;
        if (this.textServicesManager != null) {
            if (Build.VERSION.SDK_INT >= 31) {
                List enabledSpellCheckerInfos = this.textServicesManager.getEnabledSpellCheckerInfos();
                boolean gboardSpellCheckerEnabled = enabledSpellCheckerInfos.stream().anyMatch(spellCheckerInfo -> spellCheckerInfo.getPackageName().equals("com.google.android.inputmethod.latin"));
                isNativeSpellCheckServiceDefined = this.textServicesManager.isSpellCheckerEnabled() && gboardSpellCheckerEnabled;
            } else {
                isNativeSpellCheckServiceDefined = true;
            }
        }
        this.flutterEngine.getSettingsChannel().startMessage().setTextScaleFactor(this.getResources().getConfiguration().fontScale).setDisplayMetrics(this.getResources().getDisplayMetrics()).setNativeSpellCheckServiceDefined(isNativeSpellCheckServiceDefined).setBrieflyShowPassword(Settings.System.getInt((ContentResolver)this.getContext().getContentResolver(), (String)"show_password", (int)1) == 1).setUse24HourFormat(DateFormat.is24HourFormat((Context)this.getContext())).setPlatformBrightness(brightness).send();
    }

    private void sendViewportMetricsToFlutter() {
        if (!this.isAttachedToFlutterEngine()) {
            Log.w(TAG, "Tried to send viewport metrics from Android to Flutter but this FlutterView was not attached to a FlutterEngine.");
            return;
        }
        this.viewportMetrics.devicePixelRatio = this.getResources().getDisplayMetrics().density;
        this.viewportMetrics.physicalTouchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
        this.flutterEngine.getRenderer().setViewportMetrics(this.viewportMetrics);
    }

    public void onProvideAutofillVirtualStructure(@NonNull ViewStructure structure, int flags) {
        super.onProvideAutofillVirtualStructure(structure, flags);
        this.textInputPlugin.onProvideAutofillVirtualStructure(structure, flags);
    }

    public void autofill(@NonNull SparseArray<AutofillValue> values) {
        this.textInputPlugin.autofill(values);
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (this.renderSurface instanceof FlutterSurfaceView) {
            ((FlutterSurfaceView)this.renderSurface).setVisibility(visibility);
        }
    }

    @VisibleForTesting
    public static interface FlutterEngineAttachmentListener {
        public void onFlutterEngineAttachedToFlutterView(@NonNull FlutterEngine var1);

        public void onFlutterEngineDetachedFromFlutterView();
    }

    private static enum ZeroSides {
        NONE,
        LEFT,
        RIGHT,
        BOTH;

    }
}

