/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.editing;

import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.Log;
import io.flutter.embedding.engine.systemchannels.TextInputChannel;
import io.flutter.plugin.editing.TextEditingDelta;
import java.util.ArrayList;

class ListenableEditingState
extends SpannableStringBuilder {
    private static final String TAG = "ListenableEditingState";
    private int mBatchEditNestDepth = 0;
    private int mChangeNotificationDepth = 0;
    private ArrayList<EditingStateWatcher> mListeners = new ArrayList();
    private ArrayList<EditingStateWatcher> mPendingListeners = new ArrayList();
    private ArrayList<TextEditingDelta> mBatchTextEditingDeltas = new ArrayList();
    private String mToStringCache;
    private String mTextWhenBeginBatchEdit;
    private int mSelectionStartWhenBeginBatchEdit;
    private int mSelectionEndWhenBeginBatchEdit;
    private int mComposingStartWhenBeginBatchEdit;
    private int mComposingEndWhenBeginBatchEdit;
    private BaseInputConnection mDummyConnection;

    public ListenableEditingState(@Nullable TextInputChannel.TextEditState initialState, @NonNull View view) {
        ListenableEditingState self = this;
        this.mDummyConnection = new BaseInputConnection(view, true, (Editable)self){
            final /* synthetic */ Editable val$self;
            {
                this.val$self = editable;
                super(arg0, arg1);
            }

            public Editable getEditable() {
                return this.val$self;
            }
        };
        if (initialState != null) {
            this.setEditingState(initialState);
        }
    }

    public ArrayList<TextEditingDelta> extractBatchTextEditingDeltas() {
        ArrayList<TextEditingDelta> currentBatchDeltas = new ArrayList<TextEditingDelta>(this.mBatchTextEditingDeltas);
        this.mBatchTextEditingDeltas.clear();
        return currentBatchDeltas;
    }

    public void clearBatchDeltas() {
        this.mBatchTextEditingDeltas.clear();
    }

    public void beginBatchEdit() {
        ++this.mBatchEditNestDepth;
        if (this.mChangeNotificationDepth > 0) {
            Log.e(TAG, "editing state should not be changed in a listener callback");
        }
        if (this.mBatchEditNestDepth == 1 && !this.mListeners.isEmpty()) {
            this.mTextWhenBeginBatchEdit = this.toString();
            this.mSelectionStartWhenBeginBatchEdit = this.getSelectionStart();
            this.mSelectionEndWhenBeginBatchEdit = this.getSelectionEnd();
            this.mComposingStartWhenBeginBatchEdit = this.getComposingStart();
            this.mComposingEndWhenBeginBatchEdit = this.getComposingEnd();
        }
    }

    public void endBatchEdit() {
        if (this.mBatchEditNestDepth == 0) {
            Log.e(TAG, "endBatchEdit called without a matching beginBatchEdit");
            return;
        }
        if (this.mBatchEditNestDepth == 1) {
            for (EditingStateWatcher listener : this.mPendingListeners) {
                this.notifyListener(listener, true, true, true);
            }
            if (!this.mListeners.isEmpty()) {
                Log.v(TAG, "didFinishBatchEdit with " + this.mListeners.size() + " listener(s)");
                boolean textChanged = !this.toString().equals(this.mTextWhenBeginBatchEdit);
                boolean selectionChanged = this.mSelectionStartWhenBeginBatchEdit != this.getSelectionStart() || this.mSelectionEndWhenBeginBatchEdit != this.getSelectionEnd();
                boolean composingRegionChanged = this.mComposingStartWhenBeginBatchEdit != this.getComposingStart() || this.mComposingEndWhenBeginBatchEdit != this.getComposingEnd();
                this.notifyListenersIfNeeded(textChanged, selectionChanged, composingRegionChanged);
            }
        }
        this.mListeners.addAll(this.mPendingListeners);
        this.mPendingListeners.clear();
        --this.mBatchEditNestDepth;
    }

    public void setComposingRange(int composingStart, int composingEnd) {
        if (composingStart < 0 || composingStart >= composingEnd) {
            BaseInputConnection.removeComposingSpans((Spannable)this);
        } else {
            this.mDummyConnection.setComposingRegion(composingStart, composingEnd);
        }
    }

    public void setEditingState(TextInputChannel.TextEditState newState) {
        this.beginBatchEdit();
        this.replace(0, this.length(), newState.text);
        if (newState.hasSelection()) {
            Selection.setSelection((Spannable)this, (int)newState.selectionStart, (int)newState.selectionEnd);
        } else {
            Selection.removeSelection((Spannable)this);
        }
        this.setComposingRange(newState.composingStart, newState.composingEnd);
        this.clearBatchDeltas();
        this.endBatchEdit();
    }

    public void addEditingStateListener(EditingStateWatcher listener) {
        if (this.mChangeNotificationDepth > 0) {
            Log.e(TAG, "adding a listener " + listener.toString() + " in a listener callback");
        }
        if (this.mBatchEditNestDepth > 0) {
            Log.w(TAG, "a listener was added to EditingState while a batch edit was in progress");
            this.mPendingListeners.add(listener);
        } else {
            this.mListeners.add(listener);
        }
    }

    public void removeEditingStateListener(EditingStateWatcher listener) {
        if (this.mChangeNotificationDepth > 0) {
            Log.e(TAG, "removing a listener " + listener.toString() + " in a listener callback");
        }
        this.mListeners.remove(listener);
        if (this.mBatchEditNestDepth > 0) {
            this.mPendingListeners.remove(listener);
        }
    }

    public SpannableStringBuilder replace(int start, int end, CharSequence tb, int tbstart, int tbend) {
        if (this.mChangeNotificationDepth > 0) {
            Log.e(TAG, "editing state should not be changed in a listener callback");
        }
        String oldText = this.toString();
        boolean textChanged = end - start != tbend - tbstart;
        for (int i = 0; i < end - start && !textChanged; textChanged |= this.charAt(start + i) != tb.charAt(tbstart + i), ++i) {
        }
        if (textChanged) {
            this.mToStringCache = null;
        }
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        int composingStart = this.getComposingStart();
        int composingEnd = this.getComposingEnd();
        SpannableStringBuilder editable = super.replace(start, end, tb, tbstart, tbend);
        this.mBatchTextEditingDeltas.add(new TextEditingDelta(oldText, start, end, tb, this.getSelectionStart(), this.getSelectionEnd(), this.getComposingStart(), this.getComposingEnd()));
        if (this.mBatchEditNestDepth > 0) {
            return editable;
        }
        boolean selectionChanged = this.getSelectionStart() != selectionStart || this.getSelectionEnd() != selectionEnd;
        boolean composingRegionChanged = this.getComposingStart() != composingStart || this.getComposingEnd() != composingEnd;
        this.notifyListenersIfNeeded(textChanged, selectionChanged, composingRegionChanged);
        return editable;
    }

    private void notifyListener(EditingStateWatcher listener, boolean textChanged, boolean selectionChanged, boolean composingChanged) {
        ++this.mChangeNotificationDepth;
        listener.didChangeEditingState(textChanged, selectionChanged, composingChanged);
        --this.mChangeNotificationDepth;
    }

    private void notifyListenersIfNeeded(boolean textChanged, boolean selectionChanged, boolean composingChanged) {
        if (textChanged || selectionChanged || composingChanged) {
            for (EditingStateWatcher listener : this.mListeners) {
                this.notifyListener(listener, textChanged, selectionChanged, composingChanged);
            }
        }
    }

    public final int getSelectionStart() {
        return Selection.getSelectionStart((CharSequence)((Object)this));
    }

    public final int getSelectionEnd() {
        return Selection.getSelectionEnd((CharSequence)((Object)this));
    }

    public final int getComposingStart() {
        return BaseInputConnection.getComposingSpanStart((Spannable)this);
    }

    public final int getComposingEnd() {
        return BaseInputConnection.getComposingSpanEnd((Spannable)this);
    }

    public void setSpan(Object what, int start, int end, int flags) {
        super.setSpan(what, start, end, flags);
        this.mBatchTextEditingDeltas.add(new TextEditingDelta(this.toString(), this.getSelectionStart(), this.getSelectionEnd(), this.getComposingStart(), this.getComposingEnd()));
    }

    public String toString() {
        return this.mToStringCache != null ? this.mToStringCache : (this.mToStringCache = super.toString());
    }

    static interface EditingStateWatcher {
        public void didChangeEditingState(boolean var1, boolean var2, boolean var3);
    }
}

