/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.image;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import androidx.annotation.NonNull;
import io.flutter.Log;
import java.nio.ByteBuffer;

class ImageUtils {
    private static final String TAG = "ImageUtils";

    ImageUtils() {
    }

    @NonNull
    static byte[] getBytes(@NonNull ByteBuffer buffer) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        buffer.rewind();
        return bytes;
    }

    static boolean isFlipCase(int orientation) {
        switch (orientation) {
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                return true;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: {
                return false;
            }
        }
        Log.e(TAG, "Unknown EXIF orientation: " + orientation);
        return false;
    }

    static Bitmap applyFlipIfNeeded(Bitmap decoded, int exifOrientation) {
        if (decoded == null || !ImageUtils.isFlipCase(exifOrientation)) {
            return decoded;
        }
        int w = decoded.getWidth();
        int h = decoded.getHeight();
        Matrix m = new Matrix();
        switch (exifOrientation) {
            case 2: {
                m.setScale(-1.0f, 1.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 4: {
                m.setScale(1.0f, -1.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 5: {
                m.setScale(1.0f, -1.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 7: {
                m.setScale(-1.0f, 1.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            default: {
                return decoded;
            }
        }
        Bitmap flipped = Bitmap.createBitmap((Bitmap)decoded, (int)0, (int)0, (int)w, (int)h, (Matrix)m, (boolean)true);
        if (flipped != decoded) {
            decoded.recycle();
        }
        return flipped;
    }
}

