/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.Log;
import io.flutter.embedding.android.FlutterView;
import io.flutter.embedding.android.SplashScreen;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.renderer.FlutterUiDisplayListener;

final class FlutterSplashView
extends FrameLayout {
    private static String TAG = "FlutterSplashView";
    @Nullable
    private SplashScreen splashScreen;
    @Nullable
    private FlutterView flutterView;
    @Nullable
    private View splashScreenView;
    @Nullable
    private Bundle splashScreenState;
    @Nullable
    private String transitioningIsolateId;
    @Nullable
    private String previousCompletedSplashIsolate;
    @NonNull
    private final FlutterView.FlutterEngineAttachmentListener flutterEngineAttachmentListener = new FlutterView.FlutterEngineAttachmentListener(){

        @Override
        public void onFlutterEngineAttachedToFlutterView(@NonNull FlutterEngine engine) {
            FlutterSplashView.this.flutterView.removeFlutterEngineAttachmentListener(this);
            FlutterSplashView.this.displayFlutterViewWithSplash(FlutterSplashView.this.flutterView, FlutterSplashView.this.splashScreen);
        }

        @Override
        public void onFlutterEngineDetachedFromFlutterView() {
        }
    };
    @NonNull
    private final FlutterUiDisplayListener flutterUiDisplayListener = new FlutterUiDisplayListener(){

        @Override
        public void onFlutterUiDisplayed() {
            if (FlutterSplashView.this.splashScreen != null) {
                FlutterSplashView.this.transitionToFlutter();
            }
        }

        @Override
        public void onFlutterUiNoLongerDisplayed() {
        }
    };
    @NonNull
    private final Runnable onTransitionComplete = new Runnable(){

        @Override
        public void run() {
            FlutterSplashView.this.removeView(FlutterSplashView.this.splashScreenView);
            FlutterSplashView.this.previousCompletedSplashIsolate = FlutterSplashView.this.transitioningIsolateId;
        }
    };

    public FlutterSplashView(@NonNull Context context) {
        this(context, null, 0);
    }

    public FlutterSplashView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FlutterSplashView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setSaveEnabled(true);
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.previousCompletedSplashIsolate = this.previousCompletedSplashIsolate;
        savedState.splashScreenState = this.splashScreen != null ? this.splashScreen.saveSplashScreenState() : null;
        return savedState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.previousCompletedSplashIsolate = savedState.previousCompletedSplashIsolate;
        this.splashScreenState = savedState.splashScreenState;
    }

    public void displayFlutterViewWithSplash(@NonNull FlutterView flutterView, @Nullable SplashScreen splashScreen) {
        if (this.flutterView != null) {
            this.flutterView.removeOnFirstFrameRenderedListener(this.flutterUiDisplayListener);
            this.removeView((View)this.flutterView);
        }
        if (this.splashScreenView != null) {
            this.removeView(this.splashScreenView);
        }
        this.flutterView = flutterView;
        this.addView((View)flutterView);
        this.splashScreen = splashScreen;
        if (splashScreen != null) {
            if (this.isSplashScreenNeededNow()) {
                Log.v(TAG, "Showing splash screen UI.");
                this.splashScreenView = splashScreen.createSplashView(this.getContext(), this.splashScreenState);
                this.addView(this.splashScreenView);
                flutterView.addOnFirstFrameRenderedListener(this.flutterUiDisplayListener);
            } else if (this.isSplashScreenTransitionNeededNow()) {
                Log.v(TAG, "Showing an immediate splash transition to Flutter due to previously interrupted transition.");
                this.splashScreenView = splashScreen.createSplashView(this.getContext(), this.splashScreenState);
                this.addView(this.splashScreenView);
                this.transitionToFlutter();
            } else if (!flutterView.isAttachedToFlutterEngine()) {
                Log.v(TAG, "FlutterView is not yet attached to a FlutterEngine. Showing nothing until a FlutterEngine is attached.");
                flutterView.addFlutterEngineAttachmentListener(this.flutterEngineAttachmentListener);
            }
        }
    }

    private boolean isSplashScreenNeededNow() {
        return this.flutterView != null && this.flutterView.isAttachedToFlutterEngine() && !this.flutterView.hasRenderedFirstFrame() && !this.hasSplashCompleted();
    }

    private boolean isSplashScreenTransitionNeededNow() {
        return this.flutterView != null && this.flutterView.isAttachedToFlutterEngine() && this.splashScreen != null && this.splashScreen.doesSplashViewRememberItsTransition() && this.wasPreviousSplashTransitionInterrupted();
    }

    private boolean wasPreviousSplashTransitionInterrupted() {
        if (this.flutterView == null) {
            throw new IllegalStateException("Cannot determine if previous splash transition was interrupted when no FlutterView is set.");
        }
        if (!this.flutterView.isAttachedToFlutterEngine()) {
            throw new IllegalStateException("Cannot determine if previous splash transition was interrupted when no FlutterEngine is attached to our FlutterView. This question depends on an isolate ID to differentiate Flutter experiences.");
        }
        return this.flutterView.hasRenderedFirstFrame() && !this.hasSplashCompleted();
    }

    private boolean hasSplashCompleted() {
        if (this.flutterView == null) {
            throw new IllegalStateException("Cannot determine if splash has completed when no FlutterView is set.");
        }
        if (!this.flutterView.isAttachedToFlutterEngine()) {
            throw new IllegalStateException("Cannot determine if splash has completed when no FlutterEngine is attached to our FlutterView. This question depends on an isolate ID to differentiate Flutter experiences.");
        }
        return this.flutterView.getAttachedFlutterEngine().getDartExecutor().getIsolateServiceId() != null && this.flutterView.getAttachedFlutterEngine().getDartExecutor().getIsolateServiceId().equals(this.previousCompletedSplashIsolate);
    }

    private void transitionToFlutter() {
        this.transitioningIsolateId = this.flutterView.getAttachedFlutterEngine().getDartExecutor().getIsolateServiceId();
        Log.v(TAG, "Transitioning splash screen to a Flutter UI. Isolate: " + this.transitioningIsolateId);
        this.splashScreen.transitionToFlutter(this.onTransitionComplete);
    }

    @Keep
    public static class SavedState
    extends View.BaseSavedState {
        public static Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel source) {
                return new SavedState(source);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        private String previousCompletedSplashIsolate;
        private Bundle splashScreenState;

        SavedState(Parcelable superState) {
            super(superState);
        }

        SavedState(Parcel source) {
            super(source);
            this.previousCompletedSplashIsolate = source.readString();
            this.splashScreenState = source.readBundle(((Object)((Object)this)).getClass().getClassLoader());
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.previousCompletedSplashIsolate);
            out.writeBundle(this.splashScreenState);
        }
    }
}

