/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.mouse;

import android.annotation.TargetApi;
import android.view.PointerIcon;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import io.flutter.embedding.engine.systemchannels.MouseCursorChannel;
import java.util.HashMap;

@TargetApi(value=24)
@RequiresApi(value=24)
public class MouseCursorPlugin {
    @NonNull
    private final MouseCursorViewDelegate mView;
    @NonNull
    private final MouseCursorChannel mouseCursorChannel;
    @NonNull
    private static HashMap<String, Integer> systemCursorConstants;

    public MouseCursorPlugin(@NonNull MouseCursorViewDelegate view, @NonNull MouseCursorChannel mouseCursorChannel) {
        this.mView = view;
        this.mouseCursorChannel = mouseCursorChannel;
        mouseCursorChannel.setMethodHandler(new MouseCursorChannel.MouseCursorMethodHandler(){

            @Override
            public void activateSystemCursor(@NonNull String kind) {
                MouseCursorPlugin.this.mView.setPointerIcon(MouseCursorPlugin.this.resolveSystemCursor(kind));
            }
        });
    }

    private PointerIcon resolveSystemCursor(@NonNull String kind) {
        if (systemCursorConstants == null) {
            systemCursorConstants = new HashMap<String, Integer>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("alias", 1010);
                    this.put("allScroll", 1013);
                    this.put("basic", 1000);
                    this.put("cell", 1006);
                    this.put("click", 1002);
                    this.put("contextMenu", 1001);
                    this.put("copy", 1011);
                    this.put("forbidden", 1012);
                    this.put("grab", 1020);
                    this.put("grabbing", 1021);
                    this.put("help", 1003);
                    this.put("move", 1013);
                    this.put("none", 0);
                    this.put("noDrop", 1012);
                    this.put("precise", 1007);
                    this.put("text", 1008);
                    this.put("resizeColumn", 1014);
                    this.put("resizeDown", 1015);
                    this.put("resizeUpLeft", 1016);
                    this.put("resizeDownRight", 1017);
                    this.put("resizeLeft", 1014);
                    this.put("resizeLeftRight", 1014);
                    this.put("resizeRight", 1014);
                    this.put("resizeRow", 1015);
                    this.put("resizeUp", 1015);
                    this.put("resizeUpDown", 1015);
                    this.put("resizeUpLeft", 1017);
                    this.put("resizeUpRight", 1016);
                    this.put("resizeUpLeftDownRight", 1017);
                    this.put("resizeUpRightDownLeft", 1016);
                    this.put("verticalText", 1009);
                    this.put("wait", 1004);
                    this.put("zoomIn", 1018);
                    this.put("zoomOut", 1019);
                }
            };
        }
        int cursorConstant = systemCursorConstants.getOrDefault(kind, 1000);
        return this.mView.getSystemPointerIcon(cursorConstant);
    }

    public void destroy() {
        this.mouseCursorChannel.setMethodHandler(null);
    }

    public static interface MouseCursorViewDelegate {
        public PointerIcon getSystemPointerIcon(int var1);

        public void setPointerIcon(@NonNull PointerIcon var1);
    }
}

