/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.StandardMethodCodec;

public class SensitiveContentChannel {
    private static final String TAG = "SensitiveContentChannel";
    @VisibleForTesting
    public static final int AUTO_SENSITIVE_CONTENT_SENSITIVITY = 0;
    @VisibleForTesting
    public static final int SENSITIVE_CONTENT_SENSITIVITY = 1;
    @VisibleForTesting
    public static final int NOT_SENSITIVE_CONTENT_SENSITIVITY = 2;
    @VisibleForTesting
    public static final int UNKNOWN_CONTENT_SENSITIVITY = 3;
    public final MethodChannel channel;
    private SensitiveContentMethodHandler sensitiveContentMethodHandler;
    @NonNull
    public final MethodChannel.MethodCallHandler parsingMethodHandler = new MethodChannel.MethodCallHandler(){

        @Override
        public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            if (SensitiveContentChannel.this.sensitiveContentMethodHandler == null) {
                return;
            }
            String method = call.method;
            Log.v(SensitiveContentChannel.TAG, "Received '" + method + "' message.");
            switch (method) {
                case "SensitiveContent.setContentSensitivity": {
                    int contentSensitivityLevel = (Integer)call.arguments();
                    try {
                        SensitiveContentChannel.this.sensitiveContentMethodHandler.setContentSensitivity(SensitiveContentChannel.this.deserializeContentSensitivity(contentSensitivityLevel));
                    }
                    catch (IllegalArgumentException | IllegalStateException e) {
                        result.error("error", e.getMessage(), null);
                    }
                    break;
                }
                case "SensitiveContent.getContentSensitivity": {
                    try {
                        Integer currentContentSensitvity = SensitiveContentChannel.this.sensitiveContentMethodHandler.getContentSensitivity();
                        result.success(SensitiveContentChannel.this.serializeContentSensitivity(currentContentSensitvity));
                    }
                    catch (IllegalArgumentException | IllegalStateException e) {
                        result.error("error", e.getMessage(), null);
                    }
                    break;
                }
                case "SensitiveContent.isSupported": {
                    result.success(SensitiveContentChannel.this.sensitiveContentMethodHandler.isSupported());
                    break;
                }
                default: {
                    Log.v(SensitiveContentChannel.TAG, "Method " + method + " is not implemented for the SensitiveContentChannel.");
                    result.notImplemented();
                }
            }
        }
    };

    @SuppressLint(value={"InlinedApi"})
    private int deserializeContentSensitivity(int contentSensitivityIndex) {
        switch (contentSensitivityIndex) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        throw new IllegalArgumentException("contentSensitivityIndex " + contentSensitivityIndex + " not known to the SensitiveContentChannel.");
    }

    @SuppressLint(value={"InlinedApi"})
    private int serializeContentSensitivity(int contentSensitivityValue) {
        switch (contentSensitivityValue) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 3;
    }

    public SensitiveContentChannel(@NonNull DartExecutor dartExecutor) {
        this.channel = new MethodChannel(dartExecutor, "flutter/sensitivecontent", StandardMethodCodec.INSTANCE);
        this.channel.setMethodCallHandler(this.parsingMethodHandler);
    }

    public void setSensitiveContentMethodHandler(@Nullable SensitiveContentMethodHandler sensitiveContentMethodHandler) {
        this.sensitiveContentMethodHandler = sensitiveContentMethodHandler;
    }

    public static interface SensitiveContentMethodHandler {
        public void setContentSensitivity(@NonNull int var1);

        public int getContentSensitivity();

        public boolean isSupported();
    }
}

