/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.renderer;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.SyncFence;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.renderer.FlutterUiDisplayListener;
import io.flutter.embedding.engine.renderer.FlutterUiResizeListener;
import io.flutter.embedding.engine.renderer.SurfaceTextureSurfaceProducer;
import io.flutter.embedding.engine.renderer.SurfaceTextureWrapper;
import io.flutter.view.TextureRegistry;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class FlutterRenderer
implements TextureRegistry {
    @VisibleForTesting
    public static boolean debugForceSurfaceProducerGlTextures = false;
    @VisibleForTesting
    public static boolean debugDisableSurfaceClear = false;
    private static final String TAG = "FlutterRenderer";
    @NonNull
    private final FlutterJNI flutterJNI;
    @NonNull
    private final AtomicLong nextTextureId = new AtomicLong(0L);
    @Nullable
    private Surface surface;
    private boolean isDisplayingFlutterUi = false;
    private final Handler handler = new Handler();
    @NonNull
    private final Set<WeakReference<TextureRegistry.OnTrimMemoryListener>> onTrimMemoryListeners = new HashSet<WeakReference<TextureRegistry.OnTrimMemoryListener>>();
    @NonNull
    private final List<ImageReaderSurfaceProducer> imageReaderProducers = new ArrayList<ImageReaderSurfaceProducer>();
    @NonNull
    private final FlutterUiDisplayListener flutterUiDisplayListener = new FlutterUiDisplayListener(){

        @Override
        public void onFlutterUiDisplayed() {
            FlutterRenderer.this.isDisplayingFlutterUi = true;
        }

        @Override
        public void onFlutterUiNoLongerDisplayed() {
            FlutterRenderer.this.isDisplayingFlutterUi = false;
        }
    };

    public FlutterRenderer(@NonNull FlutterJNI flutterJNI) {
        this.flutterJNI = flutterJNI;
        this.flutterJNI.addIsDisplayingFlutterUiListener(this.flutterUiDisplayListener);
    }

    public void restoreSurfaceProducers() {
        Log.v(TAG, "restoreSurfaceProducers called; notifying SurfaceProducers");
        for (ImageReaderSurfaceProducer producer : this.imageReaderProducers) {
            if (producer.callback == null || !producer.notifiedDestroy) continue;
            producer.notifiedDestroy = false;
            producer.callback.onSurfaceAvailable();
        }
    }

    public boolean isDisplayingFlutterUi() {
        return this.isDisplayingFlutterUi;
    }

    public void addResizingFlutterUiListener(@NonNull FlutterUiResizeListener listener) {
        this.flutterJNI.addResizingFlutterUiListener(listener);
    }

    public void removeResizingFlutterUiListener(@NonNull FlutterUiResizeListener listener) {
        this.flutterJNI.removeResizingFlutterUiListener(listener);
    }

    public void addIsDisplayingFlutterUiListener(@NonNull FlutterUiDisplayListener listener) {
        this.flutterJNI.addIsDisplayingFlutterUiListener(listener);
        if (this.isDisplayingFlutterUi) {
            listener.onFlutterUiDisplayed();
        }
    }

    public void removeIsDisplayingFlutterUiListener(@NonNull FlutterUiDisplayListener listener) {
        this.flutterJNI.removeIsDisplayingFlutterUiListener(listener);
    }

    private void clearDeadListeners() {
        Iterator<WeakReference<TextureRegistry.OnTrimMemoryListener>> iterator = this.onTrimMemoryListeners.iterator();
        while (iterator.hasNext()) {
            WeakReference<TextureRegistry.OnTrimMemoryListener> listenerRef = iterator.next();
            TextureRegistry.OnTrimMemoryListener listener = (TextureRegistry.OnTrimMemoryListener)listenerRef.get();
            if (listener != null) continue;
            iterator.remove();
        }
    }

    @VisibleForTesting
    void addOnTrimMemoryListener(@NonNull TextureRegistry.OnTrimMemoryListener listener) {
        this.clearDeadListeners();
        this.onTrimMemoryListeners.add(new WeakReference<TextureRegistry.OnTrimMemoryListener>(listener));
    }

    @VisibleForTesting
    void removeOnTrimMemoryListener(@NonNull TextureRegistry.OnTrimMemoryListener listener) {
        for (WeakReference<TextureRegistry.OnTrimMemoryListener> listenerRef : this.onTrimMemoryListeners) {
            if (listenerRef.get() != listener) continue;
            this.onTrimMemoryListeners.remove(listenerRef);
            break;
        }
    }

    @Override
    @NonNull
    public TextureRegistry.SurfaceProducer createSurfaceProducer(TextureRegistry.SurfaceLifecycle lifecycle) {
        TextureRegistry.SurfaceProducer entry;
        if (!debugForceSurfaceProducerGlTextures && Build.VERSION.SDK_INT >= 29) {
            long id2 = this.nextTextureId.getAndIncrement();
            ImageReaderSurfaceProducer producer = new ImageReaderSurfaceProducer(id2);
            boolean reset = lifecycle == TextureRegistry.SurfaceLifecycle.resetInBackground;
            this.registerImageTexture(id2, producer, reset);
            if (reset) {
                this.addOnTrimMemoryListener(producer);
            }
            this.imageReaderProducers.add(producer);
            Log.v(TAG, "New ImageReaderSurfaceProducer ID: " + id2);
            entry = producer;
        } else {
            TextureRegistry.SurfaceTextureEntry texture = this.createSurfaceTexture();
            SurfaceTextureSurfaceProducer producer = new SurfaceTextureSurfaceProducer(texture.id(), this.handler, this.flutterJNI, texture);
            Log.v(TAG, "New SurfaceTextureSurfaceProducer ID: " + texture.id());
            entry = producer;
        }
        return entry;
    }

    @Override
    @NonNull
    public TextureRegistry.SurfaceTextureEntry createSurfaceTexture() {
        Log.v(TAG, "Creating a SurfaceTexture.");
        SurfaceTexture surfaceTexture = new SurfaceTexture(0);
        return this.registerSurfaceTexture(surfaceTexture);
    }

    @Override
    @NonNull
    public TextureRegistry.SurfaceTextureEntry registerSurfaceTexture(@NonNull SurfaceTexture surfaceTexture) {
        return this.registerSurfaceTexture(this.nextTextureId.getAndIncrement(), surfaceTexture);
    }

    @NonNull
    private TextureRegistry.SurfaceTextureEntry registerSurfaceTexture(long textureId, @NonNull SurfaceTexture surfaceTexture) {
        surfaceTexture.detachFromGLContext();
        SurfaceTextureRegistryEntry entry = new SurfaceTextureRegistryEntry(textureId, surfaceTexture);
        Log.v(TAG, "New SurfaceTexture ID: " + entry.id());
        this.registerTexture(entry.id(), entry.textureWrapper());
        this.addOnTrimMemoryListener(entry);
        return entry;
    }

    @Override
    @NonNull
    public TextureRegistry.ImageTextureEntry createImageTexture() {
        ImageTextureRegistryEntry entry = new ImageTextureRegistryEntry(this.nextTextureId.getAndIncrement());
        Log.v(TAG, "New ImageTextureEntry ID: " + entry.id());
        this.registerImageTexture(entry.id(), entry, false);
        return entry;
    }

    @Override
    public void onTrimMemory(int level) {
        Iterator<WeakReference<TextureRegistry.OnTrimMemoryListener>> iterator = this.onTrimMemoryListeners.iterator();
        while (iterator.hasNext()) {
            WeakReference<TextureRegistry.OnTrimMemoryListener> listenerRef = iterator.next();
            TextureRegistry.OnTrimMemoryListener listener = (TextureRegistry.OnTrimMemoryListener)listenerRef.get();
            if (listener != null) {
                listener.onTrimMemory(level);
                continue;
            }
            iterator.remove();
        }
    }

    public void startRenderingToSurface(@NonNull Surface surface, boolean onlySwap) {
        if (!onlySwap) {
            this.stopRenderingToSurface();
        }
        this.surface = surface;
        if (onlySwap) {
            this.flutterJNI.onSurfaceWindowChanged(surface);
        } else {
            this.flutterJNI.onSurfaceCreated(surface);
        }
    }

    public void swapSurface(@NonNull Surface surface) {
        this.surface = surface;
        this.flutterJNI.onSurfaceWindowChanged(surface);
    }

    public void surfaceChanged(int width, int height) {
        this.flutterJNI.onSurfaceChanged(width, height);
    }

    public void stopRenderingToSurface() {
        if (this.surface != null) {
            this.flutterJNI.onSurfaceDestroyed();
            if (this.isDisplayingFlutterUi) {
                this.flutterUiDisplayListener.onFlutterUiNoLongerDisplayed();
            }
            this.isDisplayingFlutterUi = false;
            this.surface = null;
        }
    }

    private void translateFeatureBounds(int[] displayFeatureBounds, int offset, Rect bounds) {
        displayFeatureBounds[offset] = bounds.left;
        displayFeatureBounds[offset + 1] = bounds.top;
        displayFeatureBounds[offset + 2] = bounds.right;
        displayFeatureBounds[offset + 3] = bounds.bottom;
    }

    public void setViewportMetrics(@NonNull ViewportMetrics viewportMetrics) {
        if (!viewportMetrics.validate()) {
            return;
        }
        Log.v(TAG, "Setting viewport metrics\nSize: " + viewportMetrics.width + " x " + viewportMetrics.height + "\nSize Constraints: " + viewportMetrics.minWidth + "," + viewportMetrics.maxWidth + " x " + viewportMetrics.minHeight + "," + viewportMetrics.maxHeight + "\nPadding - L: " + viewportMetrics.viewPaddingLeft + ", T: " + viewportMetrics.viewPaddingTop + ", R: " + viewportMetrics.viewPaddingRight + ", B: " + viewportMetrics.viewPaddingBottom + "\nInsets - L: " + viewportMetrics.viewInsetLeft + ", T: " + viewportMetrics.viewInsetTop + ", R: " + viewportMetrics.viewInsetRight + ", B: " + viewportMetrics.viewInsetBottom + "\nSystem Gesture Insets - L: " + viewportMetrics.systemGestureInsetLeft + ", T: " + viewportMetrics.systemGestureInsetTop + ", R: " + viewportMetrics.systemGestureInsetRight + ", B: " + viewportMetrics.systemGestureInsetRight + "\nDisplay Features: " + viewportMetrics.displayFeatures.size() + "\nDisplay Cutouts: " + viewportMetrics.displayCutouts.size());
        int totalFeaturesAndCutouts = viewportMetrics.displayFeatures.size() + viewportMetrics.displayCutouts.size();
        int[] displayFeaturesBounds = new int[totalFeaturesAndCutouts * 4];
        int[] displayFeaturesType = new int[totalFeaturesAndCutouts];
        int[] displayFeaturesState = new int[totalFeaturesAndCutouts];
        for (int i = 0; i < viewportMetrics.displayFeatures.size(); ++i) {
            DisplayFeature displayFeature = (DisplayFeature)viewportMetrics.displayFeatures.get(i);
            this.translateFeatureBounds(displayFeaturesBounds, 4 * i, displayFeature.bounds);
            displayFeaturesType[i] = displayFeature.type.encodedValue;
            displayFeaturesState[i] = displayFeature.state.encodedValue;
        }
        int cutoutOffset = viewportMetrics.displayFeatures.size() * 4;
        for (int i = 0; i < viewportMetrics.displayCutouts.size(); ++i) {
            DisplayFeature displayCutout = (DisplayFeature)viewportMetrics.displayCutouts.get(i);
            this.translateFeatureBounds(displayFeaturesBounds, cutoutOffset + 4 * i, displayCutout.bounds);
            displayFeaturesType[((ViewportMetrics)viewportMetrics).displayFeatures.size() + i] = displayCutout.type.encodedValue;
            displayFeaturesState[((ViewportMetrics)viewportMetrics).displayFeatures.size() + i] = displayCutout.state.encodedValue;
        }
        this.flutterJNI.setViewportMetrics(viewportMetrics.devicePixelRatio, viewportMetrics.width, viewportMetrics.height, viewportMetrics.viewPaddingTop, viewportMetrics.viewPaddingRight, viewportMetrics.viewPaddingBottom, viewportMetrics.viewPaddingLeft, viewportMetrics.viewInsetTop, viewportMetrics.viewInsetRight, viewportMetrics.viewInsetBottom, viewportMetrics.viewInsetLeft, viewportMetrics.systemGestureInsetTop, viewportMetrics.systemGestureInsetRight, viewportMetrics.systemGestureInsetBottom, viewportMetrics.systemGestureInsetLeft, viewportMetrics.physicalTouchSlop, displayFeaturesBounds, displayFeaturesType, displayFeaturesState, viewportMetrics.minWidth, viewportMetrics.maxWidth, viewportMetrics.minHeight, viewportMetrics.maxHeight);
    }

    public Bitmap getBitmap() {
        return this.flutterJNI.getBitmap();
    }

    public void dispatchPointerDataPacket(@NonNull ByteBuffer buffer, int position) {
        this.flutterJNI.dispatchPointerDataPacket(buffer, position);
    }

    private void registerTexture(long textureId, @NonNull SurfaceTextureWrapper textureWrapper) {
        this.flutterJNI.registerTexture(textureId, textureWrapper);
    }

    private void registerImageTexture(long textureId, @NonNull TextureRegistry.ImageConsumer imageTexture, boolean resetOnBackground) {
        this.flutterJNI.registerImageTexture(textureId, imageTexture, resetOnBackground);
    }

    @VisibleForTesting
    void scheduleEngineFrame() {
        this.flutterJNI.scheduleFrame();
    }

    private void unregisterTexture(long textureId) {
        this.flutterJNI.unregisterTexture(textureId);
    }

    public boolean isSoftwareRenderingEnabled() {
        return this.flutterJNI.getIsSoftwareRenderingEnabled();
    }

    public void setAccessibilityFeatures(int flags) {
        this.flutterJNI.setAccessibilityFeatures(flags);
    }

    public void setSemanticsEnabled(boolean enabled) {
        this.flutterJNI.setSemanticsEnabled(enabled);
    }

    public void dispatchSemanticsAction(int nodeId, int action, @Nullable ByteBuffer args, int argsPosition) {
        this.flutterJNI.dispatchSemanticsAction(nodeId, action, args, argsPosition);
    }

    @Keep
    final class ImageReaderSurfaceProducer
    implements TextureRegistry.SurfaceProducer,
    TextureRegistry.ImageConsumer,
    TextureRegistry.OnTrimMemoryListener {
        private static final String TAG = "ImageReaderSurfaceProducer";
        private static final int MAX_DEQUEUED_IMAGES = 2;
        private static final int MAX_IMAGES = 7;
        private static final boolean VERBOSE_LOGS = false;
        private static final boolean CLEANUP_ON_MEMORY_PRESSURE = true;
        private final long id;
        private boolean released;
        private boolean ignoringFence = false;
        private static final boolean trimOnMemoryPressure = true;
        private int requestedWidth = 1;
        private int requestedHeight = 1;
        private boolean createNewReader = true;
        @VisibleForTesting
        boolean notifiedDestroy = false;
        private long lastDequeueTime = 0L;
        private long lastQueueTime = 0L;
        private long lastScheduleTime = 0L;
        private int numTrims = 0;
        private final Object lock = new Object();
        private final ArrayDeque<PerImageReader> imageReaderQueue = new ArrayDeque();
        private final HashMap<ImageReader, PerImageReader> perImageReaders = new HashMap();
        private ArrayList<PerImage> lastDequeuedImage = new ArrayList();
        private PerImageReader lastReaderDequeuedFrom = null;
        @VisibleForTesting
        TextureRegistry.SurfaceProducer.Callback callback = null;

        double deltaMillis(long deltaNanos) {
            return (double)deltaNanos / 1000000.0;
        }

        private PerImageReader getOrCreatePerImageReader(ImageReader reader) {
            PerImageReader r = this.perImageReaders.get(reader);
            if (r == null) {
                r = this.createPerImageReader(reader);
                this.perImageReaders.put(reader, r);
                this.imageReaderQueue.add(r);
            }
            return r;
        }

        @VisibleForTesting
        public PerImageReader createPerImageReader(ImageReader reader) {
            return new PerImageReader(reader);
        }

        void pruneImageReaderQueue() {
            PerImageReader r;
            boolean change = false;
            while (this.imageReaderQueue.size() > 1 && (r = this.imageReaderQueue.peekFirst()) != null && r.canPrune()) {
                this.imageReaderQueue.removeFirst();
                this.perImageReaders.remove(r.reader);
                r.close();
                change = true;
            }
            if (change) {
                // empty if block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onImage(ImageReader reader, Image image) {
            PerImage queuedImage;
            Object object = this.lock;
            synchronized (object) {
                PerImageReader perReader = this.getOrCreatePerImageReader(reader);
                queuedImage = perReader.queueImage(image);
            }
            if (queuedImage == null) {
                return;
            }
            FlutterRenderer.this.scheduleEngineFrame();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PerImage dequeueImage() {
            PerImage r = null;
            boolean hasPendingImages = false;
            Object object = this.lock;
            synchronized (object) {
                for (PerImageReader reader : this.imageReaderQueue) {
                    r = reader.dequeueImage();
                    if (r == null) continue;
                    while (this.lastDequeuedImage.size() > 2) {
                        PerImage last = this.lastDequeuedImage.remove(0);
                        last.image.close();
                    }
                    this.lastDequeuedImage.add(r);
                    this.lastReaderDequeuedFrom = reader;
                    break;
                }
                this.pruneImageReaderQueue();
                for (PerImageReader reader : this.imageReaderQueue) {
                    if (reader.imageQueueIsEmpty()) continue;
                    hasPendingImages = true;
                    break;
                }
            }
            if (hasPendingImages) {
                FlutterRenderer.this.handler.post(() -> {
                    if (!this.released) {
                        FlutterRenderer.this.scheduleEngineFrame();
                    }
                });
            }
            return r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTrimMemory(int level) {
            if (level < 40) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                ++this.numTrims;
            }
            if (this.callback != null) {
                this.notifiedDestroy = true;
                this.callback.onSurfaceCleanup();
            }
            this.cleanup();
            this.createNewReader = true;
        }

        private void releaseInternal() {
            this.cleanup();
            this.released = true;
            FlutterRenderer.this.removeOnTrimMemoryListener(this);
            FlutterRenderer.this.imageReaderProducers.remove(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanup() {
            Object object = this.lock;
            synchronized (object) {
                for (PerImageReader pir : this.perImageReaders.values()) {
                    if (this.lastReaderDequeuedFrom == pir) {
                        this.lastReaderDequeuedFrom = null;
                    }
                    pir.close();
                }
                this.perImageReaders.clear();
                if (this.lastDequeuedImage.size() > 0) {
                    for (PerImage image : this.lastDequeuedImage) {
                        image.image.close();
                    }
                    this.lastDequeuedImage.clear();
                }
                if (this.lastReaderDequeuedFrom != null) {
                    this.lastReaderDequeuedFrom.close();
                    this.lastReaderDequeuedFrom = null;
                }
                this.imageReaderQueue.clear();
            }
        }

        @RequiresApi(value=33)
        private void waitOnFence(Image image) {
            try {
                SyncFence fence = image.getFence();
                fence.awaitForever();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void maybeWaitOnFence(Image image) {
            if (image == null) {
                return;
            }
            if (this.ignoringFence) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 33) {
                this.waitOnFence(image);
                return;
            }
            this.ignoringFence = true;
            Log.d(TAG, "ImageTextureEntry can't wait on the fence on Android < 33");
        }

        ImageReaderSurfaceProducer(long id2) {
            this.id = id2;
        }

        @Override
        public void setCallback(TextureRegistry.SurfaceProducer.Callback callback) {
            this.callback = callback;
        }

        @Override
        public boolean handlesCropAndRotation() {
            return false;
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public void release() {
            if (this.released) {
                return;
            }
            this.releaseInternal();
            FlutterRenderer.this.unregisterTexture(this.id);
        }

        @Override
        public void setSize(int width, int height) {
            width = Math.max(1, width);
            height = Math.max(1, height);
            if (this.requestedWidth == width && this.requestedHeight == height) {
                return;
            }
            this.createNewReader = true;
            this.requestedHeight = height;
            this.requestedWidth = width;
        }

        @Override
        public int getWidth() {
            return this.requestedWidth;
        }

        @Override
        public int getHeight() {
            return this.requestedHeight;
        }

        @Override
        public Surface getSurface() {
            PerImageReader pir = this.getActiveReader();
            return pir.reader.getSurface();
        }

        @Override
        public Surface getForcedNewSurface() {
            this.createNewReader = true;
            return this.getSurface();
        }

        @Override
        public void scheduleFrame() {
            FlutterRenderer.this.scheduleEngineFrame();
        }

        @Override
        @RequiresApi(value=29)
        public Image acquireLatestImage() {
            PerImage r = this.dequeueImage();
            if (r == null) {
                return null;
            }
            this.maybeWaitOnFence(r.image);
            return r.image;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PerImageReader getActiveReader() {
            Object object = this.lock;
            synchronized (object) {
                if (!this.createNewReader) {
                    PerImageReader lastPerImageReader = this.imageReaderQueue.peekLast();
                    Surface lastImageReaderSurface = lastPerImageReader.reader.getSurface();
                    boolean lastImageReaderHasValidSurface = lastImageReaderSurface.isValid();
                    if (lastImageReaderHasValidSurface) {
                        return lastPerImageReader;
                    }
                }
                this.createNewReader = false;
                ImageReader reader = this.createImageReader();
                return this.getOrCreatePerImageReader(reader);
            }
        }

        protected void finalize() throws Throwable {
            try {
                if (this.released) {
                    return;
                }
                this.releaseInternal();
                FlutterRenderer.this.handler.post((Runnable)new TextureFinalizerRunnable(this.id, FlutterRenderer.this.flutterJNI));
            }
            finally {
                super.finalize();
            }
        }

        @RequiresApi(value=33)
        private ImageReader createImageReader33() {
            ImageReader.Builder builder = new ImageReader.Builder(this.requestedWidth, this.requestedHeight);
            builder.setMaxImages(7);
            builder.setImageFormat(34);
            builder.setUsage(256L);
            return builder.build();
        }

        @RequiresApi(value=29)
        private ImageReader createImageReader29() {
            return ImageReader.newInstance((int)this.requestedWidth, (int)this.requestedHeight, (int)34, (int)7, (long)256L);
        }

        @VisibleForTesting
        public ImageReader createImageReader() {
            if (Build.VERSION.SDK_INT >= 33) {
                return this.createImageReader33();
            }
            if (Build.VERSION.SDK_INT >= 29) {
                return this.createImageReader29();
            }
            throw new UnsupportedOperationException("ImageReaderPlatformViewRenderTarget requires API version 29+");
        }

        @VisibleForTesting
        public void disableFenceForTest() {
            this.ignoringFence = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        public int numImageReaders() {
            Object object = this.lock;
            synchronized (object) {
                return this.imageReaderQueue.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        public int numTrims() {
            Object object = this.lock;
            synchronized (object) {
                return this.numTrims;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        public int numImages() {
            int r = 0;
            Object object = this.lock;
            synchronized (object) {
                for (PerImageReader reader : this.imageReaderQueue) {
                    r += reader.imageQueue.size();
                }
            }
            return r;
        }

        @VisibleForTesting
        public int pendingDequeuedImages() {
            return this.lastDequeuedImage.size();
        }

        private class PerImageReader {
            public final ImageReader reader;
            private final ArrayDeque<PerImage> imageQueue = new ArrayDeque();
            private boolean closed = false;

            public PerImageReader(ImageReader reader) {
                this.reader = reader;
                ImageReader.OnImageAvailableListener onImageAvailableListener = r -> {
                    Image image = null;
                    try {
                        image = r.acquireLatestImage();
                    }
                    catch (IllegalStateException e) {
                        Log.e(ImageReaderSurfaceProducer.TAG, "onImageAvailable acquireLatestImage failed: " + e);
                    }
                    if (image == null) {
                        return;
                    }
                    if (ImageReaderSurfaceProducer.this.released || this.closed) {
                        image.close();
                        return;
                    }
                    ImageReaderSurfaceProducer.this.onImage(r, image);
                };
                reader.setOnImageAvailableListener(onImageAvailableListener, new Handler(Looper.getMainLooper()));
            }

            PerImage queueImage(Image image) {
                if (this.closed) {
                    return null;
                }
                PerImage perImage = new PerImage(image, System.nanoTime());
                this.imageQueue.add(perImage);
                while (this.imageQueue.size() > 2) {
                    PerImage r = this.imageQueue.removeFirst();
                    r.image.close();
                }
                return perImage;
            }

            PerImage dequeueImage() {
                if (this.imageQueue.isEmpty()) {
                    return null;
                }
                return this.imageQueue.removeFirst();
            }

            boolean canPrune() {
                return this.imageQueue.isEmpty() && ImageReaderSurfaceProducer.this.lastReaderDequeuedFrom != this;
            }

            boolean imageQueueIsEmpty() {
                return this.imageQueue.isEmpty();
            }

            void close() {
                this.closed = true;
                this.reader.close();
                this.imageQueue.clear();
            }
        }

        private class PerImage {
            public final Image image;
            public final long queuedTime;

            public PerImage(Image image, long queuedTime) {
                this.image = image;
                this.queuedTime = queuedTime;
            }
        }
    }

    final class SurfaceTextureRegistryEntry
    implements TextureRegistry.SurfaceTextureEntry,
    TextureRegistry.OnTrimMemoryListener {
        private final long id;
        @NonNull
        private final SurfaceTextureWrapper textureWrapper;
        private boolean released;
        @Nullable
        private TextureRegistry.OnTrimMemoryListener trimMemoryListener;
        @Nullable
        private TextureRegistry.OnFrameConsumedListener frameConsumedListener;

        SurfaceTextureRegistryEntry(@NonNull long id2, SurfaceTexture surfaceTexture) {
            this.id = id2;
            Runnable onFrameConsumed = () -> {
                if (this.frameConsumedListener != null) {
                    this.frameConsumedListener.onFrameConsumed();
                }
            };
            this.textureWrapper = new SurfaceTextureWrapper(surfaceTexture, onFrameConsumed);
            SurfaceTexture.OnFrameAvailableListener onFrameListener = texture -> {
                if (this.released || !FlutterRenderer.this.flutterJNI.isAttached()) {
                    return;
                }
                this.textureWrapper.markDirty();
                FlutterRenderer.this.scheduleEngineFrame();
            };
            this.surfaceTexture().setOnFrameAvailableListener(onFrameListener, new Handler());
        }

        @Override
        public void onTrimMemory(int level) {
            if (this.trimMemoryListener != null) {
                this.trimMemoryListener.onTrimMemory(level);
            }
        }

        private void removeListener() {
            FlutterRenderer.this.removeOnTrimMemoryListener(this);
        }

        @NonNull
        public SurfaceTextureWrapper textureWrapper() {
            return this.textureWrapper;
        }

        @Override
        @NonNull
        public SurfaceTexture surfaceTexture() {
            return this.textureWrapper.surfaceTexture();
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public void release() {
            if (this.released) {
                return;
            }
            Log.v(FlutterRenderer.TAG, "Releasing a SurfaceTexture (" + this.id + ").");
            this.textureWrapper.release();
            FlutterRenderer.this.unregisterTexture(this.id);
            this.removeListener();
            this.released = true;
        }

        protected void finalize() throws Throwable {
            try {
                if (this.released) {
                    return;
                }
                FlutterRenderer.this.handler.post((Runnable)new TextureFinalizerRunnable(this.id, FlutterRenderer.this.flutterJNI));
            }
            finally {
                super.finalize();
            }
        }

        @Override
        public void setOnFrameConsumedListener(@Nullable TextureRegistry.OnFrameConsumedListener listener) {
            this.frameConsumedListener = listener;
        }

        @Override
        public void setOnTrimMemoryListener(@Nullable TextureRegistry.OnTrimMemoryListener listener) {
            this.trimMemoryListener = listener;
        }
    }

    @Keep
    final class ImageTextureRegistryEntry
    implements TextureRegistry.ImageTextureEntry,
    TextureRegistry.ImageConsumer {
        private static final String TAG = "ImageTextureRegistryEntry";
        private final long id;
        private boolean released;
        private boolean ignoringFence = false;
        private Image image;

        ImageTextureRegistryEntry(long id2) {
            this.id = id2;
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public void release() {
            if (this.released) {
                return;
            }
            this.released = true;
            if (this.image != null) {
                this.image.close();
                this.image = null;
            }
            FlutterRenderer.this.unregisterTexture(this.id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pushImage(Image image) {
            Image toClose;
            if (this.released) {
                return;
            }
            ImageTextureRegistryEntry imageTextureRegistryEntry = this;
            synchronized (imageTextureRegistryEntry) {
                toClose = this.image;
                this.image = image;
            }
            if (toClose != null) {
                Log.e(TAG, "Dropping PlatformView Frame");
                toClose.close();
            }
            if (image != null) {
                FlutterRenderer.this.scheduleEngineFrame();
            }
        }

        @RequiresApi(value=33)
        private void waitOnFence(Image image) {
            try {
                SyncFence fence = image.getFence();
                fence.awaitForever();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @RequiresApi(value=29)
        private void maybeWaitOnFence(Image image) {
            if (image == null) {
                return;
            }
            if (this.ignoringFence) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 33) {
                this.waitOnFence(image);
                return;
            }
            this.ignoringFence = true;
            Log.d(TAG, "ImageTextureEntry can't wait on the fence on Android < 33");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @RequiresApi(value=29)
        public Image acquireLatestImage() {
            Image r;
            ImageTextureRegistryEntry imageTextureRegistryEntry = this;
            synchronized (imageTextureRegistryEntry) {
                r = this.image;
                this.image = null;
            }
            this.maybeWaitOnFence(r);
            return r;
        }

        protected void finalize() throws Throwable {
            try {
                if (this.released) {
                    return;
                }
                if (this.image != null) {
                    this.image.close();
                    this.image = null;
                }
                this.released = true;
                FlutterRenderer.this.handler.post((Runnable)new TextureFinalizerRunnable(this.id, FlutterRenderer.this.flutterJNI));
            }
            finally {
                super.finalize();
            }
        }
    }

    public static final class ViewportMetrics {
        public static final int unsetValue = -1;
        public float devicePixelRatio = 1.0f;
        public int width = 0;
        public int height = 0;
        public int minWidth = 0;
        public int maxWidth = 0;
        public int minHeight = 0;
        public int maxHeight = 0;
        public int viewPaddingTop = 0;
        public int viewPaddingRight = 0;
        public int viewPaddingBottom = 0;
        public int viewPaddingLeft = 0;
        public int viewInsetTop = 0;
        public int viewInsetRight = 0;
        public int viewInsetBottom = 0;
        public int viewInsetLeft = 0;
        public int systemGestureInsetTop = 0;
        public int systemGestureInsetRight = 0;
        public int systemGestureInsetBottom = 0;
        public int systemGestureInsetLeft = 0;
        public int physicalTouchSlop = -1;
        private final List<DisplayFeature> displayFeatures = new ArrayList<DisplayFeature>();
        private final List<DisplayFeature> displayCutouts = new ArrayList<DisplayFeature>();

        boolean validate() {
            if (this.width == 0) {
                Log.d(FlutterRenderer.TAG, "Width is zero. " + this.minWidth + "," + this.maxWidth);
                return this.minWidth > 0 || this.maxWidth > 0;
            }
            if (this.height == 0) {
                Log.d(FlutterRenderer.TAG, "Height is zero. " + this.minHeight + "," + this.maxHeight);
                return this.minHeight > 0 || this.maxHeight > 0;
            }
            return this.width > 0 && this.height > 0 && this.devicePixelRatio > 0.0f;
        }

        public List<DisplayFeature> getDisplayFeatures() {
            return this.displayFeatures;
        }

        public List<DisplayFeature> getDisplayCutouts() {
            return this.displayCutouts;
        }

        public void setDisplayFeatures(List<DisplayFeature> newFeatures) {
            this.displayFeatures.clear();
            this.displayFeatures.addAll(newFeatures);
        }

        public void setDisplayCutouts(List<DisplayFeature> newCutouts) {
            this.displayCutouts.clear();
            this.displayCutouts.addAll(newCutouts);
        }
    }

    public static final class DisplayFeature {
        public final Rect bounds;
        public final DisplayFeatureType type;
        public final DisplayFeatureState state;

        public DisplayFeature(Rect bounds, DisplayFeatureType type, DisplayFeatureState state) {
            this.bounds = bounds;
            this.type = type;
            this.state = state;
        }
    }

    public static enum DisplayFeatureType {
        UNKNOWN(0),
        FOLD(1),
        HINGE(2),
        CUTOUT(3);

        public final int encodedValue;

        private DisplayFeatureType(int encodedValue) {
            this.encodedValue = encodedValue;
        }
    }

    public static enum DisplayFeatureState {
        UNKNOWN(0),
        POSTURE_FLAT(1),
        POSTURE_HALF_OPENED(2);

        public final int encodedValue;

        private DisplayFeatureState(int encodedValue) {
            this.encodedValue = encodedValue;
        }
    }

    static final class TextureFinalizerRunnable
    implements Runnable {
        private final long id;
        private final FlutterJNI flutterJNI;

        TextureFinalizerRunnable(long id2, @NonNull FlutterJNI flutterJNI) {
            this.id = id2;
            this.flutterJNI = flutterJNI;
        }

        @Override
        public void run() {
            if (!this.flutterJNI.isAttached()) {
                return;
            }
            Log.v(FlutterRenderer.TAG, "Releasing a Texture (" + this.id + ").");
            this.flutterJNI.unregisterTexture(this.id);
        }
    }
}

