/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.image;

import android.graphics.BitmapFactory;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import io.flutter.Log;
import io.flutter.embedding.engine.image.Metadata;

@RequiresApi(value=28)
public class BitmapMetadataReader {
    private static final String TAG = "BitmapMetadataReader";

    static void read(byte[] bytes, @NonNull Metadata metadata) {
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
            metadata.mimeType = options.outMimeType;
            metadata.originalHeight = options.outHeight;
            metadata.originalWidth = options.outWidth;
        }
        catch (Exception e) {
            Log.e(TAG, "Failed to decode image for mime type", e);
        }
    }
}

