/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.image;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import androidx.annotation.RequiresApi;
import io.flutter.embedding.engine.image.ImageDecoderDefaultImpl;
import io.flutter.embedding.engine.image.ImageUtils;
import io.flutter.embedding.engine.image.Metadata;
import java.nio.ByteBuffer;

@RequiresApi(value=36)
class ImageDecoderHeifApi36Impl
extends ImageDecoderDefaultImpl {
    public ImageDecoderHeifApi36Impl() {
        super(null);
    }

    @Override
    public Bitmap decodeImage(ByteBuffer buffer, Metadata metadata) {
        Bitmap defaultBitmap = super.decodeImage(buffer, metadata);
        if (defaultBitmap != null) {
            return defaultBitmap;
        }
        return this.decodeImageFallback(buffer, metadata);
    }

    Bitmap decodeImageFallback(ByteBuffer buffer, Metadata metadata) {
        byte[] bytes = ImageUtils.getBytes(buffer);
        BitmapFactory.Options decodeOptions = new BitmapFactory.Options();
        decodeOptions.inPreferredConfig = Bitmap.Config.ARGB_8888;
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)decodeOptions);
        if (metadata.rotation != 0) {
            Matrix matrix = new Matrix();
            matrix.postRotate((float)metadata.rotation);
            Bitmap rotatedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            bitmap.recycle();
            return ImageUtils.applyFlipIfNeeded(rotatedBitmap, metadata.orientation);
        }
        return ImageUtils.applyFlipIfNeeded(bitmap, metadata.orientation);
    }
}

