/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.MutableContextWrapper;
import android.os.Build;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.android.AndroidTouchProcessor;
import io.flutter.embedding.android.FlutterImageView;
import io.flutter.embedding.android.FlutterView;
import io.flutter.embedding.android.MotionEventTracker;
import io.flutter.embedding.engine.FlutterOverlaySurface;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.mutatorsstack.FlutterMutatorView;
import io.flutter.embedding.engine.mutatorsstack.FlutterMutatorsStack;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.embedding.engine.systemchannels.PlatformViewsChannel;
import io.flutter.plugin.editing.TextInputPlugin;
import io.flutter.plugin.platform.AccessibilityEventsDelegate;
import io.flutter.plugin.platform.PlatformView;
import io.flutter.plugin.platform.PlatformViewFactory;
import io.flutter.plugin.platform.PlatformViewRegistry;
import io.flutter.plugin.platform.PlatformViewRegistryImpl;
import io.flutter.plugin.platform.PlatformViewWrapper;
import io.flutter.plugin.platform.PlatformViewsAccessibilityDelegate;
import io.flutter.plugin.platform.VirtualDisplayController;
import io.flutter.util.ViewUtils;
import io.flutter.view.AccessibilityBridge;
import io.flutter.view.TextureRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class PlatformViewsController
implements PlatformViewsAccessibilityDelegate {
    private static final String TAG = "PlatformViewsController";
    private static Class[] VIEW_TYPES_REQUIRE_VIRTUAL_DISPLAY = new Class[]{SurfaceView.class};
    private final PlatformViewRegistryImpl registry;
    private AndroidTouchProcessor androidTouchProcessor;
    private Context context;
    private FlutterView flutterView;
    @Nullable
    private TextureRegistry textureRegistry;
    @Nullable
    private TextInputPlugin textInputPlugin;
    private PlatformViewsChannel platformViewsChannel;
    private final AccessibilityEventsDelegate accessibilityEventsDelegate;
    @VisibleForTesting
    final HashMap<Integer, VirtualDisplayController> vdControllers;
    @VisibleForTesting
    final HashMap<Context, View> contextToEmbeddedView;
    private final SparseArray<PlatformView> platformViews;
    private final SparseArray<FlutterMutatorView> platformViewParent;
    private final SparseArray<FlutterImageView> overlayLayerViews;
    private final SparseArray<PlatformViewWrapper> viewWrappers;
    private int nextOverlayLayerId = 0;
    private boolean flutterViewConvertedToImageView = false;
    private boolean synchronizeToNativeViewHierarchy = true;
    private final HashSet<Integer> currentFrameUsedOverlayLayerIds;
    private final HashSet<Integer> currentFrameUsedPlatformViewIds;
    private final MotionEventTracker motionEventTracker;
    private boolean usesSoftwareRendering = false;
    private final PlatformViewsChannel.PlatformViewsHandler channelHandler = new PlatformViewsChannel.PlatformViewsHandler(){

        @Override
        @TargetApi(value=19)
        public void createForPlatformViewLayer(@NonNull PlatformViewsChannel.PlatformViewCreationRequest request) {
            this.ensureValidAndroidVersion(19);
            int viewId = request.viewId;
            if (!PlatformViewsController.validateDirection(request.direction)) {
                throw new IllegalStateException("Trying to create a view with unknown direction value: " + request.direction + "(view id: " + viewId + ")");
            }
            PlatformViewFactory factory = PlatformViewsController.this.registry.getFactory(request.viewType);
            if (factory == null) {
                throw new IllegalStateException("Trying to create a platform view of unregistered type: " + request.viewType);
            }
            Object createParams = null;
            if (request.params != null) {
                createParams = factory.getCreateArgsCodec().decodeMessage(request.params);
            }
            PlatformView platformView = factory.create(PlatformViewsController.this.context, viewId, createParams);
            platformView.getView().setLayoutDirection(request.direction);
            PlatformViewsController.this.platformViews.put(viewId, (Object)platformView);
            Log.i(PlatformViewsController.TAG, "Using hybrid composition for platform view: " + viewId);
        }

        @Override
        @TargetApi(value=20)
        public long createForTextureLayer(@NonNull PlatformViewsChannel.PlatformViewCreationRequest request) {
            long txId;
            PlatformViewWrapper viewWrapper;
            boolean shouldUseVirtualDisplay;
            int viewId = request.viewId;
            if (PlatformViewsController.this.viewWrappers.get(viewId) != null) {
                throw new IllegalStateException("Trying to create an already created platform view, view id: " + viewId);
            }
            if (!PlatformViewsController.validateDirection(request.direction)) {
                throw new IllegalStateException("Trying to create a view with unknown direction value: " + request.direction + "(view id: " + viewId + ")");
            }
            if (PlatformViewsController.this.textureRegistry == null) {
                throw new IllegalStateException("Texture registry is null. This means that platform views controller was detached, view id: " + viewId);
            }
            if (PlatformViewsController.this.flutterView == null) {
                throw new IllegalStateException("Flutter view is null. This means the platform views controller doesn't have an attached view, view id: " + viewId);
            }
            PlatformViewFactory viewFactory = PlatformViewsController.this.registry.getFactory(request.viewType);
            if (viewFactory == null) {
                throw new IllegalStateException("Trying to create a platform view of unregistered type: " + request.viewType);
            }
            Object createParams = null;
            if (request.params != null) {
                createParams = viewFactory.getCreateArgsCodec().decodeMessage(request.params);
            }
            MutableContextWrapper embeddedViewContext = new MutableContextWrapper(PlatformViewsController.this.context);
            PlatformView platformView = viewFactory.create((Context)embeddedViewContext, viewId, createParams);
            PlatformViewsController.this.platformViews.put(viewId, (Object)platformView);
            View embeddedView = platformView.getView();
            if (embeddedView == null) {
                throw new IllegalStateException("PlatformView#getView() returned null, but an Android view reference was expected.");
            }
            if (embeddedView.getParent() != null) {
                throw new IllegalStateException("The Android view returned from PlatformView#getView() was already added to a parent view.");
            }
            embeddedView.setLayoutDirection(request.direction);
            int physicalWidth = PlatformViewsController.this.toPhysicalPixels(request.logicalWidth);
            int physicalHeight = PlatformViewsController.this.toPhysicalPixels(request.logicalHeight);
            boolean bl = shouldUseVirtualDisplay = ViewUtils.hasChildViewOfType(embeddedView, VIEW_TYPES_REQUIRE_VIRTUAL_DISPLAY) || Build.VERSION.SDK_INT < 23;
            if (!PlatformViewsController.this.usesSoftwareRendering && shouldUseVirtualDisplay) {
                Log.i(PlatformViewsController.TAG, "Hosting view in a virtual display for platform view: " + viewId);
                this.ensureValidAndroidVersion(20);
                TextureRegistry.SurfaceTextureEntry textureEntry = PlatformViewsController.this.textureRegistry.createSurfaceTexture();
                VirtualDisplayController vdController = VirtualDisplayController.create(PlatformViewsController.this.context, PlatformViewsController.this.accessibilityEventsDelegate, platformView, textureEntry, physicalWidth, physicalHeight, request.viewId, createParams, (view, hasFocus) -> {
                    if (hasFocus) {
                        PlatformViewsController.this.platformViewsChannel.invokeViewFocused(request.viewId);
                    }
                });
                if (vdController == null) {
                    throw new IllegalStateException("Failed creating virtual display for a " + request.viewType + " with id: " + request.viewId);
                }
                if (PlatformViewsController.this.flutterView != null) {
                    vdController.onFlutterViewAttached((View)PlatformViewsController.this.flutterView);
                }
                PlatformViewsController.this.vdControllers.put(request.viewId, vdController);
                PlatformViewsController.this.contextToEmbeddedView.put(embeddedView.getContext(), embeddedView);
                return textureEntry.id();
            }
            this.ensureValidAndroidVersion(23);
            Log.i(PlatformViewsController.TAG, "Hosting view in view hierarchy for platform view: " + viewId);
            if (PlatformViewsController.this.usesSoftwareRendering) {
                viewWrapper = new PlatformViewWrapper(PlatformViewsController.this.context);
                txId = -1L;
            } else {
                TextureRegistry.SurfaceTextureEntry textureEntry = PlatformViewsController.this.textureRegistry.createSurfaceTexture();
                viewWrapper = new PlatformViewWrapper(PlatformViewsController.this.context, textureEntry);
                txId = textureEntry.id();
            }
            viewWrapper.setTouchProcessor(PlatformViewsController.this.androidTouchProcessor);
            viewWrapper.setBufferSize(physicalWidth, physicalHeight);
            FrameLayout.LayoutParams viewWrapperLayoutParams = new FrameLayout.LayoutParams(physicalWidth, physicalHeight);
            int physicalTop = PlatformViewsController.this.toPhysicalPixels(request.logicalTop);
            int physicalLeft = PlatformViewsController.this.toPhysicalPixels(request.logicalLeft);
            viewWrapperLayoutParams.topMargin = physicalTop;
            viewWrapperLayoutParams.leftMargin = physicalLeft;
            viewWrapper.setLayoutParams(viewWrapperLayoutParams);
            embeddedView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(physicalWidth, physicalHeight));
            embeddedView.setImportantForAccessibility(4);
            viewWrapper.addView(embeddedView);
            viewWrapper.setOnDescendantFocusChangeListener((v, hasFocus) -> {
                if (hasFocus) {
                    PlatformViewsController.this.platformViewsChannel.invokeViewFocused(viewId);
                } else if (PlatformViewsController.this.textInputPlugin != null) {
                    PlatformViewsController.this.textInputPlugin.clearPlatformViewClient(viewId);
                }
            });
            PlatformViewsController.this.flutterView.addView((View)viewWrapper);
            PlatformViewsController.this.viewWrappers.append(viewId, (Object)viewWrapper);
            return txId;
        }

        @Override
        public void dispose(int viewId) {
            PlatformView platformView = (PlatformView)PlatformViewsController.this.platformViews.get(viewId);
            if (platformView == null) {
                Log.e(PlatformViewsController.TAG, "Disposing unknown platform view with id: " + viewId);
                return;
            }
            PlatformViewsController.this.platformViews.remove(viewId);
            try {
                platformView.dispose();
            }
            catch (RuntimeException exception) {
                Log.e(PlatformViewsController.TAG, "Disposing platform view threw an exception", exception);
            }
            if (PlatformViewsController.this.usesVirtualDisplay(viewId)) {
                VirtualDisplayController vdController = PlatformViewsController.this.vdControllers.get(viewId);
                View embeddedView = vdController.getView();
                if (embeddedView != null) {
                    PlatformViewsController.this.contextToEmbeddedView.remove(embeddedView.getContext());
                }
                PlatformViewsController.this.vdControllers.remove(viewId);
                return;
            }
            PlatformViewWrapper viewWrapper = (PlatformViewWrapper)((Object)PlatformViewsController.this.viewWrappers.get(viewId));
            if (viewWrapper != null) {
                viewWrapper.removeAllViews();
                viewWrapper.release();
                viewWrapper.unsetOnDescendantFocusChangeListener();
                ViewGroup wrapperParent = (ViewGroup)viewWrapper.getParent();
                if (wrapperParent != null) {
                    wrapperParent.removeView((View)viewWrapper);
                }
                PlatformViewsController.this.viewWrappers.remove(viewId);
                return;
            }
            FlutterMutatorView parentView = (FlutterMutatorView)((Object)PlatformViewsController.this.platformViewParent.get(viewId));
            if (parentView != null) {
                parentView.removeAllViews();
                parentView.unsetOnDescendantFocusChangeListener();
                ViewGroup mutatorViewParent = (ViewGroup)parentView.getParent();
                if (mutatorViewParent != null) {
                    mutatorViewParent.removeView((View)parentView);
                }
                PlatformViewsController.this.platformViewParent.remove(viewId);
            }
        }

        @Override
        public void offset(int viewId, double top, double left) {
            if (PlatformViewsController.this.usesVirtualDisplay(viewId)) {
                return;
            }
            PlatformViewWrapper viewWrapper = (PlatformViewWrapper)((Object)PlatformViewsController.this.viewWrappers.get(viewId));
            if (viewWrapper == null) {
                Log.e(PlatformViewsController.TAG, "Setting offset for unknown platform view with id: " + viewId);
                return;
            }
            int physicalTop = PlatformViewsController.this.toPhysicalPixels(top);
            int physicalLeft = PlatformViewsController.this.toPhysicalPixels(left);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)viewWrapper.getLayoutParams();
            layoutParams.topMargin = physicalTop;
            layoutParams.leftMargin = physicalLeft;
            viewWrapper.setLayoutParams(layoutParams);
        }

        @Override
        public void resize(@NonNull PlatformViewsChannel.PlatformViewResizeRequest request, @NonNull PlatformViewsChannel.PlatformViewBufferResized onComplete) {
            int physicalWidth = PlatformViewsController.this.toPhysicalPixels(request.newLogicalWidth);
            int physicalHeight = PlatformViewsController.this.toPhysicalPixels(request.newLogicalHeight);
            int viewId = request.viewId;
            if (PlatformViewsController.this.usesVirtualDisplay(viewId)) {
                VirtualDisplayController vdController = PlatformViewsController.this.vdControllers.get(viewId);
                PlatformViewsController.this.lockInputConnection(vdController);
                vdController.resize(physicalWidth, physicalHeight, () -> {
                    PlatformViewsController.this.unlockInputConnection(vdController);
                    onComplete.run(new PlatformViewsChannel.PlatformViewBufferSize(PlatformViewsController.this.toLogicalPixels(vdController.getBufferWidth()), PlatformViewsController.this.toLogicalPixels(vdController.getBufferHeight())));
                });
                return;
            }
            PlatformView platformView = (PlatformView)PlatformViewsController.this.platformViews.get(viewId);
            PlatformViewWrapper viewWrapper = (PlatformViewWrapper)((Object)PlatformViewsController.this.viewWrappers.get(viewId));
            if (platformView == null || viewWrapper == null) {
                Log.e(PlatformViewsController.TAG, "Resizing unknown platform view with id: " + viewId);
                return;
            }
            if (physicalWidth > viewWrapper.getBufferWidth() || physicalHeight > viewWrapper.getBufferHeight()) {
                viewWrapper.setBufferSize(physicalWidth, physicalHeight);
            }
            ViewGroup.LayoutParams viewWrapperLayoutParams = viewWrapper.getLayoutParams();
            viewWrapperLayoutParams.width = physicalWidth;
            viewWrapperLayoutParams.height = physicalHeight;
            viewWrapper.setLayoutParams(viewWrapperLayoutParams);
            View embeddedView = platformView.getView();
            if (embeddedView != null) {
                ViewGroup.LayoutParams embeddedViewLayoutParams = embeddedView.getLayoutParams();
                embeddedViewLayoutParams.width = physicalWidth;
                embeddedViewLayoutParams.height = physicalHeight;
                embeddedView.setLayoutParams(embeddedViewLayoutParams);
            }
            onComplete.run(new PlatformViewsChannel.PlatformViewBufferSize(PlatformViewsController.this.toLogicalPixels(viewWrapper.getBufferWidth()), PlatformViewsController.this.toLogicalPixels(viewWrapper.getBufferHeight())));
        }

        @Override
        public void onTouch(@NonNull PlatformViewsChannel.PlatformViewTouch touch) {
            int viewId = touch.viewId;
            float density = ((PlatformViewsController)PlatformViewsController.this).context.getResources().getDisplayMetrics().density;
            if (PlatformViewsController.this.usesVirtualDisplay(viewId)) {
                VirtualDisplayController vdController = PlatformViewsController.this.vdControllers.get(viewId);
                MotionEvent event = PlatformViewsController.this.toMotionEvent(density, touch, true);
                vdController.dispatchTouchEvent(event);
                return;
            }
            PlatformView platformView = (PlatformView)PlatformViewsController.this.platformViews.get(viewId);
            if (platformView == null) {
                Log.e(PlatformViewsController.TAG, "Sending touch to an unknown view with id: " + viewId);
                return;
            }
            View view = platformView.getView();
            if (view == null) {
                Log.e(PlatformViewsController.TAG, "Sending touch to a null view with id: " + viewId);
                return;
            }
            MotionEvent event = PlatformViewsController.this.toMotionEvent(density, touch, false);
            view.dispatchTouchEvent(event);
        }

        @Override
        @TargetApi(value=17)
        public void setDirection(int viewId, int direction) {
            View embeddedView;
            if (!PlatformViewsController.validateDirection(direction)) {
                throw new IllegalStateException("Trying to set unknown direction value: " + direction + "(view id: " + viewId + ")");
            }
            if (PlatformViewsController.this.usesVirtualDisplay(viewId)) {
                VirtualDisplayController controller = PlatformViewsController.this.vdControllers.get(viewId);
                embeddedView = controller.getView();
            } else {
                PlatformView platformView = (PlatformView)PlatformViewsController.this.platformViews.get(viewId);
                if (platformView == null) {
                    Log.e(PlatformViewsController.TAG, "Setting direction to an unknown view with id: " + viewId);
                    return;
                }
                embeddedView = platformView.getView();
            }
            if (embeddedView == null) {
                Log.e(PlatformViewsController.TAG, "Setting direction to a null view with id: " + viewId);
                return;
            }
            embeddedView.setLayoutDirection(direction);
        }

        @Override
        public void clearFocus(int viewId) {
            View embeddedView;
            if (PlatformViewsController.this.usesVirtualDisplay(viewId)) {
                VirtualDisplayController controller = PlatformViewsController.this.vdControllers.get(viewId);
                embeddedView = controller.getView();
            } else {
                PlatformView platformView = (PlatformView)PlatformViewsController.this.platformViews.get(viewId);
                if (platformView == null) {
                    Log.e(PlatformViewsController.TAG, "Clearing focus on an unknown view with id: " + viewId);
                    return;
                }
                embeddedView = platformView.getView();
            }
            if (embeddedView == null) {
                Log.e(PlatformViewsController.TAG, "Clearing focus on a null view with id: " + viewId);
                return;
            }
            embeddedView.clearFocus();
        }

        private void ensureValidAndroidVersion(int minSdkVersion) {
            if (Build.VERSION.SDK_INT < minSdkVersion) {
                throw new IllegalStateException("Trying to use platform views with API " + Build.VERSION.SDK_INT + ", required API level is: " + minSdkVersion);
            }
        }

        @Override
        public void synchronizeToNativeViewHierarchy(boolean yes) {
            PlatformViewsController.this.synchronizeToNativeViewHierarchy = yes;
        }
    };

    @VisibleForTesting
    public MotionEvent toMotionEvent(float density, PlatformViewsChannel.PlatformViewTouch touch, boolean usingVirtualDiplay) {
        MotionEventTracker.MotionEventId motionEventId = MotionEventTracker.MotionEventId.from(touch.motionEventId);
        MotionEvent trackedEvent = this.motionEventTracker.pop(motionEventId);
        MotionEvent.PointerProperties[] pointerProperties = PlatformViewsController.parsePointerPropertiesList(touch.rawPointerPropertiesList).toArray(new MotionEvent.PointerProperties[touch.pointerCount]);
        MotionEvent.PointerCoords[] pointerCoords = PlatformViewsController.parsePointerCoordsList(touch.rawPointerCoords, density).toArray(new MotionEvent.PointerCoords[touch.pointerCount]);
        if (!usingVirtualDiplay && trackedEvent != null) {
            return MotionEvent.obtain((long)trackedEvent.getDownTime(), (long)trackedEvent.getEventTime(), (int)trackedEvent.getAction(), (int)touch.pointerCount, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)trackedEvent.getMetaState(), (int)trackedEvent.getButtonState(), (float)trackedEvent.getXPrecision(), (float)trackedEvent.getYPrecision(), (int)trackedEvent.getDeviceId(), (int)trackedEvent.getEdgeFlags(), (int)trackedEvent.getSource(), (int)trackedEvent.getFlags());
        }
        return MotionEvent.obtain((long)touch.downTime.longValue(), (long)touch.eventTime.longValue(), (int)touch.action, (int)touch.pointerCount, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)touch.metaState, (int)touch.buttonState, (float)touch.xPrecision, (float)touch.yPrecision, (int)touch.deviceId, (int)touch.edgeFlags, (int)touch.source, (int)touch.flags);
    }

    public PlatformViewsController() {
        this.registry = new PlatformViewRegistryImpl();
        this.vdControllers = new HashMap();
        this.accessibilityEventsDelegate = new AccessibilityEventsDelegate();
        this.contextToEmbeddedView = new HashMap();
        this.overlayLayerViews = new SparseArray();
        this.currentFrameUsedOverlayLayerIds = new HashSet();
        this.currentFrameUsedPlatformViewIds = new HashSet();
        this.viewWrappers = new SparseArray();
        this.platformViews = new SparseArray();
        this.platformViewParent = new SparseArray();
        this.motionEventTracker = MotionEventTracker.getInstance();
    }

    public void attach(@Nullable Context context, @NonNull TextureRegistry textureRegistry, @NonNull DartExecutor dartExecutor) {
        if (this.context != null) {
            throw new AssertionError((Object)"A PlatformViewsController can only be attached to a single output target.\nattach was called while the PlatformViewsController was already attached.");
        }
        this.context = context;
        this.textureRegistry = textureRegistry;
        this.platformViewsChannel = new PlatformViewsChannel(dartExecutor);
        this.platformViewsChannel.setPlatformViewsHandler(this.channelHandler);
    }

    public void setSoftwareRendering(boolean useSoftwareRendering) {
        this.usesSoftwareRendering = useSoftwareRendering;
    }

    @UiThread
    public void detach() {
        if (this.platformViewsChannel != null) {
            this.platformViewsChannel.setPlatformViewsHandler(null);
        }
        this.destroyOverlaySurfaces();
        this.platformViewsChannel = null;
        this.context = null;
        this.textureRegistry = null;
    }

    public void attachToView(@NonNull FlutterView newFlutterView) {
        Object view;
        int index;
        this.flutterView = newFlutterView;
        for (index = 0; index < this.viewWrappers.size(); ++index) {
            view = (PlatformViewWrapper)((Object)this.viewWrappers.valueAt(index));
            this.flutterView.addView((View)view);
        }
        for (index = 0; index < this.platformViewParent.size(); ++index) {
            view = (FlutterMutatorView)((Object)this.platformViewParent.valueAt(index));
            this.flutterView.addView((View)view);
        }
        for (index = 0; index < this.platformViews.size(); ++index) {
            view = (PlatformView)this.platformViews.valueAt(index);
            view.onFlutterViewAttached((View)this.flutterView);
        }
    }

    public void detachFromView() {
        Object view;
        int index;
        for (index = 0; index < this.viewWrappers.size(); ++index) {
            view = (PlatformViewWrapper)((Object)this.viewWrappers.valueAt(index));
            this.flutterView.removeView((View)view);
        }
        for (index = 0; index < this.platformViewParent.size(); ++index) {
            view = (FlutterMutatorView)((Object)this.platformViewParent.valueAt(index));
            this.flutterView.removeView((View)view);
        }
        this.destroyOverlaySurfaces();
        this.removeOverlaySurfaces();
        this.flutterView = null;
        this.flutterViewConvertedToImageView = false;
        for (index = 0; index < this.platformViews.size(); ++index) {
            view = (PlatformView)this.platformViews.valueAt(index);
            view.onFlutterViewDetached();
        }
    }

    @Override
    public void attachAccessibilityBridge(@NonNull AccessibilityBridge accessibilityBridge) {
        this.accessibilityEventsDelegate.setAccessibilityBridge(accessibilityBridge);
    }

    @Override
    public void detachAccessibilityBridge() {
        this.accessibilityEventsDelegate.setAccessibilityBridge(null);
    }

    public void attachTextInputPlugin(@NonNull TextInputPlugin textInputPlugin) {
        this.textInputPlugin = textInputPlugin;
    }

    public void detachTextInputPlugin() {
        this.textInputPlugin = null;
    }

    public boolean checkInputConnectionProxy(@Nullable View view) {
        if (view == null) {
            return false;
        }
        if (!this.contextToEmbeddedView.containsKey(view.getContext())) {
            return false;
        }
        View platformView = this.contextToEmbeddedView.get(view.getContext());
        if (platformView == view) {
            return true;
        }
        return platformView.checkInputConnectionProxy(view);
    }

    public PlatformViewRegistry getRegistry() {
        return this.registry;
    }

    public void onAttachedToJNI() {
    }

    public void onDetachedFromJNI() {
        this.diposeAllViews();
    }

    public void onPreEngineRestart() {
        this.diposeAllViews();
    }

    @Override
    @Nullable
    public View getPlatformViewById(int viewId) {
        if (this.usesVirtualDisplay(viewId)) {
            VirtualDisplayController controller = this.vdControllers.get(viewId);
            return controller.getView();
        }
        PlatformView platformView = (PlatformView)this.platformViews.get(viewId);
        if (platformView == null) {
            return null;
        }
        return platformView.getView();
    }

    @Override
    public boolean usesVirtualDisplay(int id2) {
        return this.vdControllers.containsKey(id2);
    }

    private void lockInputConnection(@NonNull VirtualDisplayController controller) {
        if (this.textInputPlugin == null) {
            return;
        }
        this.textInputPlugin.lockPlatformViewInputConnection();
        controller.onInputConnectionLocked();
    }

    private void unlockInputConnection(@NonNull VirtualDisplayController controller) {
        if (this.textInputPlugin == null) {
            return;
        }
        this.textInputPlugin.unlockPlatformViewInputConnection();
        controller.onInputConnectionUnlocked();
    }

    private static boolean validateDirection(int direction) {
        return direction == 0 || direction == 1;
    }

    private static List<MotionEvent.PointerProperties> parsePointerPropertiesList(Object rawPropertiesList) {
        List rawProperties = (List)rawPropertiesList;
        ArrayList<MotionEvent.PointerProperties> pointerProperties = new ArrayList<MotionEvent.PointerProperties>();
        for (Object o : rawProperties) {
            pointerProperties.add(PlatformViewsController.parsePointerProperties(o));
        }
        return pointerProperties;
    }

    private static MotionEvent.PointerProperties parsePointerProperties(Object rawProperties) {
        List propertiesList = (List)rawProperties;
        MotionEvent.PointerProperties properties = new MotionEvent.PointerProperties();
        properties.id = (Integer)propertiesList.get(0);
        properties.toolType = (Integer)propertiesList.get(1);
        return properties;
    }

    private static List<MotionEvent.PointerCoords> parsePointerCoordsList(Object rawCoordsList, float density) {
        List rawCoords = (List)rawCoordsList;
        ArrayList<MotionEvent.PointerCoords> pointerCoords = new ArrayList<MotionEvent.PointerCoords>();
        for (Object o : rawCoords) {
            pointerCoords.add(PlatformViewsController.parsePointerCoords(o, density));
        }
        return pointerCoords;
    }

    private static MotionEvent.PointerCoords parsePointerCoords(Object rawCoords, float density) {
        List coordsList = (List)rawCoords;
        MotionEvent.PointerCoords coords = new MotionEvent.PointerCoords();
        coords.orientation = (float)((Double)coordsList.get(0)).doubleValue();
        coords.pressure = (float)((Double)coordsList.get(1)).doubleValue();
        coords.size = (float)((Double)coordsList.get(2)).doubleValue();
        coords.toolMajor = (float)((Double)coordsList.get(3)).doubleValue() * density;
        coords.toolMinor = (float)((Double)coordsList.get(4)).doubleValue() * density;
        coords.touchMajor = (float)((Double)coordsList.get(5)).doubleValue() * density;
        coords.touchMinor = (float)((Double)coordsList.get(6)).doubleValue() * density;
        coords.x = (float)((Double)coordsList.get(7)).doubleValue() * density;
        coords.y = (float)((Double)coordsList.get(8)).doubleValue() * density;
        return coords;
    }

    private float getDisplayDensity() {
        return this.context.getResources().getDisplayMetrics().density;
    }

    private int toPhysicalPixels(double logicalPixels) {
        return (int)Math.round(logicalPixels * (double)this.getDisplayDensity());
    }

    private int toLogicalPixels(double physicalPixels) {
        return (int)Math.round(physicalPixels / (double)this.getDisplayDensity());
    }

    private void diposeAllViews() {
        while (this.platformViews.size() > 0) {
            int viewId = this.platformViews.keyAt(0);
            this.channelHandler.dispose(viewId);
        }
    }

    private void initializeRootImageViewIfNeeded() {
        if (this.synchronizeToNativeViewHierarchy && !this.flutterViewConvertedToImageView) {
            this.flutterView.convertToImageView();
            this.flutterViewConvertedToImageView = true;
        }
    }

    @VisibleForTesting
    @TargetApi(value=19)
    void initializePlatformViewIfNeeded(int viewId) {
        PlatformView platformView = (PlatformView)this.platformViews.get(viewId);
        if (platformView == null) {
            throw new IllegalStateException("Platform view hasn't been initialized from the platform view channel.");
        }
        if (this.platformViewParent.get(viewId) != null) {
            return;
        }
        View embeddedView = platformView.getView();
        if (embeddedView == null) {
            throw new IllegalStateException("PlatformView#getView() returned null, but an Android view reference was expected.");
        }
        if (embeddedView.getParent() != null) {
            throw new IllegalStateException("The Android view returned from PlatformView#getView() was already added to a parent view.");
        }
        FlutterMutatorView parentView = new FlutterMutatorView(this.context, this.context.getResources().getDisplayMetrics().density, this.androidTouchProcessor);
        parentView.setOnDescendantFocusChangeListener((view, hasFocus) -> {
            if (hasFocus) {
                this.platformViewsChannel.invokeViewFocused(viewId);
            } else if (this.textInputPlugin != null) {
                this.textInputPlugin.clearPlatformViewClient(viewId);
            }
        });
        this.platformViewParent.put(viewId, (Object)parentView);
        embeddedView.setImportantForAccessibility(4);
        parentView.addView(embeddedView);
        this.flutterView.addView((View)parentView);
    }

    public void attachToFlutterRenderer(@NonNull FlutterRenderer flutterRenderer) {
        this.androidTouchProcessor = new AndroidTouchProcessor(flutterRenderer, true);
    }

    public void onDisplayPlatformView(int viewId, int x, int y, int width, int height, int viewWidth, int viewHeight, @NonNull FlutterMutatorsStack mutatorsStack) {
        this.initializeRootImageViewIfNeeded();
        this.initializePlatformViewIfNeeded(viewId);
        FlutterMutatorView parentView = (FlutterMutatorView)((Object)this.platformViewParent.get(viewId));
        parentView.readyToDisplay(mutatorsStack, x, y, width, height);
        parentView.setVisibility(0);
        parentView.bringToFront();
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(viewWidth, viewHeight);
        View view = ((PlatformView)this.platformViews.get(viewId)).getView();
        if (view != null) {
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            view.bringToFront();
        }
        this.currentFrameUsedPlatformViewIds.add(viewId);
    }

    public void onDisplayOverlaySurface(int id2, int x, int y, int width, int height) {
        if (this.overlayLayerViews.get(id2) == null) {
            throw new IllegalStateException("The overlay surface (id:" + id2 + ") doesn't exist");
        }
        this.initializeRootImageViewIfNeeded();
        FlutterImageView overlayView = (FlutterImageView)this.overlayLayerViews.get(id2);
        if (overlayView.getParent() == null) {
            this.flutterView.addView(overlayView);
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(width, height);
        layoutParams.leftMargin = x;
        layoutParams.topMargin = y;
        overlayView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        overlayView.setVisibility(0);
        overlayView.bringToFront();
        this.currentFrameUsedOverlayLayerIds.add(id2);
    }

    public void onBeginFrame() {
        this.currentFrameUsedOverlayLayerIds.clear();
        this.currentFrameUsedPlatformViewIds.clear();
    }

    public void onEndFrame() {
        if (this.flutterViewConvertedToImageView && this.currentFrameUsedPlatformViewIds.isEmpty()) {
            this.flutterViewConvertedToImageView = false;
            this.flutterView.revertImageView(() -> this.finishFrame(false));
            return;
        }
        boolean isFrameRenderedUsingImageReaders = this.flutterViewConvertedToImageView && this.flutterView.acquireLatestImageViewFrame();
        this.finishFrame(isFrameRenderedUsingImageReaders);
    }

    private void finishFrame(boolean isFrameRenderedUsingImageReaders) {
        int i;
        for (i = 0; i < this.overlayLayerViews.size(); ++i) {
            int overlayId = this.overlayLayerViews.keyAt(i);
            FlutterImageView overlayView = (FlutterImageView)this.overlayLayerViews.valueAt(i);
            if (this.currentFrameUsedOverlayLayerIds.contains(overlayId)) {
                this.flutterView.attachOverlaySurfaceToRender(overlayView);
                boolean didAcquireOverlaySurfaceImage = overlayView.acquireLatestImage();
                isFrameRenderedUsingImageReaders &= didAcquireOverlaySurfaceImage;
                continue;
            }
            if (!this.flutterViewConvertedToImageView) {
                overlayView.detachFromRenderer();
            }
            overlayView.setVisibility(8);
        }
        for (i = 0; i < this.platformViewParent.size(); ++i) {
            int viewId = this.platformViewParent.keyAt(i);
            View parentView = (View)this.platformViewParent.get(viewId);
            if (this.currentFrameUsedPlatformViewIds.contains(viewId) && (isFrameRenderedUsingImageReaders || !this.synchronizeToNativeViewHierarchy)) {
                parentView.setVisibility(0);
                continue;
            }
            parentView.setVisibility(8);
        }
    }

    @VisibleForTesting
    @TargetApi(value=19)
    @NonNull
    public FlutterOverlaySurface createOverlaySurface(@NonNull FlutterImageView imageView) {
        int id2 = this.nextOverlayLayerId++;
        this.overlayLayerViews.put(id2, (Object)imageView);
        return new FlutterOverlaySurface(id2, imageView.getSurface());
    }

    @TargetApi(value=19)
    @NonNull
    public FlutterOverlaySurface createOverlaySurface() {
        return this.createOverlaySurface(new FlutterImageView(this.flutterView.getContext(), this.flutterView.getWidth(), this.flutterView.getHeight(), FlutterImageView.SurfaceKind.overlay));
    }

    public void destroyOverlaySurfaces() {
        for (int viewId = 0; viewId < this.overlayLayerViews.size(); ++viewId) {
            FlutterImageView overlayView = (FlutterImageView)this.overlayLayerViews.valueAt(viewId);
            overlayView.detachFromRenderer();
            overlayView.closeImageReader();
        }
    }

    private void removeOverlaySurfaces() {
        if (this.flutterView == null) {
            Log.e(TAG, "removeOverlaySurfaces called while flutter view is null");
            return;
        }
        for (int viewId = 0; viewId < this.overlayLayerViews.size(); ++viewId) {
            this.flutterView.removeView((View)this.overlayLayerViews.valueAt(viewId));
        }
        this.overlayLayerViews.clear();
    }
}

