/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.editing;

import android.view.textservice.SentenceSuggestionsInfo;
import android.view.textservice.SpellCheckerSession;
import android.view.textservice.SuggestionsInfo;
import android.view.textservice.TextInfo;
import android.view.textservice.TextServicesManager;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import io.flutter.embedding.engine.systemchannels.SpellCheckChannel;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.localization.LocalizationPlugin;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class SpellCheckPlugin
implements SpellCheckChannel.SpellCheckMethodHandler,
SpellCheckerSession.SpellCheckerSessionListener {
    private final SpellCheckChannel mSpellCheckChannel;
    private final TextServicesManager mTextServicesManager;
    private SpellCheckerSession mSpellCheckerSession;
    public static final String START_INDEX_KEY = "startIndex";
    public static final String END_INDEX_KEY = "endIndex";
    public static final String SUGGESTIONS_KEY = "suggestions";
    @VisibleForTesting
    MethodChannel.Result pendingResult;
    private static final int MAX_SPELL_CHECK_SUGGESTIONS = 5;

    public SpellCheckPlugin(@NonNull TextServicesManager textServicesManager, @NonNull SpellCheckChannel spellCheckChannel) {
        this.mTextServicesManager = textServicesManager;
        this.mSpellCheckChannel = spellCheckChannel;
        this.mSpellCheckChannel.setSpellCheckMethodHandler(this);
    }

    public void destroy() {
        this.mSpellCheckChannel.setSpellCheckMethodHandler(null);
        if (this.mSpellCheckerSession != null) {
            this.mSpellCheckerSession.close();
        }
    }

    @Override
    public void initiateSpellCheck(@NonNull String locale, @NonNull String text, @NonNull MethodChannel.Result result) {
        if (this.pendingResult != null) {
            result.error("error", "Previous spell check request still pending.", null);
            return;
        }
        this.pendingResult = result;
        this.performSpellCheck(locale, text);
    }

    public void performSpellCheck(@NonNull String locale, @NonNull String text) {
        String[] localeCodes = locale.split("-");
        Locale localeFromString = LocalizationPlugin.localeFromString(locale);
        if (this.mSpellCheckerSession == null) {
            this.mSpellCheckerSession = this.mTextServicesManager.newSpellCheckerSession(null, localeFromString, (SpellCheckerSession.SpellCheckerSessionListener)this, true);
        }
        TextInfo[] textInfos = new TextInfo[]{new TextInfo(text)};
        this.mSpellCheckerSession.getSentenceSuggestions(textInfos, 5);
    }

    public void onGetSentenceSuggestions(SentenceSuggestionsInfo[] results) {
        if (results.length == 0) {
            this.pendingResult.success(new ArrayList());
            this.pendingResult = null;
            return;
        }
        ArrayList spellCheckerSuggestionSpans = new ArrayList();
        SentenceSuggestionsInfo spellCheckResults = results[0];
        for (int i = 0; i < spellCheckResults.getSuggestionsCount(); ++i) {
            SuggestionsInfo suggestionsInfo = spellCheckResults.getSuggestionsInfoAt(i);
            int suggestionsCount = suggestionsInfo.getSuggestionsCount();
            if (suggestionsCount <= 0) continue;
            HashMap<String, Serializable> spellCheckerSuggestionSpan = new HashMap<String, Serializable>();
            int start = spellCheckResults.getOffsetAt(i);
            int end = start + spellCheckResults.getLengthAt(i);
            spellCheckerSuggestionSpan.put(START_INDEX_KEY, Integer.valueOf(start));
            spellCheckerSuggestionSpan.put(END_INDEX_KEY, Integer.valueOf(end));
            ArrayList<String> suggestions = new ArrayList<String>();
            for (int j = 0; j < suggestionsCount; ++j) {
                suggestions.add(suggestionsInfo.getSuggestionAt(j));
            }
            spellCheckerSuggestionSpan.put(SUGGESTIONS_KEY, suggestions);
            spellCheckerSuggestionSpans.add(spellCheckerSuggestionSpan);
        }
        this.pendingResult.success(spellCheckerSuggestionSpans);
        this.pendingResult = null;
    }

    public void onGetSuggestions(SuggestionsInfo[] results) {
    }
}

