/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.view.Window;
import android.view.WindowInsets;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.util.ViewUtils;
import java.util.Collections;
import java.util.List;

public class FlutterViewDelegate {
    @VisibleForTesting
    public WindowInsets getWindowInsets(Context context) {
        Activity activity = ViewUtils.getActivity(context);
        if (activity == null) {
            return null;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return null;
        }
        return window.getDecorView().getRootWindowInsets();
    }

    @RequiresApi(api=35)
    public List<Rect> getCaptionBarInsets(Context context) {
        WindowInsets insets = this.getWindowInsets(context);
        if (insets == null) {
            return Collections.emptyList();
        }
        return insets.getBoundingRects(WindowInsets.Type.captionBar());
    }

    @RequiresApi(api=35)
    public void growViewportMetricsToCaptionBar(Context context, FlutterRenderer.ViewportMetrics viewportMetrics) {
        List<Rect> boundingRects = this.getCaptionBarInsets(context);
        int viewPaddingTop = viewportMetrics.viewPaddingTop;
        for (Rect rect : boundingRects) {
            viewPaddingTop = Math.max(viewPaddingTop, rect.bottom);
        }
        viewportMetrics.viewPaddingTop = viewPaddingTop;
    }
}

