/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.view;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.os.Build;
import android.view.View;
import androidx.annotation.NonNull;
import io.flutter.embedding.engine.systemchannels.SensitiveContentChannel;

public class SensitiveContentPlugin
implements SensitiveContentChannel.SensitiveContentMethodHandler {
    private Activity mFlutterActivity;
    private final int mFlutterViewId;
    private final SensitiveContentChannel mSensitiveContentChannel;

    public SensitiveContentPlugin(@NonNull int flutterViewId, @NonNull Activity activity, @NonNull SensitiveContentChannel sensitiveContentChannel) {
        this.mFlutterActivity = activity;
        this.mFlutterViewId = flutterViewId;
        this.mSensitiveContentChannel = sensitiveContentChannel;
        this.mSensitiveContentChannel.setSensitiveContentMethodHandler(this);
    }

    private String getNotSupportedErrorReason() {
        return "isSupported() should be called before attempting to set content sensitivity as it is not supported on this device.";
    }

    private String getFlutterViewNotFoundErrorReason() {
        return "FlutterView with ID " + this.mFlutterViewId + "not found";
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void setContentSensitivity(@NonNull int requestedContentSensitivity) {
        if (!this.isSupported()) {
            throw new IllegalStateException(this.getNotSupportedErrorReason());
        }
        View flutterView = this.mFlutterActivity.findViewById(this.mFlutterViewId);
        if (flutterView == null) {
            throw new IllegalArgumentException(this.getFlutterViewNotFoundErrorReason());
        }
        int currentContentSensitivity = flutterView.getContentSensitivity();
        if (currentContentSensitivity == requestedContentSensitivity) {
            return;
        }
        flutterView.setContentSensitivity(requestedContentSensitivity);
        flutterView.invalidate();
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public int getContentSensitivity() {
        if (!this.isSupported()) {
            return 2;
        }
        View flutterView = this.mFlutterActivity.findViewById(this.mFlutterViewId);
        if (flutterView == null) {
            throw new IllegalArgumentException(this.getFlutterViewNotFoundErrorReason());
        }
        int currentContentSensitivity = flutterView.getContentSensitivity();
        return currentContentSensitivity;
    }

    @Override
    public boolean isSupported() {
        boolean isSupported = Build.VERSION.SDK_INT >= 35;
        return isSupported;
    }

    public void destroy() {
        this.mSensitiveContentChannel.setSensitiveContentMethodHandler(null);
        this.mFlutterActivity = null;
    }
}

