/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.net.Uri;
import android.opengl.Matrix;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.provider.Settings;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.LocaleSpan;
import android.text.style.TtsSpan;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowInsets;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.accessibility.AccessibilityRecord;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.engine.systemchannels.AccessibilityChannel;
import io.flutter.plugin.platform.PlatformViewsAccessibilityDelegate;
import io.flutter.util.Predicate;
import io.flutter.util.ViewUtils;
import io.flutter.view.AccessibilityViewEmbedder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AccessibilityBridge
extends AccessibilityNodeProvider {
    private static final String TAG = "AccessibilityBridge";
    private static final int ACTION_SHOW_ON_SCREEN = 16908342;
    private static final float SCROLL_EXTENT_FOR_INFINITY = 100000.0f;
    private static final float SCROLL_POSITION_CAP_FOR_INFINITY = 70000.0f;
    private static final int ROOT_NODE_ID = 0;
    private static final int SCROLLABLE_ACTIONS = Action.SCROLL_RIGHT.value | Action.SCROLL_LEFT.value | Action.SCROLL_UP.value | Action.SCROLL_DOWN.value;
    private static final int FOCUSABLE_FLAGS = Flag.HAS_CHECKED_STATE.value | Flag.IS_CHECKED.value | Flag.IS_SELECTED.value | Flag.IS_TEXT_FIELD.value | Flag.IS_FOCUSED.value | Flag.HAS_ENABLED_STATE.value | Flag.IS_ENABLED.value | Flag.IS_IN_MUTUALLY_EXCLUSIVE_GROUP.value | Flag.HAS_TOGGLED_STATE.value | Flag.IS_TOGGLED.value | Flag.IS_FOCUSABLE.value | Flag.IS_SLIDER.value;
    private static final int MIN_ENGINE_GENERATED_NODE_ID = 65536;
    private static final int BOLD_TEXT_WEIGHT_ADJUSTMENT = 300;
    private static int FIRST_RESOURCE_ID = 0xFF00001;
    @NonNull
    private final View rootAccessibilityView;
    @NonNull
    private final AccessibilityChannel accessibilityChannel;
    @NonNull
    private final AccessibilityManager accessibilityManager;
    @NonNull
    private final AccessibilityViewEmbedder accessibilityViewEmbedder;
    @NonNull
    private final PlatformViewsAccessibilityDelegate platformViewsAccessibilityDelegate;
    @NonNull
    private final ContentResolver contentResolver;
    @NonNull
    private final Map<Integer, SemanticsNode> flutterSemanticsTree = new HashMap<Integer, SemanticsNode>();
    @NonNull
    private final Map<Integer, CustomAccessibilityAction> customAccessibilityActions = new HashMap<Integer, CustomAccessibilityAction>();
    @Nullable
    private SemanticsNode accessibilityFocusedSemanticsNode;
    private Integer embeddedAccessibilityFocusedNodeId;
    private Integer embeddedInputFocusedNodeId;
    private int accessibilityFeatureFlags = 0;
    @Nullable
    private SemanticsNode inputFocusedSemanticsNode;
    @Nullable
    private SemanticsNode lastInputFocusedSemanticsNode;
    @Nullable
    private SemanticsNode hoveredObject;
    @NonNull
    private final List<Integer> flutterNavigationStack = new ArrayList<Integer>();
    private int previousRouteId = 0;
    @NonNull
    private Integer lastLeftFrameInset = 0;
    @Nullable
    private OnAccessibilityChangeListener onAccessibilityChangeListener;
    private boolean accessibleNavigation = false;
    private boolean isReleased = false;
    private final AccessibilityChannel.AccessibilityMessageHandler accessibilityMessageHandler = new AccessibilityChannel.AccessibilityMessageHandler(){

        @Override
        public void announce(@NonNull String message) {
            AccessibilityBridge.this.rootAccessibilityView.announceForAccessibility((CharSequence)message);
        }

        @Override
        public void onTap(int nodeId) {
            AccessibilityBridge.this.sendAccessibilityEvent(nodeId, 1);
        }

        @Override
        public void onLongPress(int nodeId) {
            AccessibilityBridge.this.sendAccessibilityEvent(nodeId, 2);
        }

        @Override
        public void onTooltip(@NonNull String message) {
            if (Build.VERSION.SDK_INT >= 28) {
                return;
            }
            AccessibilityEvent e = AccessibilityBridge.this.obtainAccessibilityEvent(0, 32);
            e.getText().add(message);
            AccessibilityBridge.this.sendAccessibilityEvent(e);
        }

        @Override
        public void updateCustomAccessibilityActions(ByteBuffer buffer, String[] strings) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            AccessibilityBridge.this.updateCustomAccessibilityActions(buffer, strings);
        }

        @Override
        public void updateSemantics(ByteBuffer buffer, String[] strings, ByteBuffer[] stringAttributeArgs) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            for (ByteBuffer args : stringAttributeArgs) {
                args.order(ByteOrder.LITTLE_ENDIAN);
            }
            AccessibilityBridge.this.updateSemantics(buffer, strings, stringAttributeArgs);
        }
    };
    private final AccessibilityManager.AccessibilityStateChangeListener accessibilityStateChangeListener = new AccessibilityManager.AccessibilityStateChangeListener(){

        public void onAccessibilityStateChanged(boolean accessibilityEnabled) {
            if (AccessibilityBridge.this.isReleased) {
                return;
            }
            if (accessibilityEnabled) {
                AccessibilityBridge.this.accessibilityChannel.setAccessibilityMessageHandler(AccessibilityBridge.this.accessibilityMessageHandler);
                AccessibilityBridge.this.accessibilityChannel.onAndroidAccessibilityEnabled();
            } else {
                AccessibilityBridge.this.setAccessibleNavigation(false);
                AccessibilityBridge.this.accessibilityChannel.setAccessibilityMessageHandler(null);
                AccessibilityBridge.this.accessibilityChannel.onAndroidAccessibilityDisabled();
            }
            if (AccessibilityBridge.this.onAccessibilityChangeListener != null) {
                AccessibilityBridge.this.onAccessibilityChangeListener.onAccessibilityChanged(accessibilityEnabled, AccessibilityBridge.this.accessibilityManager.isTouchExplorationEnabled());
            }
        }
    };
    @TargetApi(value=19)
    @RequiresApi(value=19)
    private final AccessibilityManager.TouchExplorationStateChangeListener touchExplorationStateChangeListener;
    private final ContentObserver animationScaleObserver = new ContentObserver(new Handler()){

        public void onChange(boolean selfChange) {
            this.onChange(selfChange, null);
        }

        public void onChange(boolean selfChange, Uri uri) {
            boolean shouldAnimationsBeDisabled;
            if (AccessibilityBridge.this.isReleased) {
                return;
            }
            String value = Build.VERSION.SDK_INT < 17 ? null : Settings.Global.getString((ContentResolver)AccessibilityBridge.this.contentResolver, (String)"transition_animation_scale");
            boolean bl = shouldAnimationsBeDisabled = value != null && value.equals("0");
            if (shouldAnimationsBeDisabled) {
                AccessibilityBridge.this.accessibilityFeatureFlags |= AccessibilityFeature.DISABLE_ANIMATIONS.value;
            } else {
                AccessibilityBridge.this.accessibilityFeatureFlags &= ~AccessibilityFeature.DISABLE_ANIMATIONS.value;
            }
            AccessibilityBridge.this.sendLatestAccessibilityFlagsToFlutter();
        }
    };

    @VisibleForTesting
    public int getHoveredObjectId() {
        return this.hoveredObject.id;
    }

    @VisibleForTesting
    public boolean getAccessibleNavigation() {
        return this.accessibleNavigation;
    }

    private void setAccessibleNavigation(boolean value) {
        if (this.accessibleNavigation == value) {
            return;
        }
        this.accessibleNavigation = value;
        this.accessibilityFeatureFlags = this.accessibleNavigation ? (this.accessibilityFeatureFlags |= AccessibilityFeature.ACCESSIBLE_NAVIGATION.value) : (this.accessibilityFeatureFlags &= ~AccessibilityFeature.ACCESSIBLE_NAVIGATION.value);
        this.sendLatestAccessibilityFlagsToFlutter();
    }

    public AccessibilityBridge(@NonNull View rootAccessibilityView, @NonNull AccessibilityChannel accessibilityChannel, @NonNull AccessibilityManager accessibilityManager, @NonNull ContentResolver contentResolver, @NonNull PlatformViewsAccessibilityDelegate platformViewsAccessibilityDelegate) {
        this(rootAccessibilityView, accessibilityChannel, accessibilityManager, contentResolver, new AccessibilityViewEmbedder(rootAccessibilityView, 65536), platformViewsAccessibilityDelegate);
    }

    @VisibleForTesting
    public AccessibilityBridge(@NonNull View rootAccessibilityView, @NonNull AccessibilityChannel accessibilityChannel, final @NonNull AccessibilityManager accessibilityManager, @NonNull ContentResolver contentResolver, @NonNull AccessibilityViewEmbedder accessibilityViewEmbedder, @NonNull PlatformViewsAccessibilityDelegate platformViewsAccessibilityDelegate) {
        this.rootAccessibilityView = rootAccessibilityView;
        this.accessibilityChannel = accessibilityChannel;
        this.accessibilityManager = accessibilityManager;
        this.contentResolver = contentResolver;
        this.accessibilityViewEmbedder = accessibilityViewEmbedder;
        this.platformViewsAccessibilityDelegate = platformViewsAccessibilityDelegate;
        this.accessibilityStateChangeListener.onAccessibilityStateChanged(accessibilityManager.isEnabled());
        this.accessibilityManager.addAccessibilityStateChangeListener(this.accessibilityStateChangeListener);
        if (Build.VERSION.SDK_INT >= 19) {
            this.touchExplorationStateChangeListener = new AccessibilityManager.TouchExplorationStateChangeListener(){

                public void onTouchExplorationStateChanged(boolean isTouchExplorationEnabled) {
                    if (AccessibilityBridge.this.isReleased) {
                        return;
                    }
                    if (!isTouchExplorationEnabled) {
                        AccessibilityBridge.this.setAccessibleNavigation(false);
                        AccessibilityBridge.this.onTouchExplorationExit();
                    }
                    if (AccessibilityBridge.this.onAccessibilityChangeListener != null) {
                        AccessibilityBridge.this.onAccessibilityChangeListener.onAccessibilityChanged(accessibilityManager.isEnabled(), isTouchExplorationEnabled);
                    }
                }
            };
            this.touchExplorationStateChangeListener.onTouchExplorationStateChanged(accessibilityManager.isTouchExplorationEnabled());
            this.accessibilityManager.addTouchExplorationStateChangeListener(this.touchExplorationStateChangeListener);
        } else {
            this.touchExplorationStateChangeListener = null;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            this.animationScaleObserver.onChange(false);
            Uri transitionUri = Settings.Global.getUriFor((String)"transition_animation_scale");
            this.contentResolver.registerContentObserver(transitionUri, false, this.animationScaleObserver);
        }
        if (Build.VERSION.SDK_INT >= 31) {
            this.setBoldTextFlag();
        }
        platformViewsAccessibilityDelegate.attachAccessibilityBridge(this);
    }

    public void release() {
        this.isReleased = true;
        this.platformViewsAccessibilityDelegate.detachAccessibilityBridge();
        this.setOnAccessibilityChangeListener(null);
        this.accessibilityManager.removeAccessibilityStateChangeListener(this.accessibilityStateChangeListener);
        if (Build.VERSION.SDK_INT >= 19) {
            this.accessibilityManager.removeTouchExplorationStateChangeListener(this.touchExplorationStateChangeListener);
        }
        this.contentResolver.unregisterContentObserver(this.animationScaleObserver);
        this.accessibilityChannel.setAccessibilityMessageHandler(null);
    }

    public boolean isAccessibilityEnabled() {
        return this.accessibilityManager.isEnabled();
    }

    public boolean isTouchExplorationEnabled() {
        return this.accessibilityManager.isTouchExplorationEnabled();
    }

    public void setOnAccessibilityChangeListener(@Nullable OnAccessibilityChangeListener listener) {
        this.onAccessibilityChangeListener = listener;
    }

    private void sendLatestAccessibilityFlagsToFlutter() {
        this.accessibilityChannel.setAccessibilityFeatures(this.accessibilityFeatureFlags);
    }

    private boolean shouldSetCollectionInfo(SemanticsNode semanticsNode) {
        return semanticsNode.scrollChildren > 0 && (SemanticsNode.nullableHasAncestor(this.accessibilityFocusedSemanticsNode, o -> o == semanticsNode) || !SemanticsNode.nullableHasAncestor(this.accessibilityFocusedSemanticsNode, o -> ((SemanticsNode)o).hasFlag(Flag.HAS_IMPLICIT_SCROLLING)));
    }

    @TargetApi(value=31)
    @RequiresApi(value=31)
    private void setBoldTextFlag() {
        boolean shouldBold;
        if (this.rootAccessibilityView == null || this.rootAccessibilityView.getResources() == null) {
            return;
        }
        int fontWeightAdjustment = this.rootAccessibilityView.getResources().getConfiguration().fontWeightAdjustment;
        boolean bl = shouldBold = fontWeightAdjustment != Integer.MAX_VALUE && fontWeightAdjustment >= 300;
        this.accessibilityFeatureFlags = shouldBold ? (this.accessibilityFeatureFlags |= AccessibilityFeature.BOLD_TEXT.value) : (this.accessibilityFeatureFlags &= AccessibilityFeature.BOLD_TEXT.value);
        this.sendLatestAccessibilityFlagsToFlutter();
    }

    @VisibleForTesting
    public AccessibilityNodeInfo obtainAccessibilityNodeInfo(View rootView, int virtualViewId) {
        return AccessibilityNodeInfo.obtain((View)rootView, (int)virtualViewId);
    }

    @SuppressLint(value={"NewApi"})
    public AccessibilityNodeInfo createAccessibilityNodeInfo(int virtualViewId) {
        this.setAccessibleNavigation(true);
        if (virtualViewId >= 65536) {
            return this.accessibilityViewEmbedder.createAccessibilityNodeInfo(virtualViewId);
        }
        if (virtualViewId == -1) {
            AccessibilityNodeInfo result = AccessibilityNodeInfo.obtain((View)this.rootAccessibilityView);
            this.rootAccessibilityView.onInitializeAccessibilityNodeInfo(result);
            if (this.flutterSemanticsTree.containsKey(0)) {
                result.addChild(this.rootAccessibilityView, 0);
            }
            return result;
        }
        SemanticsNode semanticsNode = this.flutterSemanticsTree.get(virtualViewId);
        if (semanticsNode == null) {
            return null;
        }
        if (semanticsNode.platformViewId != -1 && this.platformViewsAccessibilityDelegate.usesVirtualDisplay(semanticsNode.platformViewId)) {
            View embeddedView = this.platformViewsAccessibilityDelegate.getPlatformViewById(semanticsNode.platformViewId);
            if (embeddedView == null) {
                return null;
            }
            Rect bounds = semanticsNode.getGlobalRect();
            return this.accessibilityViewEmbedder.getRootNode(embeddedView, semanticsNode.id, bounds);
        }
        AccessibilityNodeInfo result = this.obtainAccessibilityNodeInfo(this.rootAccessibilityView, virtualViewId);
        if (Build.VERSION.SDK_INT >= 18) {
            result.setViewIdResourceName("");
        }
        result.setPackageName((CharSequence)this.rootAccessibilityView.getContext().getPackageName());
        result.setClassName((CharSequence)"android.view.View");
        result.setSource(this.rootAccessibilityView, virtualViewId);
        result.setFocusable(semanticsNode.isFocusable());
        if (this.inputFocusedSemanticsNode != null) {
            result.setFocused(this.inputFocusedSemanticsNode.id == virtualViewId);
        }
        if (this.accessibilityFocusedSemanticsNode != null) {
            result.setAccessibilityFocused(this.accessibilityFocusedSemanticsNode.id == virtualViewId);
        }
        if (semanticsNode.hasFlag(Flag.IS_TEXT_FIELD)) {
            result.setPassword(semanticsNode.hasFlag(Flag.IS_OBSCURED));
            if (!semanticsNode.hasFlag(Flag.IS_READ_ONLY)) {
                result.setClassName((CharSequence)"android.widget.EditText");
            }
            if (Build.VERSION.SDK_INT >= 18) {
                result.setEditable(!semanticsNode.hasFlag(Flag.IS_READ_ONLY));
                if (semanticsNode.textSelectionBase != -1 && semanticsNode.textSelectionExtent != -1) {
                    result.setTextSelection(semanticsNode.textSelectionBase, semanticsNode.textSelectionExtent);
                }
                if (Build.VERSION.SDK_INT > 18 && this.accessibilityFocusedSemanticsNode != null && this.accessibilityFocusedSemanticsNode.id == virtualViewId) {
                    result.setLiveRegion(1);
                }
            }
            int granularities = 0;
            if (semanticsNode.hasAction(Action.MOVE_CURSOR_FORWARD_BY_CHARACTER)) {
                result.addAction(256);
                granularities |= 1;
            }
            if (semanticsNode.hasAction(Action.MOVE_CURSOR_BACKWARD_BY_CHARACTER)) {
                result.addAction(512);
                granularities |= 1;
            }
            if (semanticsNode.hasAction(Action.MOVE_CURSOR_FORWARD_BY_WORD)) {
                result.addAction(256);
                granularities |= 2;
            }
            if (semanticsNode.hasAction(Action.MOVE_CURSOR_BACKWARD_BY_WORD)) {
                result.addAction(512);
                granularities |= 2;
            }
            result.setMovementGranularities(granularities);
            if (Build.VERSION.SDK_INT >= 21 && semanticsNode.maxValueLength >= 0) {
                int length = semanticsNode.value == null ? 0 : semanticsNode.value.length();
                int a = length - semanticsNode.currentValueLength + semanticsNode.maxValueLength;
                result.setMaxTextLength(length - semanticsNode.currentValueLength + semanticsNode.maxValueLength);
            }
        }
        if (Build.VERSION.SDK_INT > 18) {
            if (semanticsNode.hasAction(Action.SET_SELECTION)) {
                result.addAction(131072);
            }
            if (semanticsNode.hasAction(Action.COPY)) {
                result.addAction(16384);
            }
            if (semanticsNode.hasAction(Action.CUT)) {
                result.addAction(65536);
            }
            if (semanticsNode.hasAction(Action.PASTE)) {
                result.addAction(32768);
            }
        }
        if (Build.VERSION.SDK_INT >= 21 && semanticsNode.hasAction(Action.SET_TEXT)) {
            result.addAction(0x200000);
        }
        if (semanticsNode.hasFlag(Flag.IS_BUTTON) || semanticsNode.hasFlag(Flag.IS_LINK)) {
            result.setClassName((CharSequence)"android.widget.Button");
        }
        if (semanticsNode.hasFlag(Flag.IS_IMAGE)) {
            result.setClassName((CharSequence)"android.widget.ImageView");
        }
        if (Build.VERSION.SDK_INT > 18 && semanticsNode.hasAction(Action.DISMISS)) {
            result.setDismissable(true);
            result.addAction(0x100000);
        }
        if (semanticsNode.parent != null) {
            if (semanticsNode.id <= 0) {
                Log.e(TAG, "Semantics node id is not > ROOT_NODE_ID.");
            }
            result.setParent(this.rootAccessibilityView, semanticsNode.parent.id);
        } else {
            if (semanticsNode.id != 0) {
                Log.e(TAG, "Semantics node id does not equal ROOT_NODE_ID.");
            }
            result.setParent(this.rootAccessibilityView);
        }
        if (semanticsNode.previousNodeId != -1 && Build.VERSION.SDK_INT >= 22) {
            result.setTraversalAfter(this.rootAccessibilityView, semanticsNode.previousNodeId);
        }
        Rect bounds = semanticsNode.getGlobalRect();
        if (semanticsNode.parent != null) {
            Rect parentBounds = semanticsNode.parent.getGlobalRect();
            Rect boundsInParent = new Rect(bounds);
            boundsInParent.offset(-parentBounds.left, -parentBounds.top);
            result.setBoundsInParent(boundsInParent);
        } else {
            result.setBoundsInParent(bounds);
        }
        Rect boundsInScreen = this.getBoundsInScreen(bounds);
        result.setBoundsInScreen(boundsInScreen);
        result.setVisibleToUser(true);
        result.setEnabled(!semanticsNode.hasFlag(Flag.HAS_ENABLED_STATE) || semanticsNode.hasFlag(Flag.IS_ENABLED));
        if (semanticsNode.hasAction(Action.TAP)) {
            if (Build.VERSION.SDK_INT >= 21 && semanticsNode.onTapOverride != null) {
                result.addAction(new AccessibilityNodeInfo.AccessibilityAction(16, (CharSequence)semanticsNode.onTapOverride.hint));
                result.setClickable(true);
            } else {
                result.addAction(16);
                result.setClickable(true);
            }
        }
        if (semanticsNode.hasAction(Action.LONG_PRESS)) {
            if (Build.VERSION.SDK_INT >= 21 && semanticsNode.onLongPressOverride != null) {
                result.addAction(new AccessibilityNodeInfo.AccessibilityAction(32, (CharSequence)semanticsNode.onLongPressOverride.hint));
                result.setLongClickable(true);
            } else {
                result.addAction(32);
                result.setLongClickable(true);
            }
        }
        if (semanticsNode.hasAction(Action.SCROLL_LEFT) || semanticsNode.hasAction(Action.SCROLL_UP) || semanticsNode.hasAction(Action.SCROLL_RIGHT) || semanticsNode.hasAction(Action.SCROLL_DOWN)) {
            result.setScrollable(true);
            if (semanticsNode.hasFlag(Flag.HAS_IMPLICIT_SCROLLING)) {
                if (semanticsNode.hasAction(Action.SCROLL_LEFT) || semanticsNode.hasAction(Action.SCROLL_RIGHT)) {
                    if (Build.VERSION.SDK_INT > 19 && this.shouldSetCollectionInfo(semanticsNode)) {
                        result.setCollectionInfo(AccessibilityNodeInfo.CollectionInfo.obtain((int)0, (int)semanticsNode.scrollChildren, (boolean)false));
                    } else {
                        result.setClassName((CharSequence)"android.widget.HorizontalScrollView");
                    }
                } else if (Build.VERSION.SDK_INT > 18 && this.shouldSetCollectionInfo(semanticsNode)) {
                    result.setCollectionInfo(AccessibilityNodeInfo.CollectionInfo.obtain((int)semanticsNode.scrollChildren, (int)0, (boolean)false));
                } else {
                    result.setClassName((CharSequence)"android.widget.ScrollView");
                }
            }
            if (semanticsNode.hasAction(Action.SCROLL_LEFT) || semanticsNode.hasAction(Action.SCROLL_UP)) {
                result.addAction(4096);
            }
            if (semanticsNode.hasAction(Action.SCROLL_RIGHT) || semanticsNode.hasAction(Action.SCROLL_DOWN)) {
                result.addAction(8192);
            }
        }
        if (semanticsNode.hasAction(Action.INCREASE) || semanticsNode.hasAction(Action.DECREASE)) {
            result.setClassName((CharSequence)"android.widget.SeekBar");
            if (semanticsNode.hasAction(Action.INCREASE)) {
                result.addAction(4096);
            }
            if (semanticsNode.hasAction(Action.DECREASE)) {
                result.addAction(8192);
            }
        }
        if (semanticsNode.hasFlag(Flag.IS_LIVE_REGION) && Build.VERSION.SDK_INT > 18) {
            result.setLiveRegion(1);
        }
        if (semanticsNode.hasFlag(Flag.IS_TEXT_FIELD)) {
            result.setText(semanticsNode.getValue());
            if (Build.VERSION.SDK_INT >= 28) {
                result.setHintText(semanticsNode.getTextFieldHint());
            }
        } else if (!semanticsNode.hasFlag(Flag.SCOPES_ROUTE)) {
            CharSequence content = semanticsNode.getValueLabelHint();
            if (Build.VERSION.SDK_INT < 28 && semanticsNode.tooltip != null) {
                content = content != null ? content : "";
                content = content + "\n" + semanticsNode.tooltip;
            }
            if (content != null) {
                result.setContentDescription(content);
            }
        }
        if (Build.VERSION.SDK_INT >= 28 && semanticsNode.tooltip != null) {
            result.setTooltipText((CharSequence)semanticsNode.tooltip);
        }
        boolean hasCheckedState = semanticsNode.hasFlag(Flag.HAS_CHECKED_STATE);
        boolean hasToggledState = semanticsNode.hasFlag(Flag.HAS_TOGGLED_STATE);
        if (hasCheckedState && hasToggledState) {
            Log.e(TAG, "Expected semanticsNode to have checked state and toggled state.");
        }
        result.setCheckable(hasCheckedState || hasToggledState);
        if (hasCheckedState) {
            result.setChecked(semanticsNode.hasFlag(Flag.IS_CHECKED));
            if (semanticsNode.hasFlag(Flag.IS_IN_MUTUALLY_EXCLUSIVE_GROUP)) {
                result.setClassName((CharSequence)"android.widget.RadioButton");
            } else {
                result.setClassName((CharSequence)"android.widget.CheckBox");
            }
        } else if (hasToggledState) {
            result.setChecked(semanticsNode.hasFlag(Flag.IS_TOGGLED));
            result.setClassName((CharSequence)"android.widget.Switch");
        }
        result.setSelected(semanticsNode.hasFlag(Flag.IS_SELECTED));
        if (Build.VERSION.SDK_INT >= 28) {
            result.setHeading(semanticsNode.hasFlag(Flag.IS_HEADER));
        }
        if (this.accessibilityFocusedSemanticsNode != null && this.accessibilityFocusedSemanticsNode.id == virtualViewId) {
            result.addAction(128);
        } else {
            result.addAction(64);
        }
        if (Build.VERSION.SDK_INT >= 21 && semanticsNode.customAccessibilityActions != null) {
            for (CustomAccessibilityAction action : semanticsNode.customAccessibilityActions) {
                result.addAction(new AccessibilityNodeInfo.AccessibilityAction(action.resourceId, (CharSequence)action.label));
            }
        }
        for (SemanticsNode child : semanticsNode.childrenInTraversalOrder) {
            if (child.hasFlag(Flag.IS_HIDDEN)) continue;
            if (child.platformViewId != -1) {
                View embeddedView = this.platformViewsAccessibilityDelegate.getPlatformViewById(child.platformViewId);
                if (!this.platformViewsAccessibilityDelegate.usesVirtualDisplay(child.platformViewId)) {
                    result.addChild(embeddedView);
                    continue;
                }
            }
            result.addChild(this.rootAccessibilityView, child.id);
        }
        return result;
    }

    private Rect getBoundsInScreen(Rect bounds) {
        Rect boundsInScreen = new Rect(bounds);
        int[] locationOnScreen = new int[2];
        this.rootAccessibilityView.getLocationOnScreen(locationOnScreen);
        boundsInScreen.offset(locationOnScreen[0], locationOnScreen[1]);
        return boundsInScreen;
    }

    public boolean performAction(int virtualViewId, int accessibilityAction, @Nullable Bundle arguments) {
        if (virtualViewId >= 65536) {
            boolean didPerform = this.accessibilityViewEmbedder.performAction(virtualViewId, accessibilityAction, arguments);
            if (didPerform && accessibilityAction == 128) {
                this.embeddedAccessibilityFocusedNodeId = null;
            }
            return didPerform;
        }
        SemanticsNode semanticsNode = this.flutterSemanticsTree.get(virtualViewId);
        if (semanticsNode == null) {
            return false;
        }
        switch (accessibilityAction) {
            case 16: {
                this.accessibilityChannel.dispatchSemanticsAction(virtualViewId, Action.TAP);
                return true;
            }
            case 32: {
                this.accessibilityChannel.dispatchSemanticsAction(virtualViewId, Action.LONG_PRESS);
                return true;
            }
            case 4096: {
                if (semanticsNode.hasAction(Action.SCROLL_UP)) {
                    this.accessibilityChannel.dispatchSemanticsAction(virtualViewId, Action.SCROLL_UP);
                } else if (semanticsNode.hasAction(Action.SCROLL_LEFT)) {
                    this.accessibilityChannel.dispatchSemanticsAction(virtualViewId, Action.SCROLL_LEFT);
                } else if (semanticsNode.hasAction(Action.INCREASE)) {
                    semanticsNode.value = semanticsNode.increasedValue;
                    semanticsNode.valueAttributes = semanticsNode.increasedValueAttributes;
                    this.sendAccessibilityEvent(virtualViewId, 4);
                    this.accessibilityChannel.dispatchSemanticsAction(virtualViewId, Action.INCREASE);
                } else {
                    return false;
                }
                return true;
            }
            case 8192: {
                if (semanticsNode.hasAction(Action.SCROLL_DOWN)) {
                    this.accessibilityChannel.dispatchSemanticsAction(virtualViewId, Action.SCROLL_DOWN);
                } else if (semanticsNode.hasAction(Action.SCROLL_RIGHT)) {
                    this.accessibilityChannel.dispatchSemanticsAction(virtualViewId, Action.SCROLL_RIGHT);
                } else if (semanticsNode.hasAction(Action.DECREASE)) {
                    semanticsNode.value = semanticsNode.decreasedValue;
                    semanticsNode.valueAttributes = semanticsNode.decreasedValueAttributes;
                    this.sendAccessibilityEvent(virtualViewId, 4);
                    this.accessibilityChannel.dispatchSemanticsAction(virtualViewId, Action.DECREASE);
                } else {
                    return false;
                }
                return true;
            }
            case 512: {
                if (Build.VERSION.SDK_INT < 18) {
                    return false;
                }
                return this.performCursorMoveAction(semanticsNode, virtualViewId, arguments, false);
            }
            case 256: {
                if (Build.VERSION.SDK_INT < 18) {
                    return false;
                }
                return this.performCursorMoveAction(semanticsNode, virtualViewId, arguments, true);
            }
            case 128: {
                if (this.accessibilityFocusedSemanticsNode != null && this.accessibilityFocusedSemanticsNode.id == virtualViewId) {
                    this.accessibilityFocusedSemanticsNode = null;
                }
                if (this.embeddedAccessibilityFocusedNodeId != null && this.embeddedAccessibilityFocusedNodeId == virtualViewId) {
                    this.embeddedAccessibilityFocusedNodeId = null;
                }
                this.accessibilityChannel.dispatchSemanticsAction(virtualViewId, Action.DID_LOSE_ACCESSIBILITY_FOCUS);
                this.sendAccessibilityEvent(virtualViewId, 65536);
                return true;
            }
            case 64: {
                if (this.accessibilityFocusedSemanticsNode == null) {
                    this.rootAccessibilityView.invalidate();
                }
                this.accessibilityFocusedSemanticsNode = semanticsNode;
                this.accessibilityChannel.dispatchSemanticsAction(virtualViewId, Action.DID_GAIN_ACCESSIBILITY_FOCUS);
                this.sendAccessibilityEvent(virtualViewId, 32768);
                if (semanticsNode.hasAction(Action.INCREASE) || semanticsNode.hasAction(Action.DECREASE)) {
                    this.sendAccessibilityEvent(virtualViewId, 4);
                }
                return true;
            }
            case 16908342: {
                this.accessibilityChannel.dispatchSemanticsAction(virtualViewId, Action.SHOW_ON_SCREEN);
                return true;
            }
            case 131072: {
                boolean hasSelection;
                if (Build.VERSION.SDK_INT < 18) {
                    return false;
                }
                HashMap<String, Integer> selection = new HashMap<String, Integer>();
                boolean bl = hasSelection = arguments != null && arguments.containsKey("ACTION_ARGUMENT_SELECTION_START_INT") && arguments.containsKey("ACTION_ARGUMENT_SELECTION_END_INT");
                if (hasSelection) {
                    selection.put("base", arguments.getInt("ACTION_ARGUMENT_SELECTION_START_INT"));
                    selection.put("extent", arguments.getInt("ACTION_ARGUMENT_SELECTION_END_INT"));
                } else {
                    selection.put("base", semanticsNode.textSelectionExtent);
                    selection.put("extent", semanticsNode.textSelectionExtent);
                }
                this.accessibilityChannel.dispatchSemanticsAction(virtualViewId, Action.SET_SELECTION, selection);
                SemanticsNode node = this.flutterSemanticsTree.get(virtualViewId);
                node.textSelectionBase = (Integer)selection.get("base");
                node.textSelectionExtent = (Integer)selection.get("extent");
                return true;
            }
            case 16384: {
                this.accessibilityChannel.dispatchSemanticsAction(virtualViewId, Action.COPY);
                return true;
            }
            case 65536: {
                this.accessibilityChannel.dispatchSemanticsAction(virtualViewId, Action.CUT);
                return true;
            }
            case 32768: {
                this.accessibilityChannel.dispatchSemanticsAction(virtualViewId, Action.PASTE);
                return true;
            }
            case 0x100000: {
                this.accessibilityChannel.dispatchSemanticsAction(virtualViewId, Action.DISMISS);
                return true;
            }
            case 0x200000: {
                if (Build.VERSION.SDK_INT < 21) {
                    return false;
                }
                return this.performSetText(semanticsNode, virtualViewId, arguments);
            }
        }
        int flutterId = accessibilityAction - FIRST_RESOURCE_ID;
        CustomAccessibilityAction contextAction = this.customAccessibilityActions.get(flutterId);
        if (contextAction != null) {
            this.accessibilityChannel.dispatchSemanticsAction(virtualViewId, Action.CUSTOM_ACTION, contextAction.id);
            return true;
        }
        return false;
    }

    @TargetApi(value=18)
    @RequiresApi(value=18)
    private boolean performCursorMoveAction(@NonNull SemanticsNode semanticsNode, int virtualViewId, @NonNull Bundle arguments, boolean forward) {
        int granularity = arguments.getInt("ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT");
        boolean extendSelection = arguments.getBoolean("ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN");
        int previousTextSelectionBase = semanticsNode.textSelectionBase;
        int previousTextSelectionExtent = semanticsNode.textSelectionExtent;
        this.predictCursorMovement(semanticsNode, granularity, forward, extendSelection);
        if (previousTextSelectionBase != semanticsNode.textSelectionBase || previousTextSelectionExtent != semanticsNode.textSelectionExtent) {
            String value = semanticsNode.value != null ? semanticsNode.value : "";
            AccessibilityEvent selectionEvent = this.obtainAccessibilityEvent(semanticsNode.id, 8192);
            selectionEvent.getText().add(value);
            selectionEvent.setFromIndex(semanticsNode.textSelectionBase);
            selectionEvent.setToIndex(semanticsNode.textSelectionExtent);
            selectionEvent.setItemCount(value.length());
            this.sendAccessibilityEvent(selectionEvent);
        }
        switch (granularity) {
            case 1: {
                if (forward && semanticsNode.hasAction(Action.MOVE_CURSOR_FORWARD_BY_CHARACTER)) {
                    this.accessibilityChannel.dispatchSemanticsAction(virtualViewId, Action.MOVE_CURSOR_FORWARD_BY_CHARACTER, extendSelection);
                    return true;
                }
                if (forward || !semanticsNode.hasAction(Action.MOVE_CURSOR_BACKWARD_BY_CHARACTER)) break;
                this.accessibilityChannel.dispatchSemanticsAction(virtualViewId, Action.MOVE_CURSOR_BACKWARD_BY_CHARACTER, extendSelection);
                return true;
            }
            case 2: {
                if (forward && semanticsNode.hasAction(Action.MOVE_CURSOR_FORWARD_BY_WORD)) {
                    this.accessibilityChannel.dispatchSemanticsAction(virtualViewId, Action.MOVE_CURSOR_FORWARD_BY_WORD, extendSelection);
                    return true;
                }
                if (forward || !semanticsNode.hasAction(Action.MOVE_CURSOR_BACKWARD_BY_WORD)) break;
                this.accessibilityChannel.dispatchSemanticsAction(virtualViewId, Action.MOVE_CURSOR_BACKWARD_BY_WORD, extendSelection);
                return true;
            }
            case 4: 
            case 8: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    private void predictCursorMovement(@NonNull SemanticsNode node, int granularity, boolean forward, boolean extendSelection) {
        if (node.textSelectionExtent < 0 || node.textSelectionBase < 0) {
            return;
        }
        switch (granularity) {
            case 1: {
                if (forward && node.textSelectionExtent < node.value.length()) {
                    node.textSelectionExtent += 1;
                    break;
                }
                if (forward || node.textSelectionExtent <= 0) break;
                node.textSelectionExtent -= 1;
                break;
            }
            case 2: {
                Pattern pattern;
                Matcher result;
                if (forward && node.textSelectionExtent < node.value.length()) {
                    Pattern pattern2 = Pattern.compile("\\p{L}(\\b)");
                    Matcher result2 = pattern2.matcher(node.value.substring(node.textSelectionExtent));
                    result2.find();
                    if (result2.find()) {
                        node.textSelectionExtent += result2.start(1);
                        break;
                    }
                    node.textSelectionExtent = node.value.length();
                    break;
                }
                if (forward || node.textSelectionExtent <= 0 || !(result = (pattern = Pattern.compile("(?s:.*)(\\b)\\p{L}")).matcher(node.value.substring(0, node.textSelectionExtent))).find()) break;
                node.textSelectionExtent = result.start(1);
                break;
            }
            case 4: {
                if (forward && node.textSelectionExtent < node.value.length()) {
                    Pattern pattern = Pattern.compile("(?!^)(\\n)");
                    Matcher result = pattern.matcher(node.value.substring(node.textSelectionExtent));
                    if (result.find()) {
                        node.textSelectionExtent += result.start(1);
                        break;
                    }
                    node.textSelectionExtent = node.value.length();
                    break;
                }
                if (forward || node.textSelectionExtent <= 0) break;
                Pattern pattern = Pattern.compile("(?s:.*)(\\n)");
                Matcher result = pattern.matcher(node.value.substring(0, node.textSelectionExtent));
                if (result.find()) {
                    node.textSelectionExtent = result.start(1);
                    break;
                }
                node.textSelectionExtent = 0;
                break;
            }
            case 8: 
            case 16: {
                if (forward) {
                    node.textSelectionExtent = node.value.length();
                    break;
                }
                node.textSelectionExtent = 0;
            }
        }
        if (!extendSelection) {
            node.textSelectionBase = node.textSelectionExtent;
        }
    }

    @TargetApi(value=21)
    @RequiresApi(value=21)
    private boolean performSetText(SemanticsNode node, int virtualViewId, @NonNull Bundle arguments) {
        String newText = "";
        if (arguments != null && arguments.containsKey("ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE")) {
            newText = arguments.getString("ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE");
        }
        this.accessibilityChannel.dispatchSemanticsAction(virtualViewId, Action.SET_TEXT, newText);
        node.value = newText;
        node.valueAttributes = null;
        return true;
    }

    public AccessibilityNodeInfo findFocus(int focus) {
        switch (focus) {
            case 1: {
                if (this.inputFocusedSemanticsNode != null) {
                    return this.createAccessibilityNodeInfo(this.inputFocusedSemanticsNode.id);
                }
                if (this.embeddedInputFocusedNodeId != null) {
                    return this.createAccessibilityNodeInfo(this.embeddedInputFocusedNodeId);
                }
            }
            case 2: {
                if (this.accessibilityFocusedSemanticsNode != null) {
                    return this.createAccessibilityNodeInfo(this.accessibilityFocusedSemanticsNode.id);
                }
                if (this.embeddedAccessibilityFocusedNodeId == null) break;
                return this.createAccessibilityNodeInfo(this.embeddedAccessibilityFocusedNodeId);
            }
        }
        return null;
    }

    private SemanticsNode getRootSemanticsNode() {
        if (!this.flutterSemanticsTree.containsKey(0)) {
            Log.e(TAG, "Attempted to getRootSemanticsNode without a root semantics node.");
        }
        return this.flutterSemanticsTree.get(0);
    }

    private SemanticsNode getOrCreateSemanticsNode(int id) {
        SemanticsNode semanticsNode = this.flutterSemanticsTree.get(id);
        if (semanticsNode == null) {
            semanticsNode = new SemanticsNode(this);
            semanticsNode.id = id;
            this.flutterSemanticsTree.put(id, semanticsNode);
        }
        return semanticsNode;
    }

    private CustomAccessibilityAction getOrCreateAccessibilityAction(int id) {
        CustomAccessibilityAction action = this.customAccessibilityActions.get(id);
        if (action == null) {
            action = new CustomAccessibilityAction();
            action.id = id;
            action.resourceId = id + AccessibilityBridge.FIRST_RESOURCE_ID;
            this.customAccessibilityActions.put(id, action);
        }
        return action;
    }

    public boolean onAccessibilityHoverEvent(MotionEvent event) {
        return this.onAccessibilityHoverEvent(event, false);
    }

    public boolean onAccessibilityHoverEvent(MotionEvent event, boolean ignorePlatformViews) {
        if (!this.accessibilityManager.isTouchExplorationEnabled()) {
            return false;
        }
        if (this.flutterSemanticsTree.isEmpty()) {
            return false;
        }
        SemanticsNode semanticsNodeUnderCursor = this.getRootSemanticsNode().hitTest(new float[]{event.getX(), event.getY(), 0.0f, 1.0f}, ignorePlatformViews);
        if (semanticsNodeUnderCursor != null && semanticsNodeUnderCursor.platformViewId != -1) {
            if (ignorePlatformViews) {
                return false;
            }
            return this.accessibilityViewEmbedder.onAccessibilityHoverEvent(semanticsNodeUnderCursor.id, event);
        }
        if (event.getAction() == 9 || event.getAction() == 7) {
            this.handleTouchExploration(event.getX(), event.getY(), ignorePlatformViews);
        } else if (event.getAction() == 10) {
            this.onTouchExplorationExit();
        } else {
            Log.d("flutter", "unexpected accessibility hover event: " + event);
            return false;
        }
        return true;
    }

    private void onTouchExplorationExit() {
        if (this.hoveredObject != null) {
            this.sendAccessibilityEvent(this.hoveredObject.id, 256);
            this.hoveredObject = null;
        }
    }

    private void handleTouchExploration(float x, float y, boolean ignorePlatformViews) {
        if (this.flutterSemanticsTree.isEmpty()) {
            return;
        }
        SemanticsNode semanticsNodeUnderCursor = this.getRootSemanticsNode().hitTest(new float[]{x, y, 0.0f, 1.0f}, ignorePlatformViews);
        if (semanticsNodeUnderCursor != this.hoveredObject) {
            if (semanticsNodeUnderCursor != null) {
                this.sendAccessibilityEvent(semanticsNodeUnderCursor.id, 128);
            }
            if (this.hoveredObject != null) {
                this.sendAccessibilityEvent(this.hoveredObject.id, 256);
            }
            this.hoveredObject = semanticsNodeUnderCursor;
        }
    }

    void updateCustomAccessibilityActions(@NonNull ByteBuffer buffer, @NonNull String[] strings) {
        while (buffer.hasRemaining()) {
            int id = buffer.getInt();
            CustomAccessibilityAction action = this.getOrCreateAccessibilityAction(id);
            action.overrideId = buffer.getInt();
            int stringIndex = buffer.getInt();
            action.label = stringIndex == -1 ? null : strings[stringIndex];
            stringIndex = buffer.getInt();
            action.hint = stringIndex == -1 ? null : strings[stringIndex];
        }
    }

    void updateSemantics(@NonNull ByteBuffer buffer, @NonNull String[] strings, @NonNull ByteBuffer[] stringAttributeArgs) {
        ArrayList<SemanticsNode> updated = new ArrayList<SemanticsNode>();
        while (buffer.hasRemaining()) {
            View embeddedView;
            int id = buffer.getInt();
            SemanticsNode semanticsNode = this.getOrCreateSemanticsNode(id);
            semanticsNode.updateWith(buffer, strings, stringAttributeArgs);
            if (semanticsNode.hasFlag(Flag.IS_HIDDEN)) continue;
            if (semanticsNode.hasFlag(Flag.IS_FOCUSED)) {
                this.inputFocusedSemanticsNode = semanticsNode;
            }
            if (semanticsNode.hadPreviousConfig) {
                updated.add(semanticsNode);
            }
            if (semanticsNode.platformViewId == -1 || this.platformViewsAccessibilityDelegate.usesVirtualDisplay(semanticsNode.platformViewId) || (embeddedView = this.platformViewsAccessibilityDelegate.getPlatformViewById(semanticsNode.platformViewId)) == null) continue;
            embeddedView.setImportantForAccessibility(0);
        }
        HashSet visitedObjects = new HashSet();
        SemanticsNode rootObject = this.getRootSemanticsNode();
        ArrayList newRoutes = new ArrayList();
        if (rootObject != null) {
            float[] identity = new float[16];
            Matrix.setIdentityM((float[])identity, (int)0);
            if (Build.VERSION.SDK_INT >= 23) {
                WindowInsets insets;
                boolean needsToApplyLeftCutoutInset = true;
                if (Build.VERSION.SDK_INT >= 28) {
                    needsToApplyLeftCutoutInset = this.doesLayoutInDisplayCutoutModeRequireLeftInset();
                }
                if (needsToApplyLeftCutoutInset && (insets = this.rootAccessibilityView.getRootWindowInsets()) != null) {
                    if (!this.lastLeftFrameInset.equals(insets.getSystemWindowInsetLeft())) {
                        rootObject.globalGeometryDirty = true;
                        rootObject.inverseTransformDirty = true;
                    }
                    this.lastLeftFrameInset = insets.getSystemWindowInsetLeft();
                    Matrix.translateM((float[])identity, (int)0, (float)this.lastLeftFrameInset.intValue(), (float)0.0f, (float)0.0f);
                }
            }
            rootObject.updateRecursively(identity, visitedObjects, false);
            rootObject.collectRoutes(newRoutes);
        }
        SemanticsNode lastAdded = null;
        for (SemanticsNode semanticsNode : newRoutes) {
            if (this.flutterNavigationStack.contains(semanticsNode.id)) continue;
            lastAdded = semanticsNode;
        }
        if (lastAdded == null && newRoutes.size() > 0) {
            lastAdded = (SemanticsNode)newRoutes.get(newRoutes.size() - 1);
        }
        if (lastAdded != null && (lastAdded.id != this.previousRouteId || newRoutes.size() != this.flutterNavigationStack.size())) {
            this.previousRouteId = lastAdded.id;
            this.onWindowNameChange(lastAdded);
        }
        this.flutterNavigationStack.clear();
        for (SemanticsNode semanticsNode : newRoutes) {
            this.flutterNavigationStack.add(semanticsNode.id);
        }
        Iterator<Map.Entry<Integer, SemanticsNode>> it = this.flutterSemanticsTree.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, SemanticsNode> entry = it.next();
            SemanticsNode object = entry.getValue();
            if (visitedObjects.contains(object)) continue;
            this.willRemoveSemanticsNode(object);
            it.remove();
        }
        this.sendWindowContentChangeEvent(0);
        for (SemanticsNode object : updated) {
            AccessibilityEvent event;
            if (object.didScroll()) {
                event = this.obtainAccessibilityEvent(object.id, 4096);
                float position = object.scrollPosition;
                float max = object.scrollExtentMax;
                if (Float.isInfinite(object.scrollExtentMax)) {
                    max = 100000.0f;
                    if (position > 70000.0f) {
                        position = 70000.0f;
                    }
                }
                if (Float.isInfinite(object.scrollExtentMin)) {
                    max += 100000.0f;
                    if (position < -70000.0f) {
                        position = -70000.0f;
                    }
                    position += 100000.0f;
                } else {
                    max -= object.scrollExtentMin;
                    position -= object.scrollExtentMin;
                }
                if (object.hadAction(Action.SCROLL_UP) || object.hadAction(Action.SCROLL_DOWN)) {
                    event.setScrollY((int)position);
                    event.setMaxScrollY((int)max);
                } else if (object.hadAction(Action.SCROLL_LEFT) || object.hadAction(Action.SCROLL_RIGHT)) {
                    event.setScrollX((int)position);
                    event.setMaxScrollX((int)max);
                }
                if (object.scrollChildren > 0) {
                    event.setItemCount(object.scrollChildren);
                    event.setFromIndex(object.scrollIndex);
                    int visibleChildren = 0;
                    for (SemanticsNode child : object.childrenInHitTestOrder) {
                        if (child.hasFlag(Flag.IS_HIDDEN)) continue;
                        ++visibleChildren;
                    }
                    if (object.scrollIndex + visibleChildren > object.scrollChildren) {
                        Log.e(TAG, "Scroll index is out of bounds.");
                    }
                    if (object.childrenInHitTestOrder.isEmpty()) {
                        Log.e(TAG, "Had scrollChildren but no childrenInHitTestOrder");
                    }
                    event.setToIndex(object.scrollIndex + visibleChildren - 1);
                }
                this.sendAccessibilityEvent(event);
            }
            if (object.hasFlag(Flag.IS_LIVE_REGION) && object.didChangeLabel()) {
                this.sendWindowContentChangeEvent(object.id);
            }
            if (this.accessibilityFocusedSemanticsNode != null && this.accessibilityFocusedSemanticsNode.id == object.id && !object.hadFlag(Flag.IS_SELECTED) && object.hasFlag(Flag.IS_SELECTED)) {
                event = this.obtainAccessibilityEvent(object.id, 4);
                event.getText().add(object.label);
                this.sendAccessibilityEvent(event);
            }
            if (this.inputFocusedSemanticsNode != null && this.inputFocusedSemanticsNode.id == object.id && (this.lastInputFocusedSemanticsNode == null || this.lastInputFocusedSemanticsNode.id != this.inputFocusedSemanticsNode.id)) {
                this.lastInputFocusedSemanticsNode = this.inputFocusedSemanticsNode;
                this.sendAccessibilityEvent(this.obtainAccessibilityEvent(object.id, 8));
            } else if (this.inputFocusedSemanticsNode == null) {
                this.lastInputFocusedSemanticsNode = null;
            }
            if (this.inputFocusedSemanticsNode == null || this.inputFocusedSemanticsNode.id != object.id || !object.hadFlag(Flag.IS_TEXT_FIELD) || !object.hasFlag(Flag.IS_TEXT_FIELD) || this.accessibilityFocusedSemanticsNode != null && this.accessibilityFocusedSemanticsNode.id != this.inputFocusedSemanticsNode.id) continue;
            String oldValue = object.previousValue != null ? object.previousValue : "";
            String newValue = object.value != null ? object.value : "";
            AccessibilityEvent event2 = this.createTextChangedEvent(object.id, oldValue, newValue);
            if (event2 != null) {
                this.sendAccessibilityEvent(event2);
            }
            if (object.previousTextSelectionBase == object.textSelectionBase && object.previousTextSelectionExtent == object.textSelectionExtent) continue;
            AccessibilityEvent selectionEvent = this.obtainAccessibilityEvent(object.id, 8192);
            selectionEvent.getText().add(newValue);
            selectionEvent.setFromIndex(object.textSelectionBase);
            selectionEvent.setToIndex(object.textSelectionExtent);
            selectionEvent.setItemCount(newValue.length());
            this.sendAccessibilityEvent(selectionEvent);
        }
    }

    private AccessibilityEvent createTextChangedEvent(int id, String oldValue, String newValue) {
        int newIndex;
        int i;
        AccessibilityEvent e = this.obtainAccessibilityEvent(id, 16);
        e.setBeforeText((CharSequence)oldValue);
        e.getText().add(newValue);
        for (i = 0; i < oldValue.length() && i < newValue.length() && oldValue.charAt(i) == newValue.charAt(i); ++i) {
        }
        if (i >= oldValue.length() && i >= newValue.length()) {
            return null;
        }
        int firstDifference = i;
        e.setFromIndex(firstDifference);
        int oldIndex = oldValue.length() - 1;
        for (newIndex = newValue.length() - 1; oldIndex >= firstDifference && newIndex >= firstDifference && oldValue.charAt(oldIndex) == newValue.charAt(newIndex); --oldIndex, --newIndex) {
        }
        e.setRemovedCount(oldIndex - firstDifference + 1);
        e.setAddedCount(newIndex - firstDifference + 1);
        return e;
    }

    private void sendAccessibilityEvent(int viewId, int eventType) {
        if (!this.accessibilityManager.isEnabled()) {
            return;
        }
        this.sendAccessibilityEvent(this.obtainAccessibilityEvent(viewId, eventType));
    }

    private void sendAccessibilityEvent(@NonNull AccessibilityEvent event) {
        if (!this.accessibilityManager.isEnabled()) {
            return;
        }
        this.rootAccessibilityView.getParent().requestSendAccessibilityEvent(this.rootAccessibilityView, event);
    }

    private void onWindowNameChange(@NonNull SemanticsNode route) {
        String routeName = route.getRouteName();
        if (routeName == null) {
            routeName = " ";
        }
        if (Build.VERSION.SDK_INT >= 28) {
            this.setAccessibilityPaneTitle(routeName);
        } else {
            AccessibilityEvent event = this.obtainAccessibilityEvent(route.id, 32);
            event.getText().add(routeName);
            this.sendAccessibilityEvent(event);
        }
    }

    @TargetApi(value=28)
    @RequiresApi(value=28)
    private void setAccessibilityPaneTitle(String title) {
        this.rootAccessibilityView.setAccessibilityPaneTitle((CharSequence)title);
    }

    private void sendWindowContentChangeEvent(int virtualViewId) {
        AccessibilityEvent event = this.obtainAccessibilityEvent(virtualViewId, 2048);
        if (Build.VERSION.SDK_INT >= 19) {
            event.setContentChangeTypes(1);
        }
        this.sendAccessibilityEvent(event);
    }

    private AccessibilityEvent obtainAccessibilityEvent(int virtualViewId, int eventType) {
        AccessibilityEvent event = AccessibilityEvent.obtain((int)eventType);
        event.setPackageName((CharSequence)this.rootAccessibilityView.getContext().getPackageName());
        event.setSource(this.rootAccessibilityView, virtualViewId);
        return event;
    }

    @TargetApi(value=28)
    @RequiresApi(value=28)
    private boolean doesLayoutInDisplayCutoutModeRequireLeftInset() {
        Context context = this.rootAccessibilityView.getContext();
        Activity activity = ViewUtils.getActivity(context);
        if (activity == null || activity.getWindow() == null) {
            return false;
        }
        int layoutInDisplayCutoutMode = activity.getWindow().getAttributes().layoutInDisplayCutoutMode;
        return layoutInDisplayCutoutMode == 2 || layoutInDisplayCutoutMode == 0;
    }

    @TargetApi(value=19)
    @RequiresApi(value=19)
    private void willRemoveSemanticsNode(SemanticsNode semanticsNodeToBeRemoved) {
        View embeddedView;
        if (!this.flutterSemanticsTree.containsKey(semanticsNodeToBeRemoved.id)) {
            Log.e(TAG, "Attempted to remove a node that is not in the tree.");
        }
        if (this.flutterSemanticsTree.get(semanticsNodeToBeRemoved.id) != semanticsNodeToBeRemoved) {
            Log.e(TAG, "Flutter semantics tree failed to get expected node when searching by id.");
        }
        semanticsNodeToBeRemoved.parent = null;
        if (semanticsNodeToBeRemoved.platformViewId != -1 && this.embeddedAccessibilityFocusedNodeId != null && this.accessibilityViewEmbedder.platformViewOfNode(this.embeddedAccessibilityFocusedNodeId) == this.platformViewsAccessibilityDelegate.getPlatformViewById(semanticsNodeToBeRemoved.platformViewId)) {
            this.sendAccessibilityEvent(this.embeddedAccessibilityFocusedNodeId, 65536);
            this.embeddedAccessibilityFocusedNodeId = null;
        }
        if (semanticsNodeToBeRemoved.platformViewId != -1 && (embeddedView = this.platformViewsAccessibilityDelegate.getPlatformViewById(semanticsNodeToBeRemoved.platformViewId)) != null) {
            embeddedView.setImportantForAccessibility(4);
        }
        if (this.accessibilityFocusedSemanticsNode == semanticsNodeToBeRemoved) {
            this.sendAccessibilityEvent(this.accessibilityFocusedSemanticsNode.id, 65536);
            this.accessibilityFocusedSemanticsNode = null;
        }
        if (this.inputFocusedSemanticsNode == semanticsNodeToBeRemoved) {
            this.inputFocusedSemanticsNode = null;
        }
        if (this.hoveredObject == semanticsNodeToBeRemoved) {
            this.hoveredObject = null;
        }
    }

    public void reset() {
        this.flutterSemanticsTree.clear();
        if (this.accessibilityFocusedSemanticsNode != null) {
            this.sendAccessibilityEvent(this.accessibilityFocusedSemanticsNode.id, 65536);
        }
        this.accessibilityFocusedSemanticsNode = null;
        this.hoveredObject = null;
        this.sendWindowContentChangeEvent(0);
    }

    @SuppressLint(value={"SwitchIntDef"})
    public boolean externalViewRequestSendAccessibilityEvent(View embeddedView, View eventOrigin, AccessibilityEvent event) {
        if (!this.accessibilityViewEmbedder.requestSendAccessibilityEvent(embeddedView, eventOrigin, event)) {
            return false;
        }
        Integer virtualNodeId = this.accessibilityViewEmbedder.getRecordFlutterId(embeddedView, (AccessibilityRecord)event);
        if (virtualNodeId == null) {
            return false;
        }
        switch (event.getEventType()) {
            case 128: {
                this.hoveredObject = null;
                break;
            }
            case 32768: {
                this.embeddedAccessibilityFocusedNodeId = virtualNodeId;
                this.accessibilityFocusedSemanticsNode = null;
                break;
            }
            case 65536: {
                this.embeddedInputFocusedNodeId = null;
                this.embeddedAccessibilityFocusedNodeId = null;
                break;
            }
            case 8: {
                this.embeddedInputFocusedNodeId = virtualNodeId;
                this.inputFocusedSemanticsNode = null;
            }
        }
        return true;
    }

    private static class SemanticsNode {
        final AccessibilityBridge accessibilityBridge;
        private int id = -1;
        private int flags;
        private int actions;
        private int maxValueLength;
        private int currentValueLength;
        private int textSelectionBase;
        private int textSelectionExtent;
        private int platformViewId;
        private int scrollChildren;
        private int scrollIndex;
        private float scrollPosition;
        private float scrollExtentMax;
        private float scrollExtentMin;
        private String label;
        private List<StringAttribute> labelAttributes;
        private String value;
        private List<StringAttribute> valueAttributes;
        private String increasedValue;
        private List<StringAttribute> increasedValueAttributes;
        private String decreasedValue;
        private List<StringAttribute> decreasedValueAttributes;
        private String hint;
        private List<StringAttribute> hintAttributes;
        @Nullable
        private String tooltip;
        private int previousNodeId = -1;
        private TextDirection textDirection;
        private boolean hadPreviousConfig = false;
        private int previousFlags;
        private int previousActions;
        private int previousTextSelectionBase;
        private int previousTextSelectionExtent;
        private float previousScrollPosition;
        private float previousScrollExtentMax;
        private float previousScrollExtentMin;
        private String previousValue;
        private String previousLabel;
        private float left;
        private float top;
        private float right;
        private float bottom;
        private float[] transform;
        private SemanticsNode parent;
        private List<SemanticsNode> childrenInTraversalOrder = new ArrayList<SemanticsNode>();
        private List<SemanticsNode> childrenInHitTestOrder = new ArrayList<SemanticsNode>();
        private List<CustomAccessibilityAction> customAccessibilityActions;
        private CustomAccessibilityAction onTapOverride;
        private CustomAccessibilityAction onLongPressOverride;
        private boolean inverseTransformDirty = true;
        private float[] inverseTransform;
        private boolean globalGeometryDirty = true;
        private float[] globalTransform;
        private Rect globalRect;

        private static boolean nullableHasAncestor(SemanticsNode target, Predicate<SemanticsNode> tester) {
            return target != null && target.getAncestor(tester) != null;
        }

        SemanticsNode(@NonNull AccessibilityBridge accessibilityBridge) {
            this.accessibilityBridge = accessibilityBridge;
        }

        private SemanticsNode getAncestor(Predicate<SemanticsNode> tester) {
            SemanticsNode nextAncestor = this.parent;
            while (nextAncestor != null) {
                if (tester.test(nextAncestor)) {
                    return nextAncestor;
                }
                nextAncestor = nextAncestor.parent;
            }
            return null;
        }

        private boolean hasAction(@NonNull Action action) {
            return (this.actions & action.value) != 0;
        }

        private boolean hadAction(@NonNull Action action) {
            return (this.previousActions & action.value) != 0;
        }

        private boolean hasFlag(@NonNull Flag flag) {
            return (this.flags & flag.value) != 0;
        }

        private boolean hadFlag(@NonNull Flag flag) {
            if (!this.hadPreviousConfig) {
                Log.e(AccessibilityBridge.TAG, "Attempted to check hadFlag but had no previous config.");
            }
            return (this.previousFlags & flag.value) != 0;
        }

        private boolean didScroll() {
            return !Float.isNaN(this.scrollPosition) && !Float.isNaN(this.previousScrollPosition) && this.previousScrollPosition != this.scrollPosition;
        }

        private boolean didChangeLabel() {
            if (this.label == null && this.previousLabel == null) {
                return false;
            }
            return this.label == null || this.previousLabel == null || !this.label.equals(this.previousLabel);
        }

        private void log(@NonNull String indent, boolean recursive) {
            Log.i(AccessibilityBridge.TAG, indent + "SemanticsNode id=" + this.id + " label=" + this.label + " actions=" + this.actions + " flags=" + this.flags + "\n" + indent + "  +-- textDirection=" + (Object)((Object)this.textDirection) + "\n" + indent + "  +-- rect.ltrb=(" + this.left + ", " + this.top + ", " + this.right + ", " + this.bottom + ")\n" + indent + "  +-- transform=" + Arrays.toString(this.transform) + "\n");
            if (recursive) {
                String childIndent = indent + "  ";
                for (SemanticsNode child : this.childrenInTraversalOrder) {
                    child.log(childIndent, recursive);
                }
            }
        }

        private void updateWith(@NonNull ByteBuffer buffer, @NonNull String[] strings, @NonNull ByteBuffer[] stringAttributeArgs) {
            SemanticsNode child;
            int i;
            this.hadPreviousConfig = true;
            this.previousValue = this.value;
            this.previousLabel = this.label;
            this.previousFlags = this.flags;
            this.previousActions = this.actions;
            this.previousTextSelectionBase = this.textSelectionBase;
            this.previousTextSelectionExtent = this.textSelectionExtent;
            this.previousScrollPosition = this.scrollPosition;
            this.previousScrollExtentMax = this.scrollExtentMax;
            this.previousScrollExtentMin = this.scrollExtentMin;
            this.flags = buffer.getInt();
            this.actions = buffer.getInt();
            this.maxValueLength = buffer.getInt();
            this.currentValueLength = buffer.getInt();
            this.textSelectionBase = buffer.getInt();
            this.textSelectionExtent = buffer.getInt();
            this.platformViewId = buffer.getInt();
            this.scrollChildren = buffer.getInt();
            this.scrollIndex = buffer.getInt();
            this.scrollPosition = buffer.getFloat();
            this.scrollExtentMax = buffer.getFloat();
            this.scrollExtentMin = buffer.getFloat();
            int stringIndex = buffer.getInt();
            this.label = stringIndex == -1 ? null : strings[stringIndex];
            this.labelAttributes = this.getStringAttributesFromBuffer(buffer, stringAttributeArgs);
            stringIndex = buffer.getInt();
            this.value = stringIndex == -1 ? null : strings[stringIndex];
            this.valueAttributes = this.getStringAttributesFromBuffer(buffer, stringAttributeArgs);
            stringIndex = buffer.getInt();
            this.increasedValue = stringIndex == -1 ? null : strings[stringIndex];
            this.increasedValueAttributes = this.getStringAttributesFromBuffer(buffer, stringAttributeArgs);
            stringIndex = buffer.getInt();
            this.decreasedValue = stringIndex == -1 ? null : strings[stringIndex];
            this.decreasedValueAttributes = this.getStringAttributesFromBuffer(buffer, stringAttributeArgs);
            stringIndex = buffer.getInt();
            this.hint = stringIndex == -1 ? null : strings[stringIndex];
            this.hintAttributes = this.getStringAttributesFromBuffer(buffer, stringAttributeArgs);
            stringIndex = buffer.getInt();
            this.tooltip = stringIndex == -1 ? null : strings[stringIndex];
            this.textDirection = TextDirection.fromInt(buffer.getInt());
            this.left = buffer.getFloat();
            this.top = buffer.getFloat();
            this.right = buffer.getFloat();
            this.bottom = buffer.getFloat();
            if (this.transform == null) {
                this.transform = new float[16];
            }
            for (int i2 = 0; i2 < 16; ++i2) {
                this.transform[i2] = buffer.getFloat();
            }
            this.inverseTransformDirty = true;
            this.globalGeometryDirty = true;
            int childCount = buffer.getInt();
            this.childrenInTraversalOrder.clear();
            this.childrenInHitTestOrder.clear();
            for (i = 0; i < childCount; ++i) {
                child = this.accessibilityBridge.getOrCreateSemanticsNode(buffer.getInt());
                child.parent = this;
                this.childrenInTraversalOrder.add(child);
            }
            for (i = 0; i < childCount; ++i) {
                child = this.accessibilityBridge.getOrCreateSemanticsNode(buffer.getInt());
                child.parent = this;
                this.childrenInHitTestOrder.add(child);
            }
            int actionCount = buffer.getInt();
            if (actionCount == 0) {
                this.customAccessibilityActions = null;
            } else {
                if (this.customAccessibilityActions == null) {
                    this.customAccessibilityActions = new ArrayList<CustomAccessibilityAction>(actionCount);
                } else {
                    this.customAccessibilityActions.clear();
                }
                for (int i3 = 0; i3 < actionCount; ++i3) {
                    CustomAccessibilityAction action = this.accessibilityBridge.getOrCreateAccessibilityAction(buffer.getInt());
                    if (action.overrideId == Action.TAP.value) {
                        this.onTapOverride = action;
                    } else if (action.overrideId == Action.LONG_PRESS.value) {
                        this.onLongPressOverride = action;
                    } else {
                        if (action.overrideId != -1) {
                            Log.e(AccessibilityBridge.TAG, "Expected action.overrideId to be -1.");
                        }
                        this.customAccessibilityActions.add(action);
                    }
                    this.customAccessibilityActions.add(action);
                }
            }
        }

        private List<StringAttribute> getStringAttributesFromBuffer(@NonNull ByteBuffer buffer, @NonNull ByteBuffer[] stringAttributeArgs) {
            int attributesCount = buffer.getInt();
            if (attributesCount == -1) {
                return null;
            }
            ArrayList<StringAttribute> result = new ArrayList<StringAttribute>(attributesCount);
            block4: for (int i = 0; i < attributesCount; ++i) {
                int start = buffer.getInt();
                int end = buffer.getInt();
                StringAttributeType type = StringAttributeType.values()[buffer.getInt()];
                switch (type) {
                    case SPELLOUT: {
                        buffer.getInt();
                        SpellOutStringAttribute attribute = new SpellOutStringAttribute();
                        attribute.start = start;
                        attribute.end = end;
                        attribute.type = type;
                        result.add(attribute);
                        continue block4;
                    }
                    case LOCALE: {
                        int argsIndex = buffer.getInt();
                        ByteBuffer args = stringAttributeArgs[argsIndex];
                        LocaleStringAttribute attribute = new LocaleStringAttribute();
                        attribute.start = start;
                        attribute.end = end;
                        attribute.type = type;
                        attribute.locale = Charset.forName("UTF-8").decode(args).toString();
                        result.add(attribute);
                        continue block4;
                    }
                }
            }
            return result;
        }

        private void ensureInverseTransform() {
            if (!this.inverseTransformDirty) {
                return;
            }
            this.inverseTransformDirty = false;
            if (this.inverseTransform == null) {
                this.inverseTransform = new float[16];
            }
            if (!Matrix.invertM((float[])this.inverseTransform, (int)0, (float[])this.transform, (int)0)) {
                Arrays.fill(this.inverseTransform, 0.0f);
            }
        }

        private Rect getGlobalRect() {
            if (this.globalGeometryDirty) {
                Log.e(AccessibilityBridge.TAG, "Attempted to getGlobalRect with a dirty geometry.");
            }
            return this.globalRect;
        }

        private SemanticsNode hitTest(float[] point, boolean stopAtPlatformView) {
            float w = point[3];
            float x = point[0] / w;
            float y = point[1] / w;
            if (x < this.left || x >= this.right || y < this.top || y >= this.bottom) {
                return null;
            }
            float[] transformedPoint = new float[4];
            for (SemanticsNode child : this.childrenInHitTestOrder) {
                if (child.hasFlag(Flag.IS_HIDDEN)) continue;
                child.ensureInverseTransform();
                Matrix.multiplyMV((float[])transformedPoint, (int)0, (float[])child.inverseTransform, (int)0, (float[])point, (int)0);
                SemanticsNode result = child.hitTest(transformedPoint, stopAtPlatformView);
                if (result == null) continue;
                return result;
            }
            boolean foundPlatformView = stopAtPlatformView && this.platformViewId != -1;
            return this.isFocusable() || foundPlatformView ? this : null;
        }

        private boolean isFocusable() {
            if (this.hasFlag(Flag.SCOPES_ROUTE)) {
                return false;
            }
            if (this.hasFlag(Flag.IS_FOCUSABLE)) {
                return true;
            }
            return (this.actions & ~SCROLLABLE_ACTIONS) != 0 || (this.flags & FOCUSABLE_FLAGS) != 0 || this.label != null && !this.label.isEmpty() || this.value != null && !this.value.isEmpty() || this.hint != null && !this.hint.isEmpty();
        }

        private void collectRoutes(List<SemanticsNode> edges) {
            if (this.hasFlag(Flag.SCOPES_ROUTE)) {
                edges.add(this);
            }
            for (SemanticsNode child : this.childrenInTraversalOrder) {
                child.collectRoutes(edges);
            }
        }

        private String getRouteName() {
            if (this.hasFlag(Flag.NAMES_ROUTE) && this.label != null && !this.label.isEmpty()) {
                return this.label;
            }
            for (SemanticsNode child : this.childrenInTraversalOrder) {
                String newName = child.getRouteName();
                if (newName == null || newName.isEmpty()) continue;
                return newName;
            }
            return null;
        }

        private void updateRecursively(float[] ancestorTransform, Set<SemanticsNode> visitedObjects, boolean forceUpdate) {
            visitedObjects.add(this);
            if (this.globalGeometryDirty) {
                forceUpdate = true;
            }
            if (forceUpdate) {
                if (this.globalTransform == null) {
                    this.globalTransform = new float[16];
                }
                if (this.transform == null) {
                    Log.e(AccessibilityBridge.TAG, "transform has not been initialized for id = " + this.id);
                    this.accessibilityBridge.getRootSemanticsNode().log("Semantics tree:", true);
                    this.transform = new float[16];
                }
                Matrix.multiplyMM((float[])this.globalTransform, (int)0, (float[])ancestorTransform, (int)0, (float[])this.transform, (int)0);
                float[] sample = new float[4];
                sample[2] = 0.0f;
                sample[3] = 1.0f;
                float[] point1 = new float[4];
                float[] point2 = new float[4];
                float[] point3 = new float[4];
                float[] point4 = new float[4];
                sample[0] = this.left;
                sample[1] = this.top;
                this.transformPoint(point1, this.globalTransform, sample);
                sample[0] = this.right;
                sample[1] = this.top;
                this.transformPoint(point2, this.globalTransform, sample);
                sample[0] = this.right;
                sample[1] = this.bottom;
                this.transformPoint(point3, this.globalTransform, sample);
                sample[0] = this.left;
                sample[1] = this.bottom;
                this.transformPoint(point4, this.globalTransform, sample);
                if (this.globalRect == null) {
                    this.globalRect = new Rect();
                }
                this.globalRect.set(Math.round(this.min(point1[0], point2[0], point3[0], point4[0])), Math.round(this.min(point1[1], point2[1], point3[1], point4[1])), Math.round(this.max(point1[0], point2[0], point3[0], point4[0])), Math.round(this.max(point1[1], point2[1], point3[1], point4[1])));
                this.globalGeometryDirty = false;
            }
            if (this.globalTransform == null) {
                Log.e(AccessibilityBridge.TAG, "Expected globalTransform to not be null.");
            }
            if (this.globalRect == null) {
                Log.e(AccessibilityBridge.TAG, "Expected globalRect to not be null.");
            }
            int previousNodeId = -1;
            for (SemanticsNode child : this.childrenInTraversalOrder) {
                child.previousNodeId = previousNodeId;
                previousNodeId = child.id;
                child.updateRecursively(this.globalTransform, visitedObjects, forceUpdate);
            }
        }

        private void transformPoint(float[] result, float[] transform, float[] point) {
            Matrix.multiplyMV((float[])result, (int)0, (float[])transform, (int)0, (float[])point, (int)0);
            float w = result[3];
            result[0] = result[0] / w;
            result[1] = result[1] / w;
            result[2] = result[2] / w;
            result[3] = 0.0f;
        }

        private float min(float a, float b, float c, float d) {
            return Math.min(a, Math.min(b, Math.min(c, d)));
        }

        private float max(float a, float b, float c, float d) {
            return Math.max(a, Math.max(b, Math.max(c, d)));
        }

        private CharSequence getValue() {
            if (Build.VERSION.SDK_INT < 21) {
                return this.value;
            }
            return this.createSpannableString(this.value, this.valueAttributes);
        }

        private CharSequence getLabel() {
            if (Build.VERSION.SDK_INT < 21) {
                return this.label;
            }
            return this.createSpannableString(this.label, this.labelAttributes);
        }

        private CharSequence getHint() {
            if (Build.VERSION.SDK_INT < 21) {
                return this.hint;
            }
            return this.createSpannableString(this.hint, this.hintAttributes);
        }

        private CharSequence getValueLabelHint() {
            CharSequence[] array = new CharSequence[]{this.getValue(), this.getLabel(), this.getHint()};
            CharSequence result = null;
            for (CharSequence word : array) {
                if (word == null || word.length() <= 0) continue;
                result = result == null || result.length() == 0 ? word : TextUtils.concat((CharSequence[])new CharSequence[]{result, ", ", word});
            }
            return result;
        }

        private CharSequence getTextFieldHint() {
            CharSequence[] array = new CharSequence[]{this.getLabel(), this.getHint()};
            CharSequence result = null;
            for (CharSequence word : array) {
                if (word == null || word.length() <= 0) continue;
                result = result == null || result.length() == 0 ? word : TextUtils.concat((CharSequence[])new CharSequence[]{result, ", ", word});
            }
            return result;
        }

        @TargetApi(value=21)
        @RequiresApi(value=21)
        private SpannableString createSpannableString(String string, List<StringAttribute> attributes) {
            if (string == null) {
                return null;
            }
            SpannableString spannableString = new SpannableString((CharSequence)string);
            if (attributes != null) {
                for (StringAttribute attribute : attributes) {
                    switch (attribute.type) {
                        case SPELLOUT: {
                            TtsSpan ttsSpan = new TtsSpan.Builder("android.type.verbatim").build();
                            spannableString.setSpan((Object)ttsSpan, attribute.start, attribute.end, 0);
                            break;
                        }
                        case LOCALE: {
                            LocaleStringAttribute localeAttribute = (LocaleStringAttribute)attribute;
                            Locale locale = Locale.forLanguageTag(localeAttribute.locale);
                            LocaleSpan localeSpan = new LocaleSpan(locale);
                            spannableString.setSpan((Object)localeSpan, attribute.start, attribute.end, 0);
                            break;
                        }
                    }
                }
            }
            return spannableString;
        }
    }

    private static class LocaleStringAttribute
    extends StringAttribute {
        String locale;

        private LocaleStringAttribute() {
        }
    }

    private static class SpellOutStringAttribute
    extends StringAttribute {
        private SpellOutStringAttribute() {
        }
    }

    private static class StringAttribute {
        int start;
        int end;
        StringAttributeType type;

        private StringAttribute() {
        }
    }

    private static enum StringAttributeType {
        SPELLOUT,
        LOCALE;

    }

    private static class CustomAccessibilityAction {
        private int resourceId = -1;
        private int id = -1;
        private int overrideId = -1;
        private String label;
        private String hint;

        CustomAccessibilityAction() {
        }
    }

    private static enum TextDirection {
        UNKNOWN,
        LTR,
        RTL;


        public static TextDirection fromInt(int value) {
            switch (value) {
                case 1: {
                    return RTL;
                }
                case 2: {
                    return LTR;
                }
            }
            return UNKNOWN;
        }
    }

    private static enum AccessibilityFeature {
        ACCESSIBLE_NAVIGATION(1),
        INVERT_COLORS(2),
        DISABLE_ANIMATIONS(4),
        BOLD_TEXT(8),
        REDUCE_MOTION(16),
        HIGH_CONTRAST(32),
        ON_OFF_SWITCH_LABELS(64);

        final int value;

        private AccessibilityFeature(int value) {
            this.value = value;
        }
    }

    static enum Flag {
        HAS_CHECKED_STATE(1),
        IS_CHECKED(2),
        IS_SELECTED(4),
        IS_BUTTON(8),
        IS_TEXT_FIELD(16),
        IS_FOCUSED(32),
        HAS_ENABLED_STATE(64),
        IS_ENABLED(128),
        IS_IN_MUTUALLY_EXCLUSIVE_GROUP(256),
        IS_HEADER(512),
        IS_OBSCURED(1024),
        SCOPES_ROUTE(2048),
        NAMES_ROUTE(4096),
        IS_HIDDEN(8192),
        IS_IMAGE(16384),
        IS_LIVE_REGION(32768),
        HAS_TOGGLED_STATE(65536),
        IS_TOGGLED(131072),
        HAS_IMPLICIT_SCROLLING(262144),
        IS_MULTILINE(524288),
        IS_READ_ONLY(0x100000),
        IS_FOCUSABLE(0x200000),
        IS_LINK(0x400000),
        IS_SLIDER(0x800000),
        IS_KEYBOARD_KEY(0x1000000),
        IS_CHECK_STATE_MIXED(0x2000000);

        final int value;

        private Flag(int value) {
            this.value = value;
        }
    }

    public static enum Action {
        TAP(1),
        LONG_PRESS(2),
        SCROLL_LEFT(4),
        SCROLL_RIGHT(8),
        SCROLL_UP(16),
        SCROLL_DOWN(32),
        INCREASE(64),
        DECREASE(128),
        SHOW_ON_SCREEN(256),
        MOVE_CURSOR_FORWARD_BY_CHARACTER(512),
        MOVE_CURSOR_BACKWARD_BY_CHARACTER(1024),
        SET_SELECTION(2048),
        COPY(4096),
        CUT(8192),
        PASTE(16384),
        DID_GAIN_ACCESSIBILITY_FOCUS(32768),
        DID_LOSE_ACCESSIBILITY_FOCUS(65536),
        CUSTOM_ACTION(131072),
        DISMISS(262144),
        MOVE_CURSOR_FORWARD_BY_WORD(524288),
        MOVE_CURSOR_BACKWARD_BY_WORD(0x100000),
        SET_TEXT(0x200000);

        public final int value;

        private Action(int value) {
            this.value = value;
        }
    }

    public static interface OnAccessibilityChangeListener {
        public void onAccessibilityChanged(boolean var1, boolean var2);
    }
}

