/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.ColorSpace;
import android.graphics.ImageDecoder;
import android.os.Build;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.Size;
import android.util.TypedValue;
import android.view.Surface;
import android.view.SurfaceControl;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import com.getkeepsafe.relinker.ReLinker;
import io.flutter.Log;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.FlutterOverlaySurface;
import io.flutter.embedding.engine.dart.PlatformMessageHandler;
import io.flutter.embedding.engine.deferredcomponents.DeferredComponentManager;
import io.flutter.embedding.engine.mutatorsstack.FlutterMutatorsStack;
import io.flutter.embedding.engine.renderer.FlutterUiDisplayListener;
import io.flutter.embedding.engine.renderer.SurfaceTextureWrapper;
import io.flutter.embedding.engine.systemchannels.SettingsChannel;
import io.flutter.plugin.common.StandardMessageCodec;
import io.flutter.plugin.localization.LocalizationPlugin;
import io.flutter.plugin.platform.PlatformViewsController;
import io.flutter.plugin.platform.PlatformViewsController2;
import io.flutter.util.Preconditions;
import io.flutter.view.AccessibilityBridge;
import io.flutter.view.FlutterCallbackInformation;
import io.flutter.view.TextureRegistry;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@Keep
public class FlutterJNI {
    private static final String TAG = "FlutterJNI";
    private ReentrantReadWriteLock shellHolderLock = new ReentrantReadWriteLock();
    private static boolean loadLibraryCalled = false;
    private static boolean prefetchDefaultFontManagerCalled = false;
    private static boolean initCalled = false;
    @Nullable
    private static AsyncWaitForVsyncDelegate asyncWaitForVsyncDelegate;
    private static float refreshRateFPS;
    private static float displayWidth;
    private static float displayHeight;
    private static float displayDensity;
    @Nullable
    private static String vmServiceUri;
    @Nullable
    private Long nativeShellHolderId;
    @Nullable
    private AccessibilityDelegate accessibilityDelegate;
    @Nullable
    private PlatformMessageHandler platformMessageHandler;
    @Nullable
    private LocalizationPlugin localizationPlugin;
    @Nullable
    private PlatformViewsController platformViewsController;
    @Nullable
    private PlatformViewsController2 platformViewsController2;
    @Nullable
    private DeferredComponentManager deferredComponentManager;
    @NonNull
    private final Set<FlutterEngine.EngineLifecycleListener> engineLifecycleListeners = new CopyOnWriteArraySet<FlutterEngine.EngineLifecycleListener>();
    @NonNull
    private final Set<FlutterUiDisplayListener> flutterUiDisplayListeners = new CopyOnWriteArraySet<FlutterUiDisplayListener>();
    @NonNull
    private final Looper mainLooper = Looper.getMainLooper();

    public void loadLibrary(Context context) {
        if (loadLibraryCalled) {
            Log.w(TAG, "FlutterJNI.loadLibrary called more than once");
        }
        ReLinker.log(msg -> Log.d(TAG, msg)).loadLibrary(context, "flutter");
        loadLibraryCalled = true;
    }

    private static native void nativePrefetchDefaultFontManager();

    public void prefetchDefaultFontManager() {
        if (prefetchDefaultFontManagerCalled) {
            Log.w(TAG, "FlutterJNI.prefetchDefaultFontManager called more than once");
        }
        FlutterJNI.nativePrefetchDefaultFontManager();
        prefetchDefaultFontManagerCalled = true;
    }

    private static native void nativeInit(@NonNull Context var0, @NonNull String[] var1, @Nullable String var2, @NonNull String var3, @NonNull String var4, long var5, int var7);

    public void init(@NonNull Context context, @NonNull String[] args, @Nullable String bundlePath, @NonNull String appStoragePath, @NonNull String engineCachesPath, long initTimeMillis, int apiLevel) {
        if (initCalled) {
            Log.w(TAG, "FlutterJNI.init called more than once");
        }
        FlutterJNI.nativeInit(context, args, bundlePath, appStoragePath, engineCachesPath, initTimeMillis, apiLevel);
        initCalled = true;
    }

    private native boolean nativeGetIsSoftwareRenderingEnabled();

    @UiThread
    public boolean getIsSoftwareRenderingEnabled() {
        return this.nativeGetIsSoftwareRenderingEnabled();
    }

    @Nullable
    public static String getVMServiceUri() {
        return vmServiceUri;
    }

    public void setRefreshRateFPS(float refreshRateFPS) {
        FlutterJNI.refreshRateFPS = refreshRateFPS;
        this.updateRefreshRate();
    }

    public void updateDisplayMetrics(int displayId, float width, float height, float density) {
        displayWidth = width;
        displayHeight = height;
        displayDensity = density;
        if (!loadLibraryCalled) {
            return;
        }
        this.nativeUpdateDisplayMetrics(this.nativeShellHolderId);
    }

    private native void nativeUpdateDisplayMetrics(long var1);

    public void updateRefreshRate() {
        if (!loadLibraryCalled) {
            return;
        }
        this.nativeUpdateRefreshRate(refreshRateFPS);
    }

    private native void nativeUpdateRefreshRate(float var1);

    public void setAsyncWaitForVsyncDelegate(@Nullable AsyncWaitForVsyncDelegate delegate) {
        asyncWaitForVsyncDelegate = delegate;
    }

    private static void asyncWaitForVsync(long cookie) {
        if (asyncWaitForVsyncDelegate == null) {
            throw new IllegalStateException("An AsyncWaitForVsyncDelegate must be registered with FlutterJNI before asyncWaitForVsync() is invoked.");
        }
        asyncWaitForVsyncDelegate.asyncWaitForVsync(cookie);
    }

    private native void nativeOnVsync(long var1, long var3, long var5);

    public void onVsync(long frameDelayNanos, long refreshPeriodNanos, long cookie) {
        this.nativeOnVsync(frameDelayNanos, refreshPeriodNanos, cookie);
    }

    @Deprecated
    @NonNull
    public static native FlutterCallbackInformation nativeLookupCallbackInformation(long var0);

    private native boolean nativeFlutterTextUtilsIsEmoji(int var1);

    public boolean isCodePointEmoji(int codePoint) {
        return this.nativeFlutterTextUtilsIsEmoji(codePoint);
    }

    private native boolean nativeFlutterTextUtilsIsEmojiModifier(int var1);

    public boolean isCodePointEmojiModifier(int codePoint) {
        return this.nativeFlutterTextUtilsIsEmojiModifier(codePoint);
    }

    private native boolean nativeFlutterTextUtilsIsEmojiModifierBase(int var1);

    public boolean isCodePointEmojiModifierBase(int codePoint) {
        return this.nativeFlutterTextUtilsIsEmojiModifierBase(codePoint);
    }

    private native boolean nativeFlutterTextUtilsIsVariationSelector(int var1);

    public boolean isCodePointVariantSelector(int codePoint) {
        return this.nativeFlutterTextUtilsIsVariationSelector(codePoint);
    }

    private native boolean nativeFlutterTextUtilsIsRegionalIndicator(int var1);

    public boolean isCodePointRegionalIndicator(int codePoint) {
        return this.nativeFlutterTextUtilsIsRegionalIndicator(codePoint);
    }

    public boolean isAttached() {
        return this.nativeShellHolderId != null;
    }

    @UiThread
    public void attachToNative() {
        this.ensureRunningOnMainThread();
        this.ensureNotAttachedToNative();
        this.shellHolderLock.writeLock().lock();
        try {
            this.nativeShellHolderId = this.performNativeAttach(this);
        }
        finally {
            this.shellHolderLock.writeLock().unlock();
        }
    }

    @VisibleForTesting
    public long performNativeAttach(@NonNull FlutterJNI flutterJNI) {
        return this.nativeAttach(flutterJNI);
    }

    private native long nativeAttach(@NonNull FlutterJNI var1);

    @UiThread
    @NonNull
    public FlutterJNI spawn(@Nullable String entrypointFunctionName, @Nullable String pathToEntrypointFunction, @Nullable String initialRoute, @Nullable List<String> entrypointArgs, long engineId) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        FlutterJNI spawnedJNI = this.nativeSpawn(this.nativeShellHolderId, entrypointFunctionName, pathToEntrypointFunction, initialRoute, entrypointArgs, engineId);
        Preconditions.checkState(spawnedJNI.nativeShellHolderId != null && spawnedJNI.nativeShellHolderId != 0L, "Failed to spawn new JNI connected shell from existing shell.");
        return spawnedJNI;
    }

    private native FlutterJNI nativeSpawn(long var1, @Nullable String var3, @Nullable String var4, @Nullable String var5, @Nullable List<String> var6, long var7);

    @UiThread
    public void detachFromNativeAndReleaseResources() {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.shellHolderLock.writeLock().lock();
        try {
            this.nativeDestroy(this.nativeShellHolderId);
            this.nativeShellHolderId = null;
        }
        finally {
            this.shellHolderLock.writeLock().unlock();
        }
    }

    private native void nativeDestroy(long var1);

    private void ensureNotAttachedToNative() {
        if (this.nativeShellHolderId != null) {
            throw new RuntimeException("Cannot execute operation because FlutterJNI is attached to native.");
        }
    }

    private void ensureAttachedToNative() {
        if (this.nativeShellHolderId == null) {
            throw new RuntimeException("Cannot execute operation because FlutterJNI is not attached to native.");
        }
    }

    @UiThread
    public void addIsDisplayingFlutterUiListener(@NonNull FlutterUiDisplayListener listener) {
        this.ensureRunningOnMainThread();
        this.flutterUiDisplayListeners.add(listener);
    }

    @UiThread
    public void removeIsDisplayingFlutterUiListener(@NonNull FlutterUiDisplayListener listener) {
        this.ensureRunningOnMainThread();
        this.flutterUiDisplayListeners.remove(listener);
    }

    public static native void nativeImageHeaderCallback(long var0, int var2, int var3);

    @VisibleForTesting
    @Nullable
    public static Bitmap decodeImage(@NonNull ByteBuffer buffer, long imageGeneratorAddress) {
        if (Build.VERSION.SDK_INT >= 28) {
            ImageDecoder.Source source = ImageDecoder.createSource((ByteBuffer)buffer);
            try {
                return ImageDecoder.decodeBitmap((ImageDecoder.Source)source, (decoder, info, src) -> {
                    decoder.setTargetColorSpace(ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SRGB));
                    decoder.setAllocator(1);
                    Size size = info.getSize();
                    FlutterJNI.nativeImageHeaderCallback(imageGeneratorAddress, size.getWidth(), size.getHeight());
                });
            }
            catch (IOException e) {
                Log.e(TAG, "Failed to decode image", e);
                return null;
            }
        }
        return null;
    }

    @VisibleForTesting
    @UiThread
    public void onFirstFrame() {
        this.ensureRunningOnMainThread();
        for (FlutterUiDisplayListener listener : this.flutterUiDisplayListeners) {
            listener.onFlutterUiDisplayed();
        }
    }

    @VisibleForTesting
    @UiThread
    void onRenderingStopped() {
        this.ensureRunningOnMainThread();
        for (FlutterUiDisplayListener listener : this.flutterUiDisplayListeners) {
            listener.onFlutterUiNoLongerDisplayed();
        }
    }

    @UiThread
    public void onSurfaceCreated(@NonNull Surface surface) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeSurfaceCreated(this.nativeShellHolderId, surface);
    }

    private native void nativeSurfaceCreated(long var1, @NonNull Surface var3);

    @UiThread
    public void onSurfaceWindowChanged(@NonNull Surface surface) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeSurfaceWindowChanged(this.nativeShellHolderId, surface);
    }

    private native void nativeSurfaceWindowChanged(long var1, @NonNull Surface var3);

    @UiThread
    public void onSurfaceChanged(int width, int height) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeSurfaceChanged(this.nativeShellHolderId, width, height);
    }

    private native void nativeSurfaceChanged(long var1, int var3, int var4);

    @UiThread
    public void onSurfaceDestroyed() {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.onRenderingStopped();
        this.nativeSurfaceDestroyed(this.nativeShellHolderId);
    }

    private native void nativeSurfaceDestroyed(long var1);

    @UiThread
    public void setViewportMetrics(float devicePixelRatio, int physicalWidth, int physicalHeight, int physicalPaddingTop, int physicalPaddingRight, int physicalPaddingBottom, int physicalPaddingLeft, int physicalViewInsetTop, int physicalViewInsetRight, int physicalViewInsetBottom, int physicalViewInsetLeft, int systemGestureInsetTop, int systemGestureInsetRight, int systemGestureInsetBottom, int systemGestureInsetLeft, int physicalTouchSlop, int[] displayFeaturesBounds, int[] displayFeaturesType, int[] displayFeaturesState) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeSetViewportMetrics(this.nativeShellHolderId, devicePixelRatio, physicalWidth, physicalHeight, physicalPaddingTop, physicalPaddingRight, physicalPaddingBottom, physicalPaddingLeft, physicalViewInsetTop, physicalViewInsetRight, physicalViewInsetBottom, physicalViewInsetLeft, systemGestureInsetTop, systemGestureInsetRight, systemGestureInsetBottom, systemGestureInsetLeft, physicalTouchSlop, displayFeaturesBounds, displayFeaturesType, displayFeaturesState);
    }

    private native void nativeSetViewportMetrics(long var1, float var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17, int var18, int[] var19, int[] var20, int[] var21);

    @UiThread
    public void dispatchPointerDataPacket(@NonNull ByteBuffer buffer, int position) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeDispatchPointerDataPacket(this.nativeShellHolderId, buffer, position);
    }

    private native void nativeDispatchPointerDataPacket(long var1, @NonNull ByteBuffer var3, int var4);

    @UiThread
    public void setPlatformViewsController(@NonNull PlatformViewsController platformViewsController) {
        this.ensureRunningOnMainThread();
        this.platformViewsController = platformViewsController;
    }

    @UiThread
    public void setPlatformViewsController2(@NonNull PlatformViewsController2 platformViewsController2) {
        this.ensureRunningOnMainThread();
        this.platformViewsController2 = platformViewsController2;
    }

    @UiThread
    public void setAccessibilityDelegate(@Nullable AccessibilityDelegate accessibilityDelegate) {
        this.ensureRunningOnMainThread();
        this.accessibilityDelegate = accessibilityDelegate;
    }

    @UiThread
    private void updateSemantics(@NonNull ByteBuffer buffer, @NonNull String[] strings, @NonNull ByteBuffer[] stringAttributeArgs) {
        this.ensureRunningOnMainThread();
        if (this.accessibilityDelegate != null) {
            this.accessibilityDelegate.updateSemantics(buffer, strings, stringAttributeArgs);
        }
    }

    @UiThread
    private void updateCustomAccessibilityActions(@NonNull ByteBuffer buffer, @NonNull String[] strings) {
        this.ensureRunningOnMainThread();
        if (this.accessibilityDelegate != null) {
            this.accessibilityDelegate.updateCustomAccessibilityActions(buffer, strings);
        }
    }

    public void dispatchSemanticsAction(int nodeId, @NonNull AccessibilityBridge.Action action) {
        this.dispatchSemanticsAction(nodeId, action, null);
    }

    public void dispatchSemanticsAction(int nodeId, @NonNull AccessibilityBridge.Action action, @Nullable Object args) {
        this.ensureAttachedToNative();
        ByteBuffer encodedArgs = null;
        int position = 0;
        if (args != null) {
            encodedArgs = StandardMessageCodec.INSTANCE.encodeMessage(args);
            position = encodedArgs.position();
        }
        this.dispatchSemanticsAction(nodeId, action.value, encodedArgs, position);
    }

    @UiThread
    public void dispatchSemanticsAction(int nodeId, int action, @Nullable ByteBuffer args, int argsPosition) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeDispatchSemanticsAction(this.nativeShellHolderId, nodeId, action, args, argsPosition);
    }

    private native void nativeDispatchSemanticsAction(long var1, int var3, int var4, @Nullable ByteBuffer var5, int var6);

    @UiThread
    public void setSemanticsEnabled(boolean enabled) {
        this.ensureRunningOnMainThread();
        if (this.isAttached()) {
            this.setSemanticsEnabledInNative(enabled);
        }
    }

    @VisibleForTesting
    public void setSemanticsEnabledInNative(boolean enabled) {
        this.nativeSetSemanticsEnabled(this.nativeShellHolderId, enabled);
    }

    private native void nativeSetSemanticsEnabled(long var1, boolean var3);

    @UiThread
    public void setAccessibilityFeatures(int flags) {
        this.ensureRunningOnMainThread();
        if (this.isAttached()) {
            this.setAccessibilityFeaturesInNative(flags);
        }
    }

    @VisibleForTesting
    public void setAccessibilityFeaturesInNative(int flags) {
        this.nativeSetAccessibilityFeatures(this.nativeShellHolderId, flags);
    }

    private native void nativeSetAccessibilityFeatures(long var1, int var3);

    @UiThread
    public void registerTexture(long textureId, @NonNull SurfaceTextureWrapper textureWrapper) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeRegisterTexture(this.nativeShellHolderId, textureId, new WeakReference<SurfaceTextureWrapper>(textureWrapper));
    }

    private native void nativeRegisterTexture(long var1, long var3, @NonNull WeakReference<SurfaceTextureWrapper> var5);

    @UiThread
    public void registerImageTexture(long textureId, @NonNull TextureRegistry.ImageConsumer imageTexture, boolean resetOnBackground) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeRegisterImageTexture(this.nativeShellHolderId, textureId, new WeakReference<TextureRegistry.ImageConsumer>(imageTexture), resetOnBackground);
    }

    private native void nativeRegisterImageTexture(long var1, long var3, @NonNull WeakReference<TextureRegistry.ImageConsumer> var5, boolean var6);

    @UiThread
    public void markTextureFrameAvailable(long textureId) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeMarkTextureFrameAvailable(this.nativeShellHolderId, textureId);
    }

    private native void nativeMarkTextureFrameAvailable(long var1, long var3);

    @UiThread
    public void scheduleFrame() {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeScheduleFrame(this.nativeShellHolderId);
    }

    private native void nativeScheduleFrame(long var1);

    @UiThread
    public void unregisterTexture(long textureId) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeUnregisterTexture(this.nativeShellHolderId, textureId);
    }

    private native void nativeUnregisterTexture(long var1, long var3);

    @UiThread
    public void runBundleAndSnapshotFromLibrary(@NonNull String bundlePath, @Nullable String entrypointFunctionName, @Nullable String pathToEntrypointFunction, @NonNull AssetManager assetManager, @Nullable List<String> entrypointArgs, long engineId) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeRunBundleAndSnapshotFromLibrary(this.nativeShellHolderId, bundlePath, entrypointFunctionName, pathToEntrypointFunction, assetManager, entrypointArgs, engineId);
    }

    private native void nativeRunBundleAndSnapshotFromLibrary(long var1, @NonNull String var3, @Nullable String var4, @Nullable String var5, @NonNull AssetManager var6, @Nullable List<String> var7, long var8);

    @UiThread
    public void setPlatformMessageHandler(@Nullable PlatformMessageHandler platformMessageHandler) {
        this.ensureRunningOnMainThread();
        this.platformMessageHandler = platformMessageHandler;
    }

    private native void nativeCleanupMessageData(long var1);

    public void cleanupMessageData(long messageData) {
        this.nativeCleanupMessageData(messageData);
    }

    @VisibleForTesting
    public void handlePlatformMessage(@NonNull String channel, ByteBuffer message, int replyId, long messageData) {
        if (this.platformMessageHandler != null) {
            this.platformMessageHandler.handleMessageFromDart(channel, message, replyId, messageData);
        } else {
            this.nativeCleanupMessageData(messageData);
        }
    }

    private void handlePlatformMessageResponse(int replyId, ByteBuffer reply) {
        if (this.platformMessageHandler != null) {
            this.platformMessageHandler.handlePlatformMessageResponse(replyId, reply);
        }
    }

    @UiThread
    public void dispatchEmptyPlatformMessage(@NonNull String channel, int responseId) {
        this.ensureRunningOnMainThread();
        if (this.isAttached()) {
            this.nativeDispatchEmptyPlatformMessage(this.nativeShellHolderId, channel, responseId);
        } else {
            Log.w(TAG, "Tried to send a platform message to Flutter, but FlutterJNI was detached from native C++. Could not send. Channel: " + channel + ". Response ID: " + responseId);
        }
    }

    private native void nativeDispatchEmptyPlatformMessage(long var1, @NonNull String var3, int var4);

    @UiThread
    public void dispatchPlatformMessage(@NonNull String channel, @Nullable ByteBuffer message, int position, int responseId) {
        this.ensureRunningOnMainThread();
        if (this.isAttached()) {
            this.nativeDispatchPlatformMessage(this.nativeShellHolderId, channel, message, position, responseId);
        } else {
            Log.w(TAG, "Tried to send a platform message to Flutter, but FlutterJNI was detached from native C++. Could not send. Channel: " + channel + ". Response ID: " + responseId);
        }
    }

    private native void nativeDispatchPlatformMessage(long var1, @NonNull String var3, @Nullable ByteBuffer var4, int var5, int var6);

    public void invokePlatformMessageEmptyResponseCallback(int responseId) {
        this.shellHolderLock.readLock().lock();
        try {
            if (this.isAttached()) {
                this.nativeInvokePlatformMessageEmptyResponseCallback(this.nativeShellHolderId, responseId);
            } else {
                Log.w(TAG, "Tried to send a platform message response, but FlutterJNI was detached from native C++. Could not send. Response ID: " + responseId);
            }
        }
        finally {
            this.shellHolderLock.readLock().unlock();
        }
    }

    private native void nativeInvokePlatformMessageEmptyResponseCallback(long var1, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokePlatformMessageResponseCallback(int responseId, @NonNull ByteBuffer message, int position) {
        if (!message.isDirect()) {
            throw new IllegalArgumentException("Expected a direct ByteBuffer.");
        }
        this.shellHolderLock.readLock().lock();
        try {
            if (this.isAttached()) {
                this.nativeInvokePlatformMessageResponseCallback(this.nativeShellHolderId, responseId, message, position);
            } else {
                Log.w(TAG, "Tried to send a platform message response, but FlutterJNI was detached from native C++. Could not send. Response ID: " + responseId);
            }
        }
        finally {
            this.shellHolderLock.readLock().unlock();
        }
    }

    private native void nativeInvokePlatformMessageResponseCallback(long var1, int var3, @Nullable ByteBuffer var4, int var5);

    @UiThread
    public void addEngineLifecycleListener(@NonNull FlutterEngine.EngineLifecycleListener engineLifecycleListener) {
        this.ensureRunningOnMainThread();
        this.engineLifecycleListeners.add(engineLifecycleListener);
    }

    @UiThread
    public void removeEngineLifecycleListener(@NonNull FlutterEngine.EngineLifecycleListener engineLifecycleListener) {
        this.ensureRunningOnMainThread();
        this.engineLifecycleListeners.remove(engineLifecycleListener);
    }

    private void onPreEngineRestart() {
        for (FlutterEngine.EngineLifecycleListener listener : this.engineLifecycleListeners) {
            listener.onPreEngineRestart();
        }
    }

    @UiThread
    public void onDisplayOverlaySurface(int id2, int x, int y, int width, int height) {
        this.ensureRunningOnMainThread();
        if (this.platformViewsController == null) {
            throw new RuntimeException("platformViewsController must be set before attempting to position an overlay surface");
        }
        this.platformViewsController.onDisplayOverlaySurface(id2, x, y, width, height);
    }

    @UiThread
    public void onBeginFrame() {
        this.ensureRunningOnMainThread();
        if (this.platformViewsController == null) {
            throw new RuntimeException("platformViewsController must be set before attempting to begin the frame");
        }
        this.platformViewsController.onBeginFrame();
    }

    @UiThread
    public void onEndFrame() {
        this.ensureRunningOnMainThread();
        if (this.platformViewsController == null) {
            throw new RuntimeException("platformViewsController must be set before attempting to end the frame");
        }
        this.platformViewsController.onEndFrame();
    }

    @UiThread
    public FlutterOverlaySurface createOverlaySurface() {
        this.ensureRunningOnMainThread();
        if (this.platformViewsController == null) {
            throw new RuntimeException("platformViewsController must be set before attempting to position an overlay surface");
        }
        return this.platformViewsController.createOverlaySurface();
    }

    @UiThread
    public void destroyOverlaySurfaces() {
        this.ensureRunningOnMainThread();
        if (this.platformViewsController == null) {
            throw new RuntimeException("platformViewsController must be set before attempting to destroy an overlay surface");
        }
        this.platformViewsController.destroyOverlaySurfaces();
    }

    @SuppressLint(value={"NewApi"})
    @UiThread
    public SurfaceControl.Transaction createTransaction() {
        if (this.platformViewsController2 == null) {
            throw new RuntimeException("");
        }
        return this.platformViewsController2.createTransaction();
    }

    @SuppressLint(value={"NewApi"})
    @UiThread
    public void swapTransactions() {
        if (this.platformViewsController2 == null) {
            throw new RuntimeException("");
        }
        this.platformViewsController2.swapTransactions();
    }

    @SuppressLint(value={"NewApi"})
    @UiThread
    public void applyTransactions() {
        if (this.platformViewsController2 == null) {
            throw new RuntimeException("");
        }
        this.platformViewsController2.applyTransactions();
    }

    @SuppressLint(value={"NewApi"})
    @UiThread
    public void endFrame2() {
        if (this.platformViewsController2 == null) {
            throw new RuntimeException("");
        }
        this.platformViewsController2.onEndFrame();
    }

    @SuppressLint(value={"NewApi"})
    @UiThread
    public FlutterOverlaySurface createOverlaySurface2() {
        if (this.platformViewsController2 == null) {
            throw new RuntimeException("platformViewsController must be set before attempting to position an overlay surface");
        }
        return this.platformViewsController2.createOverlaySurface();
    }

    @SuppressLint(value={"NewApi"})
    @UiThread
    public void showOverlaySurface2() {
        if (this.platformViewsController2 == null) {
            throw new RuntimeException("platformViewsController must be set before attempting to destroy an overlay surface");
        }
        this.platformViewsController2.showOverlaySurface();
    }

    @SuppressLint(value={"NewApi"})
    @UiThread
    public void hideOverlaySurface2() {
        if (this.platformViewsController2 == null) {
            throw new RuntimeException("platformViewsController must be set before attempting to destroy an overlay surface");
        }
        this.platformViewsController2.hideOverlaySurface();
    }

    @SuppressLint(value={"NewApi"})
    @UiThread
    public void destroyOverlaySurface2() {
        this.ensureRunningOnMainThread();
        if (this.platformViewsController2 == null) {
            throw new RuntimeException("platformViewsController must be set before attempting to destroy an overlay surface");
        }
        this.platformViewsController2.destroyOverlaySurface();
    }

    @UiThread
    @SuppressLint(value={"NewApi"})
    public void onDisplayPlatformView2(int viewId, int x, int y, int width, int height, int viewWidth, int viewHeight, FlutterMutatorsStack mutatorsStack) {
        this.ensureRunningOnMainThread();
        if (this.platformViewsController2 == null) {
            throw new RuntimeException("platformViewsController must be set before attempting to position a platform view");
        }
        this.platformViewsController2.onDisplayPlatformView(viewId, x, y, width, height, viewWidth, viewHeight, mutatorsStack);
    }

    @UiThread
    public void setLocalizationPlugin(@Nullable LocalizationPlugin localizationPlugin) {
        this.ensureRunningOnMainThread();
        this.localizationPlugin = localizationPlugin;
    }

    @VisibleForTesting
    public String[] computePlatformResolvedLocale(@NonNull String[] strings) {
        if (this.localizationPlugin == null) {
            return new String[0];
        }
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
        int localeDataLength = 3;
        for (int i = 0; i < strings.length; i += 3) {
            String languageCode = strings[i + 0];
            String countryCode = strings[i + 1];
            String scriptCode = strings[i + 2];
            Locale.Builder localeBuilder = new Locale.Builder();
            if (!languageCode.isEmpty()) {
                localeBuilder.setLanguage(languageCode);
            }
            if (!countryCode.isEmpty()) {
                localeBuilder.setRegion(countryCode);
            }
            if (!scriptCode.isEmpty()) {
                localeBuilder.setScript(scriptCode);
            }
            supportedLocales.add(localeBuilder.build());
        }
        Locale result = this.localizationPlugin.resolveNativeLocale(supportedLocales);
        if (result == null) {
            return new String[0];
        }
        String[] output = new String[]{result.getLanguage(), result.getCountry(), result.getScript()};
        return output;
    }

    @Nullable
    public float getScaledFontSize(float fontSize, int configurationId) {
        DisplayMetrics metrics = SettingsChannel.getPastDisplayMetrics(configurationId);
        if (metrics == null) {
            Log.e(TAG, "getScaledFontSize called with configurationId " + String.valueOf(configurationId) + ", which can't be found.");
            return -1.0f;
        }
        return TypedValue.applyDimension((int)2, (float)fontSize, (DisplayMetrics)metrics) / metrics.density;
    }

    @UiThread
    public void setDeferredComponentManager(@Nullable DeferredComponentManager deferredComponentManager) {
        this.ensureRunningOnMainThread();
        this.deferredComponentManager = deferredComponentManager;
        if (deferredComponentManager != null) {
            deferredComponentManager.setJNI(this);
        }
    }

    @UiThread
    public void requestDartDeferredLibrary(int loadingUnitId) {
        if (this.deferredComponentManager != null) {
            this.deferredComponentManager.installDeferredComponent(loadingUnitId, null);
        } else {
            Log.e(TAG, "No DeferredComponentManager found. Android setup must be completed before using split AOT deferred components.");
        }
    }

    @UiThread
    public void loadDartDeferredLibrary(int loadingUnitId, @NonNull String[] searchPaths) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeLoadDartDeferredLibrary(this.nativeShellHolderId, loadingUnitId, searchPaths);
    }

    private native void nativeLoadDartDeferredLibrary(long var1, int var3, @NonNull String[] var4);

    @UiThread
    public void updateJavaAssetManager(@NonNull AssetManager assetManager, @NonNull String assetBundlePath) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeUpdateJavaAssetManager(this.nativeShellHolderId, assetManager, assetBundlePath);
    }

    private native void nativeUpdateJavaAssetManager(long var1, @NonNull AssetManager var3, @NonNull String var4);

    @UiThread
    public void deferredComponentInstallFailure(int loadingUnitId, @NonNull String error, boolean isTransient) {
        this.ensureRunningOnMainThread();
        this.nativeDeferredComponentInstallFailure(loadingUnitId, error, isTransient);
    }

    private native void nativeDeferredComponentInstallFailure(int var1, @NonNull String var2, boolean var3);

    @UiThread
    public void onDisplayPlatformView(int viewId, int x, int y, int width, int height, int viewWidth, int viewHeight, FlutterMutatorsStack mutatorsStack) {
        this.ensureRunningOnMainThread();
        if (this.platformViewsController == null) {
            throw new RuntimeException("platformViewsController must be set before attempting to position a platform view");
        }
        this.platformViewsController.onDisplayPlatformView(viewId, x, y, width, height, viewWidth, viewHeight, mutatorsStack);
    }

    @UiThread
    public Bitmap getBitmap() {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        return this.nativeGetBitmap(this.nativeShellHolderId);
    }

    private native Bitmap nativeGetBitmap(long var1);

    @UiThread
    public void notifyLowMemoryWarning() {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeNotifyLowMemoryWarning(this.nativeShellHolderId);
    }

    private native void nativeNotifyLowMemoryWarning(long var1);

    private void ensureRunningOnMainThread() {
        if (Looper.myLooper() != this.mainLooper) {
            throw new RuntimeException("Methods marked with @UiThread must be executed on the main thread. Current thread: " + Thread.currentThread().getName());
        }
    }

    public boolean IsSurfaceControlEnabled() {
        return this.nativeIsSurfaceControlEnabled(this.nativeShellHolderId);
    }

    private native boolean nativeIsSurfaceControlEnabled(long var1);

    static {
        refreshRateFPS = 60.0f;
        displayWidth = -1.0f;
        displayHeight = -1.0f;
        displayDensity = -1.0f;
    }

    public static interface AsyncWaitForVsyncDelegate {
        public void asyncWaitForVsync(long var1);
    }

    public static interface AccessibilityDelegate {
        public void updateCustomAccessibilityActions(@NonNull ByteBuffer var1, @NonNull String[] var2);

        public void updateSemantics(@NonNull ByteBuffer var1, @NonNull String[] var2, @NonNull ByteBuffer[] var3);
    }

    public static class Factory {
        public FlutterJNI provideFlutterJNI() {
            return new FlutterJNI();
        }
    }
}

