/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.text.SpannableString;
import android.text.style.LocaleSpan;
import android.text.style.TtsSpan;
import android.text.style.URLSpan;
import java.util.List;
import java.util.Locale;

public class AccessibilityStringBuilder {
    private String string;
    private List<StringAttribute> attributes;
    private String locale;
    private String url;

    AccessibilityStringBuilder() {
    }

    AccessibilityStringBuilder addString(String string) {
        this.string = string;
        return this;
    }

    AccessibilityStringBuilder addAttributes(List<StringAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    AccessibilityStringBuilder addLocale(String locale) {
        this.locale = locale;
        return this;
    }

    AccessibilityStringBuilder addUrl(String url) {
        this.url = url;
        return this;
    }

    CharSequence build() {
        if (this.string == null) {
            return null;
        }
        SpannableString spannableString = new SpannableString((CharSequence)this.string);
        if (this.attributes != null) {
            for (StringAttribute attribute : this.attributes) {
                switch (attribute.type) {
                    case SPELLOUT: {
                        TtsSpan ttsSpan = new TtsSpan.Builder("android.type.verbatim").build();
                        spannableString.setSpan((Object)ttsSpan, attribute.start, attribute.end, 0);
                        break;
                    }
                    case LOCALE: {
                        LocaleStringAttribute localeAttribute = (LocaleStringAttribute)attribute;
                        Locale locale = Locale.forLanguageTag(localeAttribute.locale);
                        LocaleSpan localeSpan = new LocaleSpan(locale);
                        spannableString.setSpan((Object)localeSpan, attribute.start, attribute.end, 0);
                        break;
                    }
                }
            }
        }
        if (this.url != null && !this.url.isEmpty()) {
            URLSpan urlSpan = new URLSpan(this.url);
            spannableString.setSpan((Object)urlSpan, 0, this.string.length(), 0);
        }
        if (this.locale != null && !this.locale.isEmpty()) {
            Locale localeObject = Locale.forLanguageTag(this.locale);
            LocaleSpan localeSpan = new LocaleSpan(localeObject);
            spannableString.setSpan((Object)localeSpan, 0, this.string.length(), 0);
        }
        return spannableString;
    }

    public static class StringAttribute {
        int start;
        int end;
        StringAttributeType type;
    }

    public static enum StringAttributeType {
        SPELLOUT,
        LOCALE;

    }

    public static class LocaleStringAttribute
    extends StringAttribute {
        String locale;
    }

    private static class UrlStringAttribute
    extends StringAttribute {
        String url;

        private UrlStringAttribute() {
        }
    }

    public static class SpellOutStringAttribute
    extends StringAttribute {
    }
}

