/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.mutatorsstack;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;

@Keep
public class FlutterMutatorsStack {
    @NonNull
    private List<FlutterMutator> mutators = new ArrayList<FlutterMutator>();
    private List<Path> finalClippingPaths;
    private Matrix finalMatrix = new Matrix();
    private float finalOpacity = 1.0f;

    public FlutterMutatorsStack() {
        this.finalClippingPaths = new ArrayList<Path>();
    }

    public void pushTransform(float[] values) {
        Matrix matrix = new Matrix();
        matrix.setValues(values);
        FlutterMutator mutator = new FlutterMutator(matrix);
        this.mutators.add(mutator);
        this.finalMatrix.preConcat(mutator.getMatrix());
    }

    public void pushClipRect(int left, int top, int right, int bottom) {
        Rect rect = new Rect(left, top, right, bottom);
        FlutterMutator mutator = new FlutterMutator(rect);
        this.mutators.add(mutator);
        Path path = new Path();
        path.addRect(new RectF(rect), Path.Direction.CCW);
        path.transform(this.finalMatrix);
        this.finalClippingPaths.add(path);
    }

    public void pushClipRRect(int left, int top, int right, int bottom, float[] radiis) {
        Rect rect = new Rect(left, top, right, bottom);
        FlutterMutator mutator = new FlutterMutator(rect, radiis);
        this.mutators.add(mutator);
        Path path = new Path();
        path.addRoundRect(new RectF(rect), radiis, Path.Direction.CCW);
        path.transform(this.finalMatrix);
        this.finalClippingPaths.add(path);
    }

    public void pushOpacity(float opacity) {
        FlutterMutator mutator = new FlutterMutator(opacity);
        this.mutators.add(mutator);
        this.finalOpacity *= opacity;
    }

    public void pushClipPath(Path path) {
        FlutterMutator mutator = new FlutterMutator(path);
        this.mutators.add(mutator);
        path.transform(this.finalMatrix);
        this.finalClippingPaths.add(path);
    }

    public List<FlutterMutator> getMutators() {
        return this.mutators;
    }

    public List<Path> getFinalClippingPaths() {
        return this.finalClippingPaths;
    }

    public Matrix getFinalMatrix() {
        return this.finalMatrix;
    }

    public float getFinalOpacity() {
        return this.finalOpacity;
    }

    public class FlutterMutator {
        @Nullable
        private Matrix matrix;
        @Nullable
        private Rect rect;
        @Nullable
        private Path path;
        @Nullable
        private float[] radiis;
        private float opacity = 1.0f;
        private FlutterMutatorType type;

        public FlutterMutator(Rect rect) {
            this.type = FlutterMutatorType.CLIP_RECT;
            this.rect = rect;
        }

        public FlutterMutator(Rect rect, float[] radiis) {
            this.type = FlutterMutatorType.CLIP_RRECT;
            this.rect = rect;
            this.radiis = radiis;
        }

        public FlutterMutator(Path path) {
            this.type = FlutterMutatorType.CLIP_PATH;
            this.path = path;
        }

        public FlutterMutator(Matrix matrix) {
            this.type = FlutterMutatorType.TRANSFORM;
            this.matrix = matrix;
        }

        public FlutterMutator(float opacity) {
            this.type = FlutterMutatorType.OPACITY;
            this.opacity = opacity;
        }

        public FlutterMutatorType getType() {
            return this.type;
        }

        public Rect getRect() {
            return this.rect;
        }

        public Path getPath() {
            return this.path;
        }

        public Matrix getMatrix() {
            return this.matrix;
        }

        public float getOpacity() {
            return this.opacity;
        }
    }

    public static enum FlutterMutatorType {
        CLIP_RECT,
        CLIP_RRECT,
        CLIP_PATH,
        TRANSFORM,
        OPACITY;

    }
}

