/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.util;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.window.layout.WindowMetrics;
import androidx.window.layout.WindowMetricsCalculator;

public final class ViewUtils {
    public static void calculateMaximumDisplayMetrics(@Nullable Context context, @NonNull DisplayUpdater updater) {
        Activity activity = ViewUtils.getActivity(context);
        if (activity != null) {
            WindowMetrics metrics = WindowMetricsCalculator.getOrCreate().computeMaximumWindowMetrics(activity);
            float width = metrics.getBounds().width();
            float height = metrics.getBounds().height();
            float density = context.getResources().getDisplayMetrics().density;
            updater.updateDisplayMetrics(width, height, density);
        }
    }

    @Nullable
    public static Activity getActivity(@Nullable Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            return ViewUtils.getActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    public static int generateViewId(int fallbackId) {
        if (Build.VERSION.SDK_INT >= 17) {
            return View.generateViewId();
        }
        return fallbackId;
    }

    public static boolean childHasFocus(@Nullable View root) {
        return ViewUtils.traverseHierarchy(root, view -> view.hasFocus());
    }

    public static boolean hasChildViewOfType(@Nullable View root, Class<? extends View>[] viewTypes) {
        return ViewUtils.traverseHierarchy(root, view -> {
            for (int i = 0; i < viewTypes.length; ++i) {
                Class viewType = viewTypes[i];
                if (!viewType.isInstance(view)) continue;
                return true;
            }
            return false;
        });
    }

    public static boolean traverseHierarchy(@Nullable View root, @NonNull ViewVisitor visitor) {
        if (root == null) {
            return false;
        }
        if (visitor.run(root)) {
            return true;
        }
        if (root instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)root;
            for (int idx = 0; idx < viewGroup.getChildCount(); ++idx) {
                if (!ViewUtils.traverseHierarchy(viewGroup.getChildAt(idx), visitor)) continue;
                return true;
            }
        }
        return false;
    }

    public static interface ViewVisitor {
        public boolean run(@NonNull View var1);
    }

    public static interface DisplayUpdater {
        public void updateDisplayMetrics(float var1, float var2, float var3);
    }
}

