/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.FlutterInjector;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.loader.FlutterLoader;
import io.flutter.plugin.platform.PlatformViewsController;
import java.util.ArrayList;
import java.util.List;

public class FlutterEngineGroup {
    @VisibleForTesting
    final List<FlutterEngine> activeEngines = new ArrayList<FlutterEngine>();

    public FlutterEngineGroup(@NonNull Context context) {
        this(context, null);
    }

    public FlutterEngineGroup(@NonNull Context context, @Nullable String[] dartVmArgs) {
        FlutterLoader loader = FlutterInjector.instance().flutterLoader();
        if (!loader.initialized()) {
            loader.startInitialization(context.getApplicationContext());
            loader.ensureInitializationComplete(context.getApplicationContext(), dartVmArgs);
        }
    }

    public FlutterEngine createAndRunDefaultEngine(@NonNull Context context) {
        return this.createAndRunEngine(context, null);
    }

    public FlutterEngine createAndRunEngine(@NonNull Context context, @Nullable DartExecutor.DartEntrypoint dartEntrypoint) {
        return this.createAndRunEngine(context, dartEntrypoint, null);
    }

    public FlutterEngine createAndRunEngine(@NonNull Context context, @Nullable DartExecutor.DartEntrypoint dartEntrypoint, @Nullable String initialRoute) {
        return this.createAndRunEngine(new Options(context).setDartEntrypoint(dartEntrypoint).setInitialRoute(initialRoute));
    }

    public FlutterEngine createAndRunEngine(@NonNull Options options) {
        FlutterEngine engine = null;
        Context context = options.getContext();
        DartExecutor.DartEntrypoint dartEntrypoint = options.getDartEntrypoint();
        String initialRoute = options.getInitialRoute();
        List<String> dartEntrypointArgs = options.getDartEntrypointArgs();
        PlatformViewsController platformViewsController = options.getPlatformViewsController();
        platformViewsController = platformViewsController != null ? platformViewsController : new PlatformViewsController();
        boolean automaticallyRegisterPlugins = options.getAutomaticallyRegisterPlugins();
        boolean waitForRestorationData = options.getWaitForRestorationData();
        if (dartEntrypoint == null) {
            dartEntrypoint = DartExecutor.DartEntrypoint.createDefault();
        }
        if (this.activeEngines.size() == 0) {
            engine = this.createEngine(context, platformViewsController, automaticallyRegisterPlugins, waitForRestorationData);
            if (initialRoute != null) {
                engine.getNavigationChannel().setInitialRoute(initialRoute);
            }
            engine.getDartExecutor().executeDartEntrypoint(dartEntrypoint, dartEntrypointArgs);
        } else {
            engine = this.activeEngines.get(0).spawn(context, dartEntrypoint, initialRoute, dartEntrypointArgs, platformViewsController, automaticallyRegisterPlugins, waitForRestorationData);
        }
        this.activeEngines.add(engine);
        final FlutterEngine engineToCleanUpOnDestroy = engine;
        engine.addEngineLifecycleListener(new FlutterEngine.EngineLifecycleListener(){

            @Override
            public void onPreEngineRestart() {
            }

            @Override
            public void onEngineWillDestroy() {
                FlutterEngineGroup.this.activeEngines.remove(engineToCleanUpOnDestroy);
            }
        });
        return engine;
    }

    @VisibleForTesting
    FlutterEngine createEngine(Context context, @NonNull PlatformViewsController platformViewsController, boolean automaticallyRegisterPlugins, boolean waitForRestorationData) {
        return new FlutterEngine(context, null, null, platformViewsController, null, automaticallyRegisterPlugins, waitForRestorationData, this);
    }

    public static class Options {
        @NonNull
        private Context context;
        @Nullable
        private DartExecutor.DartEntrypoint dartEntrypoint;
        @Nullable
        private String initialRoute;
        @Nullable
        private List<String> dartEntrypointArgs;
        @NonNull
        private PlatformViewsController platformViewsController;
        private boolean automaticallyRegisterPlugins = true;
        private boolean waitForRestorationData = false;

        public Options(@NonNull Context context) {
            this.context = context;
        }

        public Context getContext() {
            return this.context;
        }

        public DartExecutor.DartEntrypoint getDartEntrypoint() {
            return this.dartEntrypoint;
        }

        public String getInitialRoute() {
            return this.initialRoute;
        }

        public List<String> getDartEntrypointArgs() {
            return this.dartEntrypointArgs;
        }

        public PlatformViewsController getPlatformViewsController() {
            return this.platformViewsController;
        }

        public boolean getAutomaticallyRegisterPlugins() {
            return this.automaticallyRegisterPlugins;
        }

        public boolean getWaitForRestorationData() {
            return this.waitForRestorationData;
        }

        public Options setDartEntrypoint(DartExecutor.DartEntrypoint dartEntrypoint) {
            this.dartEntrypoint = dartEntrypoint;
            return this;
        }

        public Options setInitialRoute(String initialRoute) {
            this.initialRoute = initialRoute;
            return this;
        }

        public Options setDartEntrypointArgs(List<String> dartEntrypointArgs) {
            this.dartEntrypointArgs = dartEntrypointArgs;
            return this;
        }

        public Options setPlatformViewsController(@NonNull PlatformViewsController platformViewsController) {
            this.platformViewsController = platformViewsController;
            return this;
        }

        public Options setAutomaticallyRegisterPlugins(boolean automaticallyRegisterPlugins) {
            this.automaticallyRegisterPlugins = automaticallyRegisterPlugins;
            return this;
        }

        public Options setWaitForRestorationData(boolean waitForRestorationData) {
            this.waitForRestorationData = waitForRestorationData;
            return this;
        }
    }
}

