/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import io.flutter.plugin.platform.AccessibilityEventsDelegate;
import io.flutter.plugin.platform.PlatformView;
import io.flutter.plugin.platform.PlatformViewRenderTarget;
import io.flutter.plugin.platform.SingleViewPresentation;

@TargetApi(value=20)
class VirtualDisplayController {
    private static String TAG = "VirtualDisplayController";
    @VisibleForTesting
    SingleViewPresentation presentation;
    private final Context context;
    private final AccessibilityEventsDelegate accessibilityEventsDelegate;
    private final int densityDpi;
    private final int viewId;
    private final PlatformViewRenderTarget renderTarget;
    private final View.OnFocusChangeListener focusChangeListener;
    private VirtualDisplay virtualDisplay;

    public static VirtualDisplayController create(Context context, AccessibilityEventsDelegate accessibilityEventsDelegate, PlatformView view, PlatformViewRenderTarget renderTarget, int width, int height, int viewId, Object createParams, View.OnFocusChangeListener focusChangeListener) {
        if (width == 0 || height == 0) {
            return null;
        }
        DisplayManager displayManager = (DisplayManager)context.getSystemService("display");
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        renderTarget.resize(width, height);
        VirtualDisplay virtualDisplay = displayManager.createVirtualDisplay("flutter-vd#" + viewId, width, height, metrics.densityDpi, renderTarget.getSurface(), 0);
        if (virtualDisplay == null) {
            return null;
        }
        VirtualDisplayController controller = new VirtualDisplayController(context, accessibilityEventsDelegate, virtualDisplay, view, renderTarget, focusChangeListener, viewId, createParams);
        return controller;
    }

    private VirtualDisplayController(Context context, AccessibilityEventsDelegate accessibilityEventsDelegate, VirtualDisplay virtualDisplay, PlatformView view, PlatformViewRenderTarget renderTarget, View.OnFocusChangeListener focusChangeListener, int viewId, Object createParams) {
        this.context = context;
        this.accessibilityEventsDelegate = accessibilityEventsDelegate;
        this.renderTarget = renderTarget;
        this.focusChangeListener = focusChangeListener;
        this.viewId = viewId;
        this.virtualDisplay = virtualDisplay;
        this.densityDpi = context.getResources().getDisplayMetrics().densityDpi;
        this.presentation = new SingleViewPresentation(context, this.virtualDisplay.getDisplay(), view, accessibilityEventsDelegate, viewId, focusChangeListener);
        this.presentation.show();
    }

    public int getRenderTargetWidth() {
        if (this.renderTarget != null) {
            return this.renderTarget.getWidth();
        }
        return 0;
    }

    public int getRenderTargetHeight() {
        if (this.renderTarget != null) {
            return this.renderTarget.getHeight();
        }
        return 0;
    }

    public void resize(int width, int height, final Runnable onNewSizeFrameAvailable) {
        if (width == this.getRenderTargetWidth() && height == this.getRenderTargetHeight()) {
            this.getView().postDelayed(onNewSizeFrameAvailable, 0L);
            return;
        }
        if (Build.VERSION.SDK_INT >= 31) {
            this.resize31(this.getView(), width, height, onNewSizeFrameAvailable);
            return;
        }
        boolean isFocused = this.getView().isFocused();
        SingleViewPresentation.PresentationState presentationState = this.presentation.detachState();
        this.virtualDisplay.setSurface(null);
        this.virtualDisplay.release();
        DisplayManager displayManager = (DisplayManager)this.context.getSystemService("display");
        this.renderTarget.resize(width, height);
        this.virtualDisplay = displayManager.createVirtualDisplay("flutter-vd#" + this.viewId, width, height, this.densityDpi, this.renderTarget.getSurface(), 0);
        final View embeddedView = this.getView();
        embeddedView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                OneTimeOnDrawListener.schedule(embeddedView, new Runnable(){

                    @Override
                    public void run() {
                        embeddedView.postDelayed(onNewSizeFrameAvailable, 128L);
                    }
                });
                embeddedView.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            }

            public void onViewDetachedFromWindow(View v) {
            }
        });
        SingleViewPresentation newPresentation = new SingleViewPresentation(this.context, this.virtualDisplay.getDisplay(), this.accessibilityEventsDelegate, presentationState, this.focusChangeListener, isFocused);
        newPresentation.show();
        this.presentation.cancel();
        this.presentation = newPresentation;
    }

    public void dispose() {
        this.presentation.cancel();
        this.presentation.detachState();
        this.virtualDisplay.release();
        this.renderTarget.release();
    }

    @TargetApi(value=31)
    private void resize31(View embeddedView, int width, int height, Runnable onNewSizeFrameAvailable) {
        this.renderTarget.resize(width, height);
        this.virtualDisplay.resize(width, height, this.densityDpi);
        embeddedView.postDelayed(onNewSizeFrameAvailable, 0L);
    }

    void onFlutterViewAttached(@NonNull View flutterView) {
        if (this.presentation == null || this.presentation.getView() == null) {
            return;
        }
        this.presentation.getView().onFlutterViewAttached(flutterView);
    }

    void onFlutterViewDetached() {
        if (this.presentation == null || this.presentation.getView() == null) {
            return;
        }
        this.presentation.getView().onFlutterViewDetached();
    }

    void onInputConnectionLocked() {
        if (this.presentation == null || this.presentation.getView() == null) {
            return;
        }
        this.presentation.getView().onInputConnectionLocked();
    }

    void onInputConnectionUnlocked() {
        if (this.presentation == null || this.presentation.getView() == null) {
            return;
        }
        this.presentation.getView().onInputConnectionUnlocked();
    }

    public View getView() {
        if (this.presentation == null) {
            return null;
        }
        PlatformView platformView = this.presentation.getView();
        return platformView.getView();
    }

    public void dispatchTouchEvent(MotionEvent event) {
        if (this.presentation == null) {
            return;
        }
        this.presentation.dispatchTouchEvent(event);
    }

    static class OneTimeOnDrawListener
    implements ViewTreeObserver.OnDrawListener {
        final View mView;
        Runnable mOnDrawRunnable;

        static void schedule(View view, Runnable runnable) {
            OneTimeOnDrawListener listener = new OneTimeOnDrawListener(view, runnable);
            view.getViewTreeObserver().addOnDrawListener((ViewTreeObserver.OnDrawListener)listener);
        }

        OneTimeOnDrawListener(View view, Runnable onDrawRunnable) {
            this.mView = view;
            this.mOnDrawRunnable = onDrawRunnable;
        }

        public void onDraw() {
            if (this.mOnDrawRunnable == null) {
                return;
            }
            this.mOnDrawRunnable.run();
            this.mOnDrawRunnable = null;
            this.mView.post(new Runnable(){

                @Override
                public void run() {
                    mView.getViewTreeObserver().removeOnDrawListener((ViewTreeObserver.OnDrawListener)this);
                }
            });
        }
    }
}

