// AUTO-GENERATED USING zydis-bindgen!

/// Defines the `ZydisInstructionCategory` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum InstructionCategory {
    INVALID = 0,
    ADOX_ADCX = 1,
    AES = 2,
    AMD3DNOW = 3,
    AVX = 4,
    AVX2 = 5,
    AVX2GATHER = 6,
    AVX512 = 7,
    AVX512_4FMAPS = 8,
    AVX512_4VNNIW = 9,
    AVX512_BITALG = 10,
    AVX512_VBMI = 11,
    AVX512_VP2INTERSECT = 12,
    BINARY = 13,
    BITBYTE = 14,
    BLEND = 15,
    BMI1 = 16,
    BMI2 = 17,
    BROADCAST = 18,
    CALL = 19,
    CET = 20,
    CLDEMOTE = 21,
    CLFLUSHOPT = 22,
    CLWB = 23,
    CLZERO = 24,
    CMOV = 25,
    COMPRESS = 26,
    COND_BR = 27,
    CONFLICT = 28,
    CONVERT = 29,
    DATAXFER = 30,
    DECIMAL = 31,
    ENQCMD = 32,
    EXPAND = 33,
    FCMOV = 34,
    FLAGOP = 35,
    FMA4 = 36,
    GATHER = 37,
    GFNI = 38,
    IFMA = 39,
    INTERRUPT = 40,
    IO = 41,
    IOSTRINGOP = 42,
    KMASK = 43,
    KNC = 44,
    KNCMASK = 45,
    KNCSCALAR = 46,
    LOGICAL = 47,
    LOGICAL_FP = 48,
    LZCNT = 49,
    MISC = 50,
    MMX = 51,
    MOVDIR = 52,
    MPX = 53,
    NOP = 54,
    PADLOCK = 55,
    PCLMULQDQ = 56,
    PCONFIG = 57,
    PKU = 58,
    POP = 59,
    PREFETCH = 60,
    PREFETCHWT1 = 61,
    PT = 62,
    PUSH = 63,
    RDPID = 64,
    RDPRU = 65,
    RDRAND = 66,
    RDSEED = 67,
    RDWRFSGS = 68,
    RET = 69,
    ROTATE = 70,
    SCATTER = 71,
    SEGOP = 72,
    SEMAPHORE = 73,
    SETCC = 74,
    SGX = 75,
    SHA = 76,
    SHIFT = 77,
    SMAP = 78,
    SSE = 79,
    STRINGOP = 80,
    STTNI = 81,
    SYSCALL = 82,
    SYSRET = 83,
    SYSTEM = 84,
    TBM = 85,
    UFMA = 86,
    UNCOND_BR = 87,
    VAES = 88,
    VBMI2 = 89,
    VFMA = 90,
    VPCLMULQDQ = 91,
    VTX = 92,
    WAITPKG = 93,
    WIDENOP = 94,
    X87_ALU = 95,
    XOP = 96,
    XSAVE = 97,
    XSAVEOPT = 98,
}

pub const CATEGORY_MAX_VALUE: usize = 98;

/// Defines the `ZydisISASet` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum ISASet {
    INVALID = 0,
    ADOX_ADCX = 1,
    AES = 2,
    AMD = 3,
    AMD3DNOW = 4,
    AVX = 5,
    AVX2 = 6,
    AVX2GATHER = 7,
    AVX512BW_128 = 8,
    AVX512BW_128N = 9,
    AVX512BW_256 = 10,
    AVX512BW_512 = 11,
    AVX512BW_KOP = 12,
    AVX512CD_128 = 13,
    AVX512CD_256 = 14,
    AVX512CD_512 = 15,
    AVX512DQ_128 = 16,
    AVX512DQ_128N = 17,
    AVX512DQ_256 = 18,
    AVX512DQ_512 = 19,
    AVX512DQ_KOP = 20,
    AVX512DQ_SCALAR = 21,
    AVX512ER_512 = 22,
    AVX512ER_SCALAR = 23,
    AVX512F_128 = 24,
    AVX512F_128N = 25,
    AVX512F_256 = 26,
    AVX512F_512 = 27,
    AVX512F_KOP = 28,
    AVX512F_SCALAR = 29,
    AVX512PF_512 = 30,
    AVX512_4FMAPS_512 = 31,
    AVX512_4FMAPS_SCALAR = 32,
    AVX512_4VNNIW_512 = 33,
    AVX512_BF16_128 = 34,
    AVX512_BF16_256 = 35,
    AVX512_BF16_512 = 36,
    AVX512_BITALG_128 = 37,
    AVX512_BITALG_256 = 38,
    AVX512_BITALG_512 = 39,
    AVX512_GFNI_128 = 40,
    AVX512_GFNI_256 = 41,
    AVX512_GFNI_512 = 42,
    AVX512_IFMA_128 = 43,
    AVX512_IFMA_256 = 44,
    AVX512_IFMA_512 = 45,
    AVX512_VAES_128 = 46,
    AVX512_VAES_256 = 47,
    AVX512_VAES_512 = 48,
    AVX512_VBMI2_128 = 49,
    AVX512_VBMI2_256 = 50,
    AVX512_VBMI2_512 = 51,
    AVX512_VBMI_128 = 52,
    AVX512_VBMI_256 = 53,
    AVX512_VBMI_512 = 54,
    AVX512_VNNI_128 = 55,
    AVX512_VNNI_256 = 56,
    AVX512_VNNI_512 = 57,
    AVX512_VP2INTERSECT_128 = 58,
    AVX512_VP2INTERSECT_256 = 59,
    AVX512_VP2INTERSECT_512 = 60,
    AVX512_VPCLMULQDQ_128 = 61,
    AVX512_VPCLMULQDQ_256 = 62,
    AVX512_VPCLMULQDQ_512 = 63,
    AVX512_VPOPCNTDQ_128 = 64,
    AVX512_VPOPCNTDQ_256 = 65,
    AVX512_VPOPCNTDQ_512 = 66,
    AVXAES = 67,
    AVX_GFNI = 68,
    BMI1 = 69,
    BMI2 = 70,
    CET = 71,
    CLDEMOTE = 72,
    CLFLUSHOPT = 73,
    CLFSH = 74,
    CLWB = 75,
    CLZERO = 76,
    CMOV = 77,
    CMPXCHG16B = 78,
    ENQCMD = 79,
    F16C = 80,
    FAT_NOP = 81,
    FCMOV = 82,
    FMA = 83,
    FMA4 = 84,
    FXSAVE = 85,
    FXSAVE64 = 86,
    GFNI = 87,
    I186 = 88,
    I286PROTECTED = 89,
    I286REAL = 90,
    I386 = 91,
    I486 = 92,
    I486REAL = 93,
    I86 = 94,
    INVPCID = 95,
    KNCE = 96,
    KNCJKBR = 97,
    KNCSTREAM = 98,
    KNCV = 99,
    KNC_MISC = 100,
    KNC_PF_HINT = 101,
    LAHF = 102,
    LONGMODE = 103,
    LZCNT = 104,
    MONITOR = 105,
    MONITORX = 106,
    MOVBE = 107,
    MOVDIR = 108,
    MPX = 109,
    PADLOCK_ACE = 110,
    PADLOCK_PHE = 111,
    PADLOCK_PMM = 112,
    PADLOCK_RNG = 113,
    PAUSE = 114,
    PCLMULQDQ = 115,
    PCONFIG = 116,
    PENTIUMMMX = 117,
    PENTIUMREAL = 118,
    PKU = 119,
    POPCNT = 120,
    PPRO = 121,
    PREFETCHWT1 = 122,
    PREFETCH_NOP = 123,
    PT = 124,
    RDPID = 125,
    RDPMC = 126,
    RDPRU = 127,
    RDRAND = 128,
    RDSEED = 129,
    RDTSCP = 130,
    RDWRFSGS = 131,
    RTM = 132,
    SGX = 133,
    SGX_ENCLV = 134,
    SHA = 135,
    SMAP = 136,
    SMX = 137,
    SSE = 138,
    SSE2 = 139,
    SSE2MMX = 140,
    SSE3 = 141,
    SSE3X87 = 142,
    SSE4 = 143,
    SSE42 = 144,
    SSE4A = 145,
    SSEMXCSR = 146,
    SSE_PREFETCH = 147,
    SSSE3 = 148,
    SSSE3MMX = 149,
    SVM = 150,
    TBM = 151,
    VAES = 152,
    VMFUNC = 153,
    VPCLMULQDQ = 154,
    VTX = 155,
    WAITPKG = 156,
    X87 = 157,
    XOP = 158,
    XSAVE = 159,
    XSAVEC = 160,
    XSAVEOPT = 161,
    XSAVES = 162,
}

pub const ISA_SET_MAX_VALUE: usize = 162;

/// Defines the `ZydisISAExt` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum ISAExt {
    INVALID = 0,
    ADOX_ADCX = 1,
    AES = 2,
    AMD3DNOW = 3,
    AVX = 4,
    AVX2 = 5,
    AVX2GATHER = 6,
    AVX512EVEX = 7,
    AVX512VEX = 8,
    AVXAES = 9,
    BASE = 10,
    BMI1 = 11,
    BMI2 = 12,
    CET = 13,
    CLDEMOTE = 14,
    CLFLUSHOPT = 15,
    CLFSH = 16,
    CLWB = 17,
    CLZERO = 18,
    ENQCMD = 19,
    F16C = 20,
    FMA = 21,
    FMA4 = 22,
    GFNI = 23,
    INVPCID = 24,
    KNC = 25,
    KNCE = 26,
    KNCV = 27,
    LONGMODE = 28,
    LZCNT = 29,
    MMX = 30,
    MONITOR = 31,
    MONITORX = 32,
    MOVBE = 33,
    MOVDIR = 34,
    MPX = 35,
    PADLOCK = 36,
    PAUSE = 37,
    PCLMULQDQ = 38,
    PCONFIG = 39,
    PKU = 40,
    PREFETCHWT1 = 41,
    PT = 42,
    RDPID = 43,
    RDPRU = 44,
    RDRAND = 45,
    RDSEED = 46,
    RDTSCP = 47,
    RDWRFSGS = 48,
    RTM = 49,
    SGX = 50,
    SGX_ENCLV = 51,
    SHA = 52,
    SMAP = 53,
    SMX = 54,
    SSE = 55,
    SSE2 = 56,
    SSE3 = 57,
    SSE4 = 58,
    SSE4A = 59,
    SSSE3 = 60,
    SVM = 61,
    TBM = 62,
    VAES = 63,
    VMFUNC = 64,
    VPCLMULQDQ = 65,
    VTX = 66,
    WAITPKG = 67,
    X87 = 68,
    XOP = 69,
    XSAVE = 70,
    XSAVEC = 71,
    XSAVEOPT = 72,
    XSAVES = 73,
}

pub const ISA_EXT_MAX_VALUE: usize = 73;

/// Defines the `ZydisMnemonic` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum Mnemonic {
    INVALID = 0,
    AAA = 1,
    AAD = 2,
    AAM = 3,
    AAS = 4,
    ADC = 5,
    ADCX = 6,
    ADD = 7,
    ADDPD = 8,
    ADDPS = 9,
    ADDSD = 10,
    ADDSS = 11,
    ADDSUBPD = 12,
    ADDSUBPS = 13,
    ADOX = 14,
    AESDEC = 15,
    AESDECLAST = 16,
    AESENC = 17,
    AESENCLAST = 18,
    AESIMC = 19,
    AESKEYGENASSIST = 20,
    AND = 21,
    ANDN = 22,
    ANDNPD = 23,
    ANDNPS = 24,
    ANDPD = 25,
    ANDPS = 26,
    ARPL = 27,
    BEXTR = 28,
    BLCFILL = 29,
    BLCI = 30,
    BLCIC = 31,
    BLCMSK = 32,
    BLCS = 33,
    BLENDPD = 34,
    BLENDPS = 35,
    BLENDVPD = 36,
    BLENDVPS = 37,
    BLSFILL = 38,
    BLSI = 39,
    BLSIC = 40,
    BLSMSK = 41,
    BLSR = 42,
    BNDCL = 43,
    BNDCN = 44,
    BNDCU = 45,
    BNDLDX = 46,
    BNDMK = 47,
    BNDMOV = 48,
    BNDSTX = 49,
    BOUND = 50,
    BSF = 51,
    BSR = 52,
    BSWAP = 53,
    BT = 54,
    BTC = 55,
    BTR = 56,
    BTS = 57,
    BZHI = 58,
    CALL = 59,
    CBW = 60,
    CDQ = 61,
    CDQE = 62,
    CLAC = 63,
    CLC = 64,
    CLD = 65,
    CLDEMOTE = 66,
    CLEVICT0 = 67,
    CLEVICT1 = 68,
    CLFLUSH = 69,
    CLFLUSHOPT = 70,
    CLGI = 71,
    CLI = 72,
    CLRSSBSY = 73,
    CLTS = 74,
    CLWB = 75,
    CLZERO = 76,
    CMC = 77,
    CMOVB = 78,
    CMOVBE = 79,
    CMOVL = 80,
    CMOVLE = 81,
    CMOVNB = 82,
    CMOVNBE = 83,
    CMOVNL = 84,
    CMOVNLE = 85,
    CMOVNO = 86,
    CMOVNP = 87,
    CMOVNS = 88,
    CMOVNZ = 89,
    CMOVO = 90,
    CMOVP = 91,
    CMOVS = 92,
    CMOVZ = 93,
    CMP = 94,
    CMPPD = 95,
    CMPPS = 96,
    CMPSB = 97,
    CMPSD = 98,
    CMPSQ = 99,
    CMPSS = 100,
    CMPSW = 101,
    CMPXCHG = 102,
    CMPXCHG16B = 103,
    CMPXCHG8B = 104,
    COMISD = 105,
    COMISS = 106,
    CPUID = 107,
    CQO = 108,
    CRC32 = 109,
    CVTDQ2PD = 110,
    CVTDQ2PS = 111,
    CVTPD2DQ = 112,
    CVTPD2PI = 113,
    CVTPD2PS = 114,
    CVTPI2PD = 115,
    CVTPI2PS = 116,
    CVTPS2DQ = 117,
    CVTPS2PD = 118,
    CVTPS2PI = 119,
    CVTSD2SI = 120,
    CVTSD2SS = 121,
    CVTSI2SD = 122,
    CVTSI2SS = 123,
    CVTSS2SD = 124,
    CVTSS2SI = 125,
    CVTTPD2DQ = 126,
    CVTTPD2PI = 127,
    CVTTPS2DQ = 128,
    CVTTPS2PI = 129,
    CVTTSD2SI = 130,
    CVTTSS2SI = 131,
    CWD = 132,
    CWDE = 133,
    DAA = 134,
    DAS = 135,
    DEC = 136,
    DELAY = 137,
    DIV = 138,
    DIVPD = 139,
    DIVPS = 140,
    DIVSD = 141,
    DIVSS = 142,
    DPPD = 143,
    DPPS = 144,
    EMMS = 145,
    ENCLS = 146,
    ENCLU = 147,
    ENCLV = 148,
    ENDBR32 = 149,
    ENDBR64 = 150,
    ENQCMD = 151,
    ENQCMDS = 152,
    ENTER = 153,
    EXTRACTPS = 154,
    EXTRQ = 155,
    F2XM1 = 156,
    FABS = 157,
    FADD = 158,
    FADDP = 159,
    FBLD = 160,
    FBSTP = 161,
    FCHS = 162,
    FCMOVB = 163,
    FCMOVBE = 164,
    FCMOVE = 165,
    FCMOVNB = 166,
    FCMOVNBE = 167,
    FCMOVNE = 168,
    FCMOVNU = 169,
    FCMOVU = 170,
    FCOM = 171,
    FCOMI = 172,
    FCOMIP = 173,
    FCOMP = 174,
    FCOMPP = 175,
    FCOS = 176,
    FDECSTP = 177,
    FDISI8087_NOP = 178,
    FDIV = 179,
    FDIVP = 180,
    FDIVR = 181,
    FDIVRP = 182,
    FEMMS = 183,
    FENI8087_NOP = 184,
    FFREE = 185,
    FFREEP = 186,
    FIADD = 187,
    FICOM = 188,
    FICOMP = 189,
    FIDIV = 190,
    FIDIVR = 191,
    FILD = 192,
    FIMUL = 193,
    FINCSTP = 194,
    FIST = 195,
    FISTP = 196,
    FISTTP = 197,
    FISUB = 198,
    FISUBR = 199,
    FLD = 200,
    FLD1 = 201,
    FLDCW = 202,
    FLDENV = 203,
    FLDL2E = 204,
    FLDL2T = 205,
    FLDLG2 = 206,
    FLDLN2 = 207,
    FLDPI = 208,
    FLDZ = 209,
    FMUL = 210,
    FMULP = 211,
    FNCLEX = 212,
    FNINIT = 213,
    FNOP = 214,
    FNSAVE = 215,
    FNSTCW = 216,
    FNSTENV = 217,
    FNSTSW = 218,
    FPATAN = 219,
    FPREM = 220,
    FPREM1 = 221,
    FPTAN = 222,
    FRNDINT = 223,
    FRSTOR = 224,
    FSCALE = 225,
    FSETPM287_NOP = 226,
    FSIN = 227,
    FSINCOS = 228,
    FSQRT = 229,
    FST = 230,
    FSTP = 231,
    FSTPNCE = 232,
    FSUB = 233,
    FSUBP = 234,
    FSUBR = 235,
    FSUBRP = 236,
    FTST = 237,
    FUCOM = 238,
    FUCOMI = 239,
    FUCOMIP = 240,
    FUCOMP = 241,
    FUCOMPP = 242,
    FWAIT = 243,
    FXAM = 244,
    FXCH = 245,
    FXRSTOR = 246,
    FXRSTOR64 = 247,
    FXSAVE = 248,
    FXSAVE64 = 249,
    FXTRACT = 250,
    FYL2X = 251,
    FYL2XP1 = 252,
    GETSEC = 253,
    GF2P8AFFINEINVQB = 254,
    GF2P8AFFINEQB = 255,
    GF2P8MULB = 256,
    HADDPD = 257,
    HADDPS = 258,
    HLT = 259,
    HSUBPD = 260,
    HSUBPS = 261,
    IDIV = 262,
    IMUL = 263,
    IN = 264,
    INC = 265,
    INCSSPD = 266,
    INCSSPQ = 267,
    INSB = 268,
    INSD = 269,
    INSERTPS = 270,
    INSERTQ = 271,
    INSW = 272,
    INT = 273,
    INT1 = 274,
    INT3 = 275,
    INTO = 276,
    INVD = 277,
    INVEPT = 278,
    INVLPG = 279,
    INVLPGA = 280,
    INVPCID = 281,
    INVVPID = 282,
    IRET = 283,
    IRETD = 284,
    IRETQ = 285,
    JB = 286,
    JBE = 287,
    JCXZ = 288,
    JECXZ = 289,
    JKNZD = 290,
    JKZD = 291,
    JL = 292,
    JLE = 293,
    JMP = 294,
    JNB = 295,
    JNBE = 296,
    JNL = 297,
    JNLE = 298,
    JNO = 299,
    JNP = 300,
    JNS = 301,
    JNZ = 302,
    JO = 303,
    JP = 304,
    JRCXZ = 305,
    JS = 306,
    JZ = 307,
    KADDB = 308,
    KADDD = 309,
    KADDQ = 310,
    KADDW = 311,
    KAND = 312,
    KANDB = 313,
    KANDD = 314,
    KANDN = 315,
    KANDNB = 316,
    KANDND = 317,
    KANDNQ = 318,
    KANDNR = 319,
    KANDNW = 320,
    KANDQ = 321,
    KANDW = 322,
    KCONCATH = 323,
    KCONCATL = 324,
    KEXTRACT = 325,
    KMERGE2L1H = 326,
    KMERGE2L1L = 327,
    KMOV = 328,
    KMOVB = 329,
    KMOVD = 330,
    KMOVQ = 331,
    KMOVW = 332,
    KNOT = 333,
    KNOTB = 334,
    KNOTD = 335,
    KNOTQ = 336,
    KNOTW = 337,
    KOR = 338,
    KORB = 339,
    KORD = 340,
    KORQ = 341,
    KORTEST = 342,
    KORTESTB = 343,
    KORTESTD = 344,
    KORTESTQ = 345,
    KORTESTW = 346,
    KORW = 347,
    KSHIFTLB = 348,
    KSHIFTLD = 349,
    KSHIFTLQ = 350,
    KSHIFTLW = 351,
    KSHIFTRB = 352,
    KSHIFTRD = 353,
    KSHIFTRQ = 354,
    KSHIFTRW = 355,
    KTESTB = 356,
    KTESTD = 357,
    KTESTQ = 358,
    KTESTW = 359,
    KUNPCKBW = 360,
    KUNPCKDQ = 361,
    KUNPCKWD = 362,
    KXNOR = 363,
    KXNORB = 364,
    KXNORD = 365,
    KXNORQ = 366,
    KXNORW = 367,
    KXOR = 368,
    KXORB = 369,
    KXORD = 370,
    KXORQ = 371,
    KXORW = 372,
    LAHF = 373,
    LAR = 374,
    LDDQU = 375,
    LDMXCSR = 376,
    LDS = 377,
    LEA = 378,
    LEAVE = 379,
    LES = 380,
    LFENCE = 381,
    LFS = 382,
    LGDT = 383,
    LGS = 384,
    LIDT = 385,
    LLDT = 386,
    LLWPCB = 387,
    LMSW = 388,
    LODSB = 389,
    LODSD = 390,
    LODSQ = 391,
    LODSW = 392,
    LOOP = 393,
    LOOPE = 394,
    LOOPNE = 395,
    LSL = 396,
    LSS = 397,
    LTR = 398,
    LWPINS = 399,
    LWPVAL = 400,
    LZCNT = 401,
    MASKMOVDQU = 402,
    MASKMOVQ = 403,
    MAXPD = 404,
    MAXPS = 405,
    MAXSD = 406,
    MAXSS = 407,
    MFENCE = 408,
    MINPD = 409,
    MINPS = 410,
    MINSD = 411,
    MINSS = 412,
    MONITOR = 413,
    MONITORX = 414,
    MONTMUL = 415,
    MOV = 416,
    MOVAPD = 417,
    MOVAPS = 418,
    MOVBE = 419,
    MOVD = 420,
    MOVDDUP = 421,
    MOVDIR64B = 422,
    MOVDIRI = 423,
    MOVDQ2Q = 424,
    MOVDQA = 425,
    MOVDQU = 426,
    MOVHLPS = 427,
    MOVHPD = 428,
    MOVHPS = 429,
    MOVLHPS = 430,
    MOVLPD = 431,
    MOVLPS = 432,
    MOVMSKPD = 433,
    MOVMSKPS = 434,
    MOVNTDQ = 435,
    MOVNTDQA = 436,
    MOVNTI = 437,
    MOVNTPD = 438,
    MOVNTPS = 439,
    MOVNTQ = 440,
    MOVNTSD = 441,
    MOVNTSS = 442,
    MOVQ = 443,
    MOVQ2DQ = 444,
    MOVSB = 445,
    MOVSD = 446,
    MOVSHDUP = 447,
    MOVSLDUP = 448,
    MOVSQ = 449,
    MOVSS = 450,
    MOVSW = 451,
    MOVSX = 452,
    MOVSXD = 453,
    MOVUPD = 454,
    MOVUPS = 455,
    MOVZX = 456,
    MPSADBW = 457,
    MUL = 458,
    MULPD = 459,
    MULPS = 460,
    MULSD = 461,
    MULSS = 462,
    MULX = 463,
    MWAIT = 464,
    MWAITX = 465,
    NEG = 466,
    NOP = 467,
    NOT = 468,
    OR = 469,
    ORPD = 470,
    ORPS = 471,
    OUT = 472,
    OUTSB = 473,
    OUTSD = 474,
    OUTSW = 475,
    PABSB = 476,
    PABSD = 477,
    PABSW = 478,
    PACKSSDW = 479,
    PACKSSWB = 480,
    PACKUSDW = 481,
    PACKUSWB = 482,
    PADDB = 483,
    PADDD = 484,
    PADDQ = 485,
    PADDSB = 486,
    PADDSW = 487,
    PADDUSB = 488,
    PADDUSW = 489,
    PADDW = 490,
    PALIGNR = 491,
    PAND = 492,
    PANDN = 493,
    PAUSE = 494,
    PAVGB = 495,
    PAVGUSB = 496,
    PAVGW = 497,
    PBLENDVB = 498,
    PBLENDW = 499,
    PCLMULQDQ = 500,
    PCMPEQB = 501,
    PCMPEQD = 502,
    PCMPEQQ = 503,
    PCMPEQW = 504,
    PCMPESTRI = 505,
    PCMPESTRM = 506,
    PCMPGTB = 507,
    PCMPGTD = 508,
    PCMPGTQ = 509,
    PCMPGTW = 510,
    PCMPISTRI = 511,
    PCMPISTRM = 512,
    PCONFIG = 513,
    PDEP = 514,
    PEXT = 515,
    PEXTRB = 516,
    PEXTRD = 517,
    PEXTRQ = 518,
    PEXTRW = 519,
    PF2ID = 520,
    PF2IW = 521,
    PFACC = 522,
    PFADD = 523,
    PFCMPEQ = 524,
    PFCMPGE = 525,
    PFCMPGT = 526,
    PFCPIT1 = 527,
    PFMAX = 528,
    PFMIN = 529,
    PFMUL = 530,
    PFNACC = 531,
    PFPNACC = 532,
    PFRCP = 533,
    PFRCPIT2 = 534,
    PFRSQIT1 = 535,
    PFSQRT = 536,
    PFSUB = 537,
    PFSUBR = 538,
    PHADDD = 539,
    PHADDSW = 540,
    PHADDW = 541,
    PHMINPOSUW = 542,
    PHSUBD = 543,
    PHSUBSW = 544,
    PHSUBW = 545,
    PI2FD = 546,
    PI2FW = 547,
    PINSRB = 548,
    PINSRD = 549,
    PINSRQ = 550,
    PINSRW = 551,
    PMADDUBSW = 552,
    PMADDWD = 553,
    PMAXSB = 554,
    PMAXSD = 555,
    PMAXSW = 556,
    PMAXUB = 557,
    PMAXUD = 558,
    PMAXUW = 559,
    PMINSB = 560,
    PMINSD = 561,
    PMINSW = 562,
    PMINUB = 563,
    PMINUD = 564,
    PMINUW = 565,
    PMOVMSKB = 566,
    PMOVSXBD = 567,
    PMOVSXBQ = 568,
    PMOVSXBW = 569,
    PMOVSXDQ = 570,
    PMOVSXWD = 571,
    PMOVSXWQ = 572,
    PMOVZXBD = 573,
    PMOVZXBQ = 574,
    PMOVZXBW = 575,
    PMOVZXDQ = 576,
    PMOVZXWD = 577,
    PMOVZXWQ = 578,
    PMULDQ = 579,
    PMULHRSW = 580,
    PMULHRW = 581,
    PMULHUW = 582,
    PMULHW = 583,
    PMULLD = 584,
    PMULLW = 585,
    PMULUDQ = 586,
    POP = 587,
    POPA = 588,
    POPAD = 589,
    POPCNT = 590,
    POPF = 591,
    POPFD = 592,
    POPFQ = 593,
    POR = 594,
    PREFETCH = 595,
    PREFETCHNTA = 596,
    PREFETCHT0 = 597,
    PREFETCHT1 = 598,
    PREFETCHT2 = 599,
    PREFETCHW = 600,
    PREFETCHWT1 = 601,
    PSADBW = 602,
    PSHUFB = 603,
    PSHUFD = 604,
    PSHUFHW = 605,
    PSHUFLW = 606,
    PSHUFW = 607,
    PSIGNB = 608,
    PSIGND = 609,
    PSIGNW = 610,
    PSLLD = 611,
    PSLLDQ = 612,
    PSLLQ = 613,
    PSLLW = 614,
    PSRAD = 615,
    PSRAW = 616,
    PSRLD = 617,
    PSRLDQ = 618,
    PSRLQ = 619,
    PSRLW = 620,
    PSUBB = 621,
    PSUBD = 622,
    PSUBQ = 623,
    PSUBSB = 624,
    PSUBSW = 625,
    PSUBUSB = 626,
    PSUBUSW = 627,
    PSUBW = 628,
    PSWAPD = 629,
    PTEST = 630,
    PTWRITE = 631,
    PUNPCKHBW = 632,
    PUNPCKHDQ = 633,
    PUNPCKHQDQ = 634,
    PUNPCKHWD = 635,
    PUNPCKLBW = 636,
    PUNPCKLDQ = 637,
    PUNPCKLQDQ = 638,
    PUNPCKLWD = 639,
    PUSH = 640,
    PUSHA = 641,
    PUSHAD = 642,
    PUSHF = 643,
    PUSHFD = 644,
    PUSHFQ = 645,
    PXOR = 646,
    RCL = 647,
    RCPPS = 648,
    RCPSS = 649,
    RCR = 650,
    RDFSBASE = 651,
    RDGSBASE = 652,
    RDMSR = 653,
    RDPID = 654,
    RDPKRU = 655,
    RDPMC = 656,
    RDPRU = 657,
    RDRAND = 658,
    RDSEED = 659,
    RDSSPD = 660,
    RDSSPQ = 661,
    RDTSC = 662,
    RDTSCP = 663,
    RET = 664,
    ROL = 665,
    ROR = 666,
    RORX = 667,
    ROUNDPD = 668,
    ROUNDPS = 669,
    ROUNDSD = 670,
    ROUNDSS = 671,
    RSM = 672,
    RSQRTPS = 673,
    RSQRTSS = 674,
    RSTORSSP = 675,
    SAHF = 676,
    SALC = 677,
    SAR = 678,
    SARX = 679,
    SAVEPREVSSP = 680,
    SBB = 681,
    SCASB = 682,
    SCASD = 683,
    SCASQ = 684,
    SCASW = 685,
    SETB = 686,
    SETBE = 687,
    SETL = 688,
    SETLE = 689,
    SETNB = 690,
    SETNBE = 691,
    SETNL = 692,
    SETNLE = 693,
    SETNO = 694,
    SETNP = 695,
    SETNS = 696,
    SETNZ = 697,
    SETO = 698,
    SETP = 699,
    SETS = 700,
    SETSSBSY = 701,
    SETZ = 702,
    SFENCE = 703,
    SGDT = 704,
    SHA1MSG1 = 705,
    SHA1MSG2 = 706,
    SHA1NEXTE = 707,
    SHA1RNDS4 = 708,
    SHA256MSG1 = 709,
    SHA256MSG2 = 710,
    SHA256RNDS2 = 711,
    SHL = 712,
    SHLD = 713,
    SHLX = 714,
    SHR = 715,
    SHRD = 716,
    SHRX = 717,
    SHUFPD = 718,
    SHUFPS = 719,
    SIDT = 720,
    SKINIT = 721,
    SLDT = 722,
    SLWPCB = 723,
    SMSW = 724,
    SPFLT = 725,
    SQRTPD = 726,
    SQRTPS = 727,
    SQRTSD = 728,
    SQRTSS = 729,
    STAC = 730,
    STC = 731,
    STD = 732,
    STGI = 733,
    STI = 734,
    STMXCSR = 735,
    STOSB = 736,
    STOSD = 737,
    STOSQ = 738,
    STOSW = 739,
    STR = 740,
    SUB = 741,
    SUBPD = 742,
    SUBPS = 743,
    SUBSD = 744,
    SUBSS = 745,
    SWAPGS = 746,
    SYSCALL = 747,
    SYSENTER = 748,
    SYSEXIT = 749,
    SYSRET = 750,
    T1MSKC = 751,
    TEST = 752,
    TPAUSE = 753,
    TZCNT = 754,
    TZCNTI = 755,
    TZMSK = 756,
    UCOMISD = 757,
    UCOMISS = 758,
    UD0 = 759,
    UD1 = 760,
    UD2 = 761,
    UMONITOR = 762,
    UMWAIT = 763,
    UNPCKHPD = 764,
    UNPCKHPS = 765,
    UNPCKLPD = 766,
    UNPCKLPS = 767,
    V4FMADDPS = 768,
    V4FMADDSS = 769,
    V4FNMADDPS = 770,
    V4FNMADDSS = 771,
    VADDNPD = 772,
    VADDNPS = 773,
    VADDPD = 774,
    VADDPS = 775,
    VADDSD = 776,
    VADDSETSPS = 777,
    VADDSS = 778,
    VADDSUBPD = 779,
    VADDSUBPS = 780,
    VAESDEC = 781,
    VAESDECLAST = 782,
    VAESENC = 783,
    VAESENCLAST = 784,
    VAESIMC = 785,
    VAESKEYGENASSIST = 786,
    VALIGND = 787,
    VALIGNQ = 788,
    VANDNPD = 789,
    VANDNPS = 790,
    VANDPD = 791,
    VANDPS = 792,
    VBLENDMPD = 793,
    VBLENDMPS = 794,
    VBLENDPD = 795,
    VBLENDPS = 796,
    VBLENDVPD = 797,
    VBLENDVPS = 798,
    VBROADCASTF128 = 799,
    VBROADCASTF32X2 = 800,
    VBROADCASTF32X4 = 801,
    VBROADCASTF32X8 = 802,
    VBROADCASTF64X2 = 803,
    VBROADCASTF64X4 = 804,
    VBROADCASTI128 = 805,
    VBROADCASTI32X2 = 806,
    VBROADCASTI32X4 = 807,
    VBROADCASTI32X8 = 808,
    VBROADCASTI64X2 = 809,
    VBROADCASTI64X4 = 810,
    VBROADCASTSD = 811,
    VBROADCASTSS = 812,
    VCMPPD = 813,
    VCMPPS = 814,
    VCMPSD = 815,
    VCMPSS = 816,
    VCOMISD = 817,
    VCOMISS = 818,
    VCOMPRESSPD = 819,
    VCOMPRESSPS = 820,
    VCVTDQ2PD = 821,
    VCVTDQ2PS = 822,
    VCVTFXPNTDQ2PS = 823,
    VCVTFXPNTPD2DQ = 824,
    VCVTFXPNTPD2UDQ = 825,
    VCVTFXPNTPS2DQ = 826,
    VCVTFXPNTPS2UDQ = 827,
    VCVTFXPNTUDQ2PS = 828,
    VCVTNE2PS2BF16 = 829,
    VCVTNEPS2BF16 = 830,
    VCVTPD2DQ = 831,
    VCVTPD2PS = 832,
    VCVTPD2QQ = 833,
    VCVTPD2UDQ = 834,
    VCVTPD2UQQ = 835,
    VCVTPH2PS = 836,
    VCVTPS2DQ = 837,
    VCVTPS2PD = 838,
    VCVTPS2PH = 839,
    VCVTPS2QQ = 840,
    VCVTPS2UDQ = 841,
    VCVTPS2UQQ = 842,
    VCVTQQ2PD = 843,
    VCVTQQ2PS = 844,
    VCVTSD2SI = 845,
    VCVTSD2SS = 846,
    VCVTSD2USI = 847,
    VCVTSI2SD = 848,
    VCVTSI2SS = 849,
    VCVTSS2SD = 850,
    VCVTSS2SI = 851,
    VCVTSS2USI = 852,
    VCVTTPD2DQ = 853,
    VCVTTPD2QQ = 854,
    VCVTTPD2UDQ = 855,
    VCVTTPD2UQQ = 856,
    VCVTTPS2DQ = 857,
    VCVTTPS2QQ = 858,
    VCVTTPS2UDQ = 859,
    VCVTTPS2UQQ = 860,
    VCVTTSD2SI = 861,
    VCVTTSD2USI = 862,
    VCVTTSS2SI = 863,
    VCVTTSS2USI = 864,
    VCVTUDQ2PD = 865,
    VCVTUDQ2PS = 866,
    VCVTUQQ2PD = 867,
    VCVTUQQ2PS = 868,
    VCVTUSI2SD = 869,
    VCVTUSI2SS = 870,
    VDBPSADBW = 871,
    VDIVPD = 872,
    VDIVPS = 873,
    VDIVSD = 874,
    VDIVSS = 875,
    VDPBF16PS = 876,
    VDPPD = 877,
    VDPPS = 878,
    VERR = 879,
    VERW = 880,
    VEXP223PS = 881,
    VEXP2PD = 882,
    VEXP2PS = 883,
    VEXPANDPD = 884,
    VEXPANDPS = 885,
    VEXTRACTF128 = 886,
    VEXTRACTF32X4 = 887,
    VEXTRACTF32X8 = 888,
    VEXTRACTF64X2 = 889,
    VEXTRACTF64X4 = 890,
    VEXTRACTI128 = 891,
    VEXTRACTI32X4 = 892,
    VEXTRACTI32X8 = 893,
    VEXTRACTI64X2 = 894,
    VEXTRACTI64X4 = 895,
    VEXTRACTPS = 896,
    VFIXUPIMMPD = 897,
    VFIXUPIMMPS = 898,
    VFIXUPIMMSD = 899,
    VFIXUPIMMSS = 900,
    VFIXUPNANPD = 901,
    VFIXUPNANPS = 902,
    VFMADD132PD = 903,
    VFMADD132PS = 904,
    VFMADD132SD = 905,
    VFMADD132SS = 906,
    VFMADD213PD = 907,
    VFMADD213PS = 908,
    VFMADD213SD = 909,
    VFMADD213SS = 910,
    VFMADD231PD = 911,
    VFMADD231PS = 912,
    VFMADD231SD = 913,
    VFMADD231SS = 914,
    VFMADD233PS = 915,
    VFMADDPD = 916,
    VFMADDPS = 917,
    VFMADDSD = 918,
    VFMADDSS = 919,
    VFMADDSUB132PD = 920,
    VFMADDSUB132PS = 921,
    VFMADDSUB213PD = 922,
    VFMADDSUB213PS = 923,
    VFMADDSUB231PD = 924,
    VFMADDSUB231PS = 925,
    VFMADDSUBPD = 926,
    VFMADDSUBPS = 927,
    VFMSUB132PD = 928,
    VFMSUB132PS = 929,
    VFMSUB132SD = 930,
    VFMSUB132SS = 931,
    VFMSUB213PD = 932,
    VFMSUB213PS = 933,
    VFMSUB213SD = 934,
    VFMSUB213SS = 935,
    VFMSUB231PD = 936,
    VFMSUB231PS = 937,
    VFMSUB231SD = 938,
    VFMSUB231SS = 939,
    VFMSUBADD132PD = 940,
    VFMSUBADD132PS = 941,
    VFMSUBADD213PD = 942,
    VFMSUBADD213PS = 943,
    VFMSUBADD231PD = 944,
    VFMSUBADD231PS = 945,
    VFMSUBADDPD = 946,
    VFMSUBADDPS = 947,
    VFMSUBPD = 948,
    VFMSUBPS = 949,
    VFMSUBSD = 950,
    VFMSUBSS = 951,
    VFNMADD132PD = 952,
    VFNMADD132PS = 953,
    VFNMADD132SD = 954,
    VFNMADD132SS = 955,
    VFNMADD213PD = 956,
    VFNMADD213PS = 957,
    VFNMADD213SD = 958,
    VFNMADD213SS = 959,
    VFNMADD231PD = 960,
    VFNMADD231PS = 961,
    VFNMADD231SD = 962,
    VFNMADD231SS = 963,
    VFNMADDPD = 964,
    VFNMADDPS = 965,
    VFNMADDSD = 966,
    VFNMADDSS = 967,
    VFNMSUB132PD = 968,
    VFNMSUB132PS = 969,
    VFNMSUB132SD = 970,
    VFNMSUB132SS = 971,
    VFNMSUB213PD = 972,
    VFNMSUB213PS = 973,
    VFNMSUB213SD = 974,
    VFNMSUB213SS = 975,
    VFNMSUB231PD = 976,
    VFNMSUB231PS = 977,
    VFNMSUB231SD = 978,
    VFNMSUB231SS = 979,
    VFNMSUBPD = 980,
    VFNMSUBPS = 981,
    VFNMSUBSD = 982,
    VFNMSUBSS = 983,
    VFPCLASSPD = 984,
    VFPCLASSPS = 985,
    VFPCLASSSD = 986,
    VFPCLASSSS = 987,
    VFRCZPD = 988,
    VFRCZPS = 989,
    VFRCZSD = 990,
    VFRCZSS = 991,
    VGATHERDPD = 992,
    VGATHERDPS = 993,
    VGATHERPF0DPD = 994,
    VGATHERPF0DPS = 995,
    VGATHERPF0HINTDPD = 996,
    VGATHERPF0HINTDPS = 997,
    VGATHERPF0QPD = 998,
    VGATHERPF0QPS = 999,
    VGATHERPF1DPD = 1000,
    VGATHERPF1DPS = 1001,
    VGATHERPF1QPD = 1002,
    VGATHERPF1QPS = 1003,
    VGATHERQPD = 1004,
    VGATHERQPS = 1005,
    VGETEXPPD = 1006,
    VGETEXPPS = 1007,
    VGETEXPSD = 1008,
    VGETEXPSS = 1009,
    VGETMANTPD = 1010,
    VGETMANTPS = 1011,
    VGETMANTSD = 1012,
    VGETMANTSS = 1013,
    VGF2P8AFFINEINVQB = 1014,
    VGF2P8AFFINEQB = 1015,
    VGF2P8MULB = 1016,
    VGMAXABSPS = 1017,
    VGMAXPD = 1018,
    VGMAXPS = 1019,
    VGMINPD = 1020,
    VGMINPS = 1021,
    VHADDPD = 1022,
    VHADDPS = 1023,
    VHSUBPD = 1024,
    VHSUBPS = 1025,
    VINSERTF128 = 1026,
    VINSERTF32X4 = 1027,
    VINSERTF32X8 = 1028,
    VINSERTF64X2 = 1029,
    VINSERTF64X4 = 1030,
    VINSERTI128 = 1031,
    VINSERTI32X4 = 1032,
    VINSERTI32X8 = 1033,
    VINSERTI64X2 = 1034,
    VINSERTI64X4 = 1035,
    VINSERTPS = 1036,
    VLDDQU = 1037,
    VLDMXCSR = 1038,
    VLOADUNPACKHD = 1039,
    VLOADUNPACKHPD = 1040,
    VLOADUNPACKHPS = 1041,
    VLOADUNPACKHQ = 1042,
    VLOADUNPACKLD = 1043,
    VLOADUNPACKLPD = 1044,
    VLOADUNPACKLPS = 1045,
    VLOADUNPACKLQ = 1046,
    VLOG2PS = 1047,
    VMASKMOVDQU = 1048,
    VMASKMOVPD = 1049,
    VMASKMOVPS = 1050,
    VMAXPD = 1051,
    VMAXPS = 1052,
    VMAXSD = 1053,
    VMAXSS = 1054,
    VMCALL = 1055,
    VMCLEAR = 1056,
    VMFUNC = 1057,
    VMINPD = 1058,
    VMINPS = 1059,
    VMINSD = 1060,
    VMINSS = 1061,
    VMLAUNCH = 1062,
    VMLOAD = 1063,
    VMMCALL = 1064,
    VMOVAPD = 1065,
    VMOVAPS = 1066,
    VMOVD = 1067,
    VMOVDDUP = 1068,
    VMOVDQA = 1069,
    VMOVDQA32 = 1070,
    VMOVDQA64 = 1071,
    VMOVDQU = 1072,
    VMOVDQU16 = 1073,
    VMOVDQU32 = 1074,
    VMOVDQU64 = 1075,
    VMOVDQU8 = 1076,
    VMOVHLPS = 1077,
    VMOVHPD = 1078,
    VMOVHPS = 1079,
    VMOVLHPS = 1080,
    VMOVLPD = 1081,
    VMOVLPS = 1082,
    VMOVMSKPD = 1083,
    VMOVMSKPS = 1084,
    VMOVNRAPD = 1085,
    VMOVNRAPS = 1086,
    VMOVNRNGOAPD = 1087,
    VMOVNRNGOAPS = 1088,
    VMOVNTDQ = 1089,
    VMOVNTDQA = 1090,
    VMOVNTPD = 1091,
    VMOVNTPS = 1092,
    VMOVQ = 1093,
    VMOVSD = 1094,
    VMOVSHDUP = 1095,
    VMOVSLDUP = 1096,
    VMOVSS = 1097,
    VMOVUPD = 1098,
    VMOVUPS = 1099,
    VMPSADBW = 1100,
    VMPTRLD = 1101,
    VMPTRST = 1102,
    VMREAD = 1103,
    VMRESUME = 1104,
    VMRUN = 1105,
    VMSAVE = 1106,
    VMULPD = 1107,
    VMULPS = 1108,
    VMULSD = 1109,
    VMULSS = 1110,
    VMWRITE = 1111,
    VMXOFF = 1112,
    VMXON = 1113,
    VORPD = 1114,
    VORPS = 1115,
    VP2INTERSECTD = 1116,
    VP2INTERSECTQ = 1117,
    VP4DPWSSD = 1118,
    VP4DPWSSDS = 1119,
    VPABSB = 1120,
    VPABSD = 1121,
    VPABSQ = 1122,
    VPABSW = 1123,
    VPACKSSDW = 1124,
    VPACKSSWB = 1125,
    VPACKSTOREHD = 1126,
    VPACKSTOREHPD = 1127,
    VPACKSTOREHPS = 1128,
    VPACKSTOREHQ = 1129,
    VPACKSTORELD = 1130,
    VPACKSTORELPD = 1131,
    VPACKSTORELPS = 1132,
    VPACKSTORELQ = 1133,
    VPACKUSDW = 1134,
    VPACKUSWB = 1135,
    VPADCD = 1136,
    VPADDB = 1137,
    VPADDD = 1138,
    VPADDQ = 1139,
    VPADDSB = 1140,
    VPADDSETCD = 1141,
    VPADDSETSD = 1142,
    VPADDSW = 1143,
    VPADDUSB = 1144,
    VPADDUSW = 1145,
    VPADDW = 1146,
    VPALIGNR = 1147,
    VPAND = 1148,
    VPANDD = 1149,
    VPANDN = 1150,
    VPANDND = 1151,
    VPANDNQ = 1152,
    VPANDQ = 1153,
    VPAVGB = 1154,
    VPAVGW = 1155,
    VPBLENDD = 1156,
    VPBLENDMB = 1157,
    VPBLENDMD = 1158,
    VPBLENDMQ = 1159,
    VPBLENDMW = 1160,
    VPBLENDVB = 1161,
    VPBLENDW = 1162,
    VPBROADCASTB = 1163,
    VPBROADCASTD = 1164,
    VPBROADCASTMB2Q = 1165,
    VPBROADCASTMW2D = 1166,
    VPBROADCASTQ = 1167,
    VPBROADCASTW = 1168,
    VPCLMULQDQ = 1169,
    VPCMOV = 1170,
    VPCMPB = 1171,
    VPCMPD = 1172,
    VPCMPEQB = 1173,
    VPCMPEQD = 1174,
    VPCMPEQQ = 1175,
    VPCMPEQW = 1176,
    VPCMPESTRI = 1177,
    VPCMPESTRM = 1178,
    VPCMPGTB = 1179,
    VPCMPGTD = 1180,
    VPCMPGTQ = 1181,
    VPCMPGTW = 1182,
    VPCMPISTRI = 1183,
    VPCMPISTRM = 1184,
    VPCMPLTD = 1185,
    VPCMPQ = 1186,
    VPCMPUB = 1187,
    VPCMPUD = 1188,
    VPCMPUQ = 1189,
    VPCMPUW = 1190,
    VPCMPW = 1191,
    VPCOMB = 1192,
    VPCOMD = 1193,
    VPCOMPRESSB = 1194,
    VPCOMPRESSD = 1195,
    VPCOMPRESSQ = 1196,
    VPCOMPRESSW = 1197,
    VPCOMQ = 1198,
    VPCOMUB = 1199,
    VPCOMUD = 1200,
    VPCOMUQ = 1201,
    VPCOMUW = 1202,
    VPCOMW = 1203,
    VPCONFLICTD = 1204,
    VPCONFLICTQ = 1205,
    VPDPBUSD = 1206,
    VPDPBUSDS = 1207,
    VPDPWSSD = 1208,
    VPDPWSSDS = 1209,
    VPERM2F128 = 1210,
    VPERM2I128 = 1211,
    VPERMB = 1212,
    VPERMD = 1213,
    VPERMF32X4 = 1214,
    VPERMI2B = 1215,
    VPERMI2D = 1216,
    VPERMI2PD = 1217,
    VPERMI2PS = 1218,
    VPERMI2Q = 1219,
    VPERMI2W = 1220,
    VPERMIL2PD = 1221,
    VPERMIL2PS = 1222,
    VPERMILPD = 1223,
    VPERMILPS = 1224,
    VPERMPD = 1225,
    VPERMPS = 1226,
    VPERMQ = 1227,
    VPERMT2B = 1228,
    VPERMT2D = 1229,
    VPERMT2PD = 1230,
    VPERMT2PS = 1231,
    VPERMT2Q = 1232,
    VPERMT2W = 1233,
    VPERMW = 1234,
    VPEXPANDB = 1235,
    VPEXPANDD = 1236,
    VPEXPANDQ = 1237,
    VPEXPANDW = 1238,
    VPEXTRB = 1239,
    VPEXTRD = 1240,
    VPEXTRQ = 1241,
    VPEXTRW = 1242,
    VPGATHERDD = 1243,
    VPGATHERDQ = 1244,
    VPGATHERQD = 1245,
    VPGATHERQQ = 1246,
    VPHADDBD = 1247,
    VPHADDBQ = 1248,
    VPHADDBW = 1249,
    VPHADDD = 1250,
    VPHADDDQ = 1251,
    VPHADDSW = 1252,
    VPHADDUBD = 1253,
    VPHADDUBQ = 1254,
    VPHADDUBW = 1255,
    VPHADDUDQ = 1256,
    VPHADDUWD = 1257,
    VPHADDUWQ = 1258,
    VPHADDW = 1259,
    VPHADDWD = 1260,
    VPHADDWQ = 1261,
    VPHMINPOSUW = 1262,
    VPHSUBBW = 1263,
    VPHSUBD = 1264,
    VPHSUBDQ = 1265,
    VPHSUBSW = 1266,
    VPHSUBW = 1267,
    VPHSUBWD = 1268,
    VPINSRB = 1269,
    VPINSRD = 1270,
    VPINSRQ = 1271,
    VPINSRW = 1272,
    VPLZCNTD = 1273,
    VPLZCNTQ = 1274,
    VPMACSDD = 1275,
    VPMACSDQH = 1276,
    VPMACSDQL = 1277,
    VPMACSSDD = 1278,
    VPMACSSDQH = 1279,
    VPMACSSDQL = 1280,
    VPMACSSWD = 1281,
    VPMACSSWW = 1282,
    VPMACSWD = 1283,
    VPMACSWW = 1284,
    VPMADCSSWD = 1285,
    VPMADCSWD = 1286,
    VPMADD231D = 1287,
    VPMADD233D = 1288,
    VPMADD52HUQ = 1289,
    VPMADD52LUQ = 1290,
    VPMADDUBSW = 1291,
    VPMADDWD = 1292,
    VPMASKMOVD = 1293,
    VPMASKMOVQ = 1294,
    VPMAXSB = 1295,
    VPMAXSD = 1296,
    VPMAXSQ = 1297,
    VPMAXSW = 1298,
    VPMAXUB = 1299,
    VPMAXUD = 1300,
    VPMAXUQ = 1301,
    VPMAXUW = 1302,
    VPMINSB = 1303,
    VPMINSD = 1304,
    VPMINSQ = 1305,
    VPMINSW = 1306,
    VPMINUB = 1307,
    VPMINUD = 1308,
    VPMINUQ = 1309,
    VPMINUW = 1310,
    VPMOVB2M = 1311,
    VPMOVD2M = 1312,
    VPMOVDB = 1313,
    VPMOVDW = 1314,
    VPMOVM2B = 1315,
    VPMOVM2D = 1316,
    VPMOVM2Q = 1317,
    VPMOVM2W = 1318,
    VPMOVMSKB = 1319,
    VPMOVQ2M = 1320,
    VPMOVQB = 1321,
    VPMOVQD = 1322,
    VPMOVQW = 1323,
    VPMOVSDB = 1324,
    VPMOVSDW = 1325,
    VPMOVSQB = 1326,
    VPMOVSQD = 1327,
    VPMOVSQW = 1328,
    VPMOVSWB = 1329,
    VPMOVSXBD = 1330,
    VPMOVSXBQ = 1331,
    VPMOVSXBW = 1332,
    VPMOVSXDQ = 1333,
    VPMOVSXWD = 1334,
    VPMOVSXWQ = 1335,
    VPMOVUSDB = 1336,
    VPMOVUSDW = 1337,
    VPMOVUSQB = 1338,
    VPMOVUSQD = 1339,
    VPMOVUSQW = 1340,
    VPMOVUSWB = 1341,
    VPMOVW2M = 1342,
    VPMOVWB = 1343,
    VPMOVZXBD = 1344,
    VPMOVZXBQ = 1345,
    VPMOVZXBW = 1346,
    VPMOVZXDQ = 1347,
    VPMOVZXWD = 1348,
    VPMOVZXWQ = 1349,
    VPMULDQ = 1350,
    VPMULHD = 1351,
    VPMULHRSW = 1352,
    VPMULHUD = 1353,
    VPMULHUW = 1354,
    VPMULHW = 1355,
    VPMULLD = 1356,
    VPMULLQ = 1357,
    VPMULLW = 1358,
    VPMULTISHIFTQB = 1359,
    VPMULUDQ = 1360,
    VPOPCNTB = 1361,
    VPOPCNTD = 1362,
    VPOPCNTQ = 1363,
    VPOPCNTW = 1364,
    VPOR = 1365,
    VPORD = 1366,
    VPORQ = 1367,
    VPPERM = 1368,
    VPREFETCH0 = 1369,
    VPREFETCH1 = 1370,
    VPREFETCH2 = 1371,
    VPREFETCHE0 = 1372,
    VPREFETCHE1 = 1373,
    VPREFETCHE2 = 1374,
    VPREFETCHENTA = 1375,
    VPREFETCHNTA = 1376,
    VPROLD = 1377,
    VPROLQ = 1378,
    VPROLVD = 1379,
    VPROLVQ = 1380,
    VPRORD = 1381,
    VPRORQ = 1382,
    VPRORVD = 1383,
    VPRORVQ = 1384,
    VPROTB = 1385,
    VPROTD = 1386,
    VPROTQ = 1387,
    VPROTW = 1388,
    VPSADBW = 1389,
    VPSBBD = 1390,
    VPSBBRD = 1391,
    VPSCATTERDD = 1392,
    VPSCATTERDQ = 1393,
    VPSCATTERQD = 1394,
    VPSCATTERQQ = 1395,
    VPSHAB = 1396,
    VPSHAD = 1397,
    VPSHAQ = 1398,
    VPSHAW = 1399,
    VPSHLB = 1400,
    VPSHLD = 1401,
    VPSHLDD = 1402,
    VPSHLDQ = 1403,
    VPSHLDVD = 1404,
    VPSHLDVQ = 1405,
    VPSHLDVW = 1406,
    VPSHLDW = 1407,
    VPSHLQ = 1408,
    VPSHLW = 1409,
    VPSHRDD = 1410,
    VPSHRDQ = 1411,
    VPSHRDVD = 1412,
    VPSHRDVQ = 1413,
    VPSHRDVW = 1414,
    VPSHRDW = 1415,
    VPSHUFB = 1416,
    VPSHUFBITQMB = 1417,
    VPSHUFD = 1418,
    VPSHUFHW = 1419,
    VPSHUFLW = 1420,
    VPSIGNB = 1421,
    VPSIGND = 1422,
    VPSIGNW = 1423,
    VPSLLD = 1424,
    VPSLLDQ = 1425,
    VPSLLQ = 1426,
    VPSLLVD = 1427,
    VPSLLVQ = 1428,
    VPSLLVW = 1429,
    VPSLLW = 1430,
    VPSRAD = 1431,
    VPSRAQ = 1432,
    VPSRAVD = 1433,
    VPSRAVQ = 1434,
    VPSRAVW = 1435,
    VPSRAW = 1436,
    VPSRLD = 1437,
    VPSRLDQ = 1438,
    VPSRLQ = 1439,
    VPSRLVD = 1440,
    VPSRLVQ = 1441,
    VPSRLVW = 1442,
    VPSRLW = 1443,
    VPSUBB = 1444,
    VPSUBD = 1445,
    VPSUBQ = 1446,
    VPSUBRD = 1447,
    VPSUBRSETBD = 1448,
    VPSUBSB = 1449,
    VPSUBSETBD = 1450,
    VPSUBSW = 1451,
    VPSUBUSB = 1452,
    VPSUBUSW = 1453,
    VPSUBW = 1454,
    VPTERNLOGD = 1455,
    VPTERNLOGQ = 1456,
    VPTEST = 1457,
    VPTESTMB = 1458,
    VPTESTMD = 1459,
    VPTESTMQ = 1460,
    VPTESTMW = 1461,
    VPTESTNMB = 1462,
    VPTESTNMD = 1463,
    VPTESTNMQ = 1464,
    VPTESTNMW = 1465,
    VPUNPCKHBW = 1466,
    VPUNPCKHDQ = 1467,
    VPUNPCKHQDQ = 1468,
    VPUNPCKHWD = 1469,
    VPUNPCKLBW = 1470,
    VPUNPCKLDQ = 1471,
    VPUNPCKLQDQ = 1472,
    VPUNPCKLWD = 1473,
    VPXOR = 1474,
    VPXORD = 1475,
    VPXORQ = 1476,
    VRANGEPD = 1477,
    VRANGEPS = 1478,
    VRANGESD = 1479,
    VRANGESS = 1480,
    VRCP14PD = 1481,
    VRCP14PS = 1482,
    VRCP14SD = 1483,
    VRCP14SS = 1484,
    VRCP23PS = 1485,
    VRCP28PD = 1486,
    VRCP28PS = 1487,
    VRCP28SD = 1488,
    VRCP28SS = 1489,
    VRCPPS = 1490,
    VRCPSS = 1491,
    VREDUCEPD = 1492,
    VREDUCEPS = 1493,
    VREDUCESD = 1494,
    VREDUCESS = 1495,
    VRNDFXPNTPD = 1496,
    VRNDFXPNTPS = 1497,
    VRNDSCALEPD = 1498,
    VRNDSCALEPS = 1499,
    VRNDSCALESD = 1500,
    VRNDSCALESS = 1501,
    VROUNDPD = 1502,
    VROUNDPS = 1503,
    VROUNDSD = 1504,
    VROUNDSS = 1505,
    VRSQRT14PD = 1506,
    VRSQRT14PS = 1507,
    VRSQRT14SD = 1508,
    VRSQRT14SS = 1509,
    VRSQRT23PS = 1510,
    VRSQRT28PD = 1511,
    VRSQRT28PS = 1512,
    VRSQRT28SD = 1513,
    VRSQRT28SS = 1514,
    VRSQRTPS = 1515,
    VRSQRTSS = 1516,
    VSCALEFPD = 1517,
    VSCALEFPS = 1518,
    VSCALEFSD = 1519,
    VSCALEFSS = 1520,
    VSCALEPS = 1521,
    VSCATTERDPD = 1522,
    VSCATTERDPS = 1523,
    VSCATTERPF0DPD = 1524,
    VSCATTERPF0DPS = 1525,
    VSCATTERPF0HINTDPD = 1526,
    VSCATTERPF0HINTDPS = 1527,
    VSCATTERPF0QPD = 1528,
    VSCATTERPF0QPS = 1529,
    VSCATTERPF1DPD = 1530,
    VSCATTERPF1DPS = 1531,
    VSCATTERPF1QPD = 1532,
    VSCATTERPF1QPS = 1533,
    VSCATTERQPD = 1534,
    VSCATTERQPS = 1535,
    VSHUFF32X4 = 1536,
    VSHUFF64X2 = 1537,
    VSHUFI32X4 = 1538,
    VSHUFI64X2 = 1539,
    VSHUFPD = 1540,
    VSHUFPS = 1541,
    VSQRTPD = 1542,
    VSQRTPS = 1543,
    VSQRTSD = 1544,
    VSQRTSS = 1545,
    VSTMXCSR = 1546,
    VSUBPD = 1547,
    VSUBPS = 1548,
    VSUBRPD = 1549,
    VSUBRPS = 1550,
    VSUBSD = 1551,
    VSUBSS = 1552,
    VTESTPD = 1553,
    VTESTPS = 1554,
    VUCOMISD = 1555,
    VUCOMISS = 1556,
    VUNPCKHPD = 1557,
    VUNPCKHPS = 1558,
    VUNPCKLPD = 1559,
    VUNPCKLPS = 1560,
    VXORPD = 1561,
    VXORPS = 1562,
    VZEROALL = 1563,
    VZEROUPPER = 1564,
    WBINVD = 1565,
    WRFSBASE = 1566,
    WRGSBASE = 1567,
    WRMSR = 1568,
    WRPKRU = 1569,
    WRSSD = 1570,
    WRSSQ = 1571,
    WRUSSD = 1572,
    WRUSSQ = 1573,
    XABORT = 1574,
    XADD = 1575,
    XBEGIN = 1576,
    XCHG = 1577,
    XCRYPT_CBC = 1578,
    XCRYPT_CFB = 1579,
    XCRYPT_CTR = 1580,
    XCRYPT_ECB = 1581,
    XCRYPT_OFB = 1582,
    XEND = 1583,
    XGETBV = 1584,
    XLAT = 1585,
    XOR = 1586,
    XORPD = 1587,
    XORPS = 1588,
    XRSTOR = 1589,
    XRSTOR64 = 1590,
    XRSTORS = 1591,
    XRSTORS64 = 1592,
    XSAVE = 1593,
    XSAVE64 = 1594,
    XSAVEC = 1595,
    XSAVEC64 = 1596,
    XSAVEOPT = 1597,
    XSAVEOPT64 = 1598,
    XSAVES = 1599,
    XSAVES64 = 1600,
    XSETBV = 1601,
    XSHA1 = 1602,
    XSHA256 = 1603,
    XSTORE = 1604,
    XTEST = 1605,
}

pub const MNEMONIC_MAX_VALUE: usize = 1605;

/// Defines the `ZydisMachineMode` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum MachineMode {
    /// 64 bit mode.
    LONG_64 = 0,
    /// 32 bit protected mode.
    LONG_COMPAT_32 = 1,
    /// 16 bit protected mode.
    LONG_COMPAT_16 = 2,
    /// 32 bit protected mode.
    LEGACY_32 = 3,
    /// 16 bit protected mode.
    LEGACY_16 = 4,
    /// 16 bit real mode.
    REAL_16 = 5,
}

pub const MACHINE_MODE_MAX_VALUE: usize = 5;

/// Defines the `ZydisAddressWidth` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum AddressWidth {
    _16 = 0,
    _32 = 1,
    _64 = 2,
}

pub const ADDRESS_WIDTH_MAX_VALUE: usize = 2;

/// Defines the `ZydisElementType` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum ElementType {
    INVALID = 0,
    /// A struct type.
    STRUCT = 1,
    /// Unsigned integer value.
    UINT = 2,
    /// Signed integer value.
    INT = 3,
    /// 16-bit floating point value (`half`).
    FLOAT16 = 4,
    /// 32-bit floating point value (`single`).
    FLOAT32 = 5,
    /// 64-bit floating point value (`double`).
    FLOAT64 = 6,
    /// 80-bit floating point value (`extended`).
    FLOAT80 = 7,
    /// Binary coded decimal value.
    LONGBCD = 8,
    /// A condition code (e.g. used by `CMPPD`, `VCMPPD`, ...).
    CC = 9,
}

pub const ELEMENT_TYPE_MAX_VALUE: usize = 9;

/// Defines the `ZydisOperandType` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum OperandType {
    /// The operand is not used.
    UNUSED = 0,
    /// The operand is a register operand.
    REGISTER = 1,
    /// The operand is a memory operand.
    MEMORY = 2,
    /// The operand is a pointer operand with a segment:offset lvalue.
    POINTER = 3,
    /// The operand is an immediate operand.
    IMMEDIATE = 4,
}

pub const OPERAND_TYPE_MAX_VALUE: usize = 4;

/// Defines the `ZydisOperandEncoding` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum OperandEncoding {
    NONE = 0,
    MODRM_REG = 1,
    MODRM_RM = 2,
    OPCODE = 3,
    NDSNDD = 4,
    IS4 = 5,
    MASK = 6,
    DISP8 = 7,
    DISP16 = 8,
    DISP32 = 9,
    DISP64 = 10,
    DISP16_32_64 = 11,
    DISP32_32_64 = 12,
    DISP16_32_32 = 13,
    UIMM8 = 14,
    UIMM16 = 15,
    UIMM32 = 16,
    UIMM64 = 17,
    UIMM16_32_64 = 18,
    UIMM32_32_64 = 19,
    UIMM16_32_32 = 20,
    SIMM8 = 21,
    SIMM16 = 22,
    SIMM32 = 23,
    SIMM64 = 24,
    SIMM16_32_64 = 25,
    SIMM32_32_64 = 26,
    SIMM16_32_32 = 27,
    JIMM8 = 28,
    JIMM16 = 29,
    JIMM32 = 30,
    JIMM64 = 31,
    JIMM16_32_64 = 32,
    JIMM32_32_64 = 33,
    JIMM16_32_32 = 34,
}

pub const OPERAND_ENCODING_MAX_VALUE: usize = 34;

/// Defines the `ZydisOperandVisibility` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum OperandVisibility {
    INVALID = 0,
    /// The operand is explicitly encoded in the instruction.
    EXPLICIT = 1,
    /// The operand is part of the opcode, but listed as an operand.
    IMPLICIT = 2,
    /// The operand is part of the opcode, and not typically listed as an operand.
    HIDDEN = 3,
}

pub const OPERAND_VISIBILITY_MAX_VALUE: usize = 3;

/// Defines the `ZydisInstructionEncoding` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum InstructionEncoding {
    /// The instruction uses the legacy encoding.
    LEGACY = 0,
    /// The instruction uses the AMD 3DNow-encoding.
    _3DNOW = 1,
    /// The instruction uses the AMD XOP-encoding.
    XOP = 2,
    /// The instruction uses the VEX-encoding.
    VEX = 3,
    /// The instruction uses the EVEX-encoding.
    EVEX = 4,
    /// The instruction uses the MVEX-encoding.
    MVEX = 5,
}

pub const INSTRUCTION_ENCODING_MAX_VALUE: usize = 5;

/// Defines the `ZydisOpcodeMap` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum OpcodeMap {
    DEFAULT = 0,
    _0F = 1,
    _0F38 = 2,
    _0F3A = 3,
    _0F0F = 4,
    XOP8 = 5,
    XOP9 = 6,
    XOPA = 7,
}

pub const OPCODE_MAP_MAX_VALUE: usize = 7;

/// Defines the `ZydisRegister` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum Register {
    NONE = 0,
    AL = 1,
    CL = 2,
    DL = 3,
    BL = 4,
    AH = 5,
    CH = 6,
    DH = 7,
    BH = 8,
    SPL = 9,
    BPL = 10,
    SIL = 11,
    DIL = 12,
    R8B = 13,
    R9B = 14,
    R10B = 15,
    R11B = 16,
    R12B = 17,
    R13B = 18,
    R14B = 19,
    R15B = 20,
    AX = 21,
    CX = 22,
    DX = 23,
    BX = 24,
    SP = 25,
    BP = 26,
    SI = 27,
    DI = 28,
    R8W = 29,
    R9W = 30,
    R10W = 31,
    R11W = 32,
    R12W = 33,
    R13W = 34,
    R14W = 35,
    R15W = 36,
    EAX = 37,
    ECX = 38,
    EDX = 39,
    EBX = 40,
    ESP = 41,
    EBP = 42,
    ESI = 43,
    EDI = 44,
    R8D = 45,
    R9D = 46,
    R10D = 47,
    R11D = 48,
    R12D = 49,
    R13D = 50,
    R14D = 51,
    R15D = 52,
    RAX = 53,
    RCX = 54,
    RDX = 55,
    RBX = 56,
    RSP = 57,
    RBP = 58,
    RSI = 59,
    RDI = 60,
    R8 = 61,
    R9 = 62,
    R10 = 63,
    R11 = 64,
    R12 = 65,
    R13 = 66,
    R14 = 67,
    R15 = 68,
    ST0 = 69,
    ST1 = 70,
    ST2 = 71,
    ST3 = 72,
    ST4 = 73,
    ST5 = 74,
    ST6 = 75,
    ST7 = 76,
    X87CONTROL = 77,
    X87STATUS = 78,
    X87TAG = 79,
    MM0 = 80,
    MM1 = 81,
    MM2 = 82,
    MM3 = 83,
    MM4 = 84,
    MM5 = 85,
    MM6 = 86,
    MM7 = 87,
    XMM0 = 88,
    XMM1 = 89,
    XMM2 = 90,
    XMM3 = 91,
    XMM4 = 92,
    XMM5 = 93,
    XMM6 = 94,
    XMM7 = 95,
    XMM8 = 96,
    XMM9 = 97,
    XMM10 = 98,
    XMM11 = 99,
    XMM12 = 100,
    XMM13 = 101,
    XMM14 = 102,
    XMM15 = 103,
    XMM16 = 104,
    XMM17 = 105,
    XMM18 = 106,
    XMM19 = 107,
    XMM20 = 108,
    XMM21 = 109,
    XMM22 = 110,
    XMM23 = 111,
    XMM24 = 112,
    XMM25 = 113,
    XMM26 = 114,
    XMM27 = 115,
    XMM28 = 116,
    XMM29 = 117,
    XMM30 = 118,
    XMM31 = 119,
    YMM0 = 120,
    YMM1 = 121,
    YMM2 = 122,
    YMM3 = 123,
    YMM4 = 124,
    YMM5 = 125,
    YMM6 = 126,
    YMM7 = 127,
    YMM8 = 128,
    YMM9 = 129,
    YMM10 = 130,
    YMM11 = 131,
    YMM12 = 132,
    YMM13 = 133,
    YMM14 = 134,
    YMM15 = 135,
    YMM16 = 136,
    YMM17 = 137,
    YMM18 = 138,
    YMM19 = 139,
    YMM20 = 140,
    YMM21 = 141,
    YMM22 = 142,
    YMM23 = 143,
    YMM24 = 144,
    YMM25 = 145,
    YMM26 = 146,
    YMM27 = 147,
    YMM28 = 148,
    YMM29 = 149,
    YMM30 = 150,
    YMM31 = 151,
    ZMM0 = 152,
    ZMM1 = 153,
    ZMM2 = 154,
    ZMM3 = 155,
    ZMM4 = 156,
    ZMM5 = 157,
    ZMM6 = 158,
    ZMM7 = 159,
    ZMM8 = 160,
    ZMM9 = 161,
    ZMM10 = 162,
    ZMM11 = 163,
    ZMM12 = 164,
    ZMM13 = 165,
    ZMM14 = 166,
    ZMM15 = 167,
    ZMM16 = 168,
    ZMM17 = 169,
    ZMM18 = 170,
    ZMM19 = 171,
    ZMM20 = 172,
    ZMM21 = 173,
    ZMM22 = 174,
    ZMM23 = 175,
    ZMM24 = 176,
    ZMM25 = 177,
    ZMM26 = 178,
    ZMM27 = 179,
    ZMM28 = 180,
    ZMM29 = 181,
    ZMM30 = 182,
    ZMM31 = 183,
    FLAGS = 184,
    EFLAGS = 185,
    RFLAGS = 186,
    IP = 187,
    EIP = 188,
    RIP = 189,
    ES = 190,
    CS = 191,
    SS = 192,
    DS = 193,
    FS = 194,
    GS = 195,
    GDTR = 196,
    LDTR = 197,
    IDTR = 198,
    TR = 199,
    TR0 = 200,
    TR1 = 201,
    TR2 = 202,
    TR3 = 203,
    TR4 = 204,
    TR5 = 205,
    TR6 = 206,
    TR7 = 207,
    CR0 = 208,
    CR1 = 209,
    CR2 = 210,
    CR3 = 211,
    CR4 = 212,
    CR5 = 213,
    CR6 = 214,
    CR7 = 215,
    CR8 = 216,
    CR9 = 217,
    CR10 = 218,
    CR11 = 219,
    CR12 = 220,
    CR13 = 221,
    CR14 = 222,
    CR15 = 223,
    DR0 = 224,
    DR1 = 225,
    DR2 = 226,
    DR3 = 227,
    DR4 = 228,
    DR5 = 229,
    DR6 = 230,
    DR7 = 231,
    DR8 = 232,
    DR9 = 233,
    DR10 = 234,
    DR11 = 235,
    DR12 = 236,
    DR13 = 237,
    DR14 = 238,
    DR15 = 239,
    K0 = 240,
    K1 = 241,
    K2 = 242,
    K3 = 243,
    K4 = 244,
    K5 = 245,
    K6 = 246,
    K7 = 247,
    BND0 = 248,
    BND1 = 249,
    BND2 = 250,
    BND3 = 251,
    BNDCFG = 252,
    BNDSTATUS = 253,
    MXCSR = 254,
    PKRU = 255,
    XCR0 = 256,
}

pub const REGISTER_MAX_VALUE: usize = 256;

/// Defines the `ZydisRegisterClass` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum RegisterClass {
    INVALID = 0,
    /// 8-bit general-purpose registers.
    GPR8 = 1,
    /// 16-bit general-purpose registers.
    GPR16 = 2,
    /// 32-bit general-purpose registers.
    GPR32 = 3,
    /// 64-bit general-purpose registers.
    GPR64 = 4,
    /// Floating point legacy registers.
    X87 = 5,
    /// Floating point multimedia registers.
    MMX = 6,
    /// 128-bit vector registers.
    XMM = 7,
    /// 256-bit vector registers.
    YMM = 8,
    /// 512-bit vector registers.
    ZMM = 9,
    /// Flags registers.
    FLAGS = 10,
    /// Instruction-pointer registers.
    IP = 11,
    /// Segment registers.
    SEGMENT = 12,
    /// Test registers.
    TEST = 13,
    /// Control registers.
    CONTROL = 14,
    /// Debug registers.
    DEBUG = 15,
    /// Mask registers.
    MASK = 16,
    /// Bound registers.
    BOUND = 17,
}

pub const REGCLASS_MAX_VALUE: usize = 17;

/// Defines the `ZydisMemoryOperandType` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum MemoryOperandType {
    INVALID = 0,
    /// Normal memory operand.
    MEM = 1,
    /// The memory operand is only used for address-generation. No real memory-access is caused.
    AGEN = 2,
    /// A memory operand using `SIB` addressing form, where the index register is not used in address calculation and scale is ignored. No real memory-access is caused.
    MIB = 3,
}

pub const MEMOP_TYPE_MAX_VALUE: usize = 3;

/// Defines the `ZydisCPUFlag` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum CPUFlag {
    /// Carry flag.
    CF = 0,
    /// Parity flag.
    PF = 1,
    /// Adjust flag.
    AF = 2,
    /// Zero flag.
    ZF = 3,
    /// Sign flag.
    SF = 4,
    /// Trap flag.
    TF = 5,
    /// Interrupt enable flag.
    IF = 6,
    /// Direction flag.
    DF = 7,
    /// Overflow flag.
    OF = 8,
    /// I/O privilege level flag.
    IOPL = 9,
    /// Nested task flag.
    NT = 10,
    /// Resume flag.
    RF = 11,
    /// Virtual 8086 mode flag.
    VM = 12,
    /// Alignment check.
    AC = 13,
    /// Virtual interrupt flag.
    VIF = 14,
    /// Virtual interrupt pending.
    VIP = 15,
    /// Able to use CPUID instruction.
    ID = 16,
    /// FPU condition-code flag 0.
    C0 = 17,
    /// FPU condition-code flag 1.
    C1 = 18,
    /// FPU condition-code flag 2.
    C2 = 19,
    /// FPU condition-code flag 3.
    C3 = 20,
}

pub const CPUFLAG_MAX_VALUE: usize = 20;

/// Defines the `ZydisCPUFlagAction` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum CPUFlagAction {
    /// The CPU flag is not touched by the instruction.
    NONE = 0,
    /// The CPU flag is tested (read).
    TESTED = 1,
    /// The CPU flag is tested and modified afterwards (read-write).
    TESTED_MODIFIED = 2,
    /// The CPU flag is modified (write).
    MODIFIED = 3,
    /// The CPU flag is set to 0 (write).
    SET_0 = 4,
    /// The CPU flag is set to 1 (write).
    SET_1 = 5,
    /// The CPU flag is undefined (write).
    UNDEFINED = 6,
}

pub const CPUFLAG_ACTION_MAX_VALUE: usize = 6;

/// Defines the `ZydisBranchType` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum BranchType {
    /// The instruction is not a branch instruction.
    NONE = 0,
    /// The instruction is a short (8-bit) branch instruction.
    SHORT = 1,
    /// The instruction is a near (16-bit or 32-bit) branch instruction.
    NEAR = 2,
    /// The instruction is a far (inter-segment) branch instruction.
    FAR = 3,
}

pub const BRANCH_TYPE_MAX_VALUE: usize = 3;

/// Defines the `ZydisExceptionClass` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum ExceptionClass {
    NONE = 0,
    SSE1 = 1,
    SSE2 = 2,
    SSE3 = 3,
    SSE4 = 4,
    SSE5 = 5,
    SSE7 = 6,
    AVX1 = 7,
    AVX2 = 8,
    AVX3 = 9,
    AVX4 = 10,
    AVX5 = 11,
    AVX6 = 12,
    AVX7 = 13,
    AVX8 = 14,
    AVX11 = 15,
    AVX12 = 16,
    E1 = 17,
    E1NF = 18,
    E2 = 19,
    E2NF = 20,
    E3 = 21,
    E3NF = 22,
    E4 = 23,
    E4NF = 24,
    E5 = 25,
    E5NF = 26,
    E6 = 27,
    E6NF = 28,
    E7NM = 29,
    E7NM128 = 30,
    E9NF = 31,
    E10 = 32,
    E10NF = 33,
    E11 = 34,
    E11NF = 35,
    E12 = 36,
    E12NP = 37,
    K20 = 38,
    K21 = 39,
}

pub const EXCEPTION_CLASS_MAX_VALUE: usize = 39;

/// Defines the `ZydisMaskMode` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum MaskMode {
    INVALID = 0,
    /// Masking is disabled for the current instruction (`K0` register is used).
    DISABLED = 1,
    /// The embedded mask register is used as a merge-mask.
    MERGING = 2,
    /// The embedded mask register is used as a zero-mask.
    ZEROING = 3,
    /// The embedded mask register is used as a control-mask (element selector).
    CONTROL = 4,
    /// The embedded mask register is used as a zeroing control-mask (element selector).
    CONTROL_ZEROING = 5,
}

pub const MASK_MODE_MAX_VALUE: usize = 5;

/// Defines the `ZydisBroadcastMode` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum BroadcastMode {
    INVALID = 0,
    _1_TO_2 = 1,
    _1_TO_4 = 2,
    _1_TO_8 = 3,
    _1_TO_16 = 4,
    _1_TO_32 = 5,
    _1_TO_64 = 6,
    _2_TO_4 = 7,
    _2_TO_8 = 8,
    _2_TO_16 = 9,
    _4_TO_8 = 10,
    _4_TO_16 = 11,
    _8_TO_16 = 12,
}

pub const BROADCAST_MODE_MAX_VALUE: usize = 12;

/// Defines the `ZydisRoundingMode` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum RoundingMode {
    INVALID = 0,
    /// Round to nearest.
    RN = 1,
    /// Round down.
    RD = 2,
    /// Round up.
    RU = 3,
    /// Round towards zero.
    RZ = 4,
}

pub const ROUNDING_MODE_MAX_VALUE: usize = 4;

/// Defines the `ZydisSwizzleMode` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum SwizzleMode {
    INVALID = 0,
    DCBA = 1,
    CDAB = 2,
    BADC = 3,
    DACB = 4,
    AAAA = 5,
    BBBB = 6,
    CCCC = 7,
    DDDD = 8,
}

pub const SWIZZLE_MODE_MAX_VALUE: usize = 8;

/// Defines the `ZydisConversionMode` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum ConversionMode {
    INVALID = 0,
    FLOAT16 = 1,
    SINT8 = 2,
    UINT8 = 3,
    SINT16 = 4,
    UINT16 = 5,
}

pub const CONVERSION_MODE_MAX_VALUE: usize = 5;

/// Defines the `ZydisPrefixType` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum PrefixType {
    /// The prefix is ignored by the instruction.
    IGNORED = 0,
    /// The prefix is effectively used by the instruction.
    EFFECTIVE = 1,
    /// The prefix is used as a mandatory prefix.
    MANDATORY = 2,
}

pub const PREFIX_TYPE_MAX_VALUE: usize = 2;

/// Defines the `ZydisDecoderMode` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum DecoderMode {
    /// Enables minimal instruction decoding without semantic analysis.
    MINIMAL = 0,
    /// Enables the `AMD`-branch mode.
    AMD_BRANCHES = 1,
    /// Enables `KNC` compatibility-mode.
    KNC = 2,
    /// Enables the `MPX` mode.
    MPX = 3,
    /// Enables the `CET` mode.
    CET = 4,
    /// Enables the `LZCNT` mode.
    LZCNT = 5,
    /// Enables the `TZCNT` mode.
    TZCNT = 6,
    /// Enables the `WBNOINVD` mode.
    WBNOINVD = 7,
    /// Enables the `CLDEMOTE` mode.
    CLDEMOTE = 8,
}

pub const DECODER_MODE_MAX_VALUE: usize = 8;

/// Defines the `ZydisFormatterStyle` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum FormatterStyle {
    /// Generates `AT&T`-style disassembly.
    ATT = 0,
    /// Generates `Intel`-style disassembly.
    INTEL = 1,
    /// Generates `MASM`-style disassembly that is directly accepted as input for the `MASM` assembler.
    INTEL_MASM = 2,
}

pub const FORMATTER_STYLE_MAX_VALUE: usize = 2;

/// We wrap this in a nicer rust enum `FormatterProperty` already,
/// use that instead.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq)]
#[repr(C)]
pub enum ZydisFormatterProperty {
    /// Controls the printing of effective operand-size suffixes (`AT&T`) or operand-sizes of memory operands (`INTEL`).
    FORCE_SIZE = 0,
    /// Controls the printing of segment prefixes.
    FORCE_SEGMENT = 1,
    /// Controls the printing of branch addresses.
    FORCE_RELATIVE_BRANCHES = 2,
    /// Controls the printing of `EIP`/`RIP`-relative addresses.
    FORCE_RELATIVE_RIPREL = 3,
    /// Controls the printing of branch-instructions sizes.
    PRINT_BRANCH_SIZE = 4,
    /// Controls the printing of instruction prefixes.
    DETAILED_PREFIXES = 5,
    /// Controls the base of address values.
    ADDR_BASE = 6,
    /// Controls the signedness of relative addresses. Absolute addresses are always unsigned.
    ADDR_SIGNEDNESS = 7,
    /// Controls the padding of absolute address values.
    ADDR_PADDING_ABSOLUTE = 8,
    /// Controls the padding of relative address values.
    ADDR_PADDING_RELATIVE = 9,
    /// Controls the base of displacement values.
    DISP_BASE = 10,
    /// Controls the signedness of displacement values.
    DISP_SIGNEDNESS = 11,
    /// Controls the padding of displacement values.
    DISP_PADDING = 12,
    /// Controls the base of immediate values.
    IMM_BASE = 13,
    /// Controls the signedness of immediate values.
    IMM_SIGNEDNESS = 14,
    /// Controls the padding of immediate values.
    IMM_PADDING = 15,
    /// Controls the letter-case for prefixes.
    UPPERCASE_PREFIXES = 16,
    /// Controls the letter-case for the mnemonic.
    UPPERCASE_MNEMONIC = 17,
    /// Controls the letter-case for registers.
    UPPERCASE_REGISTERS = 18,
    /// Controls the letter-case for typecasts.
    UPPERCASE_TYPECASTS = 19,
    /// Controls the letter-case for decorators.
    UPPERCASE_DECORATORS = 20,
    /// Controls the prefix for decimal values.
    DEC_PREFIX = 21,
    /// Controls the suffix for decimal values.
    DEC_SUFFIX = 22,
    /// Controls the letter-case of hexadecimal values.
    HEX_UPPERCASE = 23,
    /// Controls the prefix for hexadecimal values.
    HEX_PREFIX = 24,
    /// Controls the suffix for hexadecimal values.
    HEX_SUFFIX = 25,
}

pub const FORMATTER_PROP_MAX_VALUE: usize = 25;

/// Defines the `ZydisNumericBase` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum NumericBase {
    /// Decimal system.
    DEC = 0,
    /// Hexadecimal system.
    HEX = 1,
}

pub const NUMERIC_BASE_MAX_VALUE: usize = 1;

/// Defines the `ZydisSignedness` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum Signedness {
    /// Automatically choose the most suitable mode based on the operands `ZydisDecodedOperand.imm.is_signed` attribute.
    AUTO = 0,
    /// Force signed values.
    SIGNED = 1,
    /// Force unsigned values.
    UNSIGNED = 2,
}

pub const SIGNEDNESS_MAX_VALUE: usize = 2;

/// Defines the `ZydisPadding` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum Padding {
    /// Disables padding.
    DISABLED = 0,
    /// Padds the value to the current stack-width for addresses, or to the operand-width for immediate values (hexadecimal only).
    AUTO = -1,
}

/// Defines the `ZydisFormatterFunction` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum FormatterFunction {
    /// This function is invoked before the formatter formats an instruction.
    PRE_INSTRUCTION = 0,
    /// This function is invoked after the formatter formatted an instruction.
    POST_INSTRUCTION = 1,
    /// This function refers to the main formatting function.
    FORMAT_INSTRUCTION = 2,
    /// This function is invoked before the formatter formats an operand.
    PRE_OPERAND = 3,
    /// This function is invoked after the formatter formatted an operand.
    POST_OPERAND = 4,
    /// This function is invoked to format a register operand.
    FORMAT_OPERAND_REG = 5,
    /// This function is invoked to format a memory operand.
    FORMAT_OPERAND_MEM = 6,
    /// This function is invoked to format a pointer operand.
    FORMAT_OPERAND_PTR = 7,
    /// This function is invoked to format an immediate operand.
    FORMAT_OPERAND_IMM = 8,
    /// This function is invoked to print the instruction mnemonic.
    PRINT_MNEMONIC = 9,
    /// This function is invoked to print a register.
    PRINT_REGISTER = 10,
    /// This function is invoked to print absolute addresses.
    PRINT_ADDRESS_ABS = 11,
    /// This function is invoked to print relative addresses.
    PRINT_ADDRESS_REL = 12,
    /// This function is invoked to print a memory displacement value.
    PRINT_DISP = 13,
    /// This function is invoked to print an immediate value.
    PRINT_IMM = 14,
    /// This function is invoked to print the size of a memory operand (`INTEL` only).
    PRINT_TYPECAST = 15,
    /// This function is invoked to print the segment-register of a memory operand.
    PRINT_SEGMENT = 16,
    /// This function is invoked to print the instruction prefixes.
    PRINT_PREFIXES = 17,
    /// This function is invoked after formatting an operand to print a `EVEX`/`MVEX` decorator.
    PRINT_DECORATOR = 18,
}

pub const FORMATTER_FUNC_MAX_VALUE: usize = 18;

/// Defines the `ZydisDecorator` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum Decorator {
    INVALID = 0,
    /// The embedded-mask decorator.
    MASK = 1,
    /// The broadcast decorator.
    BC = 2,
    /// The rounding-control decorator.
    RC = 3,
    /// The suppress-all-exceptions decorator.
    SAE = 4,
    /// The register-swizzle decorator.
    SWIZZLE = 5,
    /// The conversion decorator.
    CONVERSION = 6,
    /// The eviction-hint decorator.
    EH = 7,
}

pub const DECORATOR_MAX_VALUE: usize = 7;

/// Defines the `ZydisInstructionSegment` struct.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum InstructionSegment {
    NONE = 0,
    /// The legacy prefixes (including ignored `REX` prefixes).
    PREFIXES = 1,
    /// The effective `REX` prefix byte.
    REX = 2,
    /// The `XOP` prefix bytes.
    XOP = 3,
    /// The `VEX` prefix bytes.
    VEX = 4,
    /// The `EVEX` prefix bytes.
    EVEX = 5,
    /// The `MVEX` prefix bytes.
    MVEX = 6,
    /// The opcode bytes.
    OPCODE = 7,
    /// The `ModRM` byte.
    MODRM = 8,
    /// The `SIB` byte.
    SIB = 9,
    /// The displacement bytes.
    DISPLACEMENT = 10,
    /// The immediate bytes.
    IMMEDIATE = 11,
}

pub const INSTR_SEGMENT_MAX_VALUE: usize = 11;

/// Defines the `ZydisFeature` enum.
#[cfg_attr(feature = "serialization", derive(Deserialize, Serialize))]
#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash)]
#[repr(C)]
pub enum Feature {
    DECODER = 0,
    FORMATTER = 1,
    AVX512 = 2,
    KNC = 3,
}

pub const FEATURE_MAX_VALUE: usize = 3;

