use clap::Parser;
use std::path::PathBuf;

/// Assistant Bot for Programmers
#[derive(Parser)]
#[clap(version, trailing_var_arg = true)]
pub struct Args {
    /// Request query
    #[clap(multiple_occurrences(true))]
    pub query: Vec<String>,

    /// Increase the logging verbosity
    #[clap(short, long, parse(from_occurrences))]
    pub verbose: usize,

    /// Show the inferred internal command without running it
    #[clap(long)]
    pub dry_run: bool,

    /// Run an internal command directly
    #[clap(short, long)]
    pub run: bool,

    /// Specify input files
    #[clap(short, long, multiple_occurrences(true))]
    pub input: Vec<PathBuf>,

    /// Load config from a TOML file
    #[clap(short, long)]
    pub config: Option<PathBuf>,

    /// Dump embedded model data.
    #[clap(long, hide(true), display_order(1002))]
    pub dump_model: Option<PathBuf>,
}
