use libc::{c_char, c_int, c_uint, c_void, size_t};

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_CStream {
    _unused: [u8; 0],
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_inBuffer {
    pub src: *const c_void,
    pub size: size_t,
    pub pos: size_t,
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_outBuffer {
    pub dst: *mut c_void,
    pub size: size_t,
    pub pos: size_t,
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_DStream {
    _unused: [u8; 0],
}

pub type ZSTD_EndDirective = c_uint;

extern "C" {
    #[cfg(feature = "threadpool")]
    pub fn ZSTD_compress(
        dst: *mut c_void,
        dstCapacity: size_t,
        src: *const c_void,
        srcSize: size_t,
        compressionLevel: c_int,
    ) -> size_t;
    pub fn ZSTD_isError(code: size_t) -> c_uint;
    pub fn ZSTD_getErrorName(code: size_t) -> *const c_char;
    pub fn ZSTD_createCStream() -> *mut ZSTD_CStream;
    pub fn ZSTD_freeCStream(zcs: *mut ZSTD_CStream) -> size_t;
    pub fn ZSTD_compressStream2(
        cctx: *mut ZSTD_CStream,
        output: *mut ZSTD_outBuffer,
        input: *mut ZSTD_inBuffer,
        endOp: ZSTD_EndDirective,
    ) -> size_t;
    pub fn ZSTD_CCtx_reset(cctx: *mut ZSTD_CStream, reset: c_uint) -> size_t;
    pub fn ZSTD_CStreamOutSize() -> size_t;
    pub fn ZSTD_compressStream(
        zcs: *mut ZSTD_CStream,
        output: *mut ZSTD_outBuffer,
        input: *mut ZSTD_inBuffer,
    ) -> size_t;
    pub fn ZSTD_flushStream(zcs: *mut ZSTD_CStream, output: *mut ZSTD_outBuffer) -> size_t;
    pub fn ZSTD_endStream(zcs: *mut ZSTD_CStream, output: *mut ZSTD_outBuffer) -> size_t;

    pub fn ZSTD_createDStream() -> *mut ZSTD_DStream;
    pub fn ZSTD_freeDStream(zds: *mut ZSTD_DStream) -> size_t;
    pub fn ZSTD_initDStream(zds: *mut ZSTD_DStream) -> size_t;
    pub fn ZSTD_DCtx_reset(dctx: *mut ZSTD_DStream, reset: c_uint) -> size_t;
    pub fn ZSTD_decompressStream(
        zds: *mut ZSTD_DStream,
        output: *mut ZSTD_outBuffer,
        input: *mut ZSTD_inBuffer,
    ) -> size_t;
    pub fn ZSTD_initCStream(zcs: *mut ZSTD_CStream, compressionLevel: c_int) -> size_t;
}
