#![allow(bad_style)]
/* automatically generated by rust-bindgen 0.59.2 */
// bindgen --allowlist-function "[Zz].*" --allowlist-var "[zZ].*" --allowlist-type "[Zz].*" --no-layout-tests zopfli.h --size_t-is-usize --no-prepend-enum-name --rustified-enum '.*' > ../src/lib.rs

#[repr(C)]
#[derive(Debug, Copy, Clone, Default)]
pub struct ZopfliOptions {
    pub verbose: ::std::os::raw::c_int,
    pub verbose_more: ::std::os::raw::c_int,
    pub numiterations: ::std::os::raw::c_int,
    pub iterationlimitseconds: f64,
    pub blocksplitting: ::std::os::raw::c_int,
    pub blocksplittinglast: ::std::os::raw::c_int,
    pub blocksplittingmax: ::std::os::raw::c_int,
}
extern "C" {
    pub fn ZopfliInitOptions(options: *mut ZopfliOptions);
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ZopfliFormat {
    ZOPFLI_FORMAT_GZIP = 0,
    ZOPFLI_FORMAT_ZLIB = 1,
    ZOPFLI_FORMAT_DEFLATE = 2,
}
extern "C" {
    pub fn ZopfliCompress(
        options: *const ZopfliOptions,
        output_type: ZopfliFormat,
        in_: *const ::std::os::raw::c_uchar,
        insize: usize,
        out: *mut *mut ::std::os::raw::c_uchar,
        outsize: *mut usize,
    );
}

#[test]
fn poke() {
    let mut opts = ZopfliOptions::default();
    let mut out = std::ptr::null_mut();
    let mut outsize = 0;
    unsafe {
        ZopfliInitOptions(&mut opts);
        ZopfliCompress(&opts, ZopfliFormat::ZOPFLI_FORMAT_ZLIB, b"hello".as_ptr(), 5,  &mut out, &mut outsize);
        assert_ne!(0, outsize);
        assert!(!out.is_null());
    }
}
