## Zn - CLI for Files (Cloud Storage)

[![crates.io](https://meritbadge.herokuapp.com/zn)](https://crates.io/crates/zn)

### Purpose

This application is a CLI for [files](https://crates.io/crates/files) - a CDN Origin Server for Cloud Storage.

Zn makes it easy to upload a directory to a bucket, download a bucket to a directory, and copy buckets between cloud providers.

Zn in the future will support [lumber](https://crates.io/crates/lumber) to allow shipping logs from cloud storage to [portal](https://crates.io/crates/portal) for search indexing.

To use this service you need to be running both a [broker](https://crates.io/crates/broker) and a [files](https://crates.io/crates/files) server.

### Features

* Very performant with almost no CPU and memory usage
* Supports uploading a directory to a bucket
* Supports downloading a bucket to a directory
* Supports copying between buckets including between providers
* Under 500 lines of code
* Built on [broker](https://crates.io/crates/broker) and [files](https://crates.io/crates/files)

### Use

``` cargo install zn ```

* Refer to `zn -h` for help

* Valid regions are:

| Provider | Region  |
|--- | --- |
| wasabi | wa-us-east-1 |
| wasabi | wa-us-east-2 | 
| wasabi | wa-us-west-1 | 
| wasabi | wa-eu-central-1 |
| aws | us-east-1 |
| aws | us-east-2 |
| aws | us-west-1 |
| aws | us-west-2 |
| aws | ca-central-1 |
| aws | ap-south-1 |
| aws | ap-northeast-1 |
| aws | ap-northeast-2 |
| aws | ap-northeast-3 |
| aws | cn-north-1 |
| aws | cn-northwest-1 |
| aws | eu-north-1 |
| aws | eu-central-1 |
| aws | eu-west-1 |
| aws | eu-west-2 |
| aws | eu-west-3 |
| aws | me-south-1 |
| aws | sa-east-1 |
| do | nyc3 |
| do | ams3 |
| do | spg1 |
| do | fra1 | 
| vultr | ewr1 | 
| yandex | ru-central1 | 

### Examples

* `-q` is the URL for broker
* `-w` is the URL for files

#### Upload a directory to a bucket

```bash
zn -u="/home/me/upload_data" -a="us-east-1" -j="my-bucket" -r="user" -p="password" -q="https://broker.upbase.dev" -w="https://files.upbase.dev"
```

#### Download a bucket to a directory

```bash
zn -d="/home/me/download_data" -b="us-east-1" -k="my-bucket" -r="user" -p="password" -q="https://broker.upbase.dev" -w="https://files.upbase.dev"
```

#### Copy the files of a bucket to another bucket - including between providers

* This will copy the files in your `my-aws-bucket` in `us-east-1` to `my-wasabi-bucket` in `wa-us-east-1`

```bash
zn -a="wa-us-east-1" -b="us-east-1" -j="my-wasabi-bucket" -k="my-aws-bucket" -r="user" -p="password" -q="https://broker.upbase.dev" -w="https://files.upbase.dev"
```

### TechStack

* [Clap](https://crates.io/crates/clap)
* [Surf](https://crates.io/crates/surf)
