#!/bin/sh
set -e

# Compile the circuit
npx circom -rw

# Do a local trusted setup, generate params.bin
cargo run --release setup

# Export proving and verifying keys compatible with snarkjs and websnark
cargo run --release export-keys

# generate solidity verifier
cargo run --release generate-verifier

# generate and verify proof
npx snarkjs calculatewitness # witness is still generated by snarkjs
cargo run --release prove
cargo run --release verify

# Double check by verifying the same proof with snarkjs
npx snarkjs verify