use crate::goal::Goal;
use time::Duration;

/// The [PreProcessor] takes in a user's goals, given a duration
pub struct PreProcessor;

impl PreProcessor {
	pub fn process_task_count(goals: &[Goal], duration: Duration) -> Vec<(usize, &Goal)> {
		goals
			.into_iter()
			.map(|goal| ((duration / goal.interval).ceil(), goal))
			.map(|(mut task_count, goal)| {
				let task_time = goal.duration / task_count;
				let in_minutes = task_time.as_seconds_f64() / 60.;

				// Smallest task time is 15 minutes
				if in_minutes < 15. {
					let goal_time = goal.duration.as_seconds_f64() / 60.;
					task_count = (goal_time / 15.).ceil();
				}

				(task_count as usize, goal)
			})
			.collect()
	}
}
