# 中文维基百科字词转换机制
## CGroup
[[Module:CGroup/*]]定义有诸多组转换规则。这些规则通过[[Template:NoteTA]]被调用，实现于[[Module:NoteTA]]。[[Module:NoteTA]]对于[[Template:NoteTA]]中列出的每个标题转换、CGroup、手动转换，生成包含Mediawiki中LanguageConverter组件能直接处理的转换规则（例如 `-{H|zh-cn:博客; zh-hk:網誌; zh-tw:部落格;}-` ），见：[[Help:高级字词转换语法]]。flag为H则为全文转换规则，flag为T则为标题转换规则。

## 规则的优先级顺序
根据 [[Wikipedia:字詞轉換處理]]：
> 维基百科的字词转换共通过四个层级来实现：其一是MediaWiki内置的转换表ZhConversion.php，供各维基计划全域转换；其二是在[MediaWiki:Conversiontable]中定义的简繁和地区词转换表，供中文维基百科本地全局转换；其三是各公共转换组，供主题领域相同和相似的条目统一转换；其四是各条目内设置的手工转换，供该条目单独使用。其中，公共转换组和条目内手工转换人人均可编辑，而修改本地转换表则需要管理员权限，修改全域转换表需要向MediaWiki版本库提交代码。因此，如欲新增或修复全域及本地全局转换，一般用户需在维基百科:字词转换提出请求，交由管理员协助处理。 

理想地，条目层面设定的公共转换组和手动指明的单条转换规则应当具有最高优先级，但实际情况并非完全如此。实现上，所有转换均由PHP内置函数strtr完成，后者基于被提供的词组映射转换（存储于LanguageConverter的`mTables`，一个associative array）。所有转换规则均以其出现之次序被加载到`mTables`中。有鉴于HashMap的特性，后加入的规则会替代早前加入的key相同的规则——这确保对于同样的原词组，条目层面的规则具有更高优先级。但strtr是从词组映射中长度最大的原词组开始匹配，这使得原词组长度的拥有比规则加入顺序更高的优先级层次。

当全局转换表包含`万维网 => 全球資訊網`的转换规则，而条目层面包含`万维网 => 萬維網`时。若被转换文本为“万维网”，最终生效的规则是后者，即，转换结果为“萬維網”。

当全局转换表包含`万维网 => 全球資訊網`的转换规则，而条目层面包含`万维 => 萬維`。若被转换文本为“万维网”，最终生效的规则是前者，即，转换结果为“全球資訊網”而非“萬維网”——因为前者的原词组更长。

这一实现特性具备合理性和直觉性。但由于实现问题，其也可能产生反直觉的转换：

当全局转换表包含`维网站 => 維網站`的转换规则，而条目层面包含`万维 => WWW`时。若被转换文本为“万维网站”，最终生效的规则是后者，即，转换结果为“WWW网站”——尽管前者的原词组更长。这是因为“万维”更先出现。由此可见，这一实现并非完全是“最长匹配”，但似乎也没有什么有足够效率的替代实现方法。

总结地，优先级顺序可简化地表示为：

词组在文中出现之先后 > 原词组之长度 > 转换规则载入之后先

前两者又可解作：

> LeftmostLongest

> Use leftmost-longest match semantics, which reports leftmost matches. When there are multiple possible leftmost matches, the longest match is chosen. [https://docs.rs/aho-corasick/latest/aho_corasick/packed/enum.MatchKind.html#variant.LeftmostLongest]
